/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.resource;

import com.google.inject.Inject;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.impl.JvmDeclaredTypeImplCustom;
import org.eclipse.xtext.common.types.xtext.JvmMemberInitializableResource;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.diagnostics.ExceptionDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.CompilerPhases;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.resource.IBatchLinkableResource;
import org.eclipse.xtext.resource.ISynchronizable;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.resource.BatchLinkingService;

public class BatchLinkableResource
extends DerivedStateAwareResource
implements ISynchronizable<BatchLinkableResource>,
IBatchLinkableResource,
JvmMemberInitializableResource {
    private static final Logger log = Logger.getLogger(BatchLinkableResource.class);
    @Inject
    private BatchLinkingService batchLinkingService;
    @Inject
    private CompilerPhases compilerPhases;
    private Set<Runnable> jvmMemberInitializers = null;
    private boolean hasJvmMemberInitializers = false;
    private boolean isInitializingJvmMembers = false;

    public Object getLock() {
        ResourceSet resourceSet = this.getResourceSet();
        if (resourceSet instanceof ISynchronizable) {
            return ((ISynchronizable)resourceSet).getLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Result> Result execute(IUnitOfWork<Result, ? super BatchLinkableResource> unit) throws Exception {
        Object object = this.getLock();
        synchronized (object) {
            return (Result)unit.exec((Object)this);
        }
    }

    public EObject getEObject(String uriFragment) {
        Object object = this.getLock();
        synchronized (object) {
            block9: {
                if (!this.getEncoder().isCrossLinkFragment((Resource)this, uriFragment) || this.isLoadedFromStorage()) break block9;
                if (!this.getUnresolvableURIFragments().contains(uriFragment)) {
                    Triple triple = this.getEncoder().decode((Resource)this, uriFragment);
                    if (this.batchLinkingService.isBatchLinkable((EReference)triple.getSecond())) {
                        if (this.compilerPhases.isIndexing((Notifier)this)) {
                            log.error((Object)"Don't resolve expressions during indexing!", (Throwable)new IllegalStateException("Resource URI : " + this.getURI() + ", fragment : " + uriFragment));
                        }
                        return this.batchLinkingService.resolveBatched((EObject)triple.getFirst(), (EReference)triple.getSecond(), uriFragment);
                    }
                    return super.getEObject(uriFragment, triple);
                }
                return null;
            }
            try {
                return super.getEObject(uriFragment);
            }
            catch (RuntimeException e) {
                this.operationCanceledManager.propagateAsErrorIfCancelException((Throwable)e);
                this.getErrors().add((Object)new ExceptionDiagnostic((Exception)e));
                log.error((Object)("resolution of uriFragment '" + uriFragment + "' failed."), (Throwable)e);
                throw new WrappedException((Exception)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList<EObject> getContents() {
        Object object = this.getLock();
        synchronized (object) {
            if (!(!this.isLoaded || this.isLoading || this.isInitializing || this.isUpdating || this.fullyInitialized || this.isLoadedFromStorage())) {
                try {
                    this.eSetDeliver(false);
                    this.installDerivedState(false);
                }
                finally {
                    this.eSetDeliver(true);
                }
            }
            return this.doGetContents();
        }
    }

    public void resolveLazyCrossReferences(CancelIndicator monitor) {
        IParseResult parseResult = this.getParseResult();
        if (parseResult != null) {
            this.batchLinkingService.resolveBatched(parseResult.getRootASTElement(), monitor);
        }
        this.operationCanceledManager.checkCanceled(monitor);
        super.resolveLazyCrossReferences(monitor);
    }

    protected EObject handleCyclicResolution(Triple<EObject, EReference, INode> triple) throws AssertionError {
        if (!this.isValidationDisabled()) {
            Resource.Diagnostic diagnostic;
            EObject context = (EObject)triple.getFirst();
            if (context.eClass() == TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE) {
                return null;
            }
            DiagnosticMessage message = new DiagnosticMessage("Cyclic linking detected : " + this.getReferences(triple, this.resolving), Severity.ERROR, "cyclic-resolution", new String[0]);
            List list = this.getDiagnosticList(message);
            if (!list.contains(diagnostic = this.createDiagnostic(triple, message))) {
                list.add(diagnostic);
            }
        }
        return null;
    }

    public void linkBatched(CancelIndicator monitor) {
        this.resolveLazyCrossReferences(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureJvmMembersInitialized() {
        if (this.jvmMemberInitializers == null) {
            return;
        }
        Set<Runnable> localRunnables = null;
        BatchLinkableResource batchLinkableResource = this;
        synchronized (batchLinkableResource) {
            localRunnables = this.jvmMemberInitializers;
            this.jvmMemberInitializers = null;
            this.hasJvmMemberInitializers = false;
        }
        if (localRunnables == null) {
            return;
        }
        boolean wasDeliver = this.eDeliver();
        LinkedHashSet before = this.resolving;
        try {
            try {
                this.eSetDeliver(false);
                if (!before.isEmpty()) {
                    this.resolving = new LinkedHashSet();
                }
                if (this.isInitializingJvmMembers) {
                    throw new IllegalStateException("Reentrant attempt to initialize JvmMembers");
                }
                try {
                    this.isInitializingJvmMembers = true;
                    for (Runnable runnable : localRunnables) {
                        runnable.run();
                    }
                }
                finally {
                    this.isInitializingJvmMembers = false;
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                if (!before.isEmpty()) {
                    this.resolving = before;
                }
                this.eSetDeliver(wasDeliver);
            }
        }
        finally {
            if (!before.isEmpty()) {
                this.resolving = before;
            }
            this.eSetDeliver(wasDeliver);
        }
    }

    public boolean isInitializingJvmMembers() {
        return this.isInitializingJvmMembers;
    }

    public void discardDerivedState() {
        this.jvmMemberInitializers = null;
        this.hasJvmMemberInitializers = false;
        super.discardDerivedState();
    }

    public void addJvmMemberInitializer(Runnable runnable) {
        if (this.isInitializingJvmMembers) {
            throw new IllegalStateException("Cannot enqueue runnables during JvmMemberInitialization");
        }
        if (this.jvmMemberInitializers == null) {
            this.jvmMemberInitializers = new LinkedHashSet<Runnable>();
            this.hasJvmMemberInitializers = true;
            for (EObject obj : this.getContents()) {
                if (!(obj instanceof JvmDeclaredTypeImplCustom)) continue;
                JvmDeclaredTypeImplCustom type = (JvmDeclaredTypeImplCustom)obj;
                this.markPendingInitialization(type);
            }
        }
        this.jvmMemberInitializers.add(runnable);
    }

    private void markPendingInitialization(JvmDeclaredTypeImplCustom type) {
        type.setPendingInitialization(true);
        for (JvmMember member : type.basicGetMembers()) {
            if (!(member instanceof JvmDeclaredTypeImplCustom)) continue;
            this.markPendingInitialization((JvmDeclaredTypeImplCustom)member);
        }
    }

    public boolean hasJvmMemberInitializers() {
        return this.hasJvmMemberInitializers;
    }
}

