/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.typesystem.arguments.IFeatureCallArgumentSlot;
import org.eclipse.xtext.xbase.typesystem.arguments.IFeatureCallArguments;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractReturnAwareTypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractStackedTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.CompoundTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.NoExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.TypeExpectation;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.AbstractTypeReferencePairWalker;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.ConstraintVisitingInfo;
import org.eclipse.xtext.xbase.typesystem.util.DeferredTypeParameterHintCollector;
import org.eclipse.xtext.xbase.typesystem.util.ExpectationTypeParameterHintCollector;
import org.eclipse.xtext.xbase.typesystem.util.Maps2;
import org.eclipse.xtext.xbase.typesystem.util.RawTypeSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.TypeArgumentFromComputedTypeCollector;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterByUnboundSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameterPreservingSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

public abstract class AbstractLinkingCandidate<Expression extends XExpression>
implements ILinkingCandidate {
    private final ExpressionTypeComputationState state;
    private final ITypeExpectation expectation;
    private final Expression expression;
    protected List<LightweightTypeReference> typeArguments;
    protected IFeatureCallArguments arguments;

    protected AbstractLinkingCandidate(Expression expression, ITypeExpectation expectation, ExpressionTypeComputationState state) {
        this.expression = expression;
        this.expectation = expectation;
        this.state = state;
    }

    protected Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> initializeTypeParameterMapping() {
        this.state.acceptCandidate((XExpression)this.expression, this);
        List<JvmTypeParameter> declaredTypeParameters = this.getDeclaredTypeParameters();
        Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> typeParameterMapping = declaredTypeParameters.isEmpty() ? Collections.emptyMap() : this.initializeTypeParameterMapping(declaredTypeParameters);
        return typeParameterMapping;
    }

    protected Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> initializeTypeParameterMapping(List<JvmTypeParameter> declaredTypeParameters) {
        JvmTypeParameter declaredTypeParameter;
        List<LightweightTypeReference> explicitTypeArguments = this.getSyntacticTypeArguments();
        int size = Math.min(declaredTypeParameters.size(), explicitTypeArguments.size());
        LinkedHashMap<JvmTypeParameter, LightweightMergedBoundTypeArgument> typeParameterMapping = Maps2.newLinkedHashMapWithExpectedSize(size);
        int i = 0;
        while (i < size) {
            declaredTypeParameter = declaredTypeParameters.get(i);
            LightweightTypeReference explicitTypeArgument = explicitTypeArguments.get(i);
            UnboundTypeReference typeReference = this.state.getResolvedTypes().createUnboundTypeReference((XExpression)this.expression, declaredTypeParameter);
            if (explicitTypeArgument != null && explicitTypeArgument.isValidHint()) {
                LightweightTypeReference substitute = explicitTypeArgument.getInvariantBoundSubstitute();
                typeReference.acceptHint(substitute, BoundTypeArgumentSource.EXPLICIT, this.expression, VarianceInfo.INVARIANT, VarianceInfo.INVARIANT);
            }
            typeParameterMapping.put(declaredTypeParameter, new LightweightMergedBoundTypeArgument(typeReference, VarianceInfo.INVARIANT));
            ++i;
        }
        i = size;
        while (i < declaredTypeParameters.size()) {
            declaredTypeParameter = declaredTypeParameters.get(i);
            this.initializeMapping(declaredTypeParameter, typeParameterMapping);
            ++i;
        }
        UnboundTypeParameterPreservingSubstitutor substitutor = new UnboundTypeParameterPreservingSubstitutor(typeParameterMapping, this.getState().getReferenceOwner());
        substitutor.enhanceMapping(this.getDeclaratorParameterMapping());
        LightweightTypeReference expectedType = this.expectation.getExpectedType();
        if (expectedType != null) {
            LightweightTypeReference declaredFeatureType = this.getDeclaredType(this.getFeature());
            LightweightTypeReference substitutedFeatureType = substitutor.substitute(declaredFeatureType);
            DeferredTypeParameterHintCollector collector = new DeferredTypeParameterHintCollector(this.state.getReferenceOwner()){

                @Override
                protected void addHint(UnboundTypeReference typeParameter, LightweightTypeReference reference) {
                    if (!typeParameter.internalIsResolved() && this.getExpectedVariance() == VarianceInfo.INVARIANT) {
                        if (this.getExpectedVariance() == this.getActualVariance() && reference.getKind() != 6) {
                            this.doAddHint(typeParameter, reference, BoundTypeArgumentSource.INFERRED_EXPECTATION);
                        } else if (this.getActualVariance() == VarianceInfo.IN && !typeParameter.hasSignificantHints()) {
                            if (reference.getKind() != 6) {
                                this.doAddHint(typeParameter, reference, BoundTypeArgumentSource.INFERRED_EXPECTATION);
                            } else {
                                UnboundTypeReference casted = (UnboundTypeReference)reference;
                                List<LightweightBoundTypeArgument> hints = casted.getAllHints();
                                for (LightweightBoundTypeArgument hint : hints) {
                                    if (hint.getSource() != BoundTypeArgumentSource.INFERRED_LATER) continue;
                                    return;
                                }
                                this.doAddHint(typeParameter, reference, BoundTypeArgumentSource.INFERRED_EXPECTATION);
                            }
                        }
                    }
                }

                protected void doAddHint(UnboundTypeReference typeParameter, LightweightTypeReference reference, BoundTypeArgumentSource source) {
                    typeParameter.acceptHint(reference.getWrapperTypeIfPrimitive(), source, this.getOrigin(), this.getExpectedVariance(), this.getActualVariance());
                }
            };
            collector.processPairedReferences(substitutedFeatureType, expectedType);
        }
        int i2 = size;
        while (i2 < declaredTypeParameters.size()) {
            JvmTypeParameter declaredTypeParameter2 = declaredTypeParameters.get(i2);
            LightweightMergedBoundTypeArgument boundTypeArgument = (LightweightMergedBoundTypeArgument)typeParameterMapping.get(declaredTypeParameter2);
            LightweightTypeReference boundReference = boundTypeArgument.getTypeReference();
            if (boundReference instanceof UnboundTypeReference) {
                this.initializeConstraintMapping(declaredTypeParameter2, substitutor, (UnboundTypeReference)boundReference);
            }
            ++i2;
        }
        return typeParameterMapping;
    }

    protected void initializeMapping(JvmTypeParameter typeParameter, Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> result) {
        UnboundTypeReference typeReference = this.state.getResolvedTypes().createUnboundTypeReference((XExpression)this.expression, typeParameter);
        result.put(typeParameter, new LightweightMergedBoundTypeArgument(typeReference, VarianceInfo.INVARIANT));
    }

    protected void initializeConstraintMapping(JvmTypeParameter typeParameter, UnboundTypeParameterPreservingSubstitutor substitutor, UnboundTypeReference typeReference) {
        if (!typeReference.internalIsResolved()) {
            EList constraints = typeParameter.getConstraints();
            for (JvmTypeConstraint constraint : constraints) {
                LightweightTypeReference substitute;
                JvmTypeReference constraintReference = constraint.getTypeReference();
                if (constraintReference == null || (substitute = substitutor.substitute(constraintReference)).isType(Object.class) || substitute.isPrimitiveVoid()) continue;
                typeReference.acceptHint(substitute, BoundTypeArgumentSource.CONSTRAINT, constraint, VarianceInfo.OUT, VarianceInfo.OUT);
            }
        }
    }

    protected void accept(ObservableTypeExpectation expectation, LightweightTypeReference actual) {
        LightweightTypeReference expectedType = expectation.getExpectedType();
        if (expectedType == null || actual instanceof AnyTypeReference || actual.isPrimitiveVoid()) {
            return;
        }
        this.resolveAgainstActualType(expectedType, actual, expectation.getState());
    }

    @Override
    public List<LightweightTypeReference> getTypeArguments() {
        if (this.typeArguments == null) {
            List<JvmTypeParameter> typeParameters = this.getDeclaredTypeParameters();
            if (typeParameters.isEmpty() || this.getTypeParameterMapping().isEmpty()) {
                this.typeArguments = Collections.emptyList();
            } else {
                ArrayList result = Lists.newArrayListWithCapacity((int)typeParameters.size());
                for (JvmTypeParameter parameter : typeParameters) {
                    LightweightMergedBoundTypeArgument typeArgument = this.getTypeParameterMapping().get(parameter);
                    result.add(typeArgument.getTypeReference());
                }
                this.typeArguments = result;
            }
        }
        return this.typeArguments;
    }

    protected abstract Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getTypeParameterMapping();

    protected List<JvmTypeParameter> getDeclaredTypeParameters() {
        JvmIdentifiableElement feature = this.getFeature();
        if (feature instanceof JvmExecutable) {
            return ((JvmTypeParameterDeclarator)feature).getTypeParameters();
        }
        return Collections.emptyList();
    }

    @Override
    public void applyToComputationState() {
        this.preApply();
        JvmIdentifiableElement feature = this.getFeature();
        LightweightTypeReference featureType = this.getDeclaredType(feature);
        TypeParameterSubstitutor substitutor = null;
        if (!this.isRawTypeContext()) {
            final Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> declaratorParameterMapping = this.getDeclaratorParameterMapping();
            substitutor = new TypeParameterByUnboundSubstitutor(declaratorParameterMapping, this.expectation.getReferenceOwner()){
                private boolean wasCapturedWildcard;
                {
                    super($anonymous0, $anonymous1);
                    this.wasCapturedWildcard = false;
                }

                @Override
                protected UnboundTypeReference createUnboundTypeReference(JvmTypeParameter type) {
                    UnboundTypeReference result = AbstractLinkingCandidate.this.state.getResolvedTypes().createUnboundTypeReference(AbstractLinkingCandidate.this.expression, type);
                    return result;
                }

                @Override
                protected LightweightTypeReference getBoundTypeArgument(ParameterizedTypeReference reference, JvmTypeParameter type, ConstraintVisitingInfo visiting) {
                    if (this.getOwner().getDeclaredTypeParameters().contains(type)) {
                        return null;
                    }
                    return super.getBoundTypeArgument(reference, type, visiting);
                }

                @Override
                protected LightweightMergedBoundTypeArgument getBoundTypeArgument(JvmTypeParameter typeParameter, ConstraintVisitingInfo info) {
                    LightweightMergedBoundTypeArgument result = super.getBoundTypeArgument(typeParameter, info);
                    if (result != null) {
                        JvmTypeConstraint constraint;
                        LightweightTypeReference typeReference = result.getTypeReference();
                        if (result.getVariance() == VarianceInfo.INVARIANT && typeReference.isWildcard() && typeReference.getLowerBoundSubstitute().isAny() && typeReference.getUpperBoundSubstitute().isType(Object.class) && !typeParameter.getConstraints().isEmpty() && (constraint = (JvmTypeConstraint)typeParameter.getConstraints().get(0)) instanceof JvmUpperBound) {
                            LightweightTypeReference reference = this.getOwner().toLightweightTypeReference(constraint.getTypeReference());
                            return new LightweightMergedBoundTypeArgument(reference, VarianceInfo.OUT);
                        }
                        if (declaratorParameterMapping.containsKey(typeParameter) && typeReference.isWildcard()) {
                            this.wasCapturedWildcard = true;
                        }
                    }
                    return result;
                }

                @Override
                protected LightweightTypeReference enhanceParameterizedTypeReference(ParameterizedTypeReference reference, JvmType type, ParameterizedTypeReference result, ConstraintVisitingInfo visiting) {
                    boolean convertToWildcard = false;
                    int i = 0;
                    while (i < reference.getTypeArguments().size()) {
                        this.wasCapturedWildcard = false;
                        LightweightTypeReference argument = reference.getTypeArguments().get(i);
                        visiting.pushInfo(type instanceof JvmTypeParameterDeclarator ? (JvmTypeParameterDeclarator)type : null, i);
                        LightweightTypeReference visitedArgument = argument.accept(this, visiting);
                        if (this.wasCapturedWildcard) {
                            convertToWildcard = true;
                        }
                        this.wasCapturedWildcard = false;
                        result.addTypeArgument(visitedArgument);
                        ++i;
                    }
                    if (convertToWildcard) {
                        WildcardTypeReference wildcard = result.getOwner().newWildcardTypeReference();
                        wildcard.addUpperBound(result);
                        return wildcard;
                    }
                    return result;
                }
            };
            substitutor.enhanceMapping(this.getTypeParameterMapping());
        } else {
            substitutor = new RawTypeSubstitutor(this.expectation.getReferenceOwner());
        }
        LightweightTypeReference substitutedFeatureType = substitutor.substitute(featureType).getUpperBoundSubstitute();
        if (!this.expectation.isNoTypeExpectation()) {
            substitutedFeatureType = this.deferredBindTypeArgument(this.expectation, substitutedFeatureType);
        }
        this.expectation.acceptActualType(substitutedFeatureType, 0x400000);
        this.state.getStackedResolvedTypes().mergeIntoParent();
    }

    protected void preApply() {
        this.computeArgumentTypes();
    }

    protected LightweightTypeReference deferredBindTypeArgument(ITypeExpectation expectation, LightweightTypeReference type) {
        LightweightTypeReference expectedType = expectation.getExpectedType();
        if (expectedType != null) {
            ExpectationTypeParameterHintCollector collector = new ExpectationTypeParameterHintCollector(this.state.getReferenceOwner()){

                @Override
                protected AbstractTypeReferencePairWalker.UnboundTypeReferenceTraverser createUnboundTypeReferenceTraverser() {
                    return new DeferredTypeParameterHintCollector.UnboundTypeParameterHintCollector(this){
                        Set<Object> seenParameters = Sets.newHashSetWithExpectedSize((int)3);

                        @Override
                        protected void doVisitTypeReference(LightweightTypeReference reference, UnboundTypeReference declaration) {
                            if (declaration.internalIsResolved() || this.getOwner().isResolved(declaration.getHandle())) {
                                declaration.tryResolve();
                                this.outerVisit(declaration, reference, declaration, this.getExpectedVariance(), this.getActualVariance());
                            } else if (reference.isValidHint()) {
                                this.addHint(declaration, reference);
                                if (this.seenParameters.add(declaration.getHandle())) {
                                    List<LightweightBoundTypeArgument> hints = AbstractLinkingCandidate.this.getState().getResolvedTypes().getHints(declaration.getHandle());
                                    int i = 0;
                                    while (i < hints.size()) {
                                        LightweightBoundTypeArgument hint = hints.get(i);
                                        if (hint.getSource() == BoundTypeArgumentSource.CONSTRAINT) {
                                            this.outerVisit(hint.getTypeReference(), reference);
                                        }
                                        ++i;
                                    }
                                }
                            }
                        }

                        @Override
                        protected void doVisitUnboundTypeReference(UnboundTypeReference reference, UnboundTypeReference declaration) {
                            super.doVisitTypeReference((LightweightTypeReference)reference, declaration);
                        }
                    };
                }
            };
            collector.processPairedReferences(expectedType, type);
        }
        return type;
    }

    public void computeArgumentTypes() {
        this.initializeArgumentTypeComputation();
        while (this.arguments.hasUnprocessedArguments()) {
            this.computeArgumentType(this.arguments.getNextUnprocessedArgumentSlot());
        }
    }

    protected void initializeArgumentTypeComputation() {
        if (this.arguments != null) {
            return;
        }
        this.getTypeParameterMapping();
        this.arguments = this.state.getResolver().getExpressionArgumentFactory().createExpressionArguments((XExpression)this.expression, this);
    }

    protected void computeArgumentType(IFeatureCallArgumentSlot slot) {
        TypeParameterSubstitutor<?> substitutor = this.createArgumentTypeSubstitutor();
        if (!slot.isVarArg() && !slot.isSuperfluous()) {
            this.computeFixedArityArgumentType(slot, substitutor);
        } else if (slot.isVarArg()) {
            this.computeVarArgumentType(slot, substitutor);
        } else {
            XExpression argument = slot.getArgumentExpression();
            if (argument != null) {
                this.resolveArgumentType(argument, null, this.state.withNonVoidExpectation());
            }
        }
        slot.markProcessed();
    }

    protected void computeVarArgumentType(IFeatureCallArgumentSlot slot, TypeParameterSubstitutor<?> substitutor) {
        LightweightTypeReference componentType;
        LightweightTypeReference lastParameterType = slot.getDeclaredType();
        if (lastParameterType == null) {
            throw new IllegalStateException();
        }
        LightweightTypeReference lightweightTypeReference = componentType = lastParameterType.isArray() ? lastParameterType.getComponentType() : lastParameterType;
        if (componentType == null) {
            throw new IllegalStateException();
        }
        ITypeComputationState argumentState = null;
        LightweightTypeReference substitutedComponentType = substitutor.substitute(componentType);
        List<XExpression> arguments = slot.getArgumentExpressions();
        if (!substitutedComponentType.isAny()) {
            if (arguments.size() == 1) {
                ArgumentTypeComputationState first = this.createVarArgTypeComputationState(substitutedComponentType);
                if (substitutedComponentType.getKind() == 6) {
                    UnboundTypeReference casted = (UnboundTypeReference)substitutedComponentType.copyInto(first.getReferenceOwner());
                    List<LightweightBoundTypeArgument> hints = first.getResolvedTypes().getHints(casted.getHandle());
                    int i = 0;
                    while (i < hints.size()) {
                        LightweightBoundTypeArgument hint = hints.get(i);
                        if (hint.getSource() == BoundTypeArgumentSource.INFERRED_EXPECTATION) {
                            casted.acceptHint(hint.getTypeReference(), BoundTypeArgumentSource.INFERRED, hint.getOrigin(), hint.getDeclaredVariance(), hint.getActualVariance());
                        }
                        ++i;
                    }
                }
                ArrayTypeReference arrayTypeReference = substitutedComponentType.getOwner().newArrayTypeReference(substitutedComponentType);
                ArgumentTypeComputationState second = this.createLinkingTypeComputationState(arrayTypeReference);
                argumentState = new CompoundTypeComputationState(substitutedComponentType.getOwner(), first, second);
            } else {
                argumentState = this.createVarArgTypeComputationState(substitutedComponentType);
            }
            for (XExpression argument : arguments) {
                if (argument == null) continue;
                this.resolveArgumentType(argument, substitutedComponentType, argumentState);
            }
        } else {
            for (XExpression argument : arguments) {
                if (argument == null) continue;
                this.resolveArgumentType(argument, null, this.state.withNonVoidExpectation());
            }
        }
    }

    protected TypeParameterSubstitutor<?> createArgumentTypeSubstitutor() {
        if (this.isRawTypeContext()) {
            return new RawTypeSubstitutor(this.state.getReferenceOwner());
        }
        UnboundTypeParameterPreservingSubstitutor substitutor = new UnboundTypeParameterPreservingSubstitutor(this.getDeclaratorParameterMapping(), this.state.getReferenceOwner()){

            @Override
            protected LightweightTypeReference getBoundTypeArgument(ParameterizedTypeReference reference, JvmTypeParameter type, Set<JvmTypeParameter> visiting) {
                if (AbstractLinkingCandidate.this.isBoundTypeArgumentSkipped(type, super.getTypeParameterMapping(), this.getOwner())) {
                    return null;
                }
                return super.getBoundTypeArgument(reference, type, visiting);
            }

            @Override
            protected LightweightTypeReference visitTypeArgument(LightweightTypeReference reference, Set<JvmTypeParameter> visiting, boolean lowerBound) {
                LightweightTypeReference result = super.visitTypeArgument(reference, visiting, lowerBound);
                if (lowerBound && result.getKind() == 8) {
                    result = result.getUpperBoundSubstitute();
                }
                return result;
            }

            @Override
            protected LightweightTypeReference doVisitWildcardTypeReference(WildcardTypeReference reference, Set<JvmTypeParameter> visiting) {
                if (reference.isResolved() && reference.isOwnedBy(this.getOwner())) {
                    return reference;
                }
                WildcardTypeReference result = this.getOwner().newWildcardTypeReference();
                LightweightTypeReference lowerBound = reference.getLowerBound();
                if (lowerBound != null) {
                    LightweightTypeReference visited = this.visitTypeArgument(lowerBound, visiting, true);
                    if (visited.isWildcard()) {
                        LightweightTypeReference substitute = visited.getInvariantBoundSubstitute();
                        result.setLowerBound(substitute);
                    } else {
                        result.setLowerBound(visited);
                    }
                }
                for (LightweightTypeReference upperBound : reference.getUpperBounds()) {
                    LightweightTypeReference visitedArgument = this.visitTypeArgument(upperBound, visiting);
                    LightweightTypeReference upperBoundSubstitute = visitedArgument.getUpperBoundSubstitute();
                    result.addUpperBound(upperBoundSubstitute);
                }
                if (result.getUpperBounds().isEmpty()) {
                    throw new IllegalStateException("UpperBounds may not be empty");
                }
                return result;
            }
        };
        substitutor.enhanceMapping(this.getTypeParameterMapping());
        return substitutor;
    }

    protected boolean isBoundTypeArgumentSkipped(JvmTypeParameter type, Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> mapping, ITypeReferenceOwner owner) {
        return type.getDeclarator() instanceof JvmType && owner.getDeclaredTypeParameters().contains(type) && !mapping.containsKey(type);
    }

    protected boolean isRawTypeContext() {
        return false;
    }

    protected void computeFixedArityArgumentType(IFeatureCallArgumentSlot slot, TypeParameterSubstitutor<?> substitutor) {
        XExpression argument = slot.getArgumentExpression();
        if (argument != null) {
            LightweightTypeReference parameterType = slot.getDeclaredType();
            if (parameterType == null) {
                parameterType = this.state.getReferenceOwner().newUnknownTypeReference();
            }
            LightweightTypeReference substitutedParameterType = substitutor.substitute(parameterType);
            ArgumentTypeComputationState argumentState = this.createLinkingTypeComputationState(substitutedParameterType);
            this.resolveArgumentType(argument, substitutedParameterType, argumentState);
        }
    }

    protected ArgumentTypeComputationState createLinkingTypeComputationState(LightweightTypeReference expectedType) {
        return new ArgumentTypeComputationState(this.state, expectedType.getLowerBoundSubstitute(), 0);
    }

    protected ArgumentTypeComputationState createVarArgTypeComputationState(LightweightTypeReference componentType) {
        return new ArgumentTypeComputationState(this.state, componentType.getLowerBoundSubstitute(), 524288);
    }

    protected void resolveAgainstActualType(LightweightTypeReference declaredType, LightweightTypeReference actualType, AbstractTypeComputationState state) {
        List<JvmTypeParameter> typeParameters;
        if (!actualType.isAny() && !(typeParameters = this.getDeclaredTypeParameters()).isEmpty()) {
            TypeArgumentFromComputedTypeCollector.resolveAgainstActualType(declaredType, actualType, typeParameters, this.getTypeParameterMapping(), BoundTypeArgumentSource.EXPECTATION, state.getReferenceOwner());
        }
    }

    protected LightweightTypeReference getDeclaredType(JvmIdentifiableElement feature) {
        LightweightTypeReference result = this.state.getResolvedTypes().getActualType(feature);
        if (result == null) {
            return this.getState().getReferenceOwner().newAnyTypeReference();
        }
        return result;
    }

    protected Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getDeclaratorParameterMapping() {
        return Collections.emptyMap();
    }

    protected void resolveArgumentType(XExpression argument, LightweightTypeReference declaredType, ITypeComputationState argumentState) {
        argumentState.computeTypes(argument);
    }

    protected abstract List<XExpression> getArguments();

    protected LightweightTypeReference getExpectedType(XExpression expression) {
        return this.state.getResolvedTypes().getExpectedType(expression);
    }

    protected LightweightTypeReference getActualType(JvmIdentifiableElement element, boolean ignoreReassignedTypes) {
        return this.state.getResolvedTypes().doGetActualType(element, ignoreReassignedTypes);
    }

    protected LightweightTypeReference getActualType(XExpression expression) {
        if (expression == null) {
            return null;
        }
        return this.state.getResolvedTypes().getActualType(expression);
    }

    protected LightweightTypeReference getSubstitutedExpectedType(int argumentIndex) {
        XExpression expression = this.arguments.getArgument(argumentIndex);
        if (expression == null) {
            return null;
        }
        LightweightTypeReference expectedType = this.getExpectedType(expression);
        if (expectedType != null && expectedType instanceof UnboundTypeReference) {
            JvmTypeParameter typeParameter = ((UnboundTypeReference)expectedType).getTypeParameter();
            expectedType = expectedType.getOwner().newParameterizedTypeReference((JvmType)typeParameter);
        }
        return expectedType;
    }

    protected List<LightweightTypeReference> getSyntacticTypeArguments() {
        ArrayList result = Lists.newArrayList();
        List<JvmTypeReference> typeArguments = this.getPlainSyntacticTypeArguments();
        ITypeReferenceOwner referenceOwner = this.getState().getReferenceOwner();
        int i = 0;
        int size = typeArguments.size();
        while (i < size) {
            LightweightTypeReference typeArgument = referenceOwner.toLightweightTypeReference(typeArguments.get(i));
            result.add(typeArgument);
            ++i;
        }
        return result;
    }

    protected abstract List<JvmTypeReference> getPlainSyntacticTypeArguments();

    @Override
    public abstract JvmIdentifiableElement getFeature();

    public Expression getExpression() {
        return this.expression;
    }

    protected boolean hasReceiver() {
        return false;
    }

    public boolean isTypeLiteral() {
        return false;
    }

    protected ExpressionTypeComputationState getState() {
        return this.state;
    }

    protected boolean mustDiscardRefinement() {
        Expression expression = this.getExpression();
        if (expression instanceof XAssignment) {
            JvmIdentifiableElement feature = this.getFeature();
            if (feature instanceof XVariableDeclaration) {
                return ((XVariableDeclaration)feature).isWriteable();
            }
            if (feature instanceof JvmField) {
                return !((JvmField)feature).isFinal();
            }
        }
        return false;
    }

    protected void discardRefinementTypeIfReassigned() {
        if (this.mustDiscardRefinement()) {
            this.getState().discardReassignedTypes(this.getFeature());
        }
    }

    protected class ArgumentTypeComputationState
    extends AbstractStackedTypeComputationState {
        private final LightweightTypeReference expectedType;
        private final int defaultFlags;

        public ArgumentTypeComputationState(AbstractTypeComputationState parent, LightweightTypeReference expectedType, int defaultFlags) {
            super(parent.getResolvedTypes(), parent.getFeatureScopeSession(), parent);
            this.expectedType = expectedType;
            this.defaultFlags = defaultFlags;
        }

        @Override
        protected List<AbstractTypeExpectation> getExpectations(AbstractTypeComputationState actualState) {
            AbstractTypeExpectation result = this.createTypeExpectation(this.expectedType, actualState, false, this.defaultFlags);
            return Collections.singletonList(result);
        }

        protected AbstractTypeExpectation createTypeExpectation(LightweightTypeReference expectedType, AbstractTypeComputationState actualState, boolean returnType, int flags) {
            AbstractReturnAwareTypeExpectation result = null;
            if (expectedType != null) {
                LightweightTypeReference copied = expectedType.copyInto(actualState.getReferenceOwner());
                result = new ObservableTypeExpectation(copied, actualState, returnType, flags);
            } else {
                result = new NoExpectation(actualState, returnType);
            }
            return result;
        }

        protected int getDefaultFlags() {
            return this.defaultFlags;
        }

        protected LightweightTypeReference getExpectedType() {
            return this.expectedType;
        }
    }

    protected class ObservableTypeExpectation
    extends TypeExpectation {
        private int flags;

        public ObservableTypeExpectation(LightweightTypeReference expectedType, AbstractTypeComputationState state, boolean returnType, int flags) {
            super(expectedType, state, returnType);
            this.flags = flags;
        }

        @Override
        public void acceptActualType(LightweightTypeReference type, int flags) {
            AbstractLinkingCandidate.this.accept(this, type);
            super.acceptActualType(type, flags | this.flags);
        }

        @Override
        public ObservableTypeExpectation copyInto(ITypeReferenceOwner referenceOwner) {
            LightweightTypeReference expectedType = this.getExpectedType();
            if (expectedType == null || expectedType.isOwnedBy(referenceOwner)) {
                return this;
            }
            return new ObservableTypeExpectation(expectedType.copyInto(referenceOwner), this.getState(), this.isReturnType(), this.flags);
        }
    }
}

