/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputer;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

@Singleton
public class BoundTypeArgumentMerger {
    @Inject
    private TypeConformanceComputer conformanceComputer;

    public LightweightMergedBoundTypeArgument merge(Collection<LightweightBoundTypeArgument> allArguments, ITypeReferenceOwner owner) {
        TypeConformanceComputer conformanceComputer;
        if (allArguments.isEmpty()) {
            return null;
        }
        if (allArguments.size() == 1) {
            LightweightBoundTypeArgument argument = (LightweightBoundTypeArgument)Iterables.getOnlyElement(allArguments);
            return this.getSingleArgumentAsMergedArgument(argument);
        }
        ArrayList invariantTypes = Lists.newArrayListWithCapacity((int)3);
        ArrayList invariantVariances = Lists.newArrayListWithCapacity((int)3);
        ArrayList outTypes = Lists.newArrayListWithCapacity((int)3);
        ArrayList constraintOutTypes = Lists.newArrayListWithCapacity((int)3);
        ArrayList outVariances = Lists.newArrayListWithCapacity((int)3);
        ArrayList inTypes = Lists.newArrayListWithCapacity((int)3);
        ArrayList inVariances = Lists.newArrayListWithCapacity((int)3);
        HashSet seenOrigin = Sets.newHashSet();
        block5: for (LightweightBoundTypeArgument boundTypeArgument : allArguments) {
            Object origin = boundTypeArgument.getOrigin();
            switch (boundTypeArgument.getDeclaredVariance()) {
                case INVARIANT: {
                    invariantTypes.add(boundTypeArgument.getTypeReference());
                    if (!seenOrigin.add(origin) && origin != null && !boundTypeArgument.isValidVariancePair()) continue block5;
                    invariantVariances.add(boundTypeArgument.getActualVariance());
                    break;
                }
                case OUT: {
                    if (boundTypeArgument.getSource() == BoundTypeArgumentSource.CONSTRAINT) {
                        constraintOutTypes.add(boundTypeArgument.getTypeReference());
                    } else {
                        outTypes.add(boundTypeArgument.getTypeReference());
                    }
                    if (!seenOrigin.add(origin) && origin != null && !boundTypeArgument.isValidVariancePair()) continue block5;
                    outVariances.add(boundTypeArgument.getActualVariance());
                    break;
                }
                case IN: {
                    inTypes.add(boundTypeArgument.getTypeReference());
                    if (!seenOrigin.add(origin) && origin != null && !boundTypeArgument.isValidVariancePair()) continue block5;
                    inVariances.add(boundTypeArgument.getActualVariance());
                }
            }
        }
        LightweightTypeReference type = null;
        VarianceInfo variance = null;
        if (outTypes.isEmpty() && inTypes.isEmpty()) {
            outTypes = constraintOutTypes;
        }
        if (!invariantTypes.isEmpty()) {
            type = (LightweightTypeReference)invariantTypes.get(0);
            variance = VarianceInfo.INVARIANT.mergeDeclaredWithActuals(invariantVariances);
            if (variance == null && invariantVariances.contains((Object)VarianceInfo.IN) && invariantTypes.size() > 1) {
                conformanceComputer = owner.getServices().getTypeConformanceComputer();
                type = conformanceComputer.getCommonSuperType(invariantTypes, owner);
            }
            if (!outVariances.isEmpty()) {
                VarianceInfo outVariance = VarianceInfo.OUT.mergeDeclaredWithActuals(outVariances);
                variance = VarianceInfo.OUT.mergeInvariance(variance, outVariance);
            } else if (!inVariances.isEmpty()) {
                VarianceInfo inVariance = VarianceInfo.IN.mergeDeclaredWithActuals(inVariances);
                variance = VarianceInfo.IN.mergeInvariance(variance, inVariance);
            }
        } else if (!outTypes.isEmpty()) {
            conformanceComputer = owner.getServices().getTypeConformanceComputer();
            type = conformanceComputer.getCommonSuperType(outTypes, owner);
            if (type == null) {
                throw new IllegalStateException("common super type may not be null");
            }
            variance = VarianceInfo.OUT.mergeDeclaredWithActuals(outVariances);
            if (!inVariances.isEmpty()) {
                LightweightTypeReference inType = this.getMostSpecialType(inTypes);
                boolean conformant = type.isAssignableFrom(inType, new TypeConformanceComputationArgument(false, true, false, false, true, false));
                if (conformant) {
                    VarianceInfo inVariance = VarianceInfo.IN.mergeDeclaredWithActuals(inVariances);
                    variance = VarianceInfo.IN.mergeWithOut(variance, inVariance, conformant);
                } else {
                    boolean reverseConformant = inType.isAssignableFrom(type, new TypeConformanceComputationArgument(false, false, false, false, true, false));
                    if (reverseConformant && variance == VarianceInfo.INVARIANT && VarianceInfo.IN.mergeDeclaredWithActuals(inVariances) == VarianceInfo.INVARIANT) {
                        if (VarianceInfo.IN.mergeDeclaredWithActuals(outVariances) != null) {
                            type = inType;
                            variance = VarianceInfo.OUT;
                        }
                    } else {
                        VarianceInfo inVariance = VarianceInfo.IN.mergeDeclaredWithActuals(inVariances);
                        variance = VarianceInfo.IN.mergeWithOut(variance, inVariance, conformant);
                    }
                }
            }
        } else if (!inTypes.isEmpty()) {
            type = this.getMostSpecialType(inTypes);
            variance = VarianceInfo.IN.mergeDeclaredWithActuals(inVariances);
        }
        return new LightweightMergedBoundTypeArgument(type, variance);
    }

    protected LightweightMergedBoundTypeArgument getSingleArgumentAsMergedArgument(LightweightBoundTypeArgument argument) {
        LightweightTypeReference typeReference = argument.getTypeReference();
        VarianceInfo varianceInfo = argument.getDeclaredVariance().mergeDeclaredWithActual(argument.getActualVariance());
        if (argument.getDeclaredVariance() == VarianceInfo.IN && varianceInfo == VarianceInfo.INVARIANT && typeReference instanceof WildcardTypeReference) {
            typeReference = ((WildcardTypeReference)typeReference).getInvariantBoundSubstitute();
        }
        return new LightweightMergedBoundTypeArgument(typeReference, varianceInfo);
    }

    public boolean isPossibleMergeResult(List<LightweightBoundTypeArgument> allArguments, LightweightTypeReference candidate) {
        LightweightTypeReference singleReference;
        LightweightBoundTypeArgument singleArgument;
        if (allArguments.isEmpty()) {
            return false;
        }
        if (allArguments.size() == 1 && !candidate.isWildcard() && VarianceInfo.OUT.equals((Object)(singleArgument = allArguments.get(0)).getActualVariance()) && singleArgument.getActualVariance().equals((Object)singleArgument.getDeclaredVariance()) && (singleReference = singleArgument.getTypeReference()).isResolved()) {
            return candidate.isAssignableFrom(singleReference, new TypeConformanceComputationArgument());
        }
        LightweightMergedBoundTypeArgument merged = this.merge(allArguments, candidate.getOwner());
        if (merged == null) {
            return false;
        }
        VarianceInfo variance = merged.getVariance();
        LightweightTypeReference type = merged.getTypeReference();
        if (variance == null || type == null) {
            return false;
        }
        switch (variance) {
            case INVARIANT: {
                int result = candidate.internalIsAssignableFrom(type, new TypeConformanceComputationArgument(false, true, true, true, false, false));
                return (result & 0x200) != 0 && (result & 0x8000) == 0;
            }
            case OUT: {
                return type.isAssignableFrom(candidate, new TypeConformanceComputationArgument());
            }
            case IN: {
                return candidate.isAssignableFrom(type, new TypeConformanceComputationArgument());
            }
        }
        throw new IllegalStateException("Unknown variance info: " + (Object)((Object)variance));
    }

    protected LightweightTypeReference getMostSpecialType(List<LightweightTypeReference> candidates) {
        LightweightTypeReference type = this.conformanceComputer.getMostSpecialType(candidates);
        if (type == null) {
            type = candidates.get(0);
        }
        return type;
    }
}

