/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.scoping.batch.FeatureScopes;
import org.eclipse.xtext.xbase.scoping.batch.IBatchScopeProvider;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.EmptyResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

public abstract class AbstractBatchTypeResolver
implements IBatchTypeResolver {
    @Inject
    private IBatchScopeProvider scopeProvider;
    @Inject
    private FeatureScopes featureScopes;
    @Inject
    private CommonTypeComputationServices services;

    protected AbstractBatchTypeResolver() {
    }

    public IResolvedTypes resolveTypes(Resource resource) {
        return this.resolveTypes(resource, null);
    }

    public final IResolvedTypes resolveTypes(EObject object) {
        return this.resolveTypes(object, null);
    }

    public final IResolvedTypes resolveTypes(EObject object, CancelIndicator monitor) {
        if (object == null || object.eIsProxy()) {
            return IResolvedTypes.NULL;
        }
        return this.doResolveTypes(object, monitor);
    }

    public IResolvedTypes resolveTypes(Resource resource, CancelIndicator monitor) {
        EList resourceContents = resource.getContents();
        if (resourceContents.isEmpty()) {
            IFeatureScopeSession session = this.scopeProvider.newSession(resource);
            return new EmptyResolvedTypes(session, this.featureScopes, new StandardTypeReferenceOwner(this.services, resource));
        }
        return this.resolveTypes((EObject)resourceContents.get(0), monitor);
    }

    protected abstract IResolvedTypes doResolveTypes(EObject var1, CancelIndicator var2);
}

