/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.formatting;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parsetree.reconstr.impl.NodeIterator;
import org.eclipse.xtext.xbase.formatting.CommentInfo;
import org.eclipse.xtext.xbase.formatting.HiddenLeafs;
import org.eclipse.xtext.xbase.formatting.LeafInfo;
import org.eclipse.xtext.xbase.formatting.NodeModelAccess;
import org.eclipse.xtext.xbase.formatting.WhitespaceInfo;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HiddenLeafAccess {
    @Inject
    @Extension
    private NodeModelAccess _nodeModelAccess;

    public HiddenLeafs getHiddenLeafsBefore(INode node) {
        boolean _notEquals;
        HiddenLeafs _xblockexpression = null;
        Functions.Function1<ILeafNode, Boolean> _function = new Functions.Function1<ILeafNode, Boolean>(){

            public Boolean apply(ILeafNode it) {
                boolean _isHidden = it.isHidden();
                return !_isHidden;
            }
        };
        ILeafNode start = this._nodeModelAccess.findNextLeaf(node, (Functions.Function1<? super ILeafNode, ? extends Boolean>)_function);
        List<ILeafNode> nodes = this.findPreviousHiddenLeafs((INode)start);
        HiddenLeafs _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)start, null);
        if (_notEquals) {
            int _xifexpression_1 = 0;
            boolean _isEmpty = nodes.isEmpty();
            if (_isEmpty) {
                _xifexpression_1 = start.getOffset();
            } else {
                ILeafNode _head = (ILeafNode)IterableExtensions.head(nodes);
                _xifexpression_1 = _head.getOffset();
            }
            _xifexpression = this.newHiddenLeafs(_xifexpression_1, nodes);
        } else {
            int _offset = 0;
            if (node != null) {
                _offset = node.getOffset();
            }
            _xifexpression = new HiddenLeafs(_offset);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected HiddenLeafs newHiddenLeafs(int offset, List<ILeafNode> nodes) {
        HiddenLeafs _xblockexpression = null;
        HiddenLeafs result = new HiddenLeafs(offset);
        boolean trailing = true;
        for (ILeafNode node : nodes) {
            boolean _not;
            boolean comment = false;
            int newLines = 0;
            String _text = node.getText();
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)_text);
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                String _text_1 = node.getText();
                int _length = _text_1.length();
                int _minus = _length - 1;
                IntegerRange _upTo = new IntegerRange(0, _minus);
                for (Integer i : _upTo) {
                    boolean _not_1;
                    String _text_2 = node.getText();
                    char c = _text_2.charAt(i);
                    String _string = Character.valueOf(c).toString();
                    boolean _equals = Objects.equal((Object)_string, (Object)"\n");
                    if (_equals) {
                        ++newLines;
                        continue;
                    }
                    boolean _isWhitespace = Character.isWhitespace(c);
                    boolean bl2 = _not_1 = !_isWhitespace;
                    if (!_not_1) continue;
                    comment = true;
                }
            }
            if (comment) {
                List<LeafInfo> _leafs = result.getLeafs();
                LeafInfo _last = (LeafInfo)IterableExtensions.last(_leafs);
                if (!(_last instanceof WhitespaceInfo)) {
                    List<LeafInfo> _leafs_1 = result.getLeafs();
                    int _offset = node.getOffset();
                    WhitespaceInfo _whitespaceInfo = new WhitespaceInfo(result, null, 0, _offset);
                    _leafs_1.add(_whitespaceInfo);
                }
                List<LeafInfo> _leafs_2 = result.getLeafs();
                CommentInfo _commentInfo = new CommentInfo(result, node, newLines, trailing);
                _leafs_2.add(_commentInfo);
            } else {
                List<LeafInfo> _leafs_3 = result.getLeafs();
                int _offset_1 = node.getOffset();
                WhitespaceInfo _whitespaceInfo_1 = new WhitespaceInfo(result, node, newLines, _offset_1);
                _leafs_3.add(_whitespaceInfo_1);
            }
            if (newLines <= 0) continue;
            trailing = false;
        }
        List<LeafInfo> _leafs = result.getLeafs();
        LeafInfo _last = (LeafInfo)IterableExtensions.last(_leafs);
        if (!(_last instanceof WhitespaceInfo)) {
            List<LeafInfo> _leafs_1 = result.getLeafs();
            int _xifexpression = 0;
            List<LeafInfo> _leafs_2 = result.getLeafs();
            boolean _isEmpty = _leafs_2.isEmpty();
            if (_isEmpty) {
                _xifexpression = offset;
            } else {
                List<LeafInfo> _leafs_3 = result.getLeafs();
                LeafInfo _last_1 = (LeafInfo)IterableExtensions.last(_leafs_3);
                ILeafNode _node = _last_1.getNode();
                _xifexpression = _node.getEndOffset();
            }
            WhitespaceInfo _whitespaceInfo = new WhitespaceInfo(result, null, 0, _xifexpression);
            _leafs_1.add(_whitespaceInfo);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public HiddenLeafs getHiddenLeafsAfter(INode node) {
        boolean _notEquals;
        HiddenLeafs _xblockexpression = null;
        Functions.Function1<ILeafNode, Boolean> _function = new Functions.Function1<ILeafNode, Boolean>(){

            public Boolean apply(ILeafNode it) {
                boolean _isHidden = it.isHidden();
                return !_isHidden;
            }
        };
        ILeafNode start = this.findPreviousLeaf(node, (Functions.Function1<? super ILeafNode, ? extends Boolean>)_function);
        HiddenLeafs _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)start, null);
        if (_notEquals) {
            int _endOffset = start.getEndOffset();
            List<ILeafNode> _findNextHiddenLeafs = this.findNextHiddenLeafs((INode)start);
            _xifexpression = this.newHiddenLeafs(_endOffset, _findNextHiddenLeafs);
        } else {
            int _offset = 0;
            if (node != null) {
                _offset = node.getOffset();
            }
            _xifexpression = new HiddenLeafs(_offset);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected List<ILeafNode> findNextHiddenLeafs(INode node) {
        ArrayList _xblockexpression = null;
        ArrayList result = CollectionLiterals.newArrayList((Object[])new ILeafNode[0]);
        NodeIterator ni = new NodeIterator(node);
        while (ni.hasNext()) {
            INode next = ni.next();
            if (!(next instanceof ILeafNode)) continue;
            boolean _isHidden = ((ILeafNode)next).isHidden();
            if (_isHidden) {
                result.add((ILeafNode)next);
                continue;
            }
            return result;
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    protected ILeafNode findPreviousLeaf(INode node, Functions.Function1<? super ILeafNode, ? extends Boolean> matches) {
        boolean _notEquals;
        INode current = node;
        while (current instanceof ICompositeNode) {
            INode _lastChild;
            current = _lastChild = ((ICompositeNode)current).getLastChild();
        }
        boolean _and = false;
        if (!(current instanceof ILeafNode)) {
            _and = false;
        } else {
            Boolean _apply = (Boolean)matches.apply((Object)((ILeafNode)current));
            _and = _apply;
        }
        if (_and) {
            return (ILeafNode)current;
        }
        boolean bl = _notEquals = !Objects.equal((Object)current, null);
        if (_notEquals) {
            NodeIterator ni = new NodeIterator(current);
            while (ni.hasPrevious()) {
                INode previous = ni.previous();
                boolean _and_1 = false;
                if (!(previous instanceof ILeafNode)) {
                    _and_1 = false;
                } else {
                    Boolean _apply_1 = (Boolean)matches.apply((Object)((ILeafNode)previous));
                    _and_1 = _apply_1;
                }
                if (!_and_1) continue;
                return (ILeafNode)previous;
            }
        }
        return null;
    }

    protected List<ILeafNode> findPreviousHiddenLeafs(INode node) {
        boolean _notEquals;
        List _xblockexpression = null;
        INode current = node;
        while (current instanceof ICompositeNode) {
            INode _lastChild;
            current = _lastChild = ((ICompositeNode)current).getLastChild();
        }
        ArrayList result = CollectionLiterals.newArrayList((Object[])new ILeafNode[0]);
        boolean bl = _notEquals = !Objects.equal((Object)current, null);
        if (_notEquals) {
            NodeIterator ni = new NodeIterator(current);
            while (ni.hasPrevious()) {
                INode previous = ni.previous();
                boolean _and = false;
                boolean _notEquals_1 = !Objects.equal((Object)previous, (Object)current);
                _and = !_notEquals_1 ? false : previous instanceof ILeafNode;
                if (!_and) continue;
                boolean _isHidden = ((ILeafNode)previous).isHidden();
                if (_isHidden) {
                    result.add((ILeafNode)previous);
                    continue;
                }
                return ListExtensions.reverse((List)result);
            }
        }
        _xblockexpression = ListExtensions.reverse((List)result);
        return _xblockexpression;
    }
}

