/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameterAndNonNullResult;
import org.eclipse.xtext.xbase.typesystem.references.UnknownTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeParameterSubstitutor<Visiting>
extends TypeReferenceVisitorWithParameterAndNonNullResult<Visiting, LightweightTypeReference> {
    private final Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> typeParameterMapping;
    private final ITypeReferenceOwner owner;

    public TypeParameterSubstitutor(Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> typeParameterMapping, ITypeReferenceOwner owner) {
        this.owner = owner;
        this.typeParameterMapping = Maps.newLinkedHashMap(typeParameterMapping);
    }

    protected Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getTypeParameterMapping() {
        return this.typeParameterMapping;
    }

    public void enhanceMapping(Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> typeParameterMapping) {
        this.typeParameterMapping.putAll(typeParameterMapping);
    }

    protected ITypeReferenceOwner getOwner() {
        return this.owner;
    }

    @Override
    protected LightweightTypeReference doVisitFunctionTypeReference(FunctionTypeReference reference, Visiting visiting) {
        if (reference.isResolved() && reference.isOwnedBy(this.getOwner())) {
            return reference;
        }
        FunctionTypeReference result = new FunctionTypeReference(this.getOwner(), reference.getType());
        for (LightweightTypeReference parameterType : reference.getParameterTypes()) {
            result.addParameterType(this.visitTypeArgument(parameterType, visiting));
        }
        for (LightweightTypeReference typeArgument : reference.getTypeArguments()) {
            result.addTypeArgument(this.visitTypeArgument(typeArgument, visiting));
        }
        LightweightTypeReference returnType = reference.getReturnType();
        if (returnType != null) {
            result.setReturnType(this.visitTypeArgument(returnType, visiting));
        }
        return result;
    }

    protected LightweightTypeReference visitTypeArgument(LightweightTypeReference reference, Visiting visiting) {
        return this.visitTypeArgument(reference, visiting, false);
    }

    protected LightweightTypeReference visitTypeArgument(LightweightTypeReference reference, Visiting visiting, boolean lowerBound) {
        return (LightweightTypeReference)reference.accept(this, visiting);
    }

    @Override
    protected LightweightTypeReference doVisitParameterizedTypeReference(ParameterizedTypeReference reference, Visiting visiting) {
        LightweightTypeReference boundTypeArgument;
        if (reference.isResolved() && reference.isOwnedBy(this.getOwner())) {
            return reference;
        }
        JvmType type = reference.getType();
        if (type instanceof JvmTypeParameter && (boundTypeArgument = this.getBoundTypeArgument(reference, (JvmTypeParameter)type, visiting)) != null) {
            return boundTypeArgument;
        }
        return this.doVisitParameterizedTypeReference(reference, type, visiting);
    }

    protected LightweightTypeReference doVisitParameterizedTypeReference(ParameterizedTypeReference reference, JvmType type, Visiting visiting) {
        ParameterizedTypeReference result = new ParameterizedTypeReference(this.getOwner(), type);
        for (LightweightTypeReference argument : reference.getTypeArguments()) {
            result.addTypeArgument(this.visitTypeArgument(argument, visiting));
        }
        return result;
    }

    protected LightweightTypeReference getBoundTypeArgument(ParameterizedTypeReference reference, JvmTypeParameter type, Visiting visiting) {
        LightweightTypeReference boundReference;
        LightweightMergedBoundTypeArgument boundTypeArgument = this.typeParameterMapping.get(type);
        if (boundTypeArgument != null && (boundReference = boundTypeArgument.getTypeReference()) != null && reference != boundReference && boundReference.getType() != type) {
            return (LightweightTypeReference)boundReference.accept(this, visiting);
        }
        return null;
    }

    @Override
    protected LightweightTypeReference doVisitWildcardTypeReference(WildcardTypeReference reference, Visiting visiting) {
        if (reference.isResolved() && reference.isOwnedBy(this.getOwner())) {
            return reference;
        }
        WildcardTypeReference result = new WildcardTypeReference(this.getOwner());
        LightweightTypeReference lowerBound = reference.getLowerBound();
        if (lowerBound != null) {
            LightweightTypeReference visited = this.visitTypeArgument(lowerBound, visiting, true);
            if (visited.isWildcard()) {
                LightweightTypeReference lowerBoundSubstitute = visited.getLowerBoundSubstitute();
                if (lowerBoundSubstitute.isAny()) {
                    JvmType objectType = this.getOwner().getServices().getTypeReferences().findDeclaredType(Object.class, (Notifier)this.getOwner().getContextResourceSet());
                    result.addUpperBound(new ParameterizedTypeReference(this.getOwner(), objectType));
                    return result;
                }
                result.setLowerBound(lowerBoundSubstitute);
            } else {
                result.setLowerBound(visited);
            }
        }
        for (LightweightTypeReference upperBound : reference.getUpperBounds()) {
            LightweightTypeReference visitedArgument = this.visitTypeArgument(upperBound, visiting);
            LightweightTypeReference upperBoundSubstitute = visitedArgument.getUpperBoundSubstitute();
            result.addUpperBound(upperBoundSubstitute);
        }
        if (result.getUpperBounds().isEmpty()) {
            throw new IllegalStateException("UpperBounds may not be empty");
        }
        return result;
    }

    @Override
    protected LightweightTypeReference doVisitArrayTypeReference(ArrayTypeReference reference, Visiting visiting) {
        if (reference.isResolved() && reference.isOwnedBy(this.getOwner())) {
            return reference;
        }
        LightweightTypeReference component = this.visitTypeArgument(reference.getComponentType(), visiting);
        component = component.getUpperBoundSubstitute();
        return new ArrayTypeReference(this.getOwner(), component);
    }

    @Override
    protected LightweightTypeReference doVisitAnyTypeReference(AnyTypeReference reference, Visiting visiting) {
        return reference;
    }

    @Override
    protected LightweightTypeReference doVisitUnknownTypeReference(UnknownTypeReference reference, Visiting param) {
        return reference;
    }

    @Override
    protected LightweightTypeReference doVisitCompoundTypeReference(CompoundTypeReference reference, Visiting visiting) {
        if (reference.isResolved() && reference.isOwnedBy(this.getOwner())) {
            return reference;
        }
        CompoundTypeReference result = new CompoundTypeReference(this.getOwner(), reference.isSynonym());
        for (LightweightTypeReference component : reference.getMultiTypeComponents()) {
            result.addComponent(this.visitTypeArgument(component, visiting));
        }
        return result;
    }

    public LightweightTypeReference substitute(LightweightTypeReference original) {
        if (this.typeParameterMapping.isEmpty()) {
            return original;
        }
        return (LightweightTypeReference)original.accept(this, this.createVisiting());
    }

    public LightweightTypeReference substitute(JvmTypeReference original) {
        LightweightTypeReference lightweightReference = new OwnedConverter(this.getOwner()).toLightweightReference(original);
        return this.substitute(lightweightReference);
    }

    protected abstract Visiting createVisiting();

    protected LightweightTypeReference copy(LightweightTypeReference reference) {
        return reference.copyInto(this.getOwner());
    }

    public String toString() {
        return String.format("%s with mapping: %s", this.getClass().getSimpleName(), this.getTypeParameterMapping());
    }
}

