/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTraversalData;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.ConstraintAwareTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.ConstraintVisitingInfo;
import org.eclipse.xtext.xbase.typesystem.util.CustomTypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeParameterByConstraintSubstitutor
extends CustomTypeParameterSubstitutor {
    private final boolean ignoreDeclaredTypeParameters;

    public TypeParameterByConstraintSubstitutor(Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> typeParameterMapping, ITypeReferenceOwner owner) {
        this(typeParameterMapping, owner, false);
    }

    public TypeParameterByConstraintSubstitutor(Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> typeParameterMapping, ITypeReferenceOwner owner, boolean ignoreDeclaredTypeParameters) {
        super(typeParameterMapping, owner);
        this.ignoreDeclaredTypeParameters = ignoreDeclaredTypeParameters;
    }

    @Override
    protected LightweightTypeReference doVisitUnboundTypeReference(UnboundTypeReference reference, ConstraintVisitingInfo visiting) {
        JvmTypeParameter typeParameter = reference.getTypeParameter();
        if (!visiting.tryVisit(typeParameter)) {
            LightweightTypeReference mappedReference = this.getDeclaredUpperBound(typeParameter, visiting);
            this.getTypeParameterMapping().put(typeParameter, new LightweightMergedBoundTypeArgument(mappedReference, VarianceInfo.INVARIANT));
            if (mappedReference != null) {
                return mappedReference;
            }
            return this.getObjectReference();
        }
        try {
            LightweightTypeReference mappedReference;
            LightweightMergedBoundTypeArgument boundTypeArgument = this.getTypeParameterMapping().get(typeParameter);
            if (boundTypeArgument != null && boundTypeArgument.getTypeReference() != reference) {
                LightweightTypeReference result;
                LightweightTypeReference lightweightTypeReference = result = boundTypeArgument.getTypeReference().accept(this, visiting);
                return lightweightTypeReference;
            }
            JvmTypeParameterDeclarator currentDeclarator = visiting.getCurrentDeclarator();
            LightweightTypeReference lightweightTypeReference = mappedReference = currentDeclarator != null ? this.getDeclaredUpperBound(currentDeclarator, visiting.getCurrentIndex(), visiting) : this.getDeclaredUpperBound(typeParameter, visiting);
            if (mappedReference == null) {
                mappedReference = this.getObjectReference();
            }
            this.getTypeParameterMapping().put(typeParameter, new LightweightMergedBoundTypeArgument(mappedReference, VarianceInfo.INVARIANT));
            LightweightTypeReference lightweightTypeReference2 = mappedReference;
            return lightweightTypeReference2;
        }
        finally {
            visiting.didVisit(typeParameter);
        }
    }

    @Override
    protected LightweightTypeReference visitTypeArgument(LightweightTypeReference reference, ConstraintVisitingInfo visiting, boolean lowerBound) {
        JvmTypeParameter typeParameter;
        if (lowerBound && reference instanceof ParameterizedTypeReference && reference.getType() instanceof JvmTypeParameter && !visiting.canVisit(typeParameter = (JvmTypeParameter)reference.getType())) {
            WildcardTypeReference result = new WildcardTypeReference(reference.getOwner());
            JvmType objectType = this.getOwner().getServices().getTypeReferences().findDeclaredType(Object.class, (Notifier)this.getOwner().getContextResourceSet());
            result.addUpperBound(new ParameterizedTypeReference(this.getOwner(), objectType));
            return result;
        }
        return super.visitTypeArgument(reference, visiting, lowerBound);
    }

    @Override
    protected LightweightTypeReference getDeclaredUpperBound(JvmTypeParameter typeParameter, ConstraintVisitingInfo visiting) {
        if (!typeParameter.getConstraints().isEmpty() && ((DeclaredConstraintVisitingInfo)visiting).tryVisitDeclaredUpperBoundsOf(typeParameter)) {
            try {
                JvmTypeConstraint constraint = (JvmTypeConstraint)typeParameter.getConstraints().get(0);
                if (constraint instanceof JvmUpperBound) {
                    LightweightTypeReference reference = new OwnedConverter(this.getOwner()).toLightweightReference(constraint.getTypeReference());
                    if (visiting.getCurrentDeclarator() != reference.getType()) {
                        LightweightTypeReference lightweightTypeReference = reference.accept(this, visiting);
                        return lightweightTypeReference;
                    }
                    WildcardTypeReference result = new WildcardTypeReference(this.getOwner());
                    result.addUpperBound(this.getObjectReference());
                    WildcardTypeReference wildcardTypeReference = result;
                    return wildcardTypeReference;
                }
            }
            finally {
                ((DeclaredConstraintVisitingInfo)visiting).didVisitDeclaredUpperBoundsOf(typeParameter);
            }
        }
        return null;
    }

    @Override
    protected DeclaredConstraintVisitingInfo createVisiting() {
        return new DeclaredConstraintVisitingInfo();
    }

    public LightweightTypeReference substitute(JvmTypeParameter original) {
        return this.substitute(new ParameterizedTypeReference(this.getOwner(), (JvmType)original));
    }

    @Override
    protected LightweightTypeReference getUnmappedSubstitute(ParameterizedTypeReference reference, JvmTypeParameter type, ConstraintVisitingInfo visiting) {
        if (!this.ignoreDeclaredTypeParameters && this.isDeclaredTypeParameter(type)) {
            return reference;
        }
        ConstraintAwareTypeArgumentCollector collector = new ConstraintAwareTypeArgumentCollector(this.getOwner());
        LightweightTraversalData data = new LightweightTraversalData();
        data.getTypeParameterMapping().putAll(this.getTypeParameterMapping());
        reference.accept(collector, data);
        LightweightMergedBoundTypeArgument boundTypeArgument = data.getTypeParameterMapping().get(type);
        if (boundTypeArgument != null && boundTypeArgument.getTypeReference() != reference) {
            return boundTypeArgument.getTypeReference().accept(this, visiting);
        }
        if (boundTypeArgument != null) {
            return boundTypeArgument.getTypeReference();
        }
        return null;
    }

    protected static class DeclaredConstraintVisitingInfo
    extends ConstraintVisitingInfo {
        private Set<JvmTypeParameter> upperBounds = Sets.newHashSetWithExpectedSize((int)2);

        protected DeclaredConstraintVisitingInfo() {
        }

        public boolean tryVisitDeclaredUpperBoundsOf(JvmTypeParameter typeParameter) {
            return this.upperBounds.add(typeParameter);
        }

        public void didVisitDeclaredUpperBoundsOf(JvmTypeParameter typeParameter) {
            this.upperBounds.remove(typeParameter);
        }
    }
}

