/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.legacy;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.FeatureOverridesService;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.typesystem.legacy.LegacyTypeArgumentContext;
import org.eclipse.xtext.xbase.typesystem.legacy.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameterAndNonNullResult;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.StandardTypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterByConstraintSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class LegacyFeatureOverridesService
extends FeatureOverridesService {
    @Inject
    private CommonTypeComputationServices services;
    @Inject
    private TypeReferences typeReferences;

    public Iterable<JvmFeature> getAllJvmFeatures(JvmTypeReference type) {
        ITypeReferenceOwner owner = this.createTypeReferenceOwner((EObject)type.getType());
        LightweightTypeReference lightweightReference = new OwnedConverter(owner).toLightweightReference(type);
        ArrayList result = Lists.newArrayList(this.getAllOperations(lightweightReference, IVisibilityHelper.ALL));
        this.addDeclaredConstructors(lightweightReference, result);
        for (LightweightTypeReference superType : lightweightReference.getSuperTypes()) {
            this.addDeclaredConstructors(superType, result);
        }
        return result;
    }

    protected void addDeclaredConstructors(LightweightTypeReference lightweightReference, List<JvmFeature> result) {
        JvmType rawType = lightweightReference.getRawTypeReference().getType();
        if (rawType instanceof JvmGenericType) {
            Iterables.addAll(result, (Iterable)((JvmGenericType)rawType).getDeclaredConstructors());
        }
    }

    public ITypeReferenceOwner createTypeReferenceOwner(EObject context) {
        Resource resource = context.eResource();
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, resource.getResourceSet());
        return owner;
    }

    public Iterable<JvmFeature> getAllJvmFeatures(JvmDeclaredType type, ITypeArgumentContext ctx) {
        JvmParameterizedTypeReference typeReference = this.typeReferences.createTypeRef((JvmType)type, new JvmTypeReference[0]);
        return this.getAllJvmFeatures((JvmTypeReference)typeReference);
    }

    protected boolean isInheritanceRelation(JvmMember overriding, JvmMember overridden) {
        JvmDeclaredType subType = overridden.getDeclaringType();
        JvmDeclaredType superType = overridden.getDeclaringType();
        Resource resource = subType.eResource();
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, resource.getResourceSet());
        return new ParameterizedTypeReference(owner, (JvmType)subType).isSubtypeOf((JvmType)superType);
    }

    protected boolean hasSameTypeParameters(JvmOperation overriding, JvmOperation overridden, ITypeArgumentContext context) {
        EList overridingTypeParameters = overriding.getTypeParameters();
        EList overriddenTypeParameters = overridden.getTypeParameters();
        if (overridingTypeParameters.size() != overriddenTypeParameters.size()) {
            return false;
        }
        ITypeReferenceOwner owner = this.createTypeReferenceOwner((EObject)overriding);
        TypeParameterSubstitutor<?> substitutor = this.createSubstitutor(owner, overriding.getDeclaringType(), context);
        int i = 0;
        while (i < overridingTypeParameters.size()) {
            JvmTypeParameter overriddenTypeParameter;
            SubstitutingOperationTypeParameterVisitor visitor;
            JvmTypeParameter overridingTypeParameter = (JvmTypeParameter)overridingTypeParameters.get(i);
            if (!((LightweightTypeReference)new ParameterizedTypeReference(owner, (JvmType)overridingTypeParameter)).accept(visitor = new SubstitutingOperationTypeParameterVisitor(overriding, overridden, i, owner, substitutor), new ParameterizedTypeReference(owner, (JvmType)(overriddenTypeParameter = (JvmTypeParameter)overriddenTypeParameters.get(i)))).booleanValue()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected TypeParameterSubstitutor<?> createSubstitutor(ITypeReferenceOwner owner, JvmDeclaredType declaringType, ITypeArgumentContext context) {
        LightweightTypeReference declaringTypeReference = this.getDeclaringTypeReference(declaringType, owner, context);
        Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> parameterMapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(declaringTypeReference);
        StandardTypeParameterSubstitutor substitutor = new StandardTypeParameterSubstitutor(parameterMapping, owner);
        return substitutor;
    }

    public LightweightTypeReference getDeclaringTypeReference(JvmDeclaredType declaringType, ITypeReferenceOwner owner, ITypeArgumentContext context) {
        LightweightTypeReference declaringTypeReference = null;
        if (context instanceof LegacyTypeArgumentContext) {
            TypeArgumentContextProvider.Request request = ((LegacyTypeArgumentContext)context).getRequest();
            JvmTypeReference receiverType = request.getReceiverType();
            declaringTypeReference = new OwnedConverter(owner).toLightweightReference(receiverType);
        } else {
            JvmParameterizedTypeReference typeReference = this.typeReferences.createTypeRef((JvmType)declaringType, new JvmTypeReference[0]);
            declaringTypeReference = new OwnedConverter(owner).toLightweightReference((JvmTypeReference)typeReference);
        }
        return declaringTypeReference;
    }

    protected boolean isSameArgumentTypes(JvmOperation overriding, JvmOperation overridden, ITypeArgumentContext context) {
        ITypeReferenceOwner owner = this.createTypeReferenceOwner((EObject)overriding);
        OwnedConverter converter = new OwnedConverter(owner);
        LightweightTypeReference declaringTypeReference = this.getDeclaringTypeReference(overriding.getDeclaringType(), owner, context);
        Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> parameterMapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(declaringTypeReference);
        TypeParameterByConstraintSubstitutor substitur = new TypeParameterByConstraintSubstitutor(parameterMapping, owner);
        int i = 0;
        while (i < overriding.getParameters().size()) {
            JvmFormalParameter overridingParam = (JvmFormalParameter)overriding.getParameters().get(i);
            JvmFormalParameter overriddenParam = (JvmFormalParameter)overridden.getParameters().get(i);
            LightweightTypeReference overridingParamType = converter.toLightweightReference(overridingParam.getParameterType());
            LightweightTypeReference overriddenParamType = converter.toLightweightReference(overriddenParam.getParameterType());
            LightweightTypeReference resolvedOverridingType = substitur.substitute(overridingParamType);
            LightweightTypeReference resolvedOverriddenType = substitur.substitute(overriddenParamType);
            if (!resolvedOverridingType.getIdentifier().equals(resolvedOverriddenType.getIdentifier())) {
                return Boolean.FALSE;
            }
            ++i;
        }
        return true;
    }

    public List<JvmOperation> getAllOperations(JvmDeclaredType type, ITypeReferenceOwner owner, IVisibilityHelper visibilityHelper) {
        ParameterizedTypeReference declaringType = new ParameterizedTypeReference(owner, (JvmType)type);
        return this.getAllOperations(declaringType, visibilityHelper);
    }

    public List<JvmOperation> getAllOperations(LightweightTypeReference declaringType, IVisibilityHelper visibilityHelper) {
        if (!(declaringType.getType() instanceof JvmDeclaredType)) {
            return Collections.emptyList();
        }
        Iterable allFeatures = ((JvmDeclaredType)declaringType.getType()).getAllFeatures();
        TypeParameterSubstitutor<?> substitutor = this.createSubstitutor(declaringType.getOwner(), declaringType);
        OwnedConverter converter = new OwnedConverter(declaringType.getOwner());
        ArrayList result = Lists.newArrayList();
        HashSet signatures = Sets.newHashSet();
        for (JvmFeature feature : allFeatures) {
            JvmOperation operation;
            if (!(feature instanceof JvmOperation) || !visibilityHelper.isVisible((JvmMember)(operation = (JvmOperation)feature))) continue;
            if (!operation.isStatic()) {
                EList parameters = operation.getParameters();
                StringBuilder signature = new StringBuilder(operation.getSimpleName());
                if (parameters.isEmpty()) {
                    signature.append("()");
                } else {
                    signature.append("(");
                    for (JvmFormalParameter parameter : parameters) {
                        JvmTypeReference pType = parameter.getParameterType();
                        if (pType != null) {
                            LightweightTypeReference parameterType = substitutor.substitute(converter.toLightweightReference(pType));
                            signature.append(parameterType.getJavaIdentifier());
                        } else {
                            signature.append("<Unknown>");
                        }
                        signature.append(",");
                    }
                    signature.replace(signature.length() - 1, signature.length(), ")");
                }
                if (!signatures.add(signature.toString())) continue;
                result.add(operation);
                continue;
            }
            result.add(operation);
        }
        return result;
    }

    protected TypeParameterSubstitutor<?> createSubstitutor(ITypeReferenceOwner owner, LightweightTypeReference declaringType) {
        Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> parameterMapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(declaringType);
        StandardTypeParameterSubstitutor substitutor = new StandardTypeParameterSubstitutor(parameterMapping, owner);
        return substitutor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SubstitutingOperationTypeParameterVisitor
    extends TypeReferenceVisitorWithParameterAndNonNullResult<LightweightTypeReference, Boolean> {
        private JvmOperation overriding;
        private JvmOperation overridden;
        private int seed;
        private TypeParameterSubstitutor<?> substitutor;
        private ITypeReferenceOwner owner;

        public SubstitutingOperationTypeParameterVisitor(JvmOperation overriding, JvmOperation overridden, int seed, ITypeReferenceOwner owner, TypeParameterSubstitutor<?> substitutor) {
            this.overriding = overriding;
            this.overridden = overridden;
            this.seed = seed;
            this.owner = owner;
            this.substitutor = substitutor;
        }

        @Override
        protected Boolean doVisitArrayTypeReference(ArrayTypeReference reference, LightweightTypeReference param) {
            LightweightTypeReference componentType = param.getComponentType();
            if (componentType != null) {
                return reference.getComponentType().accept(this, componentType);
            }
            return Boolean.FALSE;
        }

        @Override
        protected Boolean doVisitAnyTypeReference(AnyTypeReference reference, LightweightTypeReference param) {
            return param.isAny();
        }

        @Override
        protected Boolean doVisitParameterizedTypeReference(ParameterizedTypeReference reference, LightweightTypeReference param) {
            if (param instanceof ParameterizedTypeReference) {
                JvmType type = reference.getType();
                JvmType otherType = param.getType();
                if (type instanceof JvmTypeParameter) {
                    JvmTypeParameter typeParameter = (JvmTypeParameter)type;
                    if (otherType instanceof JvmTypeParameter) {
                        if (type == otherType) {
                            return Boolean.TRUE;
                        }
                        JvmTypeParameter otherTypeParameter = (JvmTypeParameter)otherType;
                        if (typeParameter.getDeclarator() == this.overriding) {
                            int index = this.overriding.getTypeParameters().indexOf((Object)typeParameter);
                            if (index < 0) {
                                throw new IllegalStateException("declarator has to contain its type parameters");
                            }
                            if (index == this.seed) {
                                this.seed = -this.seed - 1;
                                if (this.overridden.getTypeParameters().indexOf((Object)otherTypeParameter) != index) {
                                    return Boolean.FALSE;
                                }
                                return this.doVisitConstraints((List<JvmTypeConstraint>)typeParameter.getConstraints(), (List<JvmTypeConstraint>)otherTypeParameter.getConstraints());
                            }
                            if (this.seed == -index - 1) {
                                return Boolean.FALSE;
                            }
                        }
                    }
                } else if (type == otherType) {
                    List<LightweightTypeReference> typeArguments = reference.getTypeArguments();
                    List<LightweightTypeReference> otherTypeArguments = ((ParameterizedTypeReference)param).getTypeArguments();
                    return this.doVisitTypeArguments(typeArguments, otherTypeArguments);
                }
            }
            return Boolean.FALSE;
        }

        public Boolean doVisitTypeArguments(List<LightweightTypeReference> typeArguments, List<LightweightTypeReference> otherTypeArguments) {
            if (typeArguments.size() != otherTypeArguments.size()) {
                return Boolean.FALSE;
            }
            int i = 0;
            while (i < typeArguments.size()) {
                LightweightTypeReference otherTypeArgument;
                LightweightTypeReference typeArgument = typeArguments.get(i);
                if (!typeArgument.accept(this, otherTypeArgument = otherTypeArguments.get(i)).booleanValue()) {
                    return Boolean.FALSE;
                }
                ++i;
            }
            return Boolean.TRUE;
        }

        protected Boolean doVisitConstraints(List<JvmTypeConstraint> constraints, List<JvmTypeConstraint> otherConstraints) {
            if (constraints.size() != otherConstraints.size()) {
                return Boolean.FALSE;
            }
            OwnedConverter converter = new OwnedConverter(this.owner);
            int i = 0;
            while (i < constraints.size()) {
                LightweightTypeReference otherConstraintType;
                JvmTypeConstraint constraint = constraints.get(i);
                JvmTypeConstraint otherConstraint = otherConstraints.get(i);
                LightweightTypeReference constraintType = this.substitutor.substitute(converter.toLightweightReference(constraint.getTypeReference()));
                if (!constraintType.accept(this, otherConstraintType = this.substitutor.substitute(converter.toLightweightReference(otherConstraint.getTypeReference()))).booleanValue()) {
                    return Boolean.FALSE;
                }
                ++i;
            }
            return Boolean.TRUE;
        }

        @Override
        protected Boolean doVisitWildcardTypeReference(WildcardTypeReference reference, LightweightTypeReference param) {
            if (param.isWildcard()) {
                WildcardTypeReference otherWildcard = (WildcardTypeReference)param;
                LightweightTypeReference lowerBound = reference.getLowerBound();
                if (lowerBound != null) {
                    LightweightTypeReference otherLowerBound = otherWildcard.getLowerBound();
                    if (otherLowerBound == null) {
                        return Boolean.FALSE;
                    }
                    if (!lowerBound.accept(this, otherLowerBound).booleanValue()) {
                        return Boolean.FALSE;
                    }
                }
                return this.doVisitTypeArguments(reference.getUpperBounds(), otherWildcard.getUpperBounds());
            }
            return Boolean.FALSE;
        }

        @Override
        protected Boolean doVisitTypeReference(LightweightTypeReference reference, LightweightTypeReference param) {
            return Boolean.FALSE;
        }
    }
}

