/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmDelegateTypeReference;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmSynonymTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.IRawTypeHelper;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.compiler.AbstractXbaseCompiler;
import org.eclipse.xtext.xbase.compiler.Later;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typing.Closures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class TypeConvertingCompiler
extends AbstractXbaseCompiler {
    @Inject
    private Closures closures;
    @Inject
    private TypeArgumentContextProvider contextProvider;
    @Inject
    private IRawTypeHelper rawTypeHelper;

    @Override
    protected final void internalToJavaExpression(XExpression obj, ITreeAppendable appendable) {
        JvmTypeReference expectedType = this.getTypeProvider().getExpectedType(obj);
        this.internalToConvertedExpression(obj, appendable, expectedType);
    }

    @Override
    protected final void internalToConvertedExpression(final XExpression obj, ITreeAppendable appendable, @Nullable JvmTypeReference toBeConvertedTo) {
        JvmTypeReference actualType;
        if (toBeConvertedTo != null) {
            actualType = this.getType(obj);
            if (this.isPrimitiveVoid(actualType)) {
                actualType = toBeConvertedTo;
            }
            if (!EcoreUtil.equals((EObject)toBeConvertedTo, (EObject)actualType)) {
                this.doConversion(toBeConvertedTo, actualType, appendable, obj, new Later(){

                    public void exec(ITreeAppendable appendable) {
                        appendable = appendable.trace(obj, true);
                        TypeConvertingCompiler.this.internalToConvertedExpression(obj, appendable);
                    }
                });
                return;
            }
            if (this.mustInsertTypeCast(obj, actualType)) {
                this.doCastConversion(actualType, appendable, obj, new Later(){

                    public void exec(ITreeAppendable appendable) {
                        appendable = appendable.trace(obj, true);
                        TypeConvertingCompiler.this.internalToConvertedExpression(obj, appendable);
                    }
                });
                return;
            }
        } else {
            actualType = this.getType(obj);
            if (obj instanceof XAbstractFeatureCall && this.mustInsertTypeCast(obj, actualType)) {
                this.doCastConversion(actualType, appendable, obj, new Later(){

                    public void exec(ITreeAppendable appendable) {
                        appendable = appendable.trace(obj, true);
                        TypeConvertingCompiler.this.internalToConvertedExpression(obj, appendable);
                    }
                });
                return;
            }
        }
        ITreeAppendable trace = appendable.trace(obj, true);
        this.internalToConvertedExpression(obj, trace);
    }

    private boolean mustInsertTypeCast(XExpression expression, JvmTypeReference actualType) {
        IResolvedTypes resolvedTypes = this.getTypeResolver().resolveTypes(expression);
        if (resolvedTypes.isRefinedType(expression) || resolvedTypes.getActualType(expression).isMultiType()) {
            LightweightTypeReference featureType;
            if (expression instanceof XAbstractFeatureCall && (featureType = resolvedTypes.getActualType(((XAbstractFeatureCall)expression).getFeature())) != null && featureType.isSubtypeOf(actualType.getType()) && !featureType.isMultiType()) {
                return false;
            }
            return !(expression.eContainer() instanceof XCastedExpression);
        }
        return false;
    }

    protected void internalToConvertedExpression(XExpression obj, ITreeAppendable appendable) {
        super.internalToJavaExpression(obj, appendable);
    }

    protected void doConversion(JvmTypeReference left, JvmTypeReference right, ITreeAppendable appendable, XExpression context, Later expression) {
        if (this.getPrimitives().isPrimitive(left) && !this.getPrimitives().isPrimitive(right)) {
            if (right instanceof JvmAnyTypeReference) {
                this.convertWrapperToPrimitive(left, this.getPrimitives().asPrimitiveIfWrapperType(left), context, appendable, expression);
            } else {
                this.convertWrapperToPrimitive(right, this.getPrimitives().asPrimitiveIfWrapperType(right), context, appendable, expression);
            }
        } else if (this.getPrimitives().isPrimitive(right) && !this.getPrimitives().isPrimitive(left)) {
            this.convertPrimitiveToWrapper(right, this.getPrimitives().asWrapperTypeIfPrimitive(right), context, appendable, expression);
        } else if (right instanceof JvmMultiTypeReference) {
            this.convertMultiType(left, (JvmMultiTypeReference)right, context, appendable, expression);
        } else if (right instanceof JvmDelegateTypeReference) {
            this.doConversion(left, ((JvmDelegateTypeReference)right).getDelegate(), appendable, context, expression);
        } else if (this.getTypeReferences().isArray(right) && this.isList(left)) {
            this.convertArrayToList(left, appendable, context, expression);
        } else if (this.isJavaConformant(left, right, context)) {
            if (this.mustInsertTypeCast(context, left)) {
                this.doCastConversion(left, appendable, context, expression);
            } else {
                expression.exec(appendable);
            }
        } else if (this.isList(right) && this.getTypeReferences().isArray(left)) {
            this.convertListToArray(left, appendable, context, expression);
        } else if (this.isFunction(right) || this.isFunction(left) && this.closures.findImplementingOperation(right, context.eResource()) != null) {
            this.convertFunctionType(left, right, appendable, expression, context);
        } else if (this.isProcedure(right) || this.isProcedure(left) && this.closures.findImplementingOperation(right, context.eResource()) != null) {
            this.convertFunctionType(left, right, appendable, expression, context);
        } else if (this.mustInsertTypeCast(context, left)) {
            this.doCastConversion(left, appendable, context, expression);
        } else {
            expression.exec(appendable);
        }
    }

    protected void doCastConversion(JvmTypeReference castTo, ITreeAppendable b, XExpression context, Later expression) {
        b.append("((");
        this.serialize(castTo, context, b);
        b.append(")");
        expression.exec(b);
        b.append(")");
    }

    protected boolean isFunction(JvmTypeReference typeReference) {
        return this.identifierStartWith(typeReference, Functions.class.getCanonicalName());
    }

    protected boolean isProcedure(JvmTypeReference typeReference) {
        return this.identifierStartWith(typeReference, Procedures.class.getCanonicalName());
    }

    protected boolean identifierStartWith(JvmTypeReference typeReference, String prefix) {
        JvmType type = typeReference.getType();
        if (type == null) {
            return false;
        }
        String identifier = type.getIdentifier();
        if (identifier != null) {
            return identifier.startsWith(prefix);
        }
        return false;
    }

    protected void convertMultiType(JvmTypeReference expectation, JvmMultiTypeReference multiType, XExpression context, ITreeAppendable b, Later expression) {
        JvmTypeReference castTo = null;
        for (JvmTypeReference candidate : multiType.getReferences()) {
            if (!this.getTypeConformanceComputer().isConformant(expectation, candidate, true)) continue;
            castTo = candidate;
            break;
        }
        if (castTo != null && this.mustInsertTypeCast(context, castTo)) {
            b.append("((");
            this.serialize(castTo, context, b, true, false);
            b.append(")");
            expression.exec(b);
            b.append(")");
        } else {
            expression.exec(b);
        }
    }

    protected void convertFunctionType(JvmTypeReference expectedType, final JvmTypeReference functionType, ITreeAppendable appendable, Later expression, XExpression context) {
        if (expectedType.getIdentifier().equals(Object.class.getName()) || EcoreUtil.equals((EObject)expectedType.getType(), (EObject)functionType.getType()) || expectedType instanceof JvmSynonymTypeReference && Iterables.any((Iterable)((JvmSynonymTypeReference)expectedType).getReferences(), (Predicate)new Predicate<JvmTypeReference>(){

            public boolean apply(@Nullable JvmTypeReference ref) {
                if (ref == null) {
                    throw new IllegalArgumentException();
                }
                return EcoreUtil.equals((EObject)ref.getType(), (EObject)functionType.getType());
            }
        })) {
            if (!this.getTypeConformanceComputer().isConformant(expectedType, functionType)) {
                appendable.append("(");
                this.serialize(expectedType, context, appendable);
                appendable.append(")");
            }
            expression.exec(appendable);
            return;
        }
        JvmOperation operation = this.closures.findImplementingOperation(expectedType, context.eResource());
        if (operation == null) {
            throw new IllegalStateException("expected type " + expectedType + " not mappable from " + functionType);
        }
        JvmType declaringType = expectedType instanceof JvmParameterizedTypeReference ? expectedType.getType() : operation.getDeclaringType();
        JvmParameterizedTypeReference typeReferenceWithPlaceHolder = this.getTypeReferences().createTypeRef(declaringType, new JvmTypeReference[0]);
        ITypeArgumentContext typeArgumentContext = this.contextProvider.getTypeArgumentContext((TypeArgumentContextProvider.Request)new TypeArgumentContextProvider.AbstractRequest((JvmTypeReference)typeReferenceWithPlaceHolder){
            private final /* synthetic */ JvmTypeReference val$typeReferenceWithPlaceHolder;
            {
                this.val$typeReferenceWithPlaceHolder = jvmTypeReference2;
            }

            public JvmTypeReference getExpectedType() {
                return functionType;
            }

            public JvmTypeReference getDeclaredType() {
                return this.val$typeReferenceWithPlaceHolder;
            }

            public String toString() {
                return "TypeConvertingCompiler.convertFunctionType [expected=" + functionType + ",declared=" + this.val$typeReferenceWithPlaceHolder + "]";
            }
        });
        JvmTypeReference resolvedExpectedType = typeArgumentContext.resolve((JvmTypeReference)typeReferenceWithPlaceHolder);
        appendable.append("new ");
        this.serialize(resolvedExpectedType, context, appendable, true, false);
        appendable.append("() {");
        appendable.increaseIndentation().increaseIndentation();
        appendable.newLine().append("public ");
        this.serialize(typeArgumentContext.resolve(operation.getReturnType()), context, appendable, true, false);
        appendable.append(" ").append(operation.getSimpleName()).append("(");
        EList params = operation.getParameters();
        Iterator iterator = params.iterator();
        while (iterator.hasNext()) {
            JvmFormalParameter p = (JvmFormalParameter)iterator.next();
            String name = p.getName();
            this.serialize(typeArgumentContext.resolve(p.getParameterType()), context, appendable, false, false);
            appendable.append(" ").append(name);
            if (!iterator.hasNext()) continue;
            appendable.append(",");
        }
        appendable.append(") {");
        appendable.increaseIndentation();
        if (!this.getTypeReferences().is(operation.getReturnType(), Void.TYPE)) {
            appendable.newLine().append("return ");
        } else {
            appendable.newLine();
        }
        expression.exec(appendable);
        appendable.append(".");
        JvmOperation actualOperation = this.closures.findImplementingOperation(functionType, context.eResource());
        appendable.append(actualOperation.getSimpleName());
        appendable.append("(");
        Iterator iterator2 = params.iterator();
        while (iterator2.hasNext()) {
            JvmFormalParameter p = (JvmFormalParameter)iterator2.next();
            String name = p.getName();
            appendable.append(name);
            if (!iterator2.hasNext()) continue;
            appendable.append(",");
        }
        appendable.append(");");
        appendable.decreaseIndentation();
        appendable.newLine().append("}");
        appendable.decreaseIndentation().decreaseIndentation();
        appendable.newLine().append("}");
    }

    protected void convertListToArray(JvmTypeReference arrayTypeReference, ITreeAppendable appendable, XExpression context, Later expression) {
        appendable.append("((");
        this.serialize(arrayTypeReference, context, appendable);
        appendable.append(")");
        JvmTypeReference conversions = this.getTypeReferences().getTypeForName(Conversions.class, (Notifier)context, new JvmTypeReference[0]);
        this.serialize(conversions, context, appendable);
        appendable.append(".unwrapArray(");
        expression.exec(appendable);
        JvmGenericArrayTypeReference rawTypeArrayReference = (JvmGenericArrayTypeReference)this.rawTypeHelper.getRawTypeReference(arrayTypeReference, context.eResource());
        appendable.append(", ");
        this.serialize(rawTypeArrayReference.getComponentType(), context, appendable);
        appendable.append(".class))");
    }

    protected void convertArrayToList(JvmTypeReference left, ITreeAppendable appendable, XExpression context, Later expression) {
        if (!(context.eContainer() instanceof XCastedExpression)) {
            if (context.eContainer() instanceof XAbstractFeatureCall) {
                appendable.append("((");
            } else {
                appendable.append("(");
            }
            this.serialize(left, context, appendable);
            appendable.append(")");
        }
        JvmTypeReference conversions = this.getTypeReferences().getTypeForName(Conversions.class, (Notifier)context, new JvmTypeReference[0]);
        this.serialize(conversions, context, appendable);
        appendable.append(".doWrapArray(");
        expression.exec(appendable);
        if (!(context.eContainer() instanceof XCastedExpression)) {
            if (context.eContainer() instanceof XAbstractFeatureCall) {
                appendable.append("))");
            } else {
                appendable.append(")");
            }
        } else {
            appendable.append(")");
        }
    }

    protected void convertPrimitiveToWrapper(JvmTypeReference primitive, JvmTypeReference wrapper, XExpression context, ITreeAppendable appendable, Later expression) {
        this.serialize(wrapper, context, appendable);
        appendable.append(".");
        appendable.append("valueOf(");
        expression.exec(appendable);
        appendable.append(")");
    }

    protected List<XExpression> normalizeBlockExpression(Collection<XExpression> expr) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)expr.size());
        for (XExpression e : expr) {
            result.add(this.normalizeBlockExpression(e));
        }
        return result;
    }

    protected XExpression normalizeBlockExpression(XExpression expr) {
        XBlockExpression block;
        if (expr instanceof XBlockExpression && (block = (XBlockExpression)expr).getExpressions().size() == 1) {
            return this.normalizeBlockExpression((XExpression)block.getExpressions().get(0));
        }
        return expr;
    }

    protected void convertWrapperToPrimitive(JvmTypeReference wrapper, JvmTypeReference primitive, XExpression context, ITreeAppendable appendable, Later expression) {
        JvmIdentifiableElement feature;
        XAbstractFeatureCall featureCall;
        XExpression normalized = this.normalizeBlockExpression(context);
        if (normalized instanceof XAbstractFeatureCall && !(context.eContainer() instanceof XAbstractFeatureCall) && (featureCall = (XAbstractFeatureCall)normalized).isStatic() && (feature = featureCall.getFeature()) instanceof JvmOperation && !((JvmOperation)feature).getTypeParameters().isEmpty()) {
            appendable.append("(");
            this.serialize(primitive, context, appendable);
            appendable.append(") ");
            expression.exec(appendable);
            return;
        }
        appendable.append("(");
        if (this.mustInsertTypeCast(context, wrapper)) {
            appendable.append("(");
            this.serialize(wrapper, context, appendable);
            appendable.append(") ");
        }
        expression.exec(appendable);
        appendable.append(")");
        appendable.append(".");
        this.serialize(primitive, context, appendable);
        appendable.append("Value()");
    }

    protected boolean isList(JvmTypeReference type) {
        TypeReferences typeRefs = this.getTypeReferences();
        return typeRefs.isInstanceOf(type, Iterable.class);
    }

    protected TypeArgumentContextProvider getContextProvider() {
        return this.contextProvider;
    }
}

