/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.internal.BooleanFunctionDelegate;
import org.eclipse.xtext.xbase.lib.internal.FunctionDelegate;
import org.eclipse.xtext.xbase.lib.internal.KeyComparator;
import org.eclipse.xtext.xbase.lib.internal.ai;
import org.eclipse.xtext.xbase.lib.internal.ap;
import org.eclipse.xtext.xbase.lib.internal.aq;
import org.eclipse.xtext.xbase.lib.internal.ar;
import org.eclipse.xtext.xbase.lib.internal.av;
import org.eclipse.xtext.xbase.lib.internal.b;
import org.eclipse.xtext.xbase.lib.internal.bd;
import org.eclipse.xtext.xbase.lib.internal.f;
import org.eclipse.xtext.xbase.lib.internal.i;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratorExtensions {
    @Pure
    public static <T> Iterable<T> toIterable(final Iterator<T> iterator) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return iterator;
            }
        };
    }

    @Pure
    @Inline(value="$3.$4concat($1, $2)", imported={ap.class})
    public static <T> Iterator<T> operator_plus(Iterator<? extends T> a2, Iterator<? extends T> b2) {
        return ap.concat(a2, b2);
    }

    /*
     * Unable to fully structure code
     */
    public static <T> T findFirst(Iterator<T> iterator, Functions.Function1<? super T, Boolean> predicate) {
        if (predicate != null) ** GOTO lbl6
        throw new NullPointerException("predicate");
lbl-1000:
        // 1 sources

        {
            t = iterator.next();
            if (!predicate.apply(t).booleanValue()) continue;
            return t;
lbl6:
            // 2 sources

            ** while (iterator.hasNext())
        }
lbl7:
        // 1 sources

        return null;
    }

    public static <T> T findLast(Iterator<T> iterator, Functions.Function1<? super T, Boolean> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        T result = null;
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (!predicate.apply(t2).booleanValue()) continue;
            result = t2;
        }
        return result;
    }

    public static <T> T head(Iterator<T> iterator) {
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static <T> Iterator<T> tail(Iterator<T> iterator) {
        return IteratorExtensions.drop(iterator, 1);
    }

    public static <T> T last(Iterator<T> iterator) {
        T result = null;
        while (iterator.hasNext()) {
            result = iterator.next();
        }
        return result;
    }

    @Pure
    public static <T> Iterator<T> take(final Iterator<T> iterator, int count) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        if (count < 0) {
            throw new IllegalArgumentException("Cannot take a negative number of elements. Argument 'count' was: " + count);
        }
        if (count == 0) {
            return ai.of().iterator();
        }
        return new i<T>(count){
            private int remaining;
            {
                this.remaining = n2;
            }

            @Override
            protected T computeNext() {
                if (this.remaining <= 0) {
                    return this.endOfData();
                }
                if (!iterator.hasNext()) {
                    return this.endOfData();
                }
                --this.remaining;
                return iterator.next();
            }
        };
    }

    public static <T> Iterator<T> drop(final Iterator<T> iterator, int count) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        if (count == 0) {
            return iterator;
        }
        if (count < 0) {
            throw new IllegalArgumentException("Cannot drop a negative number of elements. Argument 'count' was: " + count);
        }
        return new i<T>(count){
            {
                int i2 = n2;
                while (i2 > 0 && iterator2.hasNext()) {
                    iterator2.next();
                    --i2;
                }
            }

            @Override
            protected T computeNext() {
                if (!iterator.hasNext()) {
                    return this.endOfData();
                }
                return iterator.next();
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    public static <T> boolean exists(Iterator<T> iterator, Functions.Function1<? super T, Boolean> predicate) {
        if (predicate != null) ** GOTO lbl5
        throw new NullPointerException("predicate");
lbl-1000:
        // 1 sources

        {
            if (!predicate.apply(iterator.next()).booleanValue()) continue;
            return true;
lbl5:
            // 2 sources

            ** while (iterator.hasNext())
        }
lbl6:
        // 1 sources

        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static <T> boolean forall(Iterator<T> iterator, Functions.Function1<? super T, Boolean> predicate) {
        if (predicate != null) ** GOTO lbl5
        throw new NullPointerException("predicate");
lbl-1000:
        // 1 sources

        {
            if (predicate.apply(iterator.next()).booleanValue()) continue;
            return false;
lbl5:
            // 2 sources

            ** while (iterator.hasNext())
        }
lbl6:
        // 1 sources

        return true;
    }

    @Pure
    public static <T> Iterator<T> filter(Iterator<T> unfiltered, Functions.Function1<? super T, Boolean> predicate) {
        return ap.filter(unfiltered, new BooleanFunctionDelegate<T>(predicate));
    }

    @Pure
    @Inline(value="$3.$4filter($1, $2)", imported={ap.class})
    public static <T> Iterator<T> filter(Iterator<?> unfiltered, Class<T> type) {
        return ap.filter(unfiltered, type);
    }

    @Pure
    public static <T> Iterator<T> filterNull(Iterator<T> unfiltered) {
        return ap.filter(unfiltered, f.notNull());
    }

    @Pure
    public static <T, R> Iterator<R> map(Iterator<T> original, Functions.Function1<? super T, ? extends R> transformation) {
        return ap.transform(original, new FunctionDelegate<T, R>(transformation));
    }

    /*
     * Unable to fully structure code
     */
    public static <T> void forEach(Iterator<T> iterator, Procedures.Procedure1<? super T> procedure) {
        if (procedure != null) ** GOTO lbl4
        throw new NullPointerException("procedure");
lbl-1000:
        // 1 sources

        {
            procedure.apply(iterator.next());
lbl4:
            // 2 sources

            ** while (iterator.hasNext())
        }
lbl5:
        // 1 sources

    }

    public static <T> void forEach(Iterator<T> iterator, Procedures.Procedure2<? super T, ? super Integer> procedure) {
        if (procedure == null) {
            throw new NullPointerException("procedure");
        }
        int i2 = 0;
        while (iterator.hasNext()) {
            procedure.apply(iterator.next(), i2);
            if (i2 == Integer.MAX_VALUE) continue;
            ++i2;
        }
    }

    public static String join(Iterator<?> iterator) {
        return IteratorExtensions.join(iterator, "");
    }

    public static String join(Iterator<?> iterator, CharSequence separator) {
        return b.on(separator.toString()).useForNull("null").join(IteratorExtensions.toIterable(iterator));
    }

    public static <T> String join(Iterator<T> iterator, CharSequence separator, Functions.Function1<? super T, ? extends CharSequence> function) {
        if (separator == null) {
            throw new NullPointerException("separator");
        }
        if (function == null) {
            throw new NullPointerException("function");
        }
        StringBuilder result = new StringBuilder();
        while (iterator.hasNext()) {
            T next = iterator.next();
            CharSequence elementToString = function.apply(next);
            result.append(elementToString);
            if (!iterator.hasNext()) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public static <T> String join(Iterator<T> iterator, CharSequence before, CharSequence separator, CharSequence after, Functions.Function1<? super T, ? extends CharSequence> function) {
        if (function == null) {
            throw new NullPointerException("function");
        }
        StringBuilder result = new StringBuilder();
        boolean notEmpty = iterator.hasNext();
        if (notEmpty && before != null) {
            result.append(before);
        }
        while (iterator.hasNext()) {
            T next = iterator.next();
            CharSequence elementToString = function.apply(next);
            result.append(elementToString);
            if (!iterator.hasNext() || separator == null) continue;
            result.append(separator);
        }
        if (notEmpty && after != null) {
            result.append(after);
        }
        return result.toString();
    }

    public static boolean elementsEqual(Iterator<?> iterator, Iterator<?> other) {
        return ap.elementsEqual(iterator, other);
    }

    public static boolean elementsEqual(Iterator<?> iterator, Iterable<?> iterable) {
        return ap.elementsEqual(iterator, iterable.iterator());
    }

    public static boolean isNullOrEmpty(Iterator<?> iterator) {
        return iterator == null || IteratorExtensions.isEmpty(iterator);
    }

    public static boolean isEmpty(Iterator<?> iterator) {
        return !iterator.hasNext();
    }

    public static int size(Iterator<?> iterator) {
        return ap.size(iterator);
    }

    public static <T> T reduce(Iterator<? extends T> iterator, Functions.Function2<? super T, ? super T, ? extends T> function) {
        if (function == null) {
            throw new NullPointerException("function");
        }
        if (iterator.hasNext()) {
            T result = iterator.next();
            while (iterator.hasNext()) {
                result = function.apply(result, iterator.next());
            }
            return result;
        }
        return null;
    }

    public static <T, R> R fold(Iterator<T> iterator, R seed, Functions.Function2<? super R, ? super T, ? extends R> function) {
        R result = seed;
        while (iterator.hasNext()) {
            result = function.apply(result, iterator.next());
        }
        return result;
    }

    public static <T> List<T> toList(Iterator<? extends T> iterator) {
        return aq.newArrayList(iterator);
    }

    public static <T> Set<T> toSet(Iterator<? extends T> iterator) {
        return bd.newLinkedHashSet(IteratorExtensions.toIterable(iterator));
    }

    public static <K, V> Map<K, V> toInvertedMap(Iterator<? extends K> keys, Functions.Function1<? super K, V> computeValues) {
        LinkedHashMap<K, V> result = ar.newLinkedHashMap();
        while (keys.hasNext()) {
            K k2 = keys.next();
            result.put(k2, computeValues.apply(k2));
        }
        return result;
    }

    public static <K, V> Map<K, V> toMap(Iterator<? extends V> values, Functions.Function1<? super V, K> computeKeys) {
        if (computeKeys == null) {
            throw new NullPointerException("computeKeys");
        }
        LinkedHashMap<K, V> result = ar.newLinkedHashMap();
        while (values.hasNext()) {
            V v2 = values.next();
            result.put(computeKeys.apply(v2), v2);
        }
        return result;
    }

    public static <K, V> Map<K, List<V>> groupBy(Iterator<? extends V> values, Functions.Function1<? super V, ? extends K> computeKeys) {
        if (computeKeys == null) {
            throw new NullPointerException("computeKeys");
        }
        LinkedHashMap result = ar.newLinkedHashMap();
        while (values.hasNext()) {
            V v2 = values.next();
            K key = computeKeys.apply(v2);
            ArrayList<V> grouped = (ArrayList<V>)result.get(key);
            if (grouped == null) {
                grouped = new ArrayList<V>();
                result.put(key, grouped);
            }
            grouped.add(v2);
        }
        return result;
    }

    public static <T> Iterator<T> takeWhile(final Iterator<? extends T> iterator, final Functions.Function1<? super T, Boolean> predicate) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        return new i<T>(){

            @Override
            protected T computeNext() {
                if (!iterator.hasNext()) {
                    return this.endOfData();
                }
                Object next = iterator.next();
                if (((Boolean)predicate.apply(next)).booleanValue()) {
                    return next;
                }
                return this.endOfData();
            }
        };
    }

    public static <T> Iterator<T> dropWhile(final Iterator<? extends T> iterator, final Functions.Function1<? super T, Boolean> predicate) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        return new i<T>(){
            private boolean headFound = false;

            @Override
            protected T computeNext() {
                while (!this.headFound) {
                    if (!iterator.hasNext()) {
                        return this.endOfData();
                    }
                    Object next = iterator.next();
                    if (((Boolean)predicate.apply(next)).booleanValue()) continue;
                    this.headFound = true;
                    return next;
                }
                if (iterator.hasNext()) {
                    return iterator.next();
                }
                return this.endOfData();
            }
        };
    }

    public static <A> Iterator<Pair<Integer, A>> indexed(final Iterator<? extends A> iterator) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        return new i<Pair<Integer, A>>(){
            int i = 0;

            @Override
            protected Pair<Integer, A> computeNext() {
                if (iterator.hasNext()) {
                    Pair next = new Pair(this.i, iterator.next());
                    if (this.i != Integer.MAX_VALUE) {
                        ++this.i;
                    }
                    return next;
                }
                return (Pair)this.endOfData();
            }
        };
    }

    public static <T extends Comparable<? super T>> T min(Iterator<T> iterator) {
        return (T)((Comparable)IteratorExtensions.min(iterator, av.natural()));
    }

    public static <T, C extends Comparable<? super C>> T minBy(Iterator<T> iterator, Functions.Function1<? super T, C> compareBy) {
        if (compareBy == null) {
            throw new NullPointerException("compareBy");
        }
        return IteratorExtensions.min(iterator, new KeyComparator<T, C>(compareBy));
    }

    public static <T> T min(Iterator<T> iterator, Comparator<? super T> comparator) {
        if (comparator == null) {
            throw new NullPointerException("comparator");
        }
        T min = iterator.next();
        while (iterator.hasNext()) {
            T element = iterator.next();
            T t2 = min = comparator.compare(min, element) <= 0 ? min : element;
        }
        return min;
    }

    public static <T extends Comparable<? super T>> T max(Iterator<T> iterator) {
        return (T)((Comparable)IteratorExtensions.max(iterator, av.natural()));
    }

    public static <T, C extends Comparable<? super C>> T maxBy(Iterator<T> iterator, Functions.Function1<? super T, C> compareBy) {
        if (compareBy == null) {
            throw new NullPointerException("compareBy");
        }
        return IteratorExtensions.max(iterator, new KeyComparator<T, C>(compareBy));
    }

    public static <T> T max(Iterator<T> iterator, Comparator<? super T> comparator) {
        if (comparator == null) {
            throw new NullPointerException("comparator");
        }
        T max = iterator.next();
        while (iterator.hasNext()) {
            T element = iterator.next();
            T t2 = max = comparator.compare(max, element) >= 0 ? max : element;
        }
        return max;
    }
}

