/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import org.eclipse.xtext.xbase.lib.internal.ad;
import org.eclipse.xtext.xbase.lib.internal.aj;
import org.eclipse.xtext.xbase.lib.internal.am;
import org.eclipse.xtext.xbase.lib.internal.ap;
import org.eclipse.xtext.xbase.lib.internal.as;
import org.eclipse.xtext.xbase.lib.internal.bi;
import org.eclipse.xtext.xbase.lib.internal.bj;
import org.eclipse.xtext.xbase.lib.internal.bm;
import org.eclipse.xtext.xbase.lib.internal.bt;
import org.eclipse.xtext.xbase.lib.internal.d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class bc<E>
extends am<E> {
    private final transient ad<E> elements;

    bc(ad<E> elements, Comparator<? super E> comparator) {
        super(comparator);
        this.elements = elements;
        d.checkArgument(!elements.isEmpty());
    }

    @Override
    public bm<E> iterator() {
        return this.elements.iterator();
    }

    @Override
    public bm<E> descendingIterator() {
        return this.elements.reverse().iterator();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean contains(Object o2) {
        try {
            return o2 != null && this.unsafeBinarySearch(o2) >= 0;
        }
        catch (ClassCastException e2) {
            return false;
        }
    }

    @Override
    public boolean containsAll(Collection<?> targets) {
        if (targets instanceof as) {
            targets = ((as)targets).elementSet();
        }
        if (!bi.hasSameComparator(this.comparator(), targets) || targets.size() <= 1) {
            return super.containsAll(targets);
        }
        bt thisIterator = ap.peekingIterator(this.iterator());
        Iterator<?> thatIterator = targets.iterator();
        Object target = thatIterator.next();
        try {
            while (thisIterator.hasNext()) {
                int cmp = this.unsafeCompare(thisIterator.peek(), target);
                if (cmp < 0) {
                    thisIterator.next();
                    continue;
                }
                if (cmp == 0) {
                    if (!thatIterator.hasNext()) {
                        return true;
                    }
                    target = thatIterator.next();
                    continue;
                }
                if (cmp <= 0) continue;
                return false;
            }
        }
        catch (NullPointerException e2) {
            return false;
        }
        catch (ClassCastException e3) {
            return false;
        }
        return false;
    }

    private int unsafeBinarySearch(Object key) throws ClassCastException {
        return Collections.binarySearch(this.elements, key, this.unsafeComparator());
    }

    @Override
    boolean isPartialView() {
        return this.elements.isPartialView();
    }

    @Override
    int copyIntoArray(Object[] dst, int offset) {
        return this.elements.copyIntoArray(dst, offset);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set that = (Set)object;
        if (this.size() != that.size()) {
            return false;
        }
        if (bi.hasSameComparator(this.comparator, that)) {
            Iterator otherIterator = that.iterator();
            try {
                for (Object element : this) {
                    Object otherElement = otherIterator.next();
                    if (otherElement != null && this.unsafeCompare(element, otherElement) == 0) continue;
                    return false;
                }
                return true;
            }
            catch (ClassCastException e2) {
                return false;
            }
            catch (NoSuchElementException e3) {
                return false;
            }
        }
        return this.containsAll(that);
    }

    @Override
    public E first() {
        return this.elements.get(0);
    }

    @Override
    public E last() {
        return this.elements.get(this.size() - 1);
    }

    @Override
    am<E> headSetImpl(E toElement, boolean inclusive) {
        return this.getSubSet(0, this.headIndex(toElement, inclusive));
    }

    int headIndex(E toElement, boolean inclusive) {
        return bj.binarySearch(this.elements, d.checkNotNull(toElement), this.comparator(), inclusive ? bj.b.FIRST_AFTER : bj.b.FIRST_PRESENT, bj.a.NEXT_HIGHER);
    }

    @Override
    am<E> subSetImpl(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return this.tailSetImpl(fromElement, fromInclusive).headSetImpl(toElement, toInclusive);
    }

    @Override
    am<E> tailSetImpl(E fromElement, boolean inclusive) {
        return this.getSubSet(this.tailIndex(fromElement, inclusive), this.size());
    }

    int tailIndex(E fromElement, boolean inclusive) {
        return bj.binarySearch(this.elements, d.checkNotNull(fromElement), this.comparator(), inclusive ? bj.b.FIRST_PRESENT : bj.b.FIRST_AFTER, bj.a.NEXT_HIGHER);
    }

    Comparator<Object> unsafeComparator() {
        return this.comparator;
    }

    am<E> getSubSet(int newFromIndex, int newToIndex) {
        if (newFromIndex == 0 && newToIndex == this.size()) {
            return this;
        }
        if (newFromIndex < newToIndex) {
            return new bc<E>(this.elements.subList(newFromIndex, newToIndex), this.comparator);
        }
        return bc.emptySet(this.comparator);
    }

    @Override
    int indexOf(@Nullable Object target) {
        int position;
        if (target == null) {
            return -1;
        }
        try {
            position = bj.binarySearch(this.elements, target, this.unsafeComparator(), bj.b.ANY_PRESENT, bj.a.INVERTED_INSERTION_INDEX);
        }
        catch (ClassCastException e2) {
            return -1;
        }
        return position >= 0 ? position : -1;
    }

    @Override
    ad<E> createAsList() {
        return new aj<E>(this, this.elements);
    }
}

