/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.junit.typesystem;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedBytes;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

@Deprecated
@Beta
public final class SimpleBloomFilter {
    private final BitArray bits;
    private final int numHashFunctions;

    private SimpleBloomFilter(BitArray bits, int numHashFunctions) {
        Preconditions.checkArgument((numHashFunctions > 0 ? 1 : 0) != 0, (String)"numHashFunctions (%s) must be > 0", (Object[])new Object[]{numHashFunctions});
        Preconditions.checkArgument((numHashFunctions <= 255 ? 1 : 0) != 0, (String)"numHashFunctions (%s) must be <= 255", (Object[])new Object[]{numHashFunctions});
        this.bits = (BitArray)Preconditions.checkNotNull((Object)bits);
        this.numHashFunctions = numHashFunctions;
    }

    public boolean mightContain(String object) {
        long hash64 = this.hashString(object);
        int hash1 = (int)hash64;
        int hash2 = (int)(hash64 >>> 32);
        int i = 1;
        while (i <= this.numHashFunctions) {
            int nextHash = hash1 + i * hash2;
            if (nextHash < 0) {
                nextHash ^= 0xFFFFFFFF;
            }
            if (!this.bits.get(nextHash % this.bits.size())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean put(String object) {
        long hash64 = this.hashString(object);
        int hash1 = (int)hash64;
        int hash2 = (int)(hash64 >>> 32);
        boolean bitsChanged = false;
        int i = 1;
        while (i <= this.numHashFunctions) {
            int nextHash = hash1 + i * hash2;
            if (nextHash < 0) {
                nextHash ^= 0xFFFFFFFF;
            }
            bitsChanged |= this.bits.set(nextHash % this.bits.size());
            ++i;
        }
        return bitsChanged;
    }

    public static SimpleBloomFilter create(int expectedInsertions, double fpp) {
        if (expectedInsertions == 0) {
            expectedInsertions = 1;
        }
        long numBits = SimpleBloomFilter.optimalNumOfBits(expectedInsertions, fpp);
        int numHashFunctions = SimpleBloomFilter.optimalNumOfHashFunctions(expectedInsertions, numBits);
        try {
            return new SimpleBloomFilter(new BitArray(numBits), numHashFunctions);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not create BloomFilter of " + numBits + " bits", e);
        }
    }

    public static SimpleBloomFilter create(int expectedInsertions) {
        return SimpleBloomFilter.create(expectedInsertions, 0.03);
    }

    static int optimalNumOfHashFunctions(long n, long m) {
        return Math.max(1, (int)Math.round((double)(m / n) * Math.log(2.0)));
    }

    static long optimalNumOfBits(long n, double p) {
        if (p == 0.0) {
            p = Double.MIN_VALUE;
        }
        return (long)((double)(-n) * Math.log(p) / (Math.log(2.0) * Math.log(2.0)));
    }

    public long hashString(CharSequence input) {
        return new Murmur3_128Hasher(16).putString(input).hash();
    }

    private static long fromBytesNoCopy(byte[] bytes) {
        return (long)bytes[0] & 0xFFL | ((long)bytes[1] & 0xFFL) << 8 | ((long)bytes[2] & 0xFFL) << 16 | ((long)bytes[3] & 0xFFL) << 24 | ((long)bytes[4] & 0xFFL) << 32 | ((long)bytes[5] & 0xFFL) << 40 | ((long)bytes[6] & 0xFFL) << 48 | ((long)bytes[7] & 0xFFL) << 56;
    }

    static class BitArray {
        final long[] data;
        int bitCount;

        BitArray(long bits) {
            this(new long[Ints.checkedCast((long)(bits / 64L))]);
        }

        BitArray(long[] data) {
            Preconditions.checkArgument((data.length > 0 ? 1 : 0) != 0, (Object)"data length is zero!");
            this.data = data;
            int bitCount = 0;
            long[] lArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                long value = lArray[n2];
                bitCount += Long.bitCount(value);
                ++n2;
            }
            this.bitCount = bitCount;
        }

        boolean set(int index) {
            if (!this.get(index)) {
                int n = index >> 6;
                this.data[n] = this.data[n] | 1L << index;
                ++this.bitCount;
                return true;
            }
            return false;
        }

        boolean get(int index) {
            return (this.data[index >> 6] & 1L << index) != 0L;
        }

        int size() {
            return this.data.length * 64;
        }

        int bitCount() {
            return this.bitCount;
        }

        BitArray copy() {
            return new BitArray((long[])this.data.clone());
        }

        public boolean equals(Object o) {
            if (o instanceof BitArray) {
                BitArray bitArray = (BitArray)o;
                return Arrays.equals(this.data, bitArray.data);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }
    }

    private static class Murmur3_128Hasher {
        private final ByteBuffer buffer;
        private final int chunkSize;
        private static final int CHUNK_SIZE = 16;
        private static final long C1 = -8663945395140668459L;
        private static final long C2 = 5545529020109919103L;
        private long h1;
        private long h2;
        private int length;

        Murmur3_128Hasher(int size) {
            this.buffer = ByteBuffer.allocate(size + 7).order(ByteOrder.LITTLE_ENDIAN);
            this.chunkSize = size;
            this.h1 = 16L;
            this.h2 = 16L;
            this.length = 0;
        }

        public final Murmur3_128Hasher putString(CharSequence charSequence) {
            int i = 0;
            while (i < charSequence.length()) {
                this.putChar(charSequence.charAt(i));
                ++i;
            }
            return this;
        }

        public final Murmur3_128Hasher putChar(char c) {
            this.buffer.putChar(c);
            this.munchIfFull();
            return this;
        }

        public final long hash() {
            this.munch();
            this.buffer.flip();
            if (this.buffer.remaining() > 0) {
                this.processRemaining(this.buffer);
            }
            return this.makeHash();
        }

        private void munchIfFull() {
            if (this.buffer.remaining() < 8) {
                this.munch();
            }
        }

        private void munch() {
            this.buffer.flip();
            while (this.buffer.remaining() >= this.chunkSize) {
                this.process(this.buffer);
            }
            this.buffer.compact();
        }

        protected void process(ByteBuffer bb) {
            long k1 = bb.getLong();
            long k2 = bb.getLong();
            this.bmix64(k1, k2);
            this.length += 16;
        }

        private void bmix64(long k1, long k2) {
            this.h1 ^= Murmur3_128Hasher.mixK1(k1);
            this.h1 = Long.rotateLeft(this.h1, 27);
            this.h1 += this.h2;
            this.h1 = this.h1 * 5L + 1390208809L;
            this.h2 ^= Murmur3_128Hasher.mixK2(k2);
            this.h2 = Long.rotateLeft(this.h2, 31);
            this.h2 += this.h1;
            this.h2 = this.h2 * 5L + 944331445L;
        }

        protected void processRemaining(ByteBuffer bb) {
            long k1 = 0L;
            long k2 = 0L;
            this.length += bb.remaining();
            switch (bb.remaining()) {
                case 15: {
                    k2 ^= (long)UnsignedBytes.toInt((byte)bb.get(14)) << 48;
                }
                case 14: {
                    k2 ^= (long)UnsignedBytes.toInt((byte)bb.get(13)) << 40;
                }
                case 13: {
                    k2 ^= (long)UnsignedBytes.toInt((byte)bb.get(12)) << 32;
                }
                case 12: {
                    k2 ^= (long)UnsignedBytes.toInt((byte)bb.get(11)) << 24;
                }
                case 11: {
                    k2 ^= (long)UnsignedBytes.toInt((byte)bb.get(10)) << 16;
                }
                case 10: {
                    k2 ^= (long)UnsignedBytes.toInt((byte)bb.get(9)) << 8;
                }
                case 9: {
                    k2 ^= (long)UnsignedBytes.toInt((byte)bb.get(8));
                }
                case 8: {
                    k1 ^= bb.getLong();
                    break;
                }
                case 7: {
                    k1 ^= (long)UnsignedBytes.toInt((byte)bb.get(6)) << 48;
                }
                case 6: {
                    k1 ^= (long)UnsignedBytes.toInt((byte)bb.get(5)) << 40;
                }
                case 5: {
                    k1 ^= (long)UnsignedBytes.toInt((byte)bb.get(4)) << 32;
                }
                case 4: {
                    k1 ^= (long)UnsignedBytes.toInt((byte)bb.get(3)) << 24;
                }
                case 3: {
                    k1 ^= (long)UnsignedBytes.toInt((byte)bb.get(2)) << 16;
                }
                case 2: {
                    k1 ^= (long)UnsignedBytes.toInt((byte)bb.get(1)) << 8;
                }
                case 1: {
                    k1 ^= (long)UnsignedBytes.toInt((byte)bb.get(0));
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Should never get here.");
                }
            }
            this.h1 ^= Murmur3_128Hasher.mixK1(k1);
            this.h2 ^= Murmur3_128Hasher.mixK2(k2);
        }

        public long makeHash() {
            this.h1 ^= (long)this.length;
            this.h2 ^= (long)this.length;
            this.h1 += this.h2;
            this.h2 += this.h1;
            this.h1 = Murmur3_128Hasher.fmix64(this.h1);
            this.h2 = Murmur3_128Hasher.fmix64(this.h2);
            this.h1 += this.h2;
            this.h2 += this.h1;
            return SimpleBloomFilter.fromBytesNoCopy(ByteBuffer.wrap(new byte[16]).order(ByteOrder.LITTLE_ENDIAN).putLong(this.h1).putLong(this.h2).array());
        }

        private static long fmix64(long k) {
            k ^= k >>> 33;
            k *= -49064778989728563L;
            k ^= k >>> 33;
            k *= -4265267296055464877L;
            k ^= k >>> 33;
            return k;
        }

        private static long mixK1(long k1) {
            k1 *= -8663945395140668459L;
            k1 = Long.rotateLeft(k1, 31);
            return k1 *= 5545529020109919103L;
        }

        private static long mixK2(long k2) {
            k2 *= 5545529020109919103L;
            k2 = Long.rotateLeft(k2, 33);
            return k2 *= -8663945395140668459L;
        }
    }
}

