/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ide.contentassist;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalPriorities;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.xbase.ide.contentassist.IIdeTypesProposalProvider;
import org.eclipse.xtext.xbase.ide.contentassist.XbaseIdeContentProposalPriorities;
import org.eclipse.xtext.xbase.ide.types.ClasspathScanner;
import org.eclipse.xtext.xbase.ide.types.ITypeDescriptor;
import org.eclipse.xtext.xbase.imports.IImportsConfiguration;
import org.eclipse.xtext.xbase.imports.ImportSectionRegionUtil;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;
import org.eclipse.xtext.xtype.XtypePackage;

public class ClasspathBasedIdeTypesProposalProvider
implements IIdeTypesProposalProvider {
    @Inject
    private ClassLoader classLoader;
    @Inject
    private ClasspathScanner classpathScanner;
    @Inject
    private IdeContentProposalPriorities proposalPriorities;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IImportsConfiguration importsConfiguration;
    @Inject
    private ImportSectionRegionUtil importSectionRegionUtil;

    @Override
    public void createTypeProposals(EReference reference, ContentAssistContext context, Predicate<ITypeDescriptor> filter, IIdeContentProposalAcceptor acceptor) {
        boolean _not;
        ITextRegion importSectionRegion = null;
        XImportSection importSection = null;
        boolean _isImportDeclaration = this.isImportDeclaration(reference, context);
        boolean bl = _not = !_isImportDeclaration;
        if (_not) {
            ITextRegion _computeRegion;
            XImportSection _importSection;
            XtextResource _resource = context.getResource();
            importSection = _importSection = this.importsConfiguration.getImportSection(_resource);
            XtextResource _resource_1 = context.getResource();
            importSectionRegion = _computeRegion = this.importSectionRegionUtil.computeRegion(_resource_1);
        }
        Iterable<ITypeDescriptor> _typeDescriptors = this.getTypeDescriptors(context);
        for (ITypeDescriptor typeDesc : _typeDescriptors) {
            boolean _not_1;
            boolean _canAcceptMoreProposals = acceptor.canAcceptMoreProposals();
            boolean bl2 = _not_1 = !_canAcceptMoreProposals;
            if (_not_1) {
                return;
            }
            boolean _canPropose = this.canPropose(typeDesc, context, filter);
            if (!_canPropose) continue;
            ContentAssistEntry entry = this.createProposal(reference, typeDesc, context, importSection, importSectionRegion);
            int priority = ((XbaseIdeContentProposalPriorities)this.proposalPriorities).getTypeRefPriority(typeDesc, entry);
            acceptor.accept(entry, priority);
        }
    }

    protected Iterable<ITypeDescriptor> getTypeDescriptors(ContentAssistContext context) {
        Iterable<ITypeDescriptor> bootClasspath = this.classpathScanner.getBootClasspathDescriptors(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"java"})));
        ClassLoader _classLoader = this.getClassLoader(context);
        List<String> _emptyList = Collections.emptyList();
        Iterable<ITypeDescriptor> appClasspath = this.classpathScanner.getDescriptors(_classLoader, _emptyList);
        return Iterables.concat(bootClasspath, appClasspath);
    }

    protected ClassLoader getClassLoader(ContentAssistContext context) {
        XtextResource _resource = context.getResource();
        ResourceSet resourceSet = _resource.getResourceSet();
        if (resourceSet instanceof XtextResourceSet) {
            boolean _notEquals;
            Object ctx = ((XtextResourceSet)resourceSet).getClasspathURIContext();
            boolean bl = _notEquals = !Objects.equal((Object)ctx, null);
            if (_notEquals) {
                if (ctx instanceof Class) {
                    return ((Class)ctx).getClassLoader();
                }
                if (ctx instanceof ClassLoader) {
                    return (ClassLoader)ctx;
                }
                Class<?> _class = ctx.getClass();
                return _class.getClassLoader();
            }
        }
        return this.classLoader;
    }

    protected boolean canPropose(ITypeDescriptor typeDesc, ContentAssistContext context, Predicate<ITypeDescriptor> filter) {
        boolean _apply;
        boolean _isVisible;
        int _length;
        boolean _xblockexpression = false;
        String prefix = context.getPrefix();
        boolean _and = false;
        boolean _and_1 = false;
        String _simpleName = typeDesc.getSimpleName();
        boolean _regionMatches = _simpleName.regionMatches(true, 0, prefix, 0, _length = prefix.length());
        _and_1 = !_regionMatches ? false : (_isVisible = this.isVisible(typeDesc, context));
        _and = !_and_1 ? false : (_apply = filter.apply((Object)typeDesc));
        _xblockexpression = _and;
        return _xblockexpression;
    }

    protected boolean isVisible(ITypeDescriptor typeDesc, ContentAssistContext context) {
        int _accessFlags = typeDesc.getAccessFlags();
        int _bitwiseAnd = _accessFlags & 1;
        return _bitwiseAnd != 0;
    }

    protected ContentAssistEntry createProposal(final EReference reference, final ITypeDescriptor typeDesc, final ContentAssistContext context, final XImportSection importSection, final ITextRegion importSectionRegion) {
        ContentAssistEntry _contentAssistEntry = new ContentAssistEntry();
        Procedures.Procedure1<ContentAssistEntry> _function = new Procedures.Procedure1<ContentAssistEntry>(){

            public void apply(ContentAssistEntry it) {
                String _prefix = context.getPrefix();
                it.setPrefix(_prefix);
                QualifiedName _qualifiedName = typeDesc.getQualifiedName();
                String qualifiedName = ClasspathBasedIdeTypesProposalProvider.this.qualifiedNameConverter.toString(_qualifiedName);
                boolean _isImportDeclaration = ClasspathBasedIdeTypesProposalProvider.this.isImportDeclaration(reference, context);
                if (_isImportDeclaration) {
                    it.setProposal(qualifiedName);
                    String _simpleName = typeDesc.getSimpleName();
                    it.setLabel(_simpleName);
                    String _proposal = it.getProposal();
                    it.setDescription(_proposal);
                } else {
                    boolean _isImportDeclarationRequired;
                    String _simpleName_1 = typeDesc.getSimpleName();
                    it.setProposal(_simpleName_1);
                    it.setDescription(qualifiedName);
                    boolean _and = false;
                    _and = importSectionRegion == null ? false : (_isImportDeclarationRequired = ClasspathBasedIdeTypesProposalProvider.this.isImportDeclarationRequired(typeDesc, qualifiedName, context, importSection));
                    if (_and) {
                        ClasspathBasedIdeTypesProposalProvider.this.addImportDeclaration(it, importSectionRegion, typeDesc, qualifiedName, context);
                    }
                }
            }
        };
        return (ContentAssistEntry)ObjectExtensions.operator_doubleArrow((Object)_contentAssistEntry, (Procedures.Procedure1)_function);
    }

    protected boolean isImportDeclaration(EReference reference, ContentAssistContext context) {
        return Objects.equal((Object)reference, (Object)XtypePackage.Literals.XIMPORT_DECLARATION__IMPORTED_TYPE);
    }

    protected boolean isImportDeclarationRequired(ITypeDescriptor typeDesc, final String qualifiedName, ContentAssistContext context, XImportSection importSection) {
        boolean _not;
        String _name_1;
        int _lastIndexOf;
        boolean _equals;
        boolean _and = false;
        boolean _and_1 = false;
        String _name = typeDesc.getName();
        boolean _startsWith = _name.startsWith("java.lang");
        _and_1 = !_startsWith ? false : (_equals = (_lastIndexOf = (_name_1 = typeDesc.getName()).lastIndexOf(".")) == 9);
        boolean bl = _not = !_and_1;
        if (!_not) {
            _and = false;
        } else {
            Functions.Function1<XImportDeclaration, Boolean> _function;
            EList _importDeclarations;
            boolean _exists;
            boolean _not_1;
            boolean _or = false;
            _or = importSection == null ? true : (_not_1 = !(_exists = IterableExtensions.exists((Iterable)(_importDeclarations = importSection.getImportDeclarations()), (Functions.Function1)(_function = new Functions.Function1<XImportDeclaration, Boolean>(){

                public Boolean apply(XImportDeclaration it) {
                    JvmDeclaredType _importedType = it.getImportedType();
                    String _qualifiedName = null;
                    if (_importedType != null) {
                        _qualifiedName = _importedType.getQualifiedName();
                    }
                    return Objects.equal((Object)_qualifiedName, (Object)qualifiedName);
                }
            }))));
            _and = _or;
        }
        return _and;
    }

    protected boolean addImportDeclaration(ContentAssistEntry entry, ITextRegion importSectionRegion, ITypeDescriptor typeDesc, String qualifiedName, ContentAssistContext context) {
        boolean _xblockexpression = false;
        int _offset = importSectionRegion.getOffset();
        int _length = importSectionRegion.getLength();
        int insertionOffset = _offset + _length;
        String declaration = "\nimport " + qualifiedName;
        ArrayList _textReplacements = entry.getTextReplacements();
        ReplaceRegion _replaceRegion = new ReplaceRegion(insertionOffset, 0, declaration);
        _xblockexpression = _textReplacements.add(_replaceRegion);
        return _xblockexpression;
    }
}

