/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ide.contentassist;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.xbase.compiler.IGeneratorConfigProvider;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedExecutable;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.OverrideHelper;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.ContextualVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;

public class OverrideProposalUtil {
    @Inject
    private IGeneratorConfigProvider generatorConfigProvider;
    @Inject
    private OverrideHelper overrideHelper;
    @Inject
    private IVisibilityHelper visibilityHelper;

    public List<IResolvedExecutable> getImplementationCandidates(JvmDeclaredType type, boolean isAnonymous) {
        if (type == null || !(type instanceof JvmGenericType)) {
            return Collections.emptyList();
        }
        JavaVersion sourceVersion = this.generatorConfigProvider.get((EObject)type).getJavaSourceVersion();
        ResolvedFeatures resolvedFeatures = this.overrideHelper.getResolvedFeatures(type, sourceVersion);
        ArrayList<IResolvedExecutable> result = new ArrayList<IResolvedExecutable>();
        ContextualVisibilityHelper contextualVisibilityHelper = new ContextualVisibilityHelper(this.visibilityHelper, resolvedFeatures.getType());
        this.addOperationCandidates(resolvedFeatures, (IVisibilityHelper)contextualVisibilityHelper, result);
        if (!isAnonymous && !((JvmGenericType)type).isInterface()) {
            this.addConstructorCandidates(resolvedFeatures, (IVisibilityHelper)contextualVisibilityHelper, result);
        }
        return result;
    }

    protected void addOperationCandidates(ResolvedFeatures resolvedFeatures, IVisibilityHelper visibilityHelper, List<IResolvedExecutable> result) {
        List allOperations = resolvedFeatures.getAllOperations();
        LightweightTypeReference inferredType = resolvedFeatures.getType();
        for (IResolvedOperation operation : allOperations) {
            if (!this.isCandidate(inferredType, (IResolvedExecutable)operation, visibilityHelper)) continue;
            result.add((IResolvedExecutable)operation);
        }
    }

    protected void addConstructorCandidates(ResolvedFeatures resolvedFeatures, IVisibilityHelper visibilityHelper, List<IResolvedExecutable> result) {
        LightweightTypeReference typeReference = resolvedFeatures.getType();
        List superTypes = typeReference.getSuperTypes();
        for (LightweightTypeReference superType : superTypes) {
            if (superType.isInterfaceType()) continue;
            List declaredConstructors = resolvedFeatures.getDeclaredConstructors();
            HashSet erasedSignatures = Sets.newHashSet();
            for (IResolvedConstructor constructor : declaredConstructors) {
                erasedSignatures.add(constructor.getResolvedErasureSignature());
            }
            ResolvedFeatures superClass = this.overrideHelper.getResolvedFeatures(superType);
            for (IResolvedConstructor superclassConstructor : superClass.getDeclaredConstructors()) {
                ResolvedConstructor overriddenConstructor = new ResolvedConstructor(superclassConstructor.getDeclaration(), typeReference);
                if (!this.isCandidate(typeReference, (IResolvedExecutable)overriddenConstructor, visibilityHelper) || !erasedSignatures.add(superclassConstructor.getResolvedErasureSignature())) continue;
                result.add((IResolvedExecutable)overriddenConstructor);
            }
            return;
        }
    }

    protected boolean isCandidate(LightweightTypeReference type, IResolvedExecutable executable, IVisibilityHelper visibilityHelper) {
        JvmDeclaredType declaringType = executable.getDeclaration().getDeclaringType();
        if (type.getType() != declaringType && this.isVisible(executable, visibilityHelper)) {
            JvmExecutable rawExecutable = executable.getDeclaration();
            if (rawExecutable instanceof JvmOperation) {
                JvmOperation operation = (JvmOperation)rawExecutable;
                if (operation.isFinal() || operation.isStatic()) {
                    return false;
                }
                if (type.getType() instanceof JvmGenericType && ((JvmGenericType)type.getType()).isInterface()) {
                    return declaringType instanceof JvmGenericType && ((JvmGenericType)declaringType).isInterface() && !operation.isAbstract();
                }
                return true;
            }
            return true;
        }
        return false;
    }

    protected boolean isVisible(IResolvedExecutable executable, IVisibilityHelper visibilityHelper) {
        return visibilityHelper.isVisible((JvmMember)executable.getDeclaration());
    }
}

