/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.model;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.annotations.Delegate;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.web.server.IServiceResult;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.model.AbstractCachedService;
import org.eclipse.xtext.web.server.model.DocumentSynchronizer;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.PrecomputedServiceRegistry;
import org.eclipse.xtext.web.server.model.XtextWebDocument;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Log
public class XtextWebDocumentAccess {
    @Inject
    private PrecomputedServiceRegistry preComputedServiceRegistry;
    @Inject
    @Named(value="withDocumentLock")
    private ExecutorService executorService1;
    @Inject
    private ExecutorService executorService2;
    @Inject
    private OperationCanceledManager operationCanceledManager;
    private XtextWebDocument document;
    private String requiredStateId;
    private boolean skipAsyncWork;
    private static final Logger LOG = Logger.getLogger(XtextWebDocumentAccess.class);

    protected void init(XtextWebDocument document, String requiredStateId, boolean skipAsyncWork) {
        this.document = document;
        this.requiredStateId = requiredStateId;
        this.skipAsyncWork = skipAsyncWork;
    }

    protected void checkStateId() throws InvalidRequestException.InvalidDocumentStateException {
        String _stateId;
        boolean _notEquals;
        boolean _and = false;
        _and = this.requiredStateId == null ? false : (_notEquals = !Objects.equal((Object)this.requiredStateId, (Object)(_stateId = this.document.getStateId())));
        if (_and) {
            throw new InvalidRequestException.InvalidDocumentStateException("The given state id does not match the current state.");
        }
    }

    public <T> T readOnly(CancelableUnitOfWork<T, IXtextWebDocument> work) {
        return this.doAccess(work, false, false, null);
    }

    public <T> T priorityReadOnly(CancelableUnitOfWork<T, IXtextWebDocument> work) {
        return this.doAccess(work, true, false, null);
    }

    public <T> T modify(CancelableUnitOfWork<T, IXtextWebDocument> work, CancelableUnitOfWork<?, IXtextWebDocument> asynchronousWork) {
        return this.doAccess(work, true, true, asynchronousWork);
    }

    public <T> T modify(CancelableUnitOfWork<T, IXtextWebDocument> work) {
        return this.doAccess(work, true, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T doAccess(CancelableUnitOfWork<T, IXtextWebDocument> synchronousWork, boolean priority, boolean modify, final CancelableUnitOfWork<?, IXtextWebDocument> asynchronousWork) {
        try {
            Object result;
            block10: {
                final DocumentSynchronizer synchronizer = this.document.getSynchronizer();
                IXtextWebDocument _xifexpression = null;
                _xifexpression = modify ? this.document : new ReadAccess(this.document);
                final XtextWebDocument documentAccess = _xifexpression;
                boolean currentThreadOwnsLock = true;
                result = null;
                try {
                    Thread _currentThread;
                    boolean _isInterrupted;
                    boolean _not_1;
                    boolean _isCanceled;
                    boolean _not;
                    String _stateId;
                    Object _exec;
                    synchronizer.acquireLock(priority);
                    this.checkStateId();
                    synchronousWork.setCancelIndicator((CancelIndicator)synchronizer);
                    result = _exec = synchronousWork.exec((Object)documentAccess);
                    this.requiredStateId = _stateId = this.document.getStateId();
                    boolean _and = false;
                    boolean _and_1 = false;
                    _and_1 = this.skipAsyncWork || !priority || documentAccess == null ? false : (_not = !(_isCanceled = synchronizer.isCanceled()));
                    _and = !_and_1 ? false : (_not_1 = !(_isInterrupted = (_currentThread = Thread.currentThread()).isInterrupted()));
                    if (_and) {
                        Procedures.Procedure1<Object> _function = new Procedures.Procedure1<Object>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void apply(Object it) {
                                block10: {
                                    try {
                                        if (asynchronousWork != null) {
                                            asynchronousWork.setCancelIndicator((CancelIndicator)synchronizer);
                                            asynchronousWork.exec((Object)documentAccess);
                                        }
                                        XtextResource _resource = documentAccess.getResource();
                                        EcoreUtil2.resolveLazyCrossReferences((Resource)_resource, (CancelIndicator)synchronizer);
                                    }
                                    catch (Throwable _t) {
                                        if (_t instanceof VirtualMachineError) {
                                            VirtualMachineError error = (VirtualMachineError)_t;
                                            throw error;
                                        }
                                        if (_t instanceof Throwable) {
                                            Throwable throwable = _t;
                                            boolean _isOperationCanceledException = XtextWebDocumentAccess.this.operationCanceledManager.isOperationCanceledException(throwable);
                                            if (_isOperationCanceledException) {
                                                LOG.trace((Object)"Canceling background work.");
                                            } else {
                                                LOG.error((Object)"Error during background work.", throwable);
                                            }
                                            break block10;
                                        }
                                        throw Exceptions.sneakyThrow((Throwable)_t);
                                    }
                                    finally {
                                        synchronizer.releaseLock();
                                    }
                                }
                            }
                        };
                        this.executorService1.submit(new Runnable((Procedures.Procedure1)_function){
                            final /* synthetic */ Procedures.Procedure1 val$_function;
                            {
                                this.val$_function = procedure1;
                            }

                            @Override
                            public void run() {
                                this.val$_function.apply(null);
                            }
                        });
                        currentThreadOwnsLock = false;
                        Procedures.Procedure1<Object> _function_1 = new Procedures.Procedure1<Object>(){

                            public void apply(Object it) {
                                try {
                                    XtextWebDocumentAccess.this.performPrecomputation(synchronizer);
                                }
                                catch (Throwable _t) {
                                    if (_t instanceof VirtualMachineError) {
                                        VirtualMachineError error = (VirtualMachineError)_t;
                                        throw error;
                                    }
                                    if (_t instanceof InvalidRequestException.InvalidDocumentStateException) {
                                        InvalidRequestException.InvalidDocumentStateException idse = (InvalidRequestException.InvalidDocumentStateException)_t;
                                        return;
                                    }
                                    if (_t instanceof Throwable) {
                                        Throwable throwable = _t;
                                        boolean _isOperationCanceledException = XtextWebDocumentAccess.this.operationCanceledManager.isOperationCanceledException(throwable);
                                        if (_isOperationCanceledException) {
                                            LOG.trace((Object)"Canceling precomputation.");
                                        } else {
                                            LOG.error((Object)"Error during precomputation.", throwable);
                                        }
                                    }
                                    throw Exceptions.sneakyThrow((Throwable)_t);
                                }
                            }
                        };
                        this.executorService2.submit(new Runnable((Procedures.Procedure1)_function_1){
                            final /* synthetic */ Procedures.Procedure1 val$_function_1;
                            {
                                this.val$_function_1 = procedure1;
                            }

                            @Override
                            public void run() {
                                this.val$_function_1.apply(null);
                            }
                        });
                    }
                }
                catch (Throwable _t) {
                    if (_t instanceof RejectedExecutionException) {
                        RejectedExecutionException ree = (RejectedExecutionException)_t;
                        LOG.error((Object)"Failed to start background work.", (Throwable)ree);
                        break block10;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                finally {
                    if (currentThreadOwnsLock) {
                        synchronizer.releaseLock();
                    }
                }
            }
            return (T)result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void performPrecomputation(CancelIndicator cancelIndicator) {
        Iterable<AbstractCachedService<? extends IServiceResult>> _precomputedServices = this.preComputedServiceRegistry.getPrecomputedServices();
        for (AbstractCachedService<? extends IServiceResult> service : _precomputedServices) {
            this.operationCanceledManager.checkCanceled(cancelIndicator);
            this.getCachedServiceResult(service, false);
        }
    }

    protected <T extends IServiceResult> T getCachedServiceResult(final AbstractCachedService<T> service, final boolean logCacheMiss) {
        CancelableUnitOfWork _function = new CancelableUnitOfWork<T, IXtextWebDocument>(){

            public T exec(IXtextWebDocument d, CancelIndicator cancelIndicator) throws Exception {
                boolean _tripleNotEquals;
                String _resourceId = XtextWebDocumentAccess.this.document.getResourceId();
                boolean bl = _tripleNotEquals = _resourceId != null;
                if (_tripleNotEquals) {
                    return XtextWebDocumentAccess.this.document.getCachedServiceResult(service, cancelIndicator, logCacheMiss);
                }
                return service.compute(XtextWebDocumentAccess.this.document, cancelIndicator);
            }
        };
        return (T)((IServiceResult)this.readOnly(_function));
    }

    @FinalFieldsConstructor
    protected static class ReadAccess
    implements IXtextWebDocument {
        @Delegate
        private final XtextWebDocument document;

        @Override
        public void setText(String text) {
            throw new UnsupportedOperationException("Cannot modify the document with read-only access.");
        }

        @Override
        public void updateText(String text, int offset, int replaceLength) {
            throw new UnsupportedOperationException("Cannot modify the document with read-only access.");
        }

        @Override
        public void createNewStateId() {
            throw new UnsupportedOperationException("Cannot modify the document with read-only access.");
        }

        public ReadAccess(XtextWebDocument document) {
            this.document = document;
        }

        @Override
        public XtextResource getResource() {
            return this.document.getResource();
        }

        @Override
        public String getResourceId() {
            return this.document.getResourceId();
        }

        @Override
        public String getText() {
            return this.document.getText();
        }

        @Override
        public String getStateId() {
            return this.document.getStateId();
        }

        @Override
        public boolean isDirty() {
            return this.document.isDirty();
        }

        @Override
        public void setDirty(boolean dirty) {
            this.document.setDirty(dirty);
        }
    }

    public static class Factory {
        @Inject
        private Provider<XtextWebDocumentAccess> provider;

        public XtextWebDocumentAccess create(XtextWebDocument document, String requiredStateId, boolean skipAsyncWork) {
            XtextWebDocumentAccess docAccess = (XtextWebDocumentAccess)this.provider.get();
            docAccess.init(document, requiredStateId, skipAsyncWork);
            docAccess.checkStateId();
            return docAccess;
        }

        public XtextWebDocumentAccess create(XtextWebDocument document, boolean skipAsyncWork) {
            XtextWebDocumentAccess docAccess = (XtextWebDocumentAccess)this.provider.get();
            docAccess.init(document, null, skipAsyncWork);
            return docAccess;
        }
    }
}

