/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.validation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.web.server.model.AbstractCachedService;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.validation.ValidationResult;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class ValidationService
extends AbstractCachedService<ValidationResult> {
    @Inject
    private IResourceValidator resourceValidator;

    @Override
    public ValidationResult compute(IXtextWebDocument it, CancelIndicator cancelIndicator) {
        XtextResource _resource = it.getResource();
        List issues = this.resourceValidator.validate((Resource)_resource, CheckMode.ALL, cancelIndicator);
        final ValidationResult result = new ValidationResult();
        Functions.Function1<Issue, Boolean> _function = new Functions.Function1<Issue, Boolean>(){

            public Boolean apply(Issue it) {
                Severity _severity = it.getSeverity();
                return !Objects.equal((Object)_severity, (Object)Severity.IGNORE);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)issues, (Functions.Function1)_function);
        Procedures.Procedure1<Issue> _function_1 = new Procedures.Procedure1<Issue>(){

            public void apply(Issue issue) {
                List<ValidationResult.Issue> _issues = result.getIssues();
                String _message = issue.getMessage();
                Severity _severity = issue.getSeverity();
                String _translate = ValidationService.this.translate(_severity);
                Integer _lineNumber = issue.getLineNumber();
                Integer _column = issue.getColumn();
                Integer _offset = issue.getOffset();
                Integer _length = issue.getLength();
                ValidationResult.Issue _issue = new ValidationResult.Issue(_message, _translate, _lineNumber, _column, _offset, _length);
                _issues.add(_issue);
            }
        };
        IterableExtensions.forEach((Iterable)_filter, (Procedures.Procedure1)_function_1);
        return result;
    }

    protected String translate(Severity severity) {
        String _switchResult = null;
        if (severity != null) {
            switch (severity) {
                case WARNING: {
                    _switchResult = "warning";
                    break;
                }
                case ERROR: {
                    _switchResult = "error";
                    break;
                }
                case INFO: {
                    _switchResult = "info";
                    break;
                }
                default: {
                    _switchResult = "ignore";
                    break;
                }
            }
        } else {
            _switchResult = "ignore";
        }
        return _switchResult;
    }
}

