/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.occurrences;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.TargetURIs;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocumentAccess;
import org.eclipse.xtext.web.server.occurrences.OccurrencesResult;
import org.eclipse.xtext.web.server.util.CancelIndicatorProgressMonitor;
import org.eclipse.xtext.web.server.util.ElementAtOffsetUtil;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class OccurrencesService {
    @Inject
    @Extension
    private ElementAtOffsetUtil _elementAtOffsetUtil;
    @Inject
    @Extension
    private ILocationInFileProvider _iLocationInFileProvider;
    @Inject
    private Provider<TargetURIs> targetURIsProvider;
    @Inject
    @Extension
    private IReferenceFinder _iReferenceFinder;

    public OccurrencesResult findOccurrences(XtextWebDocumentAccess document, final int offset) {
        CancelableUnitOfWork<OccurrencesResult, IXtextWebDocument> _function = new CancelableUnitOfWork<OccurrencesResult, IXtextWebDocument>(){

            public OccurrencesResult exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                boolean _filter;
                XtextResource _resource = it.getResource();
                EObject element = OccurrencesService.this._elementAtOffsetUtil.getElementAt(_resource, offset);
                String _stateId = it.getStateId();
                final OccurrencesResult occurrencesResult = new OccurrencesResult(_stateId);
                boolean _and = false;
                _and = element == null ? false : (_filter = OccurrencesService.this.filter(element));
                if (_and) {
                    ITextRegion definitionRegion;
                    URI elementURI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)element);
                    TargetURIs targetURIs = (TargetURIs)OccurrencesService.this.targetURIsProvider.get();
                    targetURIs.addURI(elementURI);
                    IReferenceFinder.Acceptor acceptor = new IReferenceFinder.Acceptor(){

                        public void accept(EObject source, URI sourceURI, EReference eReference, int index, EObject targetOrProxy, URI targetURI) {
                            ITextRegion region = OccurrencesService.this._iLocationInFileProvider.getSignificantTextRegion(source, (EStructuralFeature)eReference, index);
                            List<TextRegion> _readRegions = occurrencesResult.getReadRegions();
                            int _offset = region.getOffset();
                            int _length = region.getLength();
                            TextRegion _textRegion = new TextRegion(_offset, _length);
                            _readRegions.add(_textRegion);
                        }

                        public void accept(IReferenceDescription description) {
                        }
                    };
                    XtextResource _resource_1 = it.getResource();
                    CancelIndicatorProgressMonitor _cancelIndicatorProgressMonitor = new CancelIndicatorProgressMonitor(cancelIndicator);
                    OccurrencesService.this._iReferenceFinder.findReferences(targetURIs, (Resource)_resource_1, acceptor, (IProgressMonitor)_cancelIndicatorProgressMonitor);
                    Resource _eResource = element.eResource();
                    XtextResource _resource_2 = it.getResource();
                    boolean _equals = Objects.equal((Object)_eResource, (Object)_resource_2);
                    if (_equals && (definitionRegion = OccurrencesService.this._iLocationInFileProvider.getSignificantTextRegion(element)) != null && definitionRegion != ITextRegionWithLineInformation.EMPTY_REGION) {
                        List<TextRegion> _writeRegions = occurrencesResult.getWriteRegions();
                        int _offset = definitionRegion.getOffset();
                        int _length = definitionRegion.getLength();
                        TextRegion _textRegion = new TextRegion(_offset, _length);
                        _writeRegions.add(_textRegion);
                    }
                }
                return occurrencesResult;
            }
        };
        return document.readOnly(_function);
    }

    protected boolean filter(EObject element) {
        EObject _eContainer = element.eContainer();
        return _eContainer != null;
    }
}

