/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.persistence;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.web.server.ISessionStore;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.model.DocumentStateResult;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocumentAccess;
import org.eclipse.xtext.web.server.persistence.IServerResourceHandler;
import org.eclipse.xtext.web.server.persistence.ResourceContentResult;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Pair;

@Singleton
public class ResourcePersistenceService {
    @Inject
    private XtextWebDocumentAccess.Factory documentAccessFactory;

    public ResourceContentResult load(final String resourceId, final IServerResourceHandler resourceHandler, ISessionStore sessionStore) throws InvalidRequestException {
        ResourceContentResult _xblockexpression = null;
        Pair _mappedTo = Pair.of(XtextWebDocument.class, (Object)resourceId);
        Functions.Function0<XtextWebDocument> _function = new Functions.Function0<XtextWebDocument>(){

            public XtextWebDocument apply() {
                XtextWebDocument _xtrycatchfinallyexpression = null;
                try {
                    _xtrycatchfinallyexpression = resourceHandler.get(resourceId);
                }
                catch (Throwable _t) {
                    if (_t instanceof IOException) {
                        IOException ioe = (IOException)_t;
                        throw new InvalidRequestException.ResourceNotFoundException("The requested resource was not found.", ioe);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                return _xtrycatchfinallyexpression;
            }
        };
        XtextWebDocument document = sessionStore.get(_mappedTo, _function);
        XtextWebDocumentAccess _create = this.documentAccessFactory.create(document, false);
        CancelableUnitOfWork<ResourceContentResult, IXtextWebDocument> _function_1 = new CancelableUnitOfWork<ResourceContentResult, IXtextWebDocument>(){

            public ResourceContentResult exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                String _text = it.getText();
                String _stateId = it.getStateId();
                boolean _isDirty = it.isDirty();
                return new ResourceContentResult(_text, _stateId, _isDirty);
            }
        };
        _xblockexpression = _create.readOnly(_function_1);
        return _xblockexpression;
    }

    public ResourceContentResult revert(String resourceId, IServerResourceHandler resourceHandler, ISessionStore sessionStore) throws InvalidRequestException {
        try {
            XtextWebDocument document = resourceHandler.get(resourceId);
            Pair _mappedTo = Pair.of(XtextWebDocument.class, (Object)resourceId);
            sessionStore.put(_mappedTo, document);
            String _text = document.getText();
            String _stateId = document.getStateId();
            return new ResourceContentResult(_text, _stateId, false);
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException ioe = (IOException)_t;
                throw new InvalidRequestException.ResourceNotFoundException("The requested resource was not found.", ioe);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public DocumentStateResult save(XtextWebDocumentAccess document, final IServerResourceHandler resourceHandler) throws InvalidRequestException {
        CancelableUnitOfWork<DocumentStateResult, IXtextWebDocument> _function = new CancelableUnitOfWork<DocumentStateResult, IXtextWebDocument>(){

            public DocumentStateResult exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                try {
                    resourceHandler.put(it);
                    it.setDirty(false);
                }
                catch (Throwable _t) {
                    if (_t instanceof IOException) {
                        IOException ioe = (IOException)_t;
                        String _message = ioe.getMessage();
                        throw new InvalidRequestException.ResourceNotFoundException(_message, ioe);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                String _stateId = it.getStateId();
                return new DocumentStateResult(_stateId);
            }
        };
        return document.readOnly(_function);
    }
}

