/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.web.server.IRequestData;
import org.eclipse.xtext.web.server.IServiceResult;
import org.eclipse.xtext.web.server.ISessionStore;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.ServiceConflictResult;
import org.eclipse.xtext.web.server.contentassist.ContentAssistService;
import org.eclipse.xtext.web.server.formatting.FormattingService;
import org.eclipse.xtext.web.server.generator.GeneratorService;
import org.eclipse.xtext.web.server.hover.HoverService;
import org.eclipse.xtext.web.server.model.DocumentStateResult;
import org.eclipse.xtext.web.server.model.IWebResourceSetProvider;
import org.eclipse.xtext.web.server.model.PrecomputedServiceRegistry;
import org.eclipse.xtext.web.server.model.UpdateDocumentService;
import org.eclipse.xtext.web.server.model.XtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocumentAccess;
import org.eclipse.xtext.web.server.occurrences.OccurrencesService;
import org.eclipse.xtext.web.server.persistence.IServerResourceHandler;
import org.eclipse.xtext.web.server.persistence.ResourceContentResult;
import org.eclipse.xtext.web.server.persistence.ResourcePersistenceService;
import org.eclipse.xtext.web.server.syntaxcoloring.HighlightingService;
import org.eclipse.xtext.web.server.validation.ValidationService;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Singleton
@Log
public class XtextServiceDispatcher {
    @Inject
    private ResourcePersistenceService resourcePersistenceService;
    @Inject
    private UpdateDocumentService updateDocumentService;
    @Inject
    private ContentAssistService contentAssistService;
    @Inject
    private ValidationService validationService;
    @Inject
    private HighlightingService highlightingService;
    @Inject
    private HoverService hoverService;
    @Inject
    private OccurrencesService occurrencesService;
    @Inject
    private FormattingService formattingService;
    @Inject
    private GeneratorService generatorService;
    @Inject
    private IServerResourceHandler resourceHandler;
    @Inject
    private IWebResourceSetProvider resourceSetProvider;
    @Inject
    private Provider<XtextWebDocument> documentProvider;
    @Inject
    private FileExtensionProvider fileExtensionProvider;
    @Inject
    private IResourceFactory resourceFactory;
    @Inject
    private OperationCanceledManager operationCanceledManager;
    @Inject
    private XtextWebDocumentAccess.Factory documentAccessFactory;
    private static final Logger LOG = Logger.getLogger(XtextServiceDispatcher.class);

    @Inject
    protected void registerPreComputedServices(PrecomputedServiceRegistry registry) {
        registry.addPrecomputedService(this.highlightingService);
        registry.addPrecomputedService(this.validationService);
    }

    public ServiceDescriptor getService(final IRequestData request, ISessionStore sessionStore) throws InvalidRequestException {
        final String requestType = request.getParameter("requestType");
        if (requestType == null) {
            throw new InvalidRequestException.InvalidParametersException("The parameter 'requestType' is required.");
        }
        boolean _isTraceEnabled = LOG.isTraceEnabled();
        if (_isTraceEnabled) {
            Set<String> _parameterKeys = request.getParameterKeys();
            List _sort = IterableExtensions.sort(_parameterKeys);
            Functions.Function1<String, CharSequence> _function = new Functions.Function1<String, CharSequence>(){

                public CharSequence apply(String key) {
                    boolean _greaterThan;
                    String _xblockexpression = null;
                    String value = request.getParameter(key);
                    String _xifexpression = null;
                    int _length = value.length();
                    boolean bl = _greaterThan = _length > 18;
                    if (_greaterThan) {
                        String _substring = value.substring(0, 16);
                        String _plus = key + "='" + _substring;
                        _xifexpression = _plus + "...'";
                    } else {
                        String _xifexpression_1 = null;
                        boolean _matches = value.matches(".*\\s+.*");
                        _xifexpression_1 = _matches ? key + "='" + value + "'" : key + "=" + value;
                        _xifexpression = _xifexpression_1;
                    }
                    _xblockexpression = _xifexpression;
                    return _xblockexpression;
                }
            };
            String _join = IterableExtensions.join((Iterable)_sort, (CharSequence)": ", (CharSequence)", ", (CharSequence)"", (Functions.Function1)_function);
            String stringParams = _join.replaceAll("(\\n|\\f|\\r)+", " ");
            LOG.trace((Object)("xtext-service/" + requestType + stringParams));
        }
        try {
            ServiceDescriptor _createServiceDescriptor = this.createServiceDescriptor(requestType, request, sessionStore);
            Procedures.Procedure1<ServiceDescriptor> _function_1 = new Procedures.Procedure1<ServiceDescriptor>(){

                public void apply(ServiceDescriptor it) {
                    it.type = requestType;
                }
            };
            return (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_createServiceDescriptor, (Procedures.Procedure1)_function_1);
        }
        catch (Throwable _t) {
            if (_t instanceof InvalidRequestException.InvalidDocumentStateException) {
                InvalidRequestException.InvalidDocumentStateException ire = (InvalidRequestException.InvalidDocumentStateException)_t;
                LOG.trace((Object)("Invalid document state (" + requestType + ")"));
                ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
                Procedures.Procedure1<ServiceDescriptor> _function_2 = new Procedures.Procedure1<ServiceDescriptor>(){

                    public void apply(ServiceDescriptor it) {
                        it.type = requestType;
                        Functions.Function0<IServiceResult> _function = new Functions.Function0<IServiceResult>(){

                            public IServiceResult apply() {
                                return new ServiceConflictResult("invalidStateId");
                            }
                        };
                        it.service = (Functions.Function0)_function;
                        it.hasConflict = true;
                    }
                };
                return (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function_2);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected ServiceDescriptor createServiceDescriptor(String requestType, IRequestData request, ISessionStore sessionStore) {
        ServiceDescriptor _switchResult = null;
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)requestType, (Object)"load")) {
            _matched = true;
            _switchResult = this.getLoadResourceService(false, request, sessionStore);
        }
        if (!_matched && Objects.equal((Object)requestType, (Object)"revert")) {
            _matched = true;
            _switchResult = this.getLoadResourceService(true, request, sessionStore);
        }
        if (!_matched && Objects.equal((Object)requestType, (Object)"save")) {
            _matched = true;
            _switchResult = this.getSaveResourceService(request, sessionStore);
        }
        if (!_matched && Objects.equal((Object)requestType, (Object)"update")) {
            _matched = true;
            _switchResult = this.getUpdateDocumentService(request, sessionStore);
        }
        if (!_matched && Objects.equal((Object)requestType, (Object)"assist")) {
            _matched = true;
            _switchResult = this.getContentAssistService(request, sessionStore);
        }
        if (!_matched && Objects.equal((Object)requestType, (Object)"validate")) {
            _matched = true;
            _switchResult = this.getValidationService(request, sessionStore);
        }
        if (!_matched && Objects.equal((Object)requestType, (Object)"hover")) {
            _matched = true;
            _switchResult = this.getHoverService(request, sessionStore);
        }
        if (!_matched && Objects.equal((Object)requestType, (Object)"highlight")) {
            _matched = true;
            _switchResult = this.getHighlightingService(request, sessionStore);
        }
        if (!_matched && Objects.equal((Object)requestType, (Object)"occurrences")) {
            _matched = true;
            _switchResult = this.getOccurrencesService(request, sessionStore);
        }
        if (!_matched && Objects.equal((Object)requestType, (Object)"format")) {
            _matched = true;
            _switchResult = this.getFormattingService(request, sessionStore);
        }
        if (!_matched && Objects.equal((Object)requestType, (Object)"generate")) {
            _matched = true;
            _switchResult = this.getGeneratorService(request, sessionStore);
        }
        if (!_matched) {
            throw new InvalidRequestException.InvalidParametersException("The request type '" + requestType + "' is not supported.");
        }
        return _switchResult;
    }

    protected ServiceDescriptor getLoadResourceService(final boolean revert, IRequestData request, final ISessionStore sessionStore) throws InvalidRequestException {
        ServiceDescriptor _xblockexpression = null;
        final String resourceId = request.getParameter("resource");
        if (resourceId == null) {
            throw new InvalidRequestException.InvalidParametersException("The parameter 'resource' is required.");
        }
        ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
        Procedures.Procedure1<ServiceDescriptor> _function = new Procedures.Procedure1<ServiceDescriptor>(){

            public void apply(final ServiceDescriptor it) {
                Functions.Function0<IServiceResult> _function = new Functions.Function0<IServiceResult>(){

                    public IServiceResult apply() {
                        IServiceResult _xtrycatchfinallyexpression = null;
                        try {
                            ResourceContentResult _xifexpression = null;
                            _xifexpression = revert ? XtextServiceDispatcher.this.resourcePersistenceService.revert(resourceId, XtextServiceDispatcher.this.resourceHandler, sessionStore) : XtextServiceDispatcher.this.resourcePersistenceService.load(resourceId, XtextServiceDispatcher.this.resourceHandler, sessionStore);
                            _xtrycatchfinallyexpression = _xifexpression;
                        }
                        catch (Throwable _t) {
                            if (_t instanceof Throwable) {
                                Throwable throwable = _t;
                                _xtrycatchfinallyexpression = XtextServiceDispatcher.this.handleError(it, throwable);
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                        return _xtrycatchfinallyexpression;
                    }
                };
                it.service = (Functions.Function0)_function;
                it.hasSideEffects = revert;
            }
        };
        _xblockexpression = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    protected ServiceDescriptor getSaveResourceService(final IRequestData request, ISessionStore sessionStore) throws InvalidRequestException {
        ServiceDescriptor _xblockexpression = null;
        final XtextWebDocumentAccess document = this.getDocumentAccess(request, sessionStore);
        ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
        Procedures.Procedure1<ServiceDescriptor> _function = new Procedures.Procedure1<ServiceDescriptor>(){

            public void apply(final ServiceDescriptor it) {
                Functions.Function0<IServiceResult> _function = new Functions.Function0<IServiceResult>(){

                    public IServiceResult apply() {
                        IServiceResult _xtrycatchfinallyexpression = null;
                        try {
                            _xtrycatchfinallyexpression = XtextServiceDispatcher.this.resourcePersistenceService.save(document, XtextServiceDispatcher.this.resourceHandler);
                        }
                        catch (Throwable _t) {
                            if (_t instanceof Throwable) {
                                Throwable throwable = _t;
                                _xtrycatchfinallyexpression = XtextServiceDispatcher.this.handleError(it, throwable);
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                        return _xtrycatchfinallyexpression;
                    }
                };
                it.service = (Functions.Function0)_function;
                it.hasSideEffects = true;
                Set<String> _parameterKeys = request.getParameterKeys();
                boolean _contains = _parameterKeys.contains("fullText");
                it.hasTextInput = _contains;
            }
        };
        _xblockexpression = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    protected ServiceDescriptor getUpdateDocumentService(IRequestData request, ISessionStore sessionStore) throws InvalidRequestException {
        boolean initializedFromFullText;
        String resourceId = request.getParameter("resource");
        if (resourceId == null) {
            throw new InvalidRequestException.InvalidParametersException("The parameter 'resource' is required.");
        }
        final String fullText = request.getParameter("fullText");
        XtextWebDocument document = this.getResourceDocument(resourceId, sessionStore);
        boolean bl = initializedFromFullText = document == null;
        if (initializedFromFullText) {
            XtextWebDocument _fullTextDocument;
            if (fullText == null) {
                throw new InvalidRequestException.ResourceNotFoundException("The requested resource was not found.");
            }
            document = _fullTextDocument = this.getFullTextDocument(fullText, resourceId, sessionStore);
        }
        String _parameter = request.getParameter("requiredStateId");
        final XtextWebDocumentAccess documentAccess = this.documentAccessFactory.create(document, _parameter, false);
        ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
        Procedures.Procedure1<ServiceDescriptor> _function = new Procedures.Procedure1<ServiceDescriptor>(){

            public void apply(ServiceDescriptor it) {
                it.hasSideEffects = true;
                it.hasTextInput = true;
            }
        };
        final ServiceDescriptor result = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function);
        if (fullText == null) {
            final String deltaText = request.getParameter("deltaText");
            if (deltaText == null) {
                throw new InvalidRequestException.InvalidParametersException("One of the parameters 'deltaText' and 'fullText' must be specified.");
            }
            Optional _absent = Optional.absent();
            final int deltaOffset = this.getInt(request, "deltaOffset", (Optional<Integer>)_absent);
            if (deltaOffset < 0) {
                throw new InvalidRequestException.InvalidParametersException("The parameter 'deltaOffset' must not be negative.");
            }
            Optional _absent_1 = Optional.absent();
            final int deltaReplaceLength = this.getInt(request, "deltaReplaceLength", (Optional<Integer>)_absent_1);
            if (deltaReplaceLength < 0) {
                throw new InvalidRequestException.InvalidParametersException("The parameter 'deltaReplaceLength' must not be negative.");
            }
            Functions.Function0<IServiceResult> _function_1 = new Functions.Function0<IServiceResult>(){

                public IServiceResult apply() {
                    IServiceResult _xtrycatchfinallyexpression = null;
                    try {
                        _xtrycatchfinallyexpression = XtextServiceDispatcher.this.updateDocumentService.updateDeltaText(documentAccess, deltaText, deltaOffset, deltaReplaceLength);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Throwable) {
                            Throwable throwable = _t;
                            _xtrycatchfinallyexpression = XtextServiceDispatcher.this.handleError(result, throwable);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    return _xtrycatchfinallyexpression;
                }
            };
            result.service = (Functions.Function0)_function_1;
        } else {
            Set<String> _parameterKeys = request.getParameterKeys();
            boolean _contains = _parameterKeys.contains("deltaText");
            if (_contains) {
                throw new InvalidRequestException.InvalidParametersException("The parameters 'deltaText' and 'fullText' cannot be set in the same request.");
            }
            Functions.Function0<IServiceResult> _function_2 = new Functions.Function0<IServiceResult>(){

                public IServiceResult apply() {
                    IServiceResult _xtrycatchfinallyexpression = null;
                    try {
                        DocumentStateResult _xifexpression = null;
                        _xifexpression = initializedFromFullText ? XtextServiceDispatcher.this.updateDocumentService.getStateId(documentAccess) : XtextServiceDispatcher.this.updateDocumentService.updateFullText(documentAccess, fullText);
                        _xtrycatchfinallyexpression = _xifexpression;
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Throwable) {
                            Throwable throwable = _t;
                            _xtrycatchfinallyexpression = XtextServiceDispatcher.this.handleError(result, throwable);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    return _xtrycatchfinallyexpression;
                }
            };
            result.service = (Functions.Function0)_function_2;
        }
        return result;
    }

    protected ServiceDescriptor getContentAssistService(final IRequestData request, ISessionStore sessionStore) throws InvalidRequestException {
        ServiceDescriptor _xblockexpression = null;
        Optional _of = Optional.of((Object)0);
        final int offset = this.getInt(request, "caretOffset", (Optional<Integer>)_of);
        final XtextWebDocumentAccess document = this.getDocumentAccess(request, sessionStore);
        Optional _of_1 = Optional.of((Object)1000);
        final int proposalsLimit = this.getInt(request, "proposalsLimit", (Optional<Integer>)_of_1);
        if (proposalsLimit <= 0) {
            throw new InvalidRequestException.InvalidParametersException("The parameter 'proposalsLimit' must contain a positive integer.");
        }
        Optional _of_2 = Optional.of((Object)offset);
        int selectionStart = this.getInt(request, "selectionStart", (Optional<Integer>)_of_2);
        Optional _of_3 = Optional.of((Object)selectionStart);
        int selectionEnd = this.getInt(request, "selectionEnd", (Optional<Integer>)_of_3);
        int _max = Math.max(selectionEnd - selectionStart, 0);
        final TextRegion selection = new TextRegion(selectionStart, _max);
        final String deltaText = request.getParameter("deltaText");
        ServiceDescriptor _xifexpression = null;
        if (deltaText == null) {
            ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
            Procedures.Procedure1<ServiceDescriptor> _function = new Procedures.Procedure1<ServiceDescriptor>(){

                public void apply(final ServiceDescriptor it) {
                    Functions.Function0<IServiceResult> _function = new Functions.Function0<IServiceResult>(){

                        public IServiceResult apply() {
                            IServiceResult _xtrycatchfinallyexpression = null;
                            try {
                                _xtrycatchfinallyexpression = XtextServiceDispatcher.this.contentAssistService.createProposals(document, (ITextRegion)selection, offset, proposalsLimit);
                            }
                            catch (Throwable _t) {
                                if (_t instanceof Throwable) {
                                    Throwable throwable = _t;
                                    _xtrycatchfinallyexpression = XtextServiceDispatcher.this.handleError(it, throwable);
                                }
                                throw Exceptions.sneakyThrow((Throwable)_t);
                            }
                            return _xtrycatchfinallyexpression;
                        }
                    };
                    it.service = (Functions.Function0)_function;
                    Set<String> _parameterKeys = request.getParameterKeys();
                    boolean _contains = _parameterKeys.contains("fullText");
                    it.hasTextInput = _contains;
                }
            };
            _xifexpression = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function);
        } else {
            ServiceDescriptor _xblockexpression_1 = null;
            Set<String> _parameterKeys = request.getParameterKeys();
            boolean _contains = _parameterKeys.contains("fullText");
            if (_contains) {
                throw new InvalidRequestException.InvalidParametersException("The parameters 'deltaText' and 'fullText' cannot be set in the same request.");
            }
            Optional _absent = Optional.absent();
            final int deltaOffset = this.getInt(request, "deltaOffset", (Optional<Integer>)_absent);
            if (deltaOffset < 0) {
                throw new InvalidRequestException.InvalidParametersException("The parameter 'deltaOffset' must not be negative.");
            }
            Optional _absent_1 = Optional.absent();
            final int deltaReplaceLength = this.getInt(request, "deltaReplaceLength", (Optional<Integer>)_absent_1);
            if (deltaReplaceLength < 0) {
                throw new InvalidRequestException.InvalidParametersException("The parameter 'deltaReplaceLength' must not be negative.");
            }
            ServiceDescriptor _serviceDescriptor_1 = new ServiceDescriptor();
            Procedures.Procedure1<ServiceDescriptor> _function_1 = new Procedures.Procedure1<ServiceDescriptor>(){

                public void apply(final ServiceDescriptor it) {
                    Functions.Function0<IServiceResult> _function = new Functions.Function0<IServiceResult>(){

                        public IServiceResult apply() {
                            IServiceResult _xtrycatchfinallyexpression = null;
                            try {
                                _xtrycatchfinallyexpression = XtextServiceDispatcher.this.contentAssistService.createProposalsWithUpdate(document, deltaText, deltaOffset, deltaReplaceLength, (ITextRegion)selection, offset, proposalsLimit);
                            }
                            catch (Throwable _t) {
                                if (_t instanceof Throwable) {
                                    Throwable throwable = _t;
                                    _xtrycatchfinallyexpression = XtextServiceDispatcher.this.handleError(it, throwable);
                                }
                                throw Exceptions.sneakyThrow((Throwable)_t);
                            }
                            return _xtrycatchfinallyexpression;
                        }
                    };
                    it.service = (Functions.Function0)_function;
                    it.hasSideEffects = true;
                    it.hasTextInput = true;
                }
            };
            _xifexpression = _xblockexpression_1 = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor_1, (Procedures.Procedure1)_function_1);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected ServiceDescriptor getValidationService(final IRequestData request, ISessionStore sessionStore) throws InvalidRequestException {
        ServiceDescriptor _xblockexpression = null;
        final XtextWebDocumentAccess document = this.getDocumentAccess(request, sessionStore);
        ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
        Procedures.Procedure1<ServiceDescriptor> _function = new Procedures.Procedure1<ServiceDescriptor>(){

            public void apply(final ServiceDescriptor it) {
                Functions.Function0<IServiceResult> _function = new Functions.Function0<IServiceResult>(){

                    public IServiceResult apply() {
                        ServiceConflictResult _xtrycatchfinallyexpression = null;
                        try {
                            _xtrycatchfinallyexpression = (ServiceConflictResult)XtextServiceDispatcher.this.validationService.getResult(document);
                        }
                        catch (Throwable _t) {
                            if (_t instanceof Throwable) {
                                Throwable throwable = _t;
                                _xtrycatchfinallyexpression = XtextServiceDispatcher.this.handleError(it, throwable);
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                        return _xtrycatchfinallyexpression;
                    }
                };
                it.service = (Functions.Function0)_function;
                Set<String> _parameterKeys = request.getParameterKeys();
                boolean _contains = _parameterKeys.contains("fullText");
                it.hasTextInput = _contains;
            }
        };
        _xblockexpression = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    protected ServiceDescriptor getHoverService(final IRequestData request, ISessionStore sessionStore) throws InvalidRequestException {
        ServiceDescriptor _xblockexpression = null;
        final XtextWebDocumentAccess document = this.getDocumentAccess(request, sessionStore);
        Optional _of = Optional.of((Object)0);
        final int offset = this.getInt(request, "caretOffset", (Optional<Integer>)_of);
        ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
        Procedures.Procedure1<ServiceDescriptor> _function = new Procedures.Procedure1<ServiceDescriptor>(){

            public void apply(final ServiceDescriptor it) {
                Functions.Function0<IServiceResult> _function = new Functions.Function0<IServiceResult>(){

                    public IServiceResult apply() {
                        IServiceResult _xtrycatchfinallyexpression = null;
                        try {
                            _xtrycatchfinallyexpression = XtextServiceDispatcher.this.hoverService.getHover(document, offset);
                        }
                        catch (Throwable _t) {
                            if (_t instanceof Throwable) {
                                Throwable throwable = _t;
                                _xtrycatchfinallyexpression = XtextServiceDispatcher.this.handleError(it, throwable);
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                        return _xtrycatchfinallyexpression;
                    }
                };
                it.service = (Functions.Function0)_function;
                Set<String> _parameterKeys = request.getParameterKeys();
                boolean _contains = _parameterKeys.contains("fullText");
                it.hasTextInput = _contains;
            }
        };
        _xblockexpression = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    protected ServiceDescriptor getHighlightingService(final IRequestData request, ISessionStore sessionStore) throws InvalidRequestException {
        ServiceDescriptor _xblockexpression = null;
        final XtextWebDocumentAccess document = this.getDocumentAccess(request, sessionStore);
        ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
        Procedures.Procedure1<ServiceDescriptor> _function = new Procedures.Procedure1<ServiceDescriptor>(){

            public void apply(final ServiceDescriptor it) {
                Functions.Function0<IServiceResult> _function = new Functions.Function0<IServiceResult>(){

                    public IServiceResult apply() {
                        ServiceConflictResult _xtrycatchfinallyexpression = null;
                        try {
                            _xtrycatchfinallyexpression = (ServiceConflictResult)XtextServiceDispatcher.this.highlightingService.getResult(document);
                        }
                        catch (Throwable _t) {
                            if (_t instanceof Throwable) {
                                Throwable throwable = _t;
                                _xtrycatchfinallyexpression = XtextServiceDispatcher.this.handleError(it, throwable);
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                        return _xtrycatchfinallyexpression;
                    }
                };
                it.service = (Functions.Function0)_function;
                Set<String> _parameterKeys = request.getParameterKeys();
                boolean _contains = _parameterKeys.contains("fullText");
                it.hasTextInput = _contains;
            }
        };
        _xblockexpression = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    protected ServiceDescriptor getOccurrencesService(final IRequestData request, ISessionStore sessionStore) throws InvalidRequestException {
        ServiceDescriptor _xblockexpression = null;
        final XtextWebDocumentAccess document = this.getDocumentAccess(request, sessionStore);
        Optional _of = Optional.of((Object)0);
        final int offset = this.getInt(request, "caretOffset", (Optional<Integer>)_of);
        ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
        Procedures.Procedure1<ServiceDescriptor> _function = new Procedures.Procedure1<ServiceDescriptor>(){

            public void apply(final ServiceDescriptor it) {
                Functions.Function0<IServiceResult> _function = new Functions.Function0<IServiceResult>(){

                    public IServiceResult apply() {
                        IServiceResult _xtrycatchfinallyexpression = null;
                        try {
                            _xtrycatchfinallyexpression = XtextServiceDispatcher.this.occurrencesService.findOccurrences(document, offset);
                        }
                        catch (Throwable _t) {
                            if (_t instanceof Throwable) {
                                Throwable throwable = _t;
                                _xtrycatchfinallyexpression = XtextServiceDispatcher.this.handleError(it, throwable);
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                        return _xtrycatchfinallyexpression;
                    }
                };
                it.service = (Functions.Function0)_function;
                Set<String> _parameterKeys = request.getParameterKeys();
                boolean _contains = _parameterKeys.contains("fullText");
                it.hasTextInput = _contains;
            }
        };
        _xblockexpression = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    protected ServiceDescriptor getFormattingService(final IRequestData request, ISessionStore sessionStore) throws InvalidRequestException {
        ServiceDescriptor _xblockexpression = null;
        final XtextWebDocumentAccess document = this.getDocumentAccess(request, sessionStore);
        Optional _of = Optional.of((Object)0);
        int selectionStart = this.getInt(request, "selectionStart", (Optional<Integer>)_of);
        Optional _of_1 = Optional.of((Object)selectionStart);
        int selectionEnd = this.getInt(request, "selectionEnd", (Optional<Integer>)_of_1);
        TextRegion _xifexpression = null;
        _xifexpression = selectionEnd > selectionStart ? new TextRegion(selectionStart, selectionEnd - selectionStart) : null;
        final TextRegion selection = _xifexpression;
        ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
        Procedures.Procedure1<ServiceDescriptor> _function = new Procedures.Procedure1<ServiceDescriptor>(){

            public void apply(final ServiceDescriptor it) {
                Functions.Function0<IServiceResult> _function = new Functions.Function0<IServiceResult>(){

                    public IServiceResult apply() {
                        IServiceResult _xtrycatchfinallyexpression = null;
                        try {
                            _xtrycatchfinallyexpression = XtextServiceDispatcher.this.formattingService.format(document, (ITextRegion)selection);
                        }
                        catch (Throwable _t) {
                            if (_t instanceof Throwable) {
                                Throwable throwable = _t;
                                _xtrycatchfinallyexpression = XtextServiceDispatcher.this.handleError(it, throwable);
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                        return _xtrycatchfinallyexpression;
                    }
                };
                it.service = (Functions.Function0)_function;
                Set<String> _parameterKeys = request.getParameterKeys();
                boolean _contains = _parameterKeys.contains("fullText");
                it.hasTextInput = _contains;
                it.hasSideEffects = true;
            }
        };
        _xblockexpression = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    protected ServiceDescriptor getGeneratorService(final IRequestData request, ISessionStore sessionStore) throws InvalidRequestException {
        ServiceDescriptor _xblockexpression = null;
        final XtextWebDocumentAccess document = this.getDocumentAccess(request, sessionStore);
        ServiceDescriptor _serviceDescriptor = new ServiceDescriptor();
        Procedures.Procedure1<ServiceDescriptor> _function = new Procedures.Procedure1<ServiceDescriptor>(){

            public void apply(final ServiceDescriptor it) {
                Functions.Function0<IServiceResult> _function = new Functions.Function0<IServiceResult>(){

                    public IServiceResult apply() {
                        ServiceConflictResult _xtrycatchfinallyexpression = null;
                        try {
                            _xtrycatchfinallyexpression = (ServiceConflictResult)XtextServiceDispatcher.this.generatorService.getResult(document);
                        }
                        catch (Throwable _t) {
                            if (_t instanceof Throwable) {
                                Throwable throwable = _t;
                                _xtrycatchfinallyexpression = XtextServiceDispatcher.this.handleError(it, throwable);
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                        return _xtrycatchfinallyexpression;
                    }
                };
                it.service = (Functions.Function0)_function;
                Set<String> _parameterKeys = request.getParameterKeys();
                boolean _contains = _parameterKeys.contains("fullText");
                it.hasTextInput = _contains;
            }
        };
        _xblockexpression = (ServiceDescriptor)ObjectExtensions.operator_doubleArrow((Object)_serviceDescriptor, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    protected XtextWebDocumentAccess getDocumentAccess(IRequestData request, ISessionStore sessionStore) throws InvalidRequestException {
        XtextWebDocument document = null;
        boolean initializedFromFullText = false;
        Set<String> _parameterKeys = request.getParameterKeys();
        boolean _contains = _parameterKeys.contains("fullText");
        if (_contains) {
            XtextWebDocument _fullTextDocument;
            String _parameter = request.getParameter("fullText");
            document = _fullTextDocument = this.getFullTextDocument(_parameter, null, sessionStore);
            initializedFromFullText = true;
        } else {
            Set<String> _parameterKeys_1 = request.getParameterKeys();
            boolean _contains_1 = _parameterKeys_1.contains("resource");
            if (_contains_1) {
                String _parameter_1 = request.getParameter("resource");
                XtextWebDocument _resourceDocument = this.getResourceDocument(_parameter_1, sessionStore);
                document = _resourceDocument;
                if (document == null) {
                    throw new InvalidRequestException.ResourceNotFoundException("The requested resource was not found.");
                }
            } else {
                throw new InvalidRequestException.InvalidParametersException("At least one of the parameters 'resource' and 'fullText' must be specified.");
            }
        }
        String _parameter_2 = request.getParameter("requiredStateId");
        return this.documentAccessFactory.create(document, _parameter_2, initializedFromFullText);
    }

    protected XtextWebDocument getFullTextDocument(String fullText, String resourceId, ISessionStore sessionStore) {
        try {
            ResourceSet resourceSet = this.resourceSetProvider.get(resourceId);
            String _elvis = null;
            if (resourceId != null) {
                _elvis = resourceId;
            } else {
                String _plus;
                String _primaryFileExtension = this.fileExtensionProvider.getPrimaryFileExtension();
                _elvis = _plus = "fulltext." + _primaryFileExtension;
            }
            URI uri = URI.createURI((String)_elvis);
            Resource _createResource = this.resourceFactory.createResource(uri);
            XtextResource resource = (XtextResource)_createResource;
            EList _resources = resourceSet.getResources();
            _resources.add((Object)resource);
            StringInputStream _stringInputStream = new StringInputStream(fullText);
            resource.load((InputStream)_stringInputStream, null);
            XtextWebDocument document = (XtextWebDocument)this.documentProvider.get();
            document.setInput(resource, resourceId);
            if (resourceId != null) {
                Pair _mappedTo = Pair.of(XtextWebDocument.class, (Object)resourceId);
                sessionStore.put(_mappedTo, document);
            }
            return document;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected XtextWebDocument getResourceDocument(final String resourceId, ISessionStore sessionStore) {
        try {
            Pair _mappedTo = Pair.of(XtextWebDocument.class, (Object)resourceId);
            Functions.Function0<XtextWebDocument> _function = new Functions.Function0<XtextWebDocument>(){

                public XtextWebDocument apply() {
                    try {
                        return XtextServiceDispatcher.this.resourceHandler.get(resourceId);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            };
            return sessionStore.get(_mappedTo, _function);
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException ioe = (IOException)_t;
                return null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected int getInt(IRequestData request, String key, Optional<Integer> defaultValue) throws InvalidRequestException.InvalidParametersException {
        String stringValue = request.getParameter(key);
        if (stringValue == null) {
            boolean _not;
            boolean _isPresent = defaultValue.isPresent();
            boolean bl = _not = !_isPresent;
            if (_not) {
                throw new InvalidRequestException.InvalidParametersException("The parameter '" + key + "' must be specified.");
            }
            Integer _get = (Integer)defaultValue.get();
            return _get;
        }
        try {
            return Integer.parseInt(stringValue);
        }
        catch (Throwable _t) {
            if (_t instanceof NumberFormatException) {
                NumberFormatException nfe = (NumberFormatException)_t;
                throw new InvalidRequestException.InvalidParametersException("The parameter '" + key + "' must contain an integer value.");
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected boolean getBoolean(IRequestData request, String key, Optional<Boolean> defaultValue) throws InvalidRequestException.InvalidParametersException {
        String stringValue = request.getParameter(key);
        if (stringValue == null) {
            boolean _not;
            boolean _isPresent = defaultValue.isPresent();
            boolean bl = _not = !_isPresent;
            if (_not) {
                throw new InvalidRequestException.InvalidParametersException("The parameter '" + key + "' must be specified.");
            }
            Boolean _get = (Boolean)defaultValue.get();
            return _get;
        }
        String _lowerCase = stringValue.toLowerCase();
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)_lowerCase, (Object)"true")) {
            _matched = true;
            return true;
        }
        if (!_matched && Objects.equal((Object)_lowerCase, (Object)"false")) {
            _matched = true;
            return false;
        }
        throw new InvalidRequestException.InvalidParametersException("The parameter '" + key + "' must contain a Boolean value.");
    }

    protected ServiceConflictResult _handleError(ServiceDescriptor service, Throwable throwable) {
        try {
            boolean _isOperationCanceledException = this.operationCanceledManager.isOperationCanceledException(throwable);
            if (_isOperationCanceledException) {
                LOG.trace((Object)("Service canceled (" + service.type + ")"));
                return new ServiceConflictResult("canceled");
            }
            throw throwable;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected ServiceConflictResult _handleError(ServiceDescriptor service, InvalidRequestException.InvalidDocumentStateException exception) {
        LOG.trace((Object)("Invalid document state (" + service.type + ")"));
        return new ServiceConflictResult("invalidStateId");
    }

    protected ServiceConflictResult handleError(ServiceDescriptor service, Throwable exception) {
        if (exception instanceof InvalidRequestException.InvalidDocumentStateException) {
            return this._handleError(service, (InvalidRequestException.InvalidDocumentStateException)exception);
        }
        if (exception != null) {
            return this._handleError(service, exception);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(service, exception).toString());
    }

    @Accessors
    @ToString
    public static class ServiceDescriptor {
        private String type;
        private Functions.Function0<? extends IServiceResult> service;
        private boolean hasSideEffects;
        private boolean hasTextInput;
        private boolean hasConflict;

        @Pure
        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        @Pure
        public Functions.Function0<? extends IServiceResult> getService() {
            return this.service;
        }

        public void setService(Functions.Function0<? extends IServiceResult> service) {
            this.service = service;
        }

        @Pure
        public boolean isHasSideEffects() {
            return this.hasSideEffects;
        }

        public void setHasSideEffects(boolean hasSideEffects) {
            this.hasSideEffects = hasSideEffects;
        }

        @Pure
        public boolean isHasTextInput() {
            return this.hasTextInput;
        }

        public void setHasTextInput(boolean hasTextInput) {
            this.hasTextInput = hasTextInput;
        }

        @Pure
        public boolean isHasConflict() {
            return this.hasConflict;
        }

        public void setHasConflict(boolean hasConflict) {
            this.hasConflict = hasConflict;
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("type", (Object)this.type);
            b.add("service", this.service);
            b.add("hasSideEffects", (Object)this.hasSideEffects);
            b.add("hasTextInput", (Object)this.hasTextInput);
            b.add("hasConflict", (Object)this.hasConflict);
            return b.toString();
        }
    }
}

