/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.contentassist;

import java.util.ArrayList;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.web.server.IServiceResult;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString(skipNulls=true)
public class ContentAssistResult
implements IServiceResult {
    public static final String KEYWORD = "keyword";
    public static final String PARSER_RULE = "parser-rule";
    public static final String FEATURE = "feature";
    public static final String TERMINAL = "terminal";
    public static final String CROSSREF = "cross-ref";
    private String stateId;
    private final ArrayList<Entry> entries = new ArrayList();

    @Pure
    public String getStateId() {
        return this.stateId;
    }

    public void setStateId(String stateId) {
        this.stateId = stateId;
    }

    @Pure
    public ArrayList<Entry> getEntries() {
        return this.entries;
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.skipNulls();
        b.add("stateId", (Object)this.stateId);
        b.add("entries", this.entries);
        return b.toString();
    }

    @Data
    public static class EditPosition {
        private final int offset;
        private final int length;

        public EditPosition(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.offset;
            result = 31 * result + this.length;
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EditPosition other = (EditPosition)obj;
            if (other.offset != this.offset) {
                return false;
            }
            return other.length == this.length;
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("offset", (Object)this.offset);
            b.add("length", (Object)this.length);
            return b.toString();
        }

        @Pure
        public int getOffset() {
            return this.offset;
        }

        @Pure
        public int getLength() {
            return this.length;
        }
    }

    @Data
    public static class TextReplacement {
        private final String text;
        private final int offset;
        private final int length;

        public TextReplacement(String text, int offset, int length) {
            this.text = text;
            this.offset = offset;
            this.length = length;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
            result = 31 * result + this.offset;
            result = 31 * result + this.length;
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TextReplacement other = (TextReplacement)obj;
            if (this.text == null ? other.text != null : !this.text.equals(other.text)) {
                return false;
            }
            if (other.offset != this.offset) {
                return false;
            }
            return other.length == this.length;
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("text", (Object)this.text);
            b.add("offset", (Object)this.offset);
            b.add("length", (Object)this.length);
            return b.toString();
        }

        @Pure
        public String getText() {
            return this.text;
        }

        @Pure
        public int getOffset() {
            return this.offset;
        }

        @Pure
        public int getLength() {
            return this.length;
        }
    }

    @Accessors
    @FinalFieldsConstructor
    @ToString(skipNulls=true)
    public static class Entry {
        private final String type;
        private final String prefix;
        private String proposal;
        private String name;
        private String description;
        private String style;
        private int escapePosition;
        private final ArrayList<TextReplacement> textReplacements = new ArrayList();
        private final ArrayList<EditPosition> editPositions = new ArrayList();

        public Entry(String type, String prefix) {
            this.type = type;
            this.prefix = prefix;
        }

        @Pure
        public String getType() {
            return this.type;
        }

        @Pure
        public String getPrefix() {
            return this.prefix;
        }

        @Pure
        public String getProposal() {
            return this.proposal;
        }

        public void setProposal(String proposal) {
            this.proposal = proposal;
        }

        @Pure
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Pure
        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @Pure
        public String getStyle() {
            return this.style;
        }

        public void setStyle(String style) {
            this.style = style;
        }

        @Pure
        public int getEscapePosition() {
            return this.escapePosition;
        }

        public void setEscapePosition(int escapePosition) {
            this.escapePosition = escapePosition;
        }

        @Pure
        public ArrayList<TextReplacement> getTextReplacements() {
            return this.textReplacements;
        }

        @Pure
        public ArrayList<EditPosition> getEditPositions() {
            return this.editPositions;
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.skipNulls();
            b.add("type", (Object)this.type);
            b.add("prefix", (Object)this.prefix);
            b.add("proposal", (Object)this.proposal);
            b.add("name", (Object)this.name);
            b.add("description", (Object)this.description);
            b.add("style", (Object)this.style);
            b.add("escapePosition", (Object)this.escapePosition);
            b.add("textReplacements", this.textReplacements);
            b.add("editPositions", this.editPositions);
            return b.toString();
        }
    }
}

