/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.hover;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.labels.AlternativeImageDescription;
import org.eclipse.xtext.ide.labels.DecoratedImageDescription;
import org.eclipse.xtext.ide.labels.IImageDescription;
import org.eclipse.xtext.ide.labels.IImageDescriptionProvider;
import org.eclipse.xtext.ide.labels.INameLabelProvider;
import org.eclipse.xtext.ide.labels.SimpleImageDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Wrapper;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.contentassist.ContentAssistService;
import org.eclipse.xtext.web.server.hover.HoverResult;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocumentAccess;
import org.eclipse.xtext.web.server.util.ElementAtOffsetUtil;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class HoverService {
    @Inject
    private ElementAtOffsetUtil elementAtOffsetUtil;
    @Inject
    private IEObjectDocumentationProvider eObjectDocumentationProvider;
    @Inject
    private IImageDescriptionProvider imageDescriptionProvider;
    @Inject
    private INameLabelProvider nameLabelProvider;
    @Inject
    private OperationCanceledManager operationCanceledManager;
    @Inject
    private ContentAssistService contentAssistService;

    public HoverResult getHover(XtextWebDocumentAccess document, final int offset) throws InvalidRequestException {
        return document.readOnly(new CancelableUnitOfWork<HoverResult, IXtextWebDocument>(){

            public HoverResult exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                EObject element = HoverService.this.elementAtOffsetUtil.getElementAt(it.getResource(), offset);
                return HoverService.this.createHover(element, it.getStateId(), cancelIndicator);
            }
        });
    }

    public HoverResult getHover(XtextWebDocumentAccess document, final String proposal, final ITextRegion selection, final int offset) throws InvalidRequestException {
        return document.readOnly(new CancelableUnitOfWork<HoverResult, IXtextWebDocument>(){

            public HoverResult exec(IXtextWebDocument it, final CancelIndicator cancelIndicator) throws Exception {
                ContentAssistContext[] contexts = HoverService.this.contentAssistService.getContexts(it, selection, offset);
                final Wrapper proposedElement = new Wrapper();
                List<ContentAssistContext> contextsList = Arrays.asList(contexts);
                HoverService.this.contentAssistService.getProposalProvider().createProposals(contextsList, new IIdeContentProposalAcceptor(){

                    public void accept(ContentAssistEntry entry, int priority) {
                        HoverService.this.operationCanceledManager.checkCanceled(cancelIndicator);
                        if (entry != null && entry.getSource() != null && Objects.equals(entry.getProposal(), proposal)) {
                            proposedElement.set(entry.getSource());
                        }
                    }

                    public boolean canAcceptMoreProposals() {
                        return proposedElement.get() == null;
                    }
                });
                return HoverService.this.createHover(proposedElement.get(), it.getStateId(), cancelIndicator);
            }
        });
    }

    protected HoverResult createHover(Object element, String stateId, CancelIndicator cancelIndicator) {
        String nameLabel = null;
        if (element != null && (nameLabel = this.nameLabelProvider.getNameLabel(element)) != null) {
            nameLabel = this.surroundWithDiv(nameLabel, "element-name");
        }
        if (nameLabel != null) {
            String documentation;
            this.operationCanceledManager.checkCanceled(cancelIndicator);
            String titleHtml = this.surroundWithDiv(this.addIconDivs(this.imageDescriptionProvider.getImageDescription(element), nameLabel), "xtext-hover");
            this.operationCanceledManager.checkCanceled(cancelIndicator);
            EObject eobject = null;
            if (element instanceof EObject) {
                eobject = (EObject)element;
            } else if (element instanceof IEObjectDescription) {
                eobject = ((IEObjectDescription)element).getEObjectOrProxy();
            }
            String bodyHtml = "";
            if (eobject != null && !eobject.eIsProxy() && (documentation = this.eObjectDocumentationProvider.getDocumentation(eobject)) != null) {
                bodyHtml = this.surroundWithDiv(documentation, "xtext-hover");
            }
            return new HoverResult(stateId, titleHtml, bodyHtml);
        }
        return new HoverResult(stateId);
    }

    protected String addIconDivs(IImageDescription it, String nameHtml) {
        if (it instanceof SimpleImageDescription) {
            return this.surroundWithDiv(nameHtml, ((SimpleImageDescription)it).getImageID() + "-icon");
        }
        if (it instanceof AlternativeImageDescription) {
            List strings = Lists.transform((List)((AlternativeImageDescription)it).getImageIDs(), s -> s + "-icon");
            return this.surroundWithDiv(nameHtml, strings.toArray(new String[strings.size()]));
        }
        if (it instanceof DecoratedImageDescription) {
            return (String)IterableExtensions.fold((Iterable)Iterables.concat((Iterable)((DecoratedImageDescription)it).getDecorators(), (Iterable)Lists.newArrayList((Object[])new IImageDescription[]{((DecoratedImageDescription)it).getBaseImage()})), (Object)nameHtml, ($0, $1) -> this.addIconDivs((IImageDescription)$1, (String)$0));
        }
        return null;
    }

    protected String surroundWithDiv(String html, String ... divClasses) {
        StringConcatenation builder = new StringConcatenation();
        builder.append("<div");
        if (divClasses.length > 0) {
            builder.append(" class=\"");
            builder.append(Joiner.on((String)" ").join((Object[])divClasses));
            builder.append("\"");
        }
        builder.append(">");
        builder.newLineIfNotEmpty();
        builder.append("\t");
        builder.append(html, "\t");
        builder.newLineIfNotEmpty();
        builder.append("</div>");
        builder.newLine();
        return builder.toString();
    }
}

