/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.formatting;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;
import org.eclipse.xtext.formatting.INodeModelFormatter;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IFormatter2;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.TextRegionAccessBuilder;
import org.eclipse.xtext.formatting2.regionaccess.internal.TextSegment;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.util.Wrapper;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.formatting.FormattingResult;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocumentAccess;

@Singleton
public class FormattingService {
    @Inject(optional=true)
    private INodeModelFormatter formatter1;
    @Inject(optional=true)
    private Provider<IFormatter2> formatter2Provider;
    @Inject
    private Provider<FormatterRequest> formatterRequestProvider;
    @Inject
    private TextRegionAccessBuilder regionBuilder;

    public FormattingResult format(XtextWebDocumentAccess document, final ITextRegion selection, final ITypedPreferenceValues preferences) throws InvalidRequestException {
        final Wrapper textWrapper = new Wrapper();
        final Wrapper regionWrapper = new Wrapper();
        CancelableUnitOfWork<FormattingResult, IXtextWebDocument> work = new CancelableUnitOfWork<FormattingResult, IXtextWebDocument>(){

            public FormattingResult exec(IXtextWebDocument doc, CancelIndicator cancelIndicator) throws Exception {
                if (FormattingService.this.formatter2Provider != null) {
                    textWrapper.set((Object)FormattingService.this.format2(doc.getResource(), selection, preferences));
                    if (selection != null) {
                        regionWrapper.set((Object)new TextRegion(selection.getOffset(), selection.getLength()));
                    }
                } else if (FormattingService.this.formatter1 != null) {
                    INodeModelFormatter.IFormattedRegion formattedRegion = FormattingService.this.format1(doc.getResource(), selection);
                    textWrapper.set((Object)formattedRegion.getFormattedText());
                    regionWrapper.set((Object)new TextRegion(formattedRegion.getOffset(), formattedRegion.getLength()));
                } else {
                    throw new IllegalStateException("No formatter is available in the language configuration.");
                }
                doc.setDirty(true);
                doc.createNewStateId();
                return new FormattingResult(doc.getStateId(), (String)textWrapper.get(), (TextRegion)regionWrapper.get());
            }
        };
        CancelableUnitOfWork<Object, IXtextWebDocument> asynchronousWork = new CancelableUnitOfWork<Object, IXtextWebDocument>(){

            public Object exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                if (regionWrapper.isEmpty()) {
                    it.setText((String)textWrapper.get());
                } else {
                    it.updateText((String)textWrapper.get(), ((TextRegion)regionWrapper.get()).getOffset(), ((TextRegion)regionWrapper.get()).getLength());
                }
                return null;
            }
        };
        return document.modify(work, asynchronousWork);
    }

    protected INodeModelFormatter.IFormattedRegion format1(XtextResource resource, ITextRegion selection) {
        IParseResult parseResult = resource.getParseResult();
        if (parseResult == null) {
            return null;
        }
        ICompositeNode rootNode = parseResult.getRootNode();
        ITextRegion region = selection;
        if (region == null) {
            region = new TextRegion(rootNode.getOffset(), rootNode.getLength());
        }
        return this.formatter1.format(rootNode, region.getOffset(), region.getLength());
    }

    protected String format2(XtextResource resource, ITextRegion selection, ITypedPreferenceValues preferences) {
        FormatterRequest request = (FormatterRequest)this.formatterRequestProvider.get();
        request.setAllowIdentityEdits(false);
        request.setFormatUndefinedHiddenRegionsOnly(false);
        if (selection != null) {
            request.setRegions((Collection)Lists.newArrayList((Object[])new ITextRegion[]{selection}));
        }
        if (preferences != null) {
            request.setPreferences(preferences);
        }
        ITextRegionAccess regionAccess = this.regionBuilder.forNodeModel(resource).create();
        request.setTextRegionAccess(regionAccess);
        IFormatter2 formatter2 = (IFormatter2)this.formatter2Provider.get();
        List replacements = formatter2.format(request);
        if (selection != null) {
            return regionAccess.getRewriter().renderToString((ITextSegment)new TextSegment(regionAccess, selection.getOffset(), selection.getLength()), (Iterable)replacements);
        }
        return regionAccess.getRewriter().renderToString((Iterable)replacements);
    }
}

