/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.persistence;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.web.server.IServiceContext;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.model.DocumentStateResult;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocumentAccess;
import org.eclipse.xtext.web.server.persistence.IServerResourceHandler;
import org.eclipse.xtext.web.server.persistence.ResourceContentResult;
import org.eclipse.xtext.xbase.lib.Pair;

@Singleton
public class ResourcePersistenceService {
    @Inject
    private XtextWebDocumentAccess.Factory documentAccessFactory;

    public ResourceContentResult load(String resourceId, IServerResourceHandler resourceHandler, IServiceContext serviceContext) throws InvalidRequestException {
        XtextWebDocument document = (XtextWebDocument)serviceContext.getSession().get(Pair.of(XtextWebDocument.class, (Object)resourceId), () -> {
            try {
                return resourceHandler.get(resourceId, serviceContext);
            }
            catch (IOException ioe) {
                throw new InvalidRequestException.ResourceNotFoundException("The requested resource was not found.", ioe);
            }
        });
        return this.documentAccessFactory.create(document, false).readOnly(new CancelableUnitOfWork<ResourceContentResult, IXtextWebDocument>(){

            public ResourceContentResult exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                return new ResourceContentResult(it.getText(), it.getStateId(), it.isDirty());
            }
        });
    }

    public ResourceContentResult revert(String resourceId, IServerResourceHandler resourceHandler, IServiceContext serviceContext) throws InvalidRequestException {
        try {
            XtextWebDocument document = resourceHandler.get(resourceId, serviceContext);
            serviceContext.getSession().put(Pair.of(XtextWebDocument.class, (Object)resourceId), document);
            return new ResourceContentResult(document.getText(), document.getStateId(), false);
        }
        catch (IOException ioe) {
            throw new InvalidRequestException.ResourceNotFoundException("The requested resource was not found.", ioe);
        }
    }

    public DocumentStateResult save(XtextWebDocumentAccess document, final IServerResourceHandler resourceHandler, final IServiceContext serviceContext) throws InvalidRequestException {
        return document.readOnly(new CancelableUnitOfWork<DocumentStateResult, IXtextWebDocument>(){

            public DocumentStateResult exec(IXtextWebDocument it, CancelIndicator cancelIndicator) throws Exception {
                try {
                    resourceHandler.put(it, serviceContext);
                    it.setDirty(false);
                }
                catch (IOException ioe) {
                    throw new InvalidRequestException.ResourceNotFoundException(ioe.getMessage(), ioe);
                }
                return new DocumentStateResult(it.getStateId());
            }
        });
    }
}

