/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.validation;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.web.server.model.AbstractCachedService;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.validation.ValidationResult;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class ValidationService
extends AbstractCachedService<ValidationResult> {
    @Inject
    private IResourceValidator resourceValidator;

    @Override
    public ValidationResult compute(IXtextWebDocument it, CancelIndicator cancelIndicator) {
        List issues = this.resourceValidator.validate((Resource)it.getResource(), CheckMode.ALL, cancelIndicator);
        ValidationResult result = new ValidationResult();
        IterableExtensions.filter((Iterable)issues, i -> !Severity.IGNORE.equals((Object)i.getSeverity())).forEach(issue -> result.getIssues().add(new ValidationResult.Issue(issue.getMessage(), this.translate(issue.getSeverity()), issue.getLineNumber(), issue.getColumn(), issue.getOffset(), issue.getLength())));
        return result;
    }

    protected String translate(Severity severity) {
        if (severity != null) {
            switch (severity) {
                case WARNING: {
                    return "warning";
                }
                case ERROR: {
                    return "error";
                }
                case INFO: {
                    return "info";
                }
            }
            return "ignore";
        }
        return "ignore";
    }
}

