/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.web.server.IServiceResult;
import org.eclipse.xtext.web.server.model.AbstractCachedService;
import org.eclipse.xtext.web.server.model.DocumentSynchronizer;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class XtextWebDocument
implements IXtextWebDocument {
    private static final Logger LOG = Logger.getLogger(XtextWebDocument.class);
    private final String resourceId;
    private final DocumentSynchronizer synchronizer;
    private XtextResource resource;
    private String text;
    private boolean dirty;
    private final Map<Class<?>, IServiceResult> cachedServiceResults = new HashMap();

    public XtextWebDocument(String resourceId, DocumentSynchronizer synchronizer) {
        this.resourceId = resourceId;
        this.synchronizer = synchronizer;
    }

    public void clearCachedServiceResults() {
        this.cachedServiceResults.clear();
    }

    public <T extends IServiceResult> T getCachedServiceResult(AbstractCachedService<T> service, CancelIndicator cancelIndicator, boolean logCacheMiss) {
        IServiceResult ca = this.cachedServiceResults.get(service.getClass());
        if (ca != null) {
            IServiceResult result = ca;
            return (T)result;
        }
        if (logCacheMiss) {
            LOG.trace((Object)("Cache miss for " + service.getClass().getSimpleName()));
        }
        T result = service.compute(this, cancelIndicator);
        this.cachedServiceResults.put(service.getClass(), (IServiceResult)result);
        return result;
    }

    public String toString() {
        if (this.resourceId != null) {
            return this.getClass().getSimpleName() + "(" + this.resourceId + ")";
        }
        return super.toString();
    }

    public String setInput(XtextResource resource) {
        this.clearCachedServiceResults();
        this.resource = resource;
        return this.refreshText();
    }

    protected String refreshText() {
        String text;
        ICompositeNode rootNode;
        String newText = "";
        IParseResult parseResult = this.resource.getParseResult();
        if (parseResult != null && (rootNode = parseResult.getRootNode()) != null && (text = rootNode.getText()) != null) {
            newText = text;
        }
        this.text = newText;
        return this.text;
    }

    @Override
    public String getStateId() {
        return Long.toString(this.resource.getModificationStamp(), 16);
    }

    @Override
    public void setText(String text) {
        try {
            this.clearCachedServiceResults();
            this.resource.reparse(text);
            this.refreshText();
        }
        catch (IOException e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }

    @Override
    public void updateText(String text, int offset, int replaceLength) {
        this.clearCachedServiceResults();
        this.resource.update(offset, replaceLength, text);
        this.refreshText();
    }

    @Override
    public void createNewStateId() {
        long newStateId = this.resource.getModificationStamp() + 1L;
        this.resource.setModificationStamp(newStateId);
    }

    @Override
    public String getResourceId() {
        return this.resourceId;
    }

    DocumentSynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    @Override
    public XtextResource getResource() {
        return this.resource;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }
}

