/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.model;

import com.google.inject.Singleton;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.model.DocumentStateResult;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocumentAccess;

@Singleton
public class UpdateDocumentService {
    public DocumentStateResult updateFullText(XtextWebDocumentAccess document, final String fullText) throws InvalidRequestException {
        return document.modify(new CancelableUnitOfWork<DocumentStateResult, IXtextWebDocument>(){

            public DocumentStateResult exec(IXtextWebDocument doc, CancelIndicator cancelIndicator) throws Exception {
                doc.setDirty(true);
                doc.createNewStateId();
                return new DocumentStateResult(doc.getStateId());
            }
        }, new CancelableUnitOfWork<Object, IXtextWebDocument>(){

            public Object exec(IXtextWebDocument doc, CancelIndicator cancelIndicator) throws Exception {
                doc.setText(fullText);
                return null;
            }
        });
    }

    public DocumentStateResult updateDeltaText(XtextWebDocumentAccess document, final String deltaText, final int offset, final int replaceLength) throws InvalidRequestException {
        return document.modify(new CancelableUnitOfWork<DocumentStateResult, IXtextWebDocument>(){

            public DocumentStateResult exec(IXtextWebDocument doc, CancelIndicator cancelIndicator) throws Exception {
                doc.setDirty(true);
                doc.createNewStateId();
                return new DocumentStateResult(doc.getStateId());
            }
        }, new CancelableUnitOfWork<Object, IXtextWebDocument>(){

            public Object exec(IXtextWebDocument doc, CancelIndicator cancelIndicator) throws Exception {
                if (offset <= doc.getText().length()) {
                    doc.updateText(deltaText, offset, replaceLength);
                }
                return null;
            }
        });
    }

    public DocumentStateResult getStateId(XtextWebDocumentAccess document) throws InvalidRequestException {
        return document.modify(new CancelableUnitOfWork<DocumentStateResult, IXtextWebDocument>(){

            public DocumentStateResult exec(IXtextWebDocument doc, CancelIndicator cancelIndicator) throws Exception {
                return new DocumentStateResult(doc.getStateId());
            }
        });
    }
}

