/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.formatting2.FormatterPreferenceKeys;
import org.eclipse.xtext.formatting2.FormatterPreferences;
import org.eclipse.xtext.preferences.IPreferenceValues;
import org.eclipse.xtext.preferences.IPreferenceValuesProvider;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.preferences.MapBasedPreferenceValues;
import org.eclipse.xtext.preferences.TypedPreferenceKey;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.web.server.IServiceContext;
import org.eclipse.xtext.web.server.IServiceResult;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.ServiceConflictResult;
import org.eclipse.xtext.web.server.contentassist.ContentAssistService;
import org.eclipse.xtext.web.server.formatting.FormattingService;
import org.eclipse.xtext.web.server.generator.GeneratorService;
import org.eclipse.xtext.web.server.hover.HoverService;
import org.eclipse.xtext.web.server.model.IWebDocumentProvider;
import org.eclipse.xtext.web.server.model.IWebResourceSetProvider;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.PrecomputedServiceRegistry;
import org.eclipse.xtext.web.server.model.UpdateDocumentService;
import org.eclipse.xtext.web.server.model.XtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocumentAccess;
import org.eclipse.xtext.web.server.occurrences.OccurrencesService;
import org.eclipse.xtext.web.server.persistence.IServerResourceHandler;
import org.eclipse.xtext.web.server.persistence.ResourcePersistenceService;
import org.eclipse.xtext.web.server.syntaxcoloring.HighlightingService;
import org.eclipse.xtext.web.server.validation.ValidationService;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Singleton
public class XtextServiceDispatcher {
    private static final Logger LOG = Logger.getLogger(XtextServiceDispatcher.class);
    @Inject(optional=true)
    @FormatterPreferences
    private IPreferenceValuesProvider formatterPreferencesProvider;
    @Inject
    private ResourcePersistenceService resourcePersistenceService;
    @Inject
    private UpdateDocumentService updateDocumentService;
    @Inject
    private ContentAssistService contentAssistService;
    @Inject
    private ValidationService validationService;
    @Inject
    private HighlightingService highlightingService;
    @Inject
    private HoverService hoverService;
    @Inject
    private OccurrencesService occurrencesService;
    @Inject
    private FormattingService formattingService;
    @Inject
    private GeneratorService generatorService;
    @Inject
    private IServerResourceHandler resourceHandler;
    @Inject
    private IWebResourceSetProvider resourceSetProvider;
    @Inject
    private IWebDocumentProvider documentProvider;
    @Inject
    private FileExtensionProvider fileExtensionProvider;
    @Inject
    private IResourceFactory resourceFactory;
    @Inject
    private OperationCanceledManager operationCanceledManager;
    @Inject
    private XtextWebDocumentAccess.Factory documentAccessFactory;
    private final Random randomGenerator = new Random();

    @Inject
    protected void registerPreComputedServices(PrecomputedServiceRegistry registry) {
        registry.addPrecomputedService(this.highlightingService);
        registry.addPrecomputedService(this.validationService);
    }

    public ServiceDescriptor getService(IServiceContext context) throws InvalidRequestException {
        String serviceType = context.getParameter("serviceType");
        if (serviceType == null) {
            throw new InvalidRequestException.InvalidParametersException("The parameter 'serviceType' is required.");
        }
        if (LOG.isTraceEnabled()) {
            List sorted = IterableExtensions.sort(context.getParameterKeys());
            String stringParams = IterableExtensions.join((Iterable)sorted, (CharSequence)": ", (CharSequence)", ", (CharSequence)"", key -> {
                String value = context.getParameter((String)key);
                if (value.length() > 18) {
                    return key + "='" + value.substring(0, 16) + "...'";
                }
                if (value.matches(".*\\s+.*")) {
                    return key + "='" + value + "'";
                }
                return key + "=" + value;
            }).replaceAll("(\\n|\\f|\\r)+", " ");
            LOG.trace((Object)("xtext-service/" + serviceType + stringParams));
        }
        try {
            ServiceDescriptor serviceDescriptor = this.createServiceDescriptor(serviceType, context);
            serviceDescriptor.context = context;
            return serviceDescriptor;
        }
        catch (InvalidRequestException.InvalidDocumentStateException e) {
            LOG.trace((Object)("Invalid document state (" + serviceType + ")"));
            ServiceDescriptor serviceDescriptor = new ServiceDescriptor();
            serviceDescriptor.context = context;
            serviceDescriptor.service = () -> new ServiceConflictResult("invalidStateId");
            serviceDescriptor.hasConflict = true;
            return serviceDescriptor;
        }
    }

    protected ServiceDescriptor createServiceDescriptor(String serviceType, IServiceContext context) {
        if (serviceType != null) {
            switch (serviceType) {
                case "load": {
                    return this.getLoadResourceService(false, context);
                }
                case "revert": {
                    return this.getLoadResourceService(true, context);
                }
                case "save": {
                    return this.getSaveResourceService(context);
                }
                case "update": {
                    return this.getUpdateDocumentService(context);
                }
                case "assist": {
                    return this.getContentAssistService(context);
                }
                case "validate": {
                    return this.getValidationService(context);
                }
                case "hover": {
                    return this.getHoverService(context);
                }
                case "highlight": {
                    return this.getHighlightingService(context);
                }
                case "occurrences": {
                    return this.getOccurrencesService(context);
                }
                case "format": {
                    return this.getFormattingService(context);
                }
                case "generate": {
                    return this.getGeneratorService(context);
                }
            }
            throw new InvalidRequestException.InvalidParametersException("The service type '" + serviceType + "' is not supported.");
        }
        throw new InvalidRequestException.InvalidParametersException("The service type '" + serviceType + "' is not supported.");
    }

    protected ServiceDescriptor getLoadResourceService(boolean revert, IServiceContext context) throws InvalidRequestException {
        String resourceId = this.getResourceID(context);
        if (resourceId == null) {
            throw new InvalidRequestException.InvalidParametersException("The parameter 'resource' is required.");
        }
        ServiceDescriptor serviceDescriptor = new ServiceDescriptor();
        serviceDescriptor.service = () -> {
            try {
                if (revert) {
                    return this.resourcePersistenceService.revert(resourceId, this.resourceHandler, context);
                }
                return this.resourcePersistenceService.load(resourceId, this.resourceHandler, context);
            }
            catch (Throwable throwable) {
                return this.handleError(serviceDescriptor, throwable);
            }
        };
        serviceDescriptor.hasSideEffects = revert;
        return serviceDescriptor;
    }

    protected ServiceDescriptor getSaveResourceService(IServiceContext context) throws InvalidRequestException {
        XtextWebDocumentAccess document = this.getDocumentAccess(context);
        ServiceDescriptor serviceDescriptor = new ServiceDescriptor();
        serviceDescriptor.service = () -> {
            try {
                return this.resourcePersistenceService.save(document, this.resourceHandler, context);
            }
            catch (Throwable throwable) {
                return this.handleError(serviceDescriptor, throwable);
            }
        };
        serviceDescriptor.hasSideEffects = true;
        return serviceDescriptor;
    }

    protected ServiceDescriptor getUpdateDocumentService(IServiceContext context) throws InvalidRequestException {
        boolean initializedFromFullText;
        String resourceId = this.getResourceID(context);
        if (resourceId == null) {
            throw new InvalidRequestException.InvalidParametersException("The parameter 'resource' is required.");
        }
        String fullText = context.getParameter("fullText");
        XtextWebDocument document = this.getResourceDocument(resourceId, context);
        boolean bl = initializedFromFullText = document == null;
        if (initializedFromFullText) {
            if (fullText == null) {
                throw new InvalidRequestException.ResourceNotFoundException("The requested resource was not found.");
            }
            document = this.getFullTextDocument(fullText, resourceId, context);
        }
        XtextWebDocumentAccess documentAccess = this.documentAccessFactory.create(document, context.getParameter("requiredStateId"), false);
        ServiceDescriptor serviceDescriptor = new ServiceDescriptor();
        serviceDescriptor.hasSideEffects = true;
        if (fullText == null) {
            String deltaText = context.getParameter("deltaText");
            if (deltaText == null) {
                throw new InvalidRequestException.InvalidParametersException("One of the parameters 'deltaText' and 'fullText' must be specified.");
            }
            int deltaOffset = this.getInt(context, "deltaOffset", (Optional<Integer>)Optional.absent());
            if (deltaOffset < 0) {
                throw new InvalidRequestException.InvalidParametersException("The parameter 'deltaOffset' must not be negative.");
            }
            int deltaReplaceLength = this.getInt(context, "deltaReplaceLength", (Optional<Integer>)Optional.absent());
            if (deltaReplaceLength < 0) {
                throw new InvalidRequestException.InvalidParametersException("The parameter 'deltaReplaceLength' must not be negative.");
            }
            serviceDescriptor.service = () -> {
                try {
                    return this.updateDocumentService.updateDeltaText(documentAccess, deltaText, deltaOffset, deltaReplaceLength);
                }
                catch (Throwable throwable) {
                    return this.handleError(serviceDescriptor, throwable);
                }
            };
        } else {
            if (context.getParameterKeys().contains("deltaText")) {
                throw new InvalidRequestException.InvalidParametersException("The parameters 'deltaText' and 'fullText' cannot be set in the same request.");
            }
            serviceDescriptor.service = () -> {
                try {
                    if (initializedFromFullText) {
                        return this.updateDocumentService.getStateId(documentAccess);
                    }
                    return this.updateDocumentService.updateFullText(documentAccess, fullText);
                }
                catch (Throwable throwable) {
                    return this.handleError(serviceDescriptor, throwable);
                }
            };
        }
        return serviceDescriptor;
    }

    protected ServiceDescriptor getContentAssistService(IServiceContext context) throws InvalidRequestException {
        int offset = this.getInt(context, "caretOffset", (Optional<Integer>)Optional.of((Object)0));
        if (offset < 0) {
            throw new InvalidRequestException.InvalidParametersException("The parameter 'offset' must not be negative.");
        }
        XtextWebDocumentAccess document = this.getDocumentAccess(context);
        int proposalsLimit = this.getInt(context, "proposalsLimit", (Optional<Integer>)Optional.of((Object)1000));
        if (proposalsLimit <= 0) {
            throw new InvalidRequestException.InvalidParametersException("The parameter 'proposalsLimit' must contain a positive integer.");
        }
        int selectionStart = this.getInt(context, "selectionStart", (Optional<Integer>)Optional.of((Object)offset));
        int selectionEnd = this.getInt(context, "selectionEnd", (Optional<Integer>)Optional.of((Object)selectionStart));
        TextRegion selection = new TextRegion(selectionStart, Math.max(selectionEnd - selectionStart, 0));
        String deltaText = context.getParameter("deltaText");
        if (deltaText == null) {
            ServiceDescriptor serviceDescriptor = new ServiceDescriptor();
            serviceDescriptor.service = () -> {
                try {
                    return this.contentAssistService.createProposals(document, (ITextRegion)selection, offset, proposalsLimit);
                }
                catch (Throwable throwable) {
                    return this.handleError(serviceDescriptor, throwable);
                }
            };
            return serviceDescriptor;
        }
        if (context.getParameterKeys().contains("fullText")) {
            throw new InvalidRequestException.InvalidParametersException("The parameters 'deltaText' and 'fullText' cannot be set in the same request.");
        }
        int deltaOffset = this.getInt(context, "deltaOffset", (Optional<Integer>)Optional.absent());
        if (deltaOffset < 0) {
            throw new InvalidRequestException.InvalidParametersException("The parameter 'deltaOffset' must not be negative.");
        }
        int deltaReplaceLength = this.getInt(context, "deltaReplaceLength", (Optional<Integer>)Optional.absent());
        if (deltaReplaceLength < 0) {
            throw new InvalidRequestException.InvalidParametersException("The parameter 'deltaReplaceLength' must not be negative.");
        }
        ServiceDescriptor serviceDescriptor = new ServiceDescriptor();
        serviceDescriptor.service = () -> {
            try {
                return this.contentAssistService.createProposalsWithUpdate(document, deltaText, deltaOffset, deltaReplaceLength, (ITextRegion)selection, offset, proposalsLimit);
            }
            catch (Throwable throwable) {
                return this.handleError(serviceDescriptor, throwable);
            }
        };
        serviceDescriptor.hasSideEffects = true;
        return serviceDescriptor;
    }

    protected ServiceDescriptor getValidationService(IServiceContext context) throws InvalidRequestException {
        XtextWebDocumentAccess document = this.getDocumentAccess(context);
        ServiceDescriptor serviceDescriptor = new ServiceDescriptor();
        serviceDescriptor.service = () -> {
            try {
                return this.validationService.getResult(document);
            }
            catch (Throwable throwable) {
                return this.handleError(serviceDescriptor, throwable);
            }
        };
        return serviceDescriptor;
    }

    protected ServiceDescriptor getHoverService(IServiceContext context) throws InvalidRequestException {
        XtextWebDocumentAccess document = this.getDocumentAccess(context);
        int offset = this.getInt(context, "caretOffset", (Optional<Integer>)Optional.of((Object)0));
        if (offset < 0) {
            throw new InvalidRequestException.InvalidParametersException("The parameter 'offset' must not be negative.");
        }
        int selectionStart = this.getInt(context, "selectionStart", (Optional<Integer>)Optional.of((Object)offset));
        int selectionEnd = this.getInt(context, "selectionEnd", (Optional<Integer>)Optional.of((Object)selectionStart));
        TextRegion selection = new TextRegion(selectionStart, Math.max(selectionEnd - selectionStart, 0));
        String proposal = context.getParameter("proposal");
        ServiceDescriptor serviceDescriptor = new ServiceDescriptor();
        serviceDescriptor.service = () -> {
            try {
                if (StringExtensions.isNullOrEmpty((String)proposal)) {
                    return this.hoverService.getHover(document, offset);
                }
                return this.hoverService.getHover(document, proposal, (ITextRegion)selection, offset);
            }
            catch (Throwable throwable) {
                return this.handleError(serviceDescriptor, throwable);
            }
        };
        return serviceDescriptor;
    }

    protected ServiceDescriptor getHighlightingService(IServiceContext context) throws InvalidRequestException {
        XtextWebDocumentAccess document = this.getDocumentAccess(context);
        ServiceDescriptor serviceDescriptor = new ServiceDescriptor();
        serviceDescriptor.service = () -> {
            try {
                return this.highlightingService.getResult(document);
            }
            catch (Throwable throwable) {
                return this.handleError(serviceDescriptor, throwable);
            }
        };
        return serviceDescriptor;
    }

    protected ServiceDescriptor getOccurrencesService(IServiceContext context) throws InvalidRequestException {
        XtextWebDocumentAccess document = this.getDocumentAccess(context);
        int offset = this.getInt(context, "caretOffset", (Optional<Integer>)Optional.of((Object)0));
        if (offset < 0) {
            throw new InvalidRequestException.InvalidParametersException("The parameter 'offset' must not be negative.");
        }
        ServiceDescriptor serviceDescriptor = new ServiceDescriptor();
        serviceDescriptor.service = () -> {
            try {
                return this.occurrencesService.findOccurrences(document, offset);
            }
            catch (Throwable throwable) {
                return this.handleError(serviceDescriptor, throwable);
            }
        };
        return serviceDescriptor;
    }

    protected ServiceDescriptor getFormattingService(IServiceContext context) throws InvalidRequestException {
        XtextWebDocumentAccess document = this.getDocumentAccess(context);
        int selectionStart = this.getInt(context, "selectionStart", (Optional<Integer>)Optional.of((Object)0));
        int selectionEnd = this.getInt(context, "selectionEnd", (Optional<Integer>)Optional.of((Object)selectionStart));
        String lineSeparator = context.getParameter("lineSeparator");
        String indentation = context.getParameter("indentation");
        int indentationLength = this.getInt(context, "indentationLength", (Optional<Integer>)Optional.of((Object)4));
        int maxLineWidth = this.getInt(context, "maxLineWidth", (Optional<Integer>)Optional.of((Object)120));
        IPreferenceValues formatterPreferences = document.readOnly(new CancelableUnitOfWork<IPreferenceValues, IXtextWebDocument>(){

            public IPreferenceValues exec(IXtextWebDocument $0, CancelIndicator $1) throws Exception {
                if (XtextServiceDispatcher.this.formatterPreferencesProvider != null) {
                    return XtextServiceDispatcher.this.formatterPreferencesProvider.getPreferenceValues((Resource)$0.getResource());
                }
                return null;
            }
        });
        MapBasedPreferenceValues preferences = new MapBasedPreferenceValues(formatterPreferences, new LinkedHashMap());
        preferences.put((TypedPreferenceKey)FormatterPreferenceKeys.lineSeparator, (Object)lineSeparator);
        preferences.put((TypedPreferenceKey)FormatterPreferenceKeys.indentation, (Object)indentation);
        preferences.put((TypedPreferenceKey)FormatterPreferenceKeys.tabWidth, (Object)indentationLength);
        preferences.put((TypedPreferenceKey)FormatterPreferenceKeys.maxLineWidth, (Object)maxLineWidth);
        TextRegion selection = selectionEnd > selectionStart ? new TextRegion(selectionStart, selectionEnd - selectionStart) : null;
        ServiceDescriptor serviceDescriptor = new ServiceDescriptor();
        serviceDescriptor.service = () -> {
            try {
                return this.formattingService.format(document, (ITextRegion)selection, (ITypedPreferenceValues)preferences);
            }
            catch (Throwable throwable) {
                return this.handleError(serviceDescriptor, throwable);
            }
        };
        serviceDescriptor.hasSideEffects = true;
        return serviceDescriptor;
    }

    protected ServiceDescriptor getGeneratorService(IServiceContext context) throws InvalidRequestException {
        XtextWebDocumentAccess document = this.getDocumentAccess(context);
        boolean allArtifacts = this.getBoolean(context, "allArtifacts", (Optional<Boolean>)Optional.of((Object)false));
        boolean includeContent = this.getBoolean(context, "includeContent", (Optional<Boolean>)Optional.of((Object)true));
        ServiceDescriptor serviceDescriptor = new ServiceDescriptor();
        if (allArtifacts) {
            serviceDescriptor.service = () -> {
                try {
                    return this.generatorService.getResult(document, includeContent);
                }
                catch (Throwable throwable) {
                    return this.handleError(serviceDescriptor, throwable);
                }
            };
        } else {
            String artifactId = context.getParameter("artifact");
            serviceDescriptor.service = () -> {
                try {
                    return this.generatorService.getArtifact(document, artifactId, includeContent);
                }
                catch (Throwable throwable) {
                    return this.handleError(serviceDescriptor, throwable);
                }
            };
        }
        return serviceDescriptor;
    }

    protected XtextWebDocumentAccess getDocumentAccess(IServiceContext context) throws InvalidRequestException {
        XtextWebDocument document = null;
        boolean initializedFromFullText = false;
        if (context.getParameterKeys().contains("fullText")) {
            document = this.getFullTextDocument(context.getParameter("fullText"), this.getResourceID(context), context);
            initializedFromFullText = true;
        } else if (context.getParameterKeys().contains("resource")) {
            document = this.getResourceDocument(this.getResourceID(context), context);
            if (document == null) {
                throw new InvalidRequestException.ResourceNotFoundException("The requested resource was not found.");
            }
        } else {
            throw new InvalidRequestException.InvalidParametersException("At least one of the parameters 'resource' and 'fullText' must be specified.");
        }
        return this.documentAccessFactory.create(document, context.getParameter("requiredStateId"), initializedFromFullText);
    }

    protected String getResourceID(IServiceContext context) {
        return context.getParameter("resource");
    }

    protected XtextWebDocument getFullTextDocument(String fullText, String resourceId, IServiceContext context) {
        try {
            ResourceSet resourceSet = this.resourceSetProvider.get(resourceId, context);
            String uriString = null;
            uriString = resourceId != null ? resourceId : Integer.toHexString(this.randomGenerator.nextInt()) + "." + this.fileExtensionProvider.getPrimaryFileExtension();
            URI uri = URI.createURI((String)uriString);
            XtextResource resource = (XtextResource)this.resourceFactory.createResource(uri);
            Resource existingResource = resourceSet.getResource(uri, false);
            if (existingResource != null) {
                resourceSet.getResources().remove((Object)existingResource);
            }
            resourceSet.getResources().add((Object)resource);
            resource.load((InputStream)new StringInputStream(fullText), Collections.emptyMap());
            XtextWebDocument document = this.documentProvider.get(resourceId, context);
            document.setInput(resource);
            if (resourceId != null) {
                context.getSession().put(Pair.of(XtextWebDocument.class, (Object)resourceId), document);
            }
            return document;
        }
        catch (IOException e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }

    protected XtextWebDocument getResourceDocument(String resourceId, IServiceContext context) {
        try {
            return (XtextWebDocument)context.getSession().get(Pair.of(XtextWebDocument.class, (Object)resourceId), () -> {
                try {
                    return this.resourceHandler.get(resourceId, context);
                }
                catch (Throwable t) {
                    throw Exceptions.sneakyThrow((Throwable)t);
                }
            });
        }
        catch (Throwable t) {
            if (t instanceof IOException) {
                return null;
            }
            throw Exceptions.sneakyThrow((Throwable)t);
        }
    }

    protected String getString(IServiceContext context, String key, Optional<String> defaultValue) throws InvalidRequestException.InvalidParametersException {
        String stringValue = context.getParameter(key);
        if (stringValue == null) {
            if (!defaultValue.isPresent()) {
                throw new InvalidRequestException.InvalidParametersException("The parameter '" + key + "' must be specified.");
            }
            return (String)defaultValue.get();
        }
        return stringValue;
    }

    protected int getInt(IServiceContext context, String key, Optional<Integer> defaultValue) throws InvalidRequestException.InvalidParametersException {
        String stringValue = context.getParameter(key);
        if (stringValue == null) {
            if (!defaultValue.isPresent()) {
                throw new InvalidRequestException.InvalidParametersException("The parameter '" + key + "' must be specified.");
            }
            return (Integer)defaultValue.get();
        }
        try {
            return Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            throw new InvalidRequestException.InvalidParametersException("The parameter '" + key + "' must contain an integer value.");
        }
    }

    protected boolean getBoolean(IServiceContext context, String key, Optional<Boolean> defaultValue) throws InvalidRequestException.InvalidParametersException {
        String stringValue = context.getParameter(key);
        if (stringValue == null) {
            if (!defaultValue.isPresent()) {
                throw new InvalidRequestException.InvalidParametersException("The parameter '" + key + "' must be specified.");
            }
            return (Boolean)defaultValue.get();
        }
        String lowerCase = stringValue.toLowerCase();
        if (lowerCase != null) {
            switch (lowerCase) {
                case "true": {
                    return true;
                }
                case "false": {
                    return false;
                }
            }
            throw new InvalidRequestException.InvalidParametersException("The parameter '" + key + "' must contain a Boolean value.");
        }
        throw new InvalidRequestException.InvalidParametersException("The parameter '" + key + "' must contain a Boolean value.");
    }

    protected ServiceConflictResult _handleError(ServiceDescriptor service, Throwable throwable) {
        if (this.operationCanceledManager.isOperationCanceledException(throwable)) {
            LOG.trace((Object)("Service canceled (" + service.context.getParameter("serviceType") + ")"));
            return new ServiceConflictResult("canceled");
        }
        throw Exceptions.sneakyThrow((Throwable)throwable);
    }

    protected ServiceConflictResult _handleError(ServiceDescriptor service, InvalidRequestException.InvalidDocumentStateException exception) {
        LOG.trace((Object)("Invalid document state (" + service.context.getParameter("serviceType") + ")"));
        return new ServiceConflictResult("invalidStateId");
    }

    protected ServiceConflictResult handleError(ServiceDescriptor service, Throwable exception) {
        if (exception instanceof InvalidRequestException.InvalidDocumentStateException) {
            return this._handleError(service, (InvalidRequestException.InvalidDocumentStateException)exception);
        }
        if (exception != null) {
            return this._handleError(service, exception);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(service, exception).toString());
    }

    public static class ServiceDescriptor {
        private IServiceContext context;
        private Functions.Function0<? extends IServiceResult> service;
        private boolean hasSideEffects;
        private boolean hasConflict;

        public IServiceContext getContext() {
            return this.context;
        }

        public void setContext(IServiceContext context) {
            this.context = context;
        }

        public Functions.Function0<? extends IServiceResult> getService() {
            return this.service;
        }

        public void setService(Functions.Function0<? extends IServiceResult> service) {
            this.service = service;
        }

        public boolean isHasSideEffects() {
            return this.hasSideEffects;
        }

        public void setHasSideEffects(boolean hasSideEffects) {
            this.hasSideEffects = hasSideEffects;
        }

        public boolean isHasConflict() {
            return this.hasConflict;
        }

        public void setHasConflict(boolean hasConflict) {
            this.hasConflict = hasConflict;
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("context", (Object)this.context);
            b.add("service", this.service);
            b.add("hasSideEffects", (Object)this.hasSideEffects);
            b.add("hasConflict", (Object)this.hasConflict);
            return b.toString();
        }
    }
}

