/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.model;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.annotations.Delegate;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.ide.ExecutorServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.web.server.IServiceResult;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.model.AbstractCachedService;
import org.eclipse.xtext.web.server.model.DocumentSynchronizer;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.PrecomputedServiceRegistry;
import org.eclipse.xtext.web.server.model.XtextWebDocument;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Log
public class XtextWebDocumentAccess {
    private static final String DOCUMENT_LOCK_EXECUTOR = "withDocumentLock";
    @Inject
    private PrecomputedServiceRegistry preComputedServiceRegistry;
    @Inject
    private OperationCanceledManager operationCanceledManager;
    private ExecutorService executorService1;
    private ExecutorService executorService2;
    private XtextWebDocument document;
    private String requiredStateId;
    private boolean skipAsyncWork;
    private static final Logger LOG = Logger.getLogger(XtextWebDocumentAccess.class);

    @Inject
    protected void setExecutorServiceProvider(ExecutorServiceProvider executorServiceProvider) {
        this.executorService1 = executorServiceProvider.get(DOCUMENT_LOCK_EXECUTOR);
        this.executorService2 = executorServiceProvider.get();
    }

    protected void init(XtextWebDocument document, String requiredStateId, boolean skipAsyncWork) {
        this.document = document;
        this.requiredStateId = requiredStateId;
        this.skipAsyncWork = skipAsyncWork;
    }

    protected void checkStateId() throws InvalidRequestException.InvalidDocumentStateException {
        if (this.requiredStateId != null && !Objects.equal((Object)this.requiredStateId, (Object)this.document.getStateId())) {
            throw new InvalidRequestException.InvalidDocumentStateException("The given state id does not match the current state.");
        }
    }

    public <T> T readOnly(CancelableUnitOfWork<T, IXtextWebDocument> work) {
        return this.doAccess(work, false, false, null);
    }

    public <T> T priorityReadOnly(CancelableUnitOfWork<T, IXtextWebDocument> work) {
        return this.doAccess(work, true, false, null);
    }

    public <T> T modify(CancelableUnitOfWork<T, IXtextWebDocument> work, CancelableUnitOfWork<?, IXtextWebDocument> asynchronousWork) {
        return this.doAccess(work, true, true, asynchronousWork);
    }

    public <T> T modify(CancelableUnitOfWork<T, IXtextWebDocument> work) {
        return this.doAccess(work, true, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T doAccess(CancelableUnitOfWork<T, IXtextWebDocument> synchronousWork, boolean priority, boolean modify, CancelableUnitOfWork<?, IXtextWebDocument> asynchronousWork) {
        try {
            Object result;
            block10: {
                DocumentSynchronizer synchronizer = this.document.getSynchronizer();
                IXtextWebDocument _xifexpression = null;
                _xifexpression = modify ? this.document : this.createReadAccess(this.document);
                XtextWebDocument documentAccess = _xifexpression;
                boolean currentThreadOwnsLock = true;
                result = null;
                try {
                    synchronizer.acquireLock(priority);
                    this.checkStateId();
                    synchronousWork.setCancelIndicator((CancelIndicator)synchronizer);
                    result = synchronousWork.exec((Object)documentAccess);
                    this.requiredStateId = this.document.getStateId();
                    if (!this.skipAsyncWork && priority && documentAccess != null && !synchronizer.isCanceled() && !Thread.currentThread().isInterrupted()) {
                        final Procedures.Procedure1 _function = it -> {
                            block10: {
                                try {
                                    if (asynchronousWork != null) {
                                        asynchronousWork.setCancelIndicator((CancelIndicator)synchronizer);
                                        asynchronousWork.exec((Object)documentAccess);
                                    }
                                    EcoreUtil2.resolveLazyCrossReferences((Resource)documentAccess.getResource(), (CancelIndicator)synchronizer);
                                }
                                catch (Throwable _t) {
                                    if (_t instanceof VirtualMachineError) {
                                        VirtualMachineError error = (VirtualMachineError)_t;
                                        throw error;
                                    }
                                    if (_t instanceof Throwable) {
                                        Throwable throwable = _t;
                                        boolean _isOperationCanceledException = this.operationCanceledManager.isOperationCanceledException(throwable);
                                        if (_isOperationCanceledException) {
                                            LOG.trace((Object)"Canceling background work.");
                                        } else {
                                            LOG.error((Object)"Error during background work.", throwable);
                                        }
                                        break block10;
                                    }
                                    throw Exceptions.sneakyThrow((Throwable)_t);
                                }
                                finally {
                                    synchronizer.releaseLock();
                                }
                            }
                        };
                        this.executorService1.submit(new Runnable(){

                            @Override
                            public void run() {
                                _function.apply(null);
                            }
                        });
                        currentThreadOwnsLock = false;
                        final Procedures.Procedure1 _function_1 = it -> {
                            try {
                                this.performPrecomputation(synchronizer);
                            }
                            catch (Throwable _t) {
                                if (_t instanceof VirtualMachineError) {
                                    VirtualMachineError error = (VirtualMachineError)_t;
                                    throw error;
                                }
                                if (_t instanceof InvalidRequestException.InvalidDocumentStateException) {
                                    return;
                                }
                                if (_t instanceof Throwable) {
                                    Throwable throwable = _t;
                                    boolean _isOperationCanceledException = this.operationCanceledManager.isOperationCanceledException(throwable);
                                    if (_isOperationCanceledException) {
                                        LOG.trace((Object)"Canceling precomputation.");
                                    } else {
                                        LOG.error((Object)"Error during precomputation.", throwable);
                                    }
                                }
                                throw Exceptions.sneakyThrow((Throwable)_t);
                            }
                        };
                        this.executorService2.submit(new Runnable(){

                            @Override
                            public void run() {
                                _function_1.apply(null);
                            }
                        });
                    }
                }
                catch (Throwable _t) {
                    if (_t instanceof RejectedExecutionException) {
                        RejectedExecutionException ree = (RejectedExecutionException)_t;
                        LOG.error((Object)"Failed to start background work.", (Throwable)ree);
                        break block10;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                finally {
                    if (currentThreadOwnsLock) {
                        synchronizer.releaseLock();
                    }
                }
            }
            return (T)result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void performPrecomputation(CancelIndicator cancelIndicator) {
        Iterable<AbstractCachedService<? extends IServiceResult>> _precomputedServices = this.preComputedServiceRegistry.getPrecomputedServices();
        for (AbstractCachedService<? extends IServiceResult> service : _precomputedServices) {
            this.operationCanceledManager.checkCanceled(cancelIndicator);
            this.getCachedServiceResult(service, false);
        }
    }

    protected <T extends IServiceResult> T getCachedServiceResult(final AbstractCachedService<T> service, final boolean logCacheMiss) {
        CancelableUnitOfWork _function = new CancelableUnitOfWork<T, IXtextWebDocument>(){

            public T exec(IXtextWebDocument d, CancelIndicator cancelIndicator) throws Exception {
                boolean _tripleNotEquals;
                String _resourceId = XtextWebDocumentAccess.this.document.getResourceId();
                boolean bl = _tripleNotEquals = _resourceId != null;
                if (_tripleNotEquals) {
                    return XtextWebDocumentAccess.this.document.getCachedServiceResult(service, cancelIndicator, logCacheMiss);
                }
                return service.compute(XtextWebDocumentAccess.this.document, cancelIndicator);
            }
        };
        return (T)((IServiceResult)this.readOnly(_function));
    }

    protected IXtextWebDocument createReadAccess(XtextWebDocument document) {
        return new ReadAccess(document);
    }

    @FinalFieldsConstructor
    protected static class ReadAccess
    implements IXtextWebDocument {
        @Delegate
        private final XtextWebDocument document;

        @Override
        public void setText(String text) {
            throw new UnsupportedOperationException("Cannot modify the document with read-only access.");
        }

        @Override
        public void updateText(String text, int offset, int replaceLength) {
            throw new UnsupportedOperationException("Cannot modify the document with read-only access.");
        }

        @Override
        public void createNewStateId() {
            throw new UnsupportedOperationException("Cannot modify the document with read-only access.");
        }

        public ReadAccess(XtextWebDocument document) {
            this.document = document;
        }

        @Override
        public XtextResource getResource() {
            return this.document.getResource();
        }

        @Override
        public String getResourceId() {
            return this.document.getResourceId();
        }

        @Override
        public String getStateId() {
            return this.document.getStateId();
        }

        @Override
        public String getText() {
            return this.document.getText();
        }

        @Override
        public boolean isDirty() {
            return this.document.isDirty();
        }

        @Override
        public void setDirty(boolean arg0) {
            this.document.setDirty(arg0);
        }
    }

    public static class Factory {
        @Inject
        private Provider<XtextWebDocumentAccess> provider;

        public XtextWebDocumentAccess create(XtextWebDocument document, String requiredStateId, boolean skipAsyncWork) {
            XtextWebDocumentAccess docAccess = (XtextWebDocumentAccess)this.provider.get();
            docAccess.init(document, requiredStateId, skipAsyncWork);
            docAccess.checkStateId();
            return docAccess;
        }

        public XtextWebDocumentAccess create(XtextWebDocument document, boolean skipAsyncWork) {
            XtextWebDocumentAccess docAccess = (XtextWebDocumentAccess)this.provider.get();
            docAccess.init(document, null, skipAsyncWork);
            return docAccess;
        }
    }
}

