/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.validation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.web.server.model.AbstractCachedService;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.validation.ValidationResult;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class ValidationService
extends AbstractCachedService<ValidationResult> {
    @Inject
    private IResourceValidator resourceValidator;

    @Override
    public ValidationResult compute(IXtextWebDocument it, CancelIndicator cancelIndicator) {
        List issues = this.resourceValidator.validate((Resource)it.getResource(), CheckMode.ALL, cancelIndicator);
        ValidationResult result = new ValidationResult();
        Functions.Function1 _function = it_1 -> {
            Severity _severity = it_1.getSeverity();
            return !Objects.equal((Object)_severity, (Object)Severity.IGNORE);
        };
        Consumer<Issue> _function_1 = issue -> {
            List<ValidationResult.Issue> _issues = result.getIssues();
            String _message = issue.getMessage();
            String _translate = this.translate(issue.getSeverity());
            Integer _lineNumber = issue.getLineNumber();
            Integer _column = issue.getColumn();
            Integer _offset = issue.getOffset();
            Integer _length = issue.getLength();
            ValidationResult.Issue _issue = new ValidationResult.Issue(_message, _translate, _lineNumber, _column, _offset, _length);
            _issues.add(_issue);
        };
        IterableExtensions.filter((Iterable)issues, (Functions.Function1)_function).forEach(_function_1);
        return result;
    }

    protected String translate(Severity severity) {
        String _switchResult = null;
        if (severity != null) {
            switch (severity) {
                case WARNING: {
                    _switchResult = "warning";
                    break;
                }
                case ERROR: {
                    _switchResult = "error";
                    break;
                }
                case INFO: {
                    _switchResult = "info";
                    break;
                }
                default: {
                    _switchResult = "ignore";
                    break;
                }
            }
        } else {
            _switchResult = "ignore";
        }
        return _switchResult;
    }
}

