/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.syntaxcoloring;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.xtext.ide.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ide.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.web.server.model.AbstractCachedService;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.syntaxcoloring.HighlightingResult;

@Singleton
public class HighlightingService
extends AbstractCachedService<HighlightingResult> {
    @Inject
    private ISemanticHighlightingCalculator highlightingCalculator;

    @Override
    public HighlightingResult compute(IXtextWebDocument it, CancelIndicator cancelIndicator) {
        HighlightingResult result = new HighlightingResult();
        List<HighlightingResult.Region> _regions = result.getRegions();
        IHighlightedPositionAcceptor acceptor = this.createHighlightedPositionAcceptor(_regions);
        XtextResource _resource = it.getResource();
        this.highlightingCalculator.provideHighlightingFor(_resource, acceptor, cancelIndicator);
        return result;
    }

    protected IHighlightedPositionAcceptor createHighlightedPositionAcceptor(List<HighlightingResult.Region> positions) {
        IHighlightedPositionAcceptor _function = (offset, length, ids) -> {
            HighlightingResult.Region _region = new HighlightingResult.Region(offset, length, ids);
            positions.add(_region);
        };
        return _function;
    }
}

