/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.server.persistence;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.web.server.IServiceContext;
import org.eclipse.xtext.web.server.model.IWebDocumentProvider;
import org.eclipse.xtext.web.server.model.IWebResourceSetProvider;
import org.eclipse.xtext.web.server.model.IXtextWebDocument;
import org.eclipse.xtext.web.server.model.XtextWebDocument;
import org.eclipse.xtext.web.server.persistence.IResourceBaseProvider;
import org.eclipse.xtext.web.server.persistence.IServerResourceHandler;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class FileResourceHandler
implements IServerResourceHandler {
    @Inject
    private IResourceBaseProvider resourceBaseProvider;
    @Inject
    private IWebResourceSetProvider resourceSetProvider;
    @Inject
    private IWebDocumentProvider documentProvider;
    @Inject
    private IEncodingProvider encodingProvider;

    @Override
    public XtextWebDocument get(String resourceId, IServiceContext serviceContext) throws IOException {
        try {
            URI uri = this.resourceBaseProvider.getFileURI(resourceId);
            if (uri == null) {
                throw new IOException("The requested resource does not exist.");
            }
            ResourceSet resourceSet = this.resourceSetProvider.get(resourceId, serviceContext);
            Resource _resource = resourceSet.getResource(uri, true);
            XtextResource resource = (XtextResource)_resource;
            XtextWebDocument _get = this.documentProvider.get(resourceId, serviceContext);
            Procedures.Procedure1 _function = it -> it.setInput(resource);
            return (XtextWebDocument)ObjectExtensions.operator_doubleArrow((Object)_get, (Procedures.Procedure1)_function);
        }
        catch (Throwable _t) {
            try {
                if (_t instanceof WrappedException) {
                    WrappedException exception = (WrappedException)_t;
                    throw exception.getCause();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }

    @Override
    public void put(IXtextWebDocument document, IServiceContext serviceContext) throws IOException {
        try {
            try {
                String _resourceId = document.getResourceId();
                URI uri = this.resourceBaseProvider.getFileURI(_resourceId);
                XtextResource _resource = document.getResource();
                ResourceSet _resourceSet = _resource.getResourceSet();
                URIConverter _uRIConverter = _resourceSet.getURIConverter();
                OutputStream outputStream = _uRIConverter.createOutputStream(uri);
                String _encoding = this.encodingProvider.getEncoding(uri);
                OutputStreamWriter writer = new OutputStreamWriter(outputStream, _encoding);
                String _text = document.getText();
                writer.write(_text);
                writer.close();
            }
            catch (Throwable _t) {
                if (_t instanceof WrappedException) {
                    WrappedException exception = (WrappedException)_t;
                    throw exception.getCause();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

