/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.servlet;

import com.google.common.io.ByteStreams;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.xtext.web.server.XtextServiceDispatcher;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class XtextResourcesServlet
extends HttpServlet {
    private static final long serialVersionUID = 4318411920672654776L;
    private static final long DEFAULT_EXPIRE_TIME_MS = 86400000L;
    private static final long DEFAULT_EXPIRE_TIME_S = 86400L;
    private boolean disableCache = false;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String disableCache = config.getInitParameter("disableCache");
        if (disableCache != null) {
            this.disableCache = Boolean.parseBoolean(disableCache);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            String resourceURI = "META-INF/resources" + request.getServletPath() + request.getPathInfo();
            try (InputStream inputStream = this.getResourceAsStream(resourceURI);){
                if (inputStream != null) {
                    String[] tokens = resourceURI.split("/");
                    String fileName = tokens[tokens.length - 1];
                    if (!this.disableCache && tokens.length > 4) {
                        String version = tokens[3];
                        response.setHeader("ETag", fileName + "_" + version);
                        response.setDateHeader("Expires", System.currentTimeMillis() + 86400000L);
                        response.addHeader("Cache-Control", "private, max-age=86400");
                    }
                    String mimeType = this.getServletContext().getMimeType(fileName);
                    String contentType = null;
                    contentType = mimeType != null ? mimeType : "application/octet-stream";
                    response.setContentType(contentType);
                    ByteStreams.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
                } else {
                    response.sendError(404);
                }
            }
        }
        catch (IOException e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }

    protected InputStream getResourceAsStream(String resourceURI) {
        return XtextServiceDispatcher.class.getClassLoader().getResourceAsStream(resourceURI);
    }
}

