/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.servlet;

import com.google.common.base.Objects;
import com.google.gson.Gson;
import com.google.inject.Injector;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.web.server.IServiceContext;
import org.eclipse.xtext.web.server.IServiceResult;
import org.eclipse.xtext.web.server.IUnwrappableServiceResult;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.XtextServiceDispatcher;
import org.eclipse.xtext.web.servlet.HttpServiceContext;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class XtextServlet
extends HttpServlet {
    private final Logger LOG = Logger.getLogger(((Object)((Object)this)).getClass());
    private final IResourceServiceProvider.Registry serviceProviderRegistry = IResourceServiceProvider.Registry.INSTANCE;
    private final Gson gson = new Gson();

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            super.service(req, resp);
        }
        catch (Throwable _t) {
            if (_t instanceof InvalidRequestException.ResourceNotFoundException) {
                InvalidRequestException.ResourceNotFoundException exception = (InvalidRequestException.ResourceNotFoundException)_t;
                String _requestURI = req.getRequestURI();
                String _plus = "Invalid request (" + _requestURI;
                String _plus_1 = _plus + "): ";
                String _message = exception.getMessage();
                String _plus_2 = _plus_1 + _message;
                this.LOG.trace((Object)_plus_2);
                String _message_1 = exception.getMessage();
                resp.sendError(404, _message_1);
            }
            if (_t instanceof InvalidRequestException.InvalidDocumentStateException) {
                InvalidRequestException.InvalidDocumentStateException exception_1 = (InvalidRequestException.InvalidDocumentStateException)_t;
                String _requestURI_1 = req.getRequestURI();
                String _plus_3 = "Invalid request (" + _requestURI_1;
                String _plus_4 = _plus_3 + "): ";
                String _message_2 = exception_1.getMessage();
                String _plus_5 = _plus_4 + _message_2;
                this.LOG.trace((Object)_plus_5);
                String _message_3 = exception_1.getMessage();
                resp.sendError(409, _message_3);
            }
            if (_t instanceof InvalidRequestException.PermissionDeniedException) {
                InvalidRequestException.PermissionDeniedException exception_2 = (InvalidRequestException.PermissionDeniedException)_t;
                String _requestURI_2 = req.getRequestURI();
                String _plus_6 = "Invalid request (" + _requestURI_2;
                String _plus_7 = _plus_6 + "): ";
                String _message_4 = exception_2.getMessage();
                String _plus_8 = _plus_7 + _message_4;
                this.LOG.trace((Object)_plus_8);
                String _message_5 = exception_2.getMessage();
                resp.sendError(403, _message_5);
            }
            if (_t instanceof InvalidRequestException) {
                InvalidRequestException exception_3 = (InvalidRequestException)_t;
                String _requestURI_3 = req.getRequestURI();
                String _plus_9 = "Invalid request (" + _requestURI_3;
                String _plus_10 = _plus_9 + "): ";
                String _message_6 = exception_3.getMessage();
                String _plus_11 = _plus_10 + _message_6;
                this.LOG.trace((Object)_plus_11);
                String _message_7 = exception_3.getMessage();
                resp.sendError(400, _message_7);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        XtextServiceDispatcher.ServiceDescriptor service = this.getService(req);
        if (!service.isHasConflict() && (service.isHasSideEffects() || this.hasTextInput(service))) {
            super.doGet(req, resp);
        } else {
            this.doService(service, resp);
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        XtextServiceDispatcher.ServiceDescriptor service = this.getService(req);
        IServiceContext _context = service.getContext();
        String type = _context.getParameter("serviceType");
        if (!service.isHasConflict() && !Objects.equal((Object)type, (Object)"update")) {
            super.doPut(req, resp);
        } else {
            this.doService(service, resp);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        XtextServiceDispatcher.ServiceDescriptor service = this.getService(req);
        IServiceContext _context = service.getContext();
        String type = _context.getParameter("serviceType");
        if (!service.isHasConflict() && (!service.isHasSideEffects() && !this.hasTextInput(service) || Objects.equal((Object)type, (Object)"update"))) {
            super.doPost(req, resp);
        } else {
            this.doService(service, resp);
        }
    }

    protected boolean hasTextInput(XtextServiceDispatcher.ServiceDescriptor service) {
        boolean _xblockexpression = false;
        IServiceContext _context = service.getContext();
        Set parameterKeys = _context.getParameterKeys();
        _xblockexpression = parameterKeys.contains("fullText") || parameterKeys.contains("deltaText");
        return _xblockexpression;
    }

    protected XtextServiceDispatcher.ServiceDescriptor getService(HttpServletRequest request) throws InvalidRequestException {
        HttpServiceContext serviceContext = new HttpServiceContext(request);
        Injector injector = this.getInjector(serviceContext);
        XtextServiceDispatcher serviceDispatcher = (XtextServiceDispatcher)injector.getInstance(XtextServiceDispatcher.class);
        XtextServiceDispatcher.ServiceDescriptor service = serviceDispatcher.getService((IServiceContext)serviceContext);
        return service;
    }

    protected void doService(XtextServiceDispatcher.ServiceDescriptor service, HttpServletResponse response) {
        try {
            Functions.Function0 _service = service.getService();
            IServiceResult result = (IServiceResult)_service.apply();
            response.setStatus(200);
            String _encoding = this.getEncoding(service, result);
            response.setCharacterEncoding(_encoding);
            response.setHeader("Cache-Control", "no-cache");
            if (result instanceof IUnwrappableServiceResult && ((IUnwrappableServiceResult)result).getContent() != null) {
                IUnwrappableServiceResult unwrapResult = (IUnwrappableServiceResult)result;
                String _elvis = null;
                String _contentType = unwrapResult.getContentType();
                _elvis = _contentType != null ? _contentType : "text/plain";
                response.setContentType(_elvis);
                PrintWriter _writer = response.getWriter();
                String _content = unwrapResult.getContent();
                _writer.write(_content);
            } else {
                response.setContentType("text/x-json");
                PrintWriter _writer_1 = response.getWriter();
                this.gson.toJson((Object)result, (Appendable)_writer_1);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String getEncoding(XtextServiceDispatcher.ServiceDescriptor service, IServiceResult result) {
        return "UTF-8";
    }

    protected Injector getInjector(HttpServiceContext serviceContext) throws InvalidRequestException.UnknownLanguageException {
        IResourceServiceProvider resourceServiceProvider = null;
        String _elvis = null;
        String _parameter = serviceContext.getParameter("resource");
        _elvis = _parameter != null ? _parameter : "";
        URI emfURI = URI.createURI((String)_elvis);
        String contentType = serviceContext.getParameter("contentType");
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)contentType);
        if (_isNullOrEmpty) {
            IResourceServiceProvider _resourceServiceProvider = this.serviceProviderRegistry.getResourceServiceProvider(emfURI);
            resourceServiceProvider = _resourceServiceProvider;
            if (resourceServiceProvider == null) {
                String _string = emfURI.toString();
                boolean _isEmpty = _string.isEmpty();
                if (_isEmpty) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Unable to identify the Xtext language: missing parameter 'resource' or 'contentType'.");
                    throw new InvalidRequestException.UnknownLanguageException(_builder.toString());
                }
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Unable to identify the Xtext language for resource ");
                _builder_1.append((Object)emfURI, "");
                _builder_1.append(".");
                throw new InvalidRequestException.UnknownLanguageException(_builder_1.toString());
            }
        } else {
            IResourceServiceProvider _resourceServiceProvider_1 = this.serviceProviderRegistry.getResourceServiceProvider(emfURI, contentType);
            resourceServiceProvider = _resourceServiceProvider_1;
            if (resourceServiceProvider == null) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("Unable to identify the Xtext language for contentType ");
                _builder_2.append(contentType, "");
                _builder_2.append(".");
                throw new InvalidRequestException.UnknownLanguageException(_builder_2.toString());
            }
        }
        return (Injector)resourceServiceProvider.get(Injector.class);
    }
}

