/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.formallang;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.xtext.util.formallang.Production;

public class ProductionFormatter<ELEMENT, TOKEN>
implements Function<Production<ELEMENT, TOKEN>, String> {
    protected int autoWrapChars = 140;
    protected int autoWrapChildren = 5;
    protected String indent = "    ";
    protected Function<TOKEN, String> tokenToString = new ObjToStrFunction();

    public String apply(Production<ELEMENT, TOKEN> from) {
        return this.format(from);
    }

    public String format(Production<ELEMENT, TOKEN> adapter) {
        return this.format(adapter, adapter.getRoot());
    }

    public String format(Production<ELEMENT, TOKEN> adapter, ELEMENT grammarElement) {
        return this.format(adapter, grammarElement, false);
    }

    public String format(Production<ELEMENT, TOKEN> adapter, ELEMENT grammarElement, boolean needParenthesis) {
        TOKEN token = adapter.getToken(grammarElement);
        if (token != null) {
            String cardinality = this.getCardinality(adapter, grammarElement);
            if (cardinality == null) {
                return (String)this.tokenToString.apply(token);
            }
            return String.valueOf((String)this.tokenToString.apply(token)) + cardinality;
        }
        Iterable<ELEMENT> alternative = adapter.getAlternativeChildren(grammarElement);
        if (alternative != null) {
            return this.format(adapter, grammarElement, alternative, " | ", false, needParenthesis);
        }
        Iterable<ELEMENT> group = adapter.getSequentialChildren(grammarElement);
        if (group != null) {
            return this.format(adapter, grammarElement, group, " ", false, needParenthesis);
        }
        Iterable<ELEMENT> ungroup = adapter.getUnorderedChildren(grammarElement);
        if (ungroup != null) {
            return this.format(adapter, grammarElement, ungroup, " & ", false, needParenthesis);
        }
        return "<unknown>";
    }

    protected String format(Production<ELEMENT, TOKEN> adapter, ELEMENT element, Iterable<ELEMENT> children, String separator, boolean needWrap, boolean needParenthesis) {
        ArrayList childStrs2 = Lists.newArrayList();
        int width2 = 0;
        for (ELEMENT child : children) {
            String childStr = this.format(adapter, child, true);
            childStrs2.add(childStr);
            width2 += childStr.length();
            if (!childStr.contains("\n")) continue;
            needWrap = true;
        }
        if (childStrs2.size() > this.autoWrapChildren) {
            needWrap = true;
        }
        if (width2 > this.autoWrapChars) {
            needWrap = true;
        }
        String cardinality = this.getCardinality(adapter, element);
        if (needWrap) {
            int i = 0;
            while (i < childStrs2.size()) {
                childStrs2.set(i, ((String)childStrs2.get(i)).replaceAll("\\n", "\n" + this.indent));
                ++i;
            }
            String body = Joiner.on((String)(String.valueOf(separator) + "\n" + this.indent)).join((Iterable)childStrs2);
            return "(\n" + this.indent + body + "\n)" + (cardinality == null ? "" : cardinality);
        }
        if (cardinality != null && childStrs2.size() > 1) {
            needParenthesis = true;
        }
        String body = Joiner.on((String)separator).join((Iterable)childStrs2);
        if (needParenthesis) {
            return "(" + body + ")" + (cardinality == null ? "" : cardinality);
        }
        return body;
    }

    protected String getCardinality(Production<ELEMENT, TOKEN> adapter, ELEMENT ele) {
        return adapter.isMany(ele) ? (adapter.isOptional(ele) ? "*" : "+") : (adapter.isOptional(ele) ? "?" : null);
    }

    public ProductionFormatter<ELEMENT, TOKEN> setAutoWrapChars(int autoWrapChars) {
        this.autoWrapChars = autoWrapChars;
        return this;
    }

    public ProductionFormatter<ELEMENT, TOKEN> setAutoWrapChildren(int autoWrapChildren) {
        this.autoWrapChildren = autoWrapChildren;
        return this;
    }

    public ProductionFormatter<ELEMENT, TOKEN> setIndent(String indent) {
        this.indent = indent;
        return this;
    }

    public ProductionFormatter<ELEMENT, TOKEN> setTokenToString(Function<TOKEN, String> tokenToString) {
        this.tokenToString = tokenToString;
        return this;
    }

    protected static class ObjToStrFunction<TOKEN>
    implements Function<TOKEN, String> {
        protected ObjToStrFunction() {
        }

        public String apply(TOKEN from) {
            return from == null ? "null" : from.toString();
        }
    }
}

