/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.eclipse.xtext.util.StringInputStream;

public class LazyStringInputStream
extends InputStream {
    private InputStream delegate;
    private String string;
    private String encoding;

    public LazyStringInputStream(String string) {
        this(string, Charset.defaultCharset().name());
    }

    public LazyStringInputStream(String string, Charset encoding) {
        this(string, encoding.name());
    }

    public LazyStringInputStream(String string, String encoding) {
        this.string = string;
        this.encoding = encoding;
    }

    public int read() throws IOException {
        return this.delegate().read();
    }

    private InputStream delegate() throws IOException {
        if (this.delegate == null) {
            this.delegate = new StringInputStream(this.string, this.encoding);
        }
        return this.delegate;
    }

    public int read(byte[] b) throws IOException {
        return this.delegate().read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.delegate().read(b, off, len);
    }

    public long skip(long n) throws IOException {
        return this.delegate().skip(n);
    }

    public int available() throws IOException {
        return this.delegate().available();
    }

    public void close() throws IOException {
        this.delegate().close();
    }

    public synchronized void mark(int readlimit) {
        try {
            this.delegate().mark(readlimit);
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    public synchronized void reset() throws IOException {
        this.delegate().reset();
    }

    public boolean markSupported() {
        try {
            return this.delegate().markSupported();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public String toString() {
        return this.string;
    }

    public String getString() {
        return this.string;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

