/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.util.Wrapper;

@Deprecated(forRemoval=true)
public class MergeableManifest
extends Manifest {
    public static final Attributes.Name BUNDLE_NAME = new Attributes.Name("Bundle-Name");
    public static final Attributes.Name BUNDLE_SYMBOLIC_NAME = new Attributes.Name("Bundle-SymbolicName");
    public static final Attributes.Name BUNDLE_VERSION = new Attributes.Name("Bundle-Version");
    public static final Attributes.Name BUNDLE_CLASSPATH = new Attributes.Name("Bundle-ClassPath");
    public static final Attributes.Name BUNDLE_VENDOR = new Attributes.Name("Bundle-Vendor");
    public static final Attributes.Name BUNDLE_REQUIRED_EXECUTION_ENV = new Attributes.Name("Bundle-RequiredExecutionEnvironment");
    public static final Attributes.Name EXPORT_PACKAGE = new Attributes.Name("Export-Package");
    public static final Attributes.Name IMPORT_PACKAGE = new Attributes.Name("Import-Package");
    public static final Attributes.Name REQUIRE_BUNDLE = new Attributes.Name("Require-Bundle");
    public static final Attributes.Name BUNDLE_ACTIVATION_POLICY = new Attributes.Name("Bundle-ActivationPolicy");
    public static final Attributes.Name BUNDLE_LOCALIZATION = new Attributes.Name("Bundle-Localization");
    public static final Attributes.Name BUNDLE_ACTIVATOR = new Attributes.Name("Bundle-Activator");
    @Deprecated
    private static final String LINEBREAK = Strings.newLine();
    private boolean modified = false;
    private String projectName;
    private String lineDelimiter = Strings.newLine();

    @Deprecated
    public static String make512Safe(StringBuffer lines) {
        return MergeableManifest.make512Safe(lines, LINEBREAK);
    }

    public static String make512Safe(StringBuffer lines, String lineDelimiter) {
        if (lines.length() > 512) {
            String[] splitted;
            StringBuilder result = new StringBuilder(lines.length());
            for (String string : splitted = lines.toString().split("\\r?\\n")) {
                if (string.length() > 512) {
                    int idx = 510;
                    StringBuilder temp = new StringBuilder(string);
                    int length = temp.length();
                    while (idx < length - 2) {
                        temp.insert(idx, lineDelimiter + " ");
                        idx += 512;
                        length += 3;
                    }
                    result.append(temp.toString());
                } else {
                    result.append(string);
                }
                result.append(lineDelimiter);
            }
            return result.toString();
        }
        return lines.toString();
    }

    public MergeableManifest(InputStream in) throws IOException {
        try {
            Field field = Manifest.class.getDeclaredField("attr");
            field.setAccessible(true);
            field.set(this, new OrderAwareAttributes());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.read(in);
        this.addRequiredBundles(Collections.emptySet());
        this.addExportedPackages(Collections.emptySet());
        this.addImportedPackages(Collections.emptySet());
        this.modified = false;
    }

    public MergeableManifest(InputStream in, String projectName) throws IOException {
        this(in);
        this.projectName = projectName;
    }

    public void addRequiredBundles(Set<String> bundles) {
        Set<String> bundlesToMerge;
        int idx;
        String bundleName = (String)this.getMainAttributes().get(BUNDLE_SYMBOLIC_NAME);
        if (bundleName != null && (idx = bundleName.indexOf(59)) >= 0) {
            bundleName = bundleName.substring(0, idx);
        }
        if (bundleName != null && bundles.contains(bundleName) || this.projectName != null && bundles.contains(this.projectName)) {
            bundlesToMerge = new LinkedHashSet<String>(bundles);
            bundlesToMerge.remove(bundleName);
            bundlesToMerge.remove(this.projectName);
        } else {
            bundlesToMerge = bundles;
        }
        String s = (String)this.getMainAttributes().get(REQUIRE_BUNDLE);
        Wrapper<Boolean> modified = Wrapper.wrap(this.modified);
        String result = MergeableManifest.mergeIntoCommaSeparatedList(s, bundlesToMerge, modified, this.lineDelimiter);
        this.modified = modified.get();
        this.getMainAttributes().put(REQUIRE_BUNDLE, result);
    }

    public String getBREE() {
        return (String)this.getMainAttributes().get(BUNDLE_REQUIRED_EXECUTION_ENV);
    }

    public void setBREE(String bree) {
        String oldValue = this.getBREE();
        if (Objects.equal((Object)oldValue, (Object)bree)) {
            return;
        }
        this.getMainAttributes().put(BUNDLE_REQUIRED_EXECUTION_ENV, bree);
        this.modified = true;
    }

    public String getBundleActivator() {
        return (String)this.getMainAttributes().get(BUNDLE_ACTIVATOR);
    }

    public void setBundleActivator(String activator) {
        String oldValue = this.getBundleActivator();
        if (Objects.equal((Object)oldValue, (Object)activator)) {
            return;
        }
        this.getMainAttributes().put(BUNDLE_ACTIVATOR, activator);
        this.modified = true;
    }

    public void setLineDelimiter(String delimiter) {
        this.lineDelimiter = delimiter;
    }

    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        this.getMainAttributes().myWriteMain(dos);
        for (Map.Entry<String, Attributes> e : this.getEntries().entrySet()) {
            StringBuffer buffer = new StringBuffer("Name: ");
            String value = e.getKey();
            if (value != null) {
                byte[] vb = value.getBytes("UTF8");
                value = new String(vb, 0, 0, vb.length);
            }
            buffer.append(value);
            buffer.append(this.lineDelimiter);
            dos.writeBytes(MergeableManifest.make512Safe(buffer, this.lineDelimiter));
            ((OrderAwareAttributes)e.getValue()).myWrite(dos);
        }
        dos.flush();
    }

    public void addExportedPackages(Set<String> packages) {
        String s = (String)this.getMainAttributes().get(EXPORT_PACKAGE);
        Wrapper<Boolean> modified = Wrapper.wrap(this.modified);
        String result = MergeableManifest.mergeIntoCommaSeparatedList(s, packages, modified, this.lineDelimiter);
        this.modified = modified.get();
        this.getMainAttributes().put(EXPORT_PACKAGE, result);
    }

    public void addExportedPackages(String ... packages) {
        this.addExportedPackages(Sets.newHashSet((Object[])packages));
    }

    public void addImportedPackages(Set<String> packages) {
        String s = (String)this.getMainAttributes().get(IMPORT_PACKAGE);
        Wrapper<Boolean> modified = Wrapper.wrap(this.modified);
        String result = MergeableManifest.mergeIntoCommaSeparatedList(s, packages, modified, this.lineDelimiter);
        this.modified = modified.get();
        this.getMainAttributes().put(IMPORT_PACKAGE, result);
    }

    protected static String[] splitQuoteAware(String string) {
        ArrayList result = Lists.newArrayList((Object[])new StringBuilder[]{new StringBuilder()});
        boolean inQuote = false;
        block4: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case ',': {
                    if (inQuote) {
                        ((StringBuilder)result.get(result.size() - 1)).append(string.charAt(i));
                        continue block4;
                    }
                    result.add(new StringBuilder());
                    continue block4;
                }
                case '\"': {
                    inQuote = !inQuote;
                }
                default: {
                    ((StringBuilder)result.get(result.size() - 1)).append(string.charAt(i));
                }
            }
        }
        String[] resultArray = new String[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            resultArray[i] = ((StringBuilder)result.get(i)).toString();
        }
        return resultArray;
    }

    @Deprecated
    public static String mergeIntoCommaSeparatedList(String currentString, Set<String> toMergeIn, Wrapper<Boolean> modified) {
        return MergeableManifest.mergeIntoCommaSeparatedList(currentString, toMergeIn, modified, LINEBREAK);
    }

    public static String mergeIntoCommaSeparatedList(String currentString, Set<String> toMergeIn, Wrapper<Boolean> modified, String lineDelimiter) {
        Pair<String, String> nameParameter;
        String string = currentString == null ? "" : currentString;
        String[] split = MergeableManifest.splitQuoteAware(string);
        LinkedHashMap<String, String> name2parameters = new LinkedHashMap<String, String>();
        for (int i = 0; i < split.length; ++i) {
            String value = split[i].trim();
            if (value.equals("")) continue;
            nameParameter = MergeableManifest.getSplitEntry(value);
            name2parameters.put(nameParameter.getFirst(), nameParameter.getSecond());
        }
        for (String value : toMergeIn) {
            String existingParameter;
            if (value.trim().equals("") || (existingParameter = (String)name2parameters.get((nameParameter = MergeableManifest.getSplitEntry(value.trim())).getFirst())) != null) continue;
            boolean newModified = modified.get();
            modified.set(newModified |= name2parameters.put(nameParameter.getFirst(), nameParameter.getSecond()) != null);
        }
        StringBuffer buff = new StringBuffer(string.length());
        Iterator iterator = name2parameters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            buff.append((String)entry.getKey());
            if (entry.getValue() != null) {
                buff.append(";").append((String)entry.getValue());
            }
            if (!iterator.hasNext()) continue;
            buff.append("," + lineDelimiter + " ");
        }
        String result = buff.toString();
        return result;
    }

    protected static Pair<String, String> getSplitEntry(String entry) {
        String parameter;
        String name;
        int semicolon = entry.indexOf(59);
        if (semicolon == -1) {
            name = entry;
            parameter = null;
        } else {
            name = entry.substring(0, semicolon);
            parameter = entry.substring(semicolon + 1);
        }
        return Tuples.create(name, parameter);
    }

    public void addImportedPackages(String ... packages) {
        this.addImportedPackages(Sets.newHashSet((Object[])packages));
    }

    @Override
    public OrderAwareAttributes getMainAttributes() {
        return (OrderAwareAttributes)super.getMainAttributes();
    }

    public class OrderAwareAttributes
    extends Attributes {
        public OrderAwareAttributes() {
            try {
                Field field = Attributes.class.getDeclaredField("map");
                field.setAccessible(true);
                field.set(this, new LinkedHashMap());
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public Object put(Object name, Object value) {
            Object result = super.put(name, value);
            if (result != null && !result.equals(value)) {
                MergeableManifest.this.modified = true;
            }
            return result;
        }

        public void myWriteMain(DataOutputStream out) throws IOException {
            String vername = Attributes.Name.MANIFEST_VERSION.toString();
            String version = this.getValue(vername);
            if (version == null) {
                vername = Attributes.Name.SIGNATURE_VERSION.toString();
                version = this.getValue(vername);
            }
            if (version != null) {
                out.writeBytes(vername + ": " + version + MergeableManifest.this.lineDelimiter);
            }
            Iterator<Map.Entry<Object, Object>> it = this.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> e = it.next();
                String value = (String)e.getValue();
                if (Strings.isEmpty(value)) continue;
                String name = ((Attributes.Name)e.getKey()).toString();
                if (version == null || name.equalsIgnoreCase(vername)) continue;
                StringBuffer buffer = new StringBuffer(name);
                buffer.append(": ");
                byte[] vb = value.trim().getBytes("UTF8");
                value = new String(vb, 0, 0, vb.length);
                buffer.append(value);
                if (it.hasNext()) {
                    buffer.append(MergeableManifest.this.lineDelimiter);
                }
                out.writeBytes(MergeableManifest.make512Safe(buffer, MergeableManifest.this.lineDelimiter));
            }
            out.writeBytes(MergeableManifest.this.lineDelimiter);
        }

        public void myWrite(DataOutputStream out) throws IOException {
            Iterator<Map.Entry<Object, Object>> it = this.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> e = it.next();
                String value = (String)e.getValue();
                if (!Strings.isEmpty(value)) continue;
                StringBuffer buffer = new StringBuffer(((Attributes.Name)e.getKey()).toString());
                buffer.append(": ");
                byte[] vb = value.trim().getBytes("UTF8");
                value = new String(vb, 0, 0, vb.length);
                buffer.append(value);
                if (it.hasNext()) {
                    buffer.append(MergeableManifest.this.lineDelimiter);
                }
                out.writeBytes(MergeableManifest.make512Safe(buffer, MergeableManifest.this.lineDelimiter));
            }
            out.writeBytes(MergeableManifest.this.lineDelimiter);
        }
    }
}

