/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import com.google.common.base.Objects;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Manifest;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;

@Data
public class XtextVersion {
    private final String version;

    public static XtextVersion getCurrent() {
        String _elvis = null;
        String _readVersionFromManifest = XtextVersion.readVersionFromManifest();
        _elvis = _readVersionFromManifest != null ? _readVersionFromManifest : "unknown";
        return new XtextVersion(_elvis);
    }

    public String getXtextGradlePluginVersion() {
        return "2.0.8";
    }

    public String getMweVersion() {
        return "2.11.0";
    }

    public String getAntlrGeneratorVersion() {
        return "2.1.1";
    }

    public String getXtendGradlePluginVersion() {
        return this.getXtextGradlePluginVersion();
    }

    public String getXtendAndroidGradlePluginVersion() {
        return this.getXtendGradlePluginVersion();
    }

    public boolean isSnapshot() {
        return this.version.endsWith("-SNAPSHOT");
    }

    public boolean isStable() {
        return !this.isSnapshot() && !this.version.matches("\\d+\\.\\d+(\\.\\d+)+");
    }

    public String toString() {
        return this.version;
    }

    private static String readVersionFromManifest() {
        InputStream is = null;
        try {
            URL _baseURL = Plugin.INSTANCE.getBaseURL();
            String _plus = _baseURL + "META-INF/MANIFEST.MF";
            URL url = new URL(_plus);
            is = url.openStream();
            Manifest manifest = new Manifest(is);
            String version = manifest.getMainAttributes().getValue("Maven-Version");
            boolean _equals = Objects.equal((Object)"unspecified", (Object)version);
            if (_equals) {
                version = manifest.getMainAttributes().getValue("Bundle-Version");
                boolean _endsWith = version.endsWith(".qualifier");
                if (_endsWith) {
                    String string = version.replace(".qualifier", "-SNAPSHOT");
                    return string;
                }
                String string = version.substring(0, version.lastIndexOf("."));
                return string;
            }
            String string = version;
            return string;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                String string = null;
                return string;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        finally {
            block22: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable _t_1) {
                        if (_t_1 instanceof IOException) break block22;
                        throw Exceptions.sneakyThrow((Throwable)_t_1);
                    }
                }
            }
        }
    }

    public XtextVersion(String version) {
        this.version = version;
    }

    @Pure
    public int hashCode() {
        return 31 + (this.version == null ? 0 : this.version.hashCode());
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XtextVersion other = (XtextVersion)obj;
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    @Pure
    public String getVersion() {
        return this.version;
    }

    private static class Plugin
    extends EMFPlugin {
        public static final Plugin INSTANCE = new Plugin();

        private Plugin() {
            super(new ResourceLocator[0]);
        }

        public ResourceLocator getPluginResourceLocator() {
            return null;
        }
    }
}

