/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.formallang;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtext.util.GraphvizDotBuilder;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaUtil;
import org.eclipse.xtext.util.formallang.Production;
import org.eclipse.xtext.util.formallang.ProductionFactory;
import org.eclipse.xtext.util.formallang.ProductionFormatter;
import org.eclipse.xtext.util.formallang.ProductionUtil;

public class NfaToProduction {
    private boolean excludeStartAndStop = false;

    protected <T> boolean createAlternative(StateAliasNfa<T> states) {
        boolean created = false;
        LinkedHashMultimap alternative = LinkedHashMultimap.create();
        for (StateAlias candidate : new NfaUtil().collect(states)) {
            if (candidate.getIncoming().isEmpty() || candidate.getOutgoing().isEmpty()) continue;
            alternative.put(Tuples.create(candidate.getIncoming(), candidate.getOutgoing()), (Object)candidate);
        }
        for (Pair inout : alternative.keySet()) {
            boolean single;
            Collection candidates = alternative.get((Object)inout);
            if (candidates.size() < 2) continue;
            boolean many = ((Set)inout.getFirst()).containsAll(candidates) && ((Set)inout.getSecond()).containsAll(candidates);
            boolean bl = single = !Iterables.any((Iterable)((Iterable)inout.getFirst()), (Predicate)Predicates.in((Collection)candidates)) && !Iterables.any((Iterable)((Iterable)inout.getSecond()), (Predicate)Predicates.in((Collection)candidates));
            if (!many && !single) continue;
            AlternativeAlias alt = new AlternativeAlias();
            alt.setMany(many);
            StateAlias altState = new StateAlias(alt);
            for (StateAlias candidate : candidates) {
                alt.addChild(candidate.getElement());
                for (StateAlias in : candidate.getIncoming()) {
                    in.getOutgoing().remove(candidate);
                }
                for (StateAlias out : candidate.getOutgoing()) {
                    out.getIncoming().remove(candidate);
                }
            }
            for (StateAlias in : (Set)inout.getFirst()) {
                if (candidates.contains(in)) continue;
                altState.getIncoming().add(in);
                in.getOutgoing().add(altState);
            }
            for (StateAlias out : (Set)inout.getSecond()) {
                if (candidates.contains(out)) continue;
                altState.getOutgoing().add(out);
                out.getIncoming().add(altState);
            }
            created = true;
        }
        return created;
    }

    protected <T> void createGroup(StateAlias<T> first, StateAlias<T> second) {
        GroupAlias group = new GroupAlias();
        if (first.getElement() instanceof GroupAlias && first.getElement().isOne()) {
            group.getChildren().addAll(((GroupAlias)first.getElement()).getChildren());
        } else {
            group.addChild(first.getElement());
        }
        if (second.getElement() instanceof GroupAlias && second.getElement().isOne()) {
            group.getChildren().addAll(((GroupAlias)second.getElement()).getChildren());
        } else {
            group.addChild(second.getElement());
        }
        first.element = group;
        first.getOutgoing().clear();
        first.absorbOutgoing(second);
    }

    protected <T> boolean createGroups(StateAlias<T> state, Set<StateAlias<T>> visited) {
        StateAlias<T> follower;
        if (!visited.add(state)) {
            return false;
        }
        boolean created = false;
        if (state.getOutgoing().size() == 1 && state.getOutgoing().iterator().next().getIncoming().size() == 1 && state != (follower = state.getOutgoing().iterator().next())) {
            this.createGroup(state, follower);
            created = true;
        }
        for (StateAlias<T> out : state.getOutgoing()) {
            if (!this.createGroups(out, visited)) continue;
            created = true;
        }
        return created;
    }

    protected <T> boolean createMany(StateAlias<T> state, Set<StateAlias<T>> visited) {
        if (!visited.add(state)) {
            return false;
        }
        boolean created = false;
        if (state.getOutgoing().contains(state)) {
            state.getElement().setMany(true);
            state.getOutgoing().remove(state);
            state.getIncoming().remove(state);
            created = true;
        }
        for (StateAlias<T> out : state.getOutgoing()) {
            if (!this.createMany(out, visited)) continue;
            created = true;
        }
        return created;
    }

    protected <T> boolean mergeOptionalIntoMany(StateAlias<T> state, Set<StateAlias<T>> visited) {
        if (!visited.add(state)) {
            return false;
        }
        boolean merged = false;
        if (state.getElement().isMany()) {
            for (StateAlias out : ImmutableList.copyOf(state.getOutgoing())) {
                if (!state.getIncoming().contains(out) || !this.isOptionalIgnoring(out, state)) continue;
                this.mergeOptionalIntoMany(state, out);
                merged = true;
            }
            for (StateAlias in : ImmutableList.copyOf(state.getIncoming())) {
                if (!state.getOutgoing().contains(in) || !this.isOptionalIgnoring(in, state)) continue;
                this.mergeOptionalIntoMany(in, state);
                merged = true;
            }
        }
        for (StateAlias out : ImmutableList.copyOf(state.getOutgoing())) {
            if (!this.mergeOptionalIntoMany(out, visited)) continue;
            merged = true;
        }
        return merged;
    }

    protected <T> boolean isOptionalIgnoring(StateAlias<T> cand, StateAlias<T> ignored) {
        if (cand.getIncoming().isEmpty() || cand.getOutgoing().isEmpty()) {
            return false;
        }
        for (StateAlias<T> in : cand.getIncoming()) {
            if (in.equals(ignored) || in.getOutgoing().containsAll(cand.getOutgoing())) continue;
            return false;
        }
        return true;
    }

    protected <T> void mergeOptionalIntoMany(StateAlias<T> first, StateAlias<T> second) {
        StateAlias<T> optional;
        StateAlias<T> many = first.element.isMany() ? first : second;
        StateAlias<T> stateAlias = optional = many == first ? second : first;
        if (optional.getOutgoing().contains(optional)) {
            optional.element.setMany(true);
        }
        many.element.setMany(false);
        optional.element.setOptional(true);
        for (StateAlias<T> out : optional.getOutgoing()) {
            out.getIncoming().remove(optional);
        }
        for (StateAlias<T> in : optional.getIncoming()) {
            in.getOutgoing().remove(optional);
        }
        GroupAlias group = new GroupAlias();
        group.setMany(true);
        if (first.element instanceof GroupAlias && !first.element.many && !first.element.optional) {
            group.children.addAll(((GroupAlias)first.element).children);
        } else {
            group.addChild(first.getElement());
        }
        if (second.element instanceof GroupAlias && !second.element.many && !second.element.optional) {
            group.children.addAll(((GroupAlias)second.element).children);
        } else {
            group.addChild(second.element);
        }
        many.element = group;
    }

    protected <T> boolean mergeAlternativeMultiples(StateAlias<T> state, Set<StateAlias<T>> visited) {
        if (!visited.add(state)) {
            return false;
        }
        boolean merged = false;
        if (state.getElement().isMany()) {
            for (StateAlias out : ImmutableList.copyOf(state.getOutgoing())) {
                if (!this.areAlternativeMultiples(state, out)) continue;
                this.mergeAlternativeMultiples(state, out);
                merged = true;
            }
        }
        for (StateAlias out : ImmutableList.copyOf(state.getOutgoing())) {
            if (!this.mergeAlternativeMultiples(out, visited)) continue;
            merged = true;
        }
        return merged;
    }

    protected <T> boolean areAlternativeMultiples(StateAlias<T> first, StateAlias<T> second) {
        if (!first.getElement().isMany() || !second.getElement().isMany()) {
            return false;
        }
        if (!first.getOutgoing().contains(second) || !first.getIncoming().contains(second)) {
            return false;
        }
        for (StateAlias<T> in : first.getIncoming()) {
            if (in.equals(second) || second.getIncoming().contains(in)) continue;
            return false;
        }
        for (StateAlias<T> out : first.getOutgoing()) {
            if (out.equals(second) || second.getOutgoing().contains(out)) continue;
            return false;
        }
        return true;
    }

    protected <T> void mergeAlternativeMultiples(StateAlias<T> first, StateAlias<T> second) {
        first.element.many = false;
        second.element.many = false;
        AlternativeAlias alternative = new AlternativeAlias();
        alternative.many = true;
        if (first.element instanceof AlternativeAlias) {
            alternative.getChildren().addAll(((AlternativeAlias)first.element).children);
        } else {
            alternative.addChild(first.getElement());
        }
        if (second.element instanceof AlternativeAlias) {
            alternative.getChildren().addAll(((AlternativeAlias)second.element).children);
        } else {
            alternative.addChild(second.element);
        }
        if (first.element.optional || second.element.optional) {
            alternative.optional = true;
        }
        first.element = alternative;
        for (StateAlias<T> out : second.getOutgoing()) {
            out.getIncoming().remove(second);
        }
        for (StateAlias<T> in : second.getIncoming()) {
            in.getOutgoing().remove(second);
        }
    }

    protected <STATE, TOKEN> StateAliasNfa<TOKEN> createNfa(Nfa<STATE> nfa, Function<STATE, TOKEN> state2token) {
        LinkedHashMap cache = Maps.newLinkedHashMap();
        StateAlias<Object> stop = null;
        if (nfa.getStart() != nfa.getStop()) {
            stop = new StateAlias<Object>(new ElementAlias<Object>(state2token.apply(nfa.getStop())));
            cache.put(nfa.getStop(), stop);
        }
        StateAlias<TOKEN> start = this.toAlias(nfa, state2token, nfa.getStart(), cache);
        if (nfa.getStart() == nfa.getStop()) {
            stop = new StateAlias<TOKEN>(start.getElement());
            for (StateAlias<TOKEN> in : start.getIncoming()) {
                stop.getIncoming().add(in);
                in.getOutgoing().add(stop);
                in.getOutgoing().remove(start);
            }
            start.getIncoming().clear();
        }
        StateAliasNfa<Object> states = new StateAliasNfa<Object>(start, stop);
        return states;
    }

    protected <T> boolean createOptional(StateAliasNfa<T> states) {
        ArrayList opt = Lists.newArrayList();
        block0: for (StateAlias cand : new NfaUtil().collect(states)) {
            if (cand.getIncoming().isEmpty() || cand.getOutgoing().isEmpty()) continue;
            for (StateAlias<Object> stateAlias : cand.getIncoming()) {
                if (stateAlias.getOutgoing().containsAll(cand.getOutgoing())) continue;
                continue block0;
            }
            opt.add(cand);
        }
        for (StateAlias o : opt) {
            o.getElement().setOptional(true);
            for (StateAlias<Object> stateAlias : Lists.newArrayList(o.getIncoming())) {
                if (stateAlias == o) continue;
                for (StateAlias out : Lists.newArrayList(o.getOutgoing())) {
                    if (out == o) continue;
                    out.getIncoming().remove(stateAlias);
                    stateAlias.getOutgoing().remove(out);
                }
            }
        }
        return !opt.isEmpty();
    }

    protected <T> Pair<Integer, StateAlias<T>> findSplitState(StateAlias<T> state, Integer depth, Set<StateAlias<T>> visited) {
        if (!visited.add(state)) {
            return null;
        }
        Pair<Integer, StateAlias<Integer>> result = state.getOutgoing().size() > 0 && state.getIncoming().size() > 0 && state.getOutgoing().size() + state.getIncoming().size() > 2 ? Tuples.create(depth, state) : null;
        for (StateAlias<T> out : state.getOutgoing()) {
            Pair<Integer, StateAlias<T>> cand = this.findSplitState(out, depth + 1, visited);
            if (cand == null || result != null && !this.isPreferredSplitState(cand, result)) continue;
            result = cand;
        }
        return result;
    }

    protected <T> boolean isPreferredSplitState(Pair<Integer, StateAlias<T>> state1, Pair<Integer, StateAlias<T>> state2) {
        int size2;
        int count2;
        int count1 = state1.getSecond().getElement().getElementCount();
        if (count1 != (count2 = state2.getSecond().getElement().getElementCount())) {
            return count1 < count2;
        }
        int size1 = state1.getSecond().getOutgoing().size() + state1.getSecond().getIncoming().size();
        if (size1 != (size2 = state2.getSecond().getOutgoing().size() + state2.getSecond().getIncoming().size())) {
            return size1 < size2;
        }
        return state1.getFirst() > state2.getFirst();
    }

    public <ELEMENT, STATE, TOKEN> ELEMENT nfaToGrammar(Nfa<STATE> nfa, Function<STATE, TOKEN> state2token, ProductionFactory<ELEMENT, TOKEN> grammarFactory) {
        return this.nfaToGrammar(nfa, state2token, null, grammarFactory);
    }

    public <ELEMENT, STATE, TOKEN> ELEMENT nfaToGrammar(Nfa<STATE> nfa, Function<STATE, TOKEN> state2token, Comparator<? super TOKEN> order, ProductionFactory<ELEMENT, TOKEN> grammarFactory) {
        StateAliasNfa<TOKEN> states = this.createNfa(nfa, state2token);
        boolean changed = true;
        while (!((StateAlias)states.getStart()).getOutgoing().isEmpty() && changed) {
            Pair splitState;
            while (!((StateAlias)states.getStart()).getOutgoing().isEmpty() && changed) {
                changed = this.createAlternative(states);
                changed |= this.createOptional(states);
                changed |= this.createMany((StateAlias)states.getStart(), Sets.newHashSet());
                changed |= this.createGroups((StateAlias)states.getStart(), Sets.newHashSet());
                changed |= this.mergeOptionalIntoMany((StateAlias)states.getStart(), Sets.newHashSet());
                changed |= this.mergeAlternativeMultiples((StateAlias)states.getStart(), Sets.newHashSet());
            }
            if (((StateAlias)states.getStart()).getOutgoing().isEmpty() || (splitState = this.findSplitState((StateAlias)states.getStart(), 0, Sets.newHashSet())) == null) continue;
            changed = true;
            this.splitState(splitState.getSecond());
        }
        AbstractElementAlias root = ((StateAlias)states.getStart()).getElement();
        if (this.excludeStartAndStop) {
            root = this.removeStartAndStop(nfa, state2token, root);
        }
        this.normalize(root);
        if (order != null) {
            root.sort(new ElementAliasComparator<TOKEN>(order));
        }
        AliasGrammarProvider production = new AliasGrammarProvider(root);
        return new ProductionUtil().clone(production, grammarFactory);
    }

    protected <TOKEN, STATE> AbstractElementAlias<TOKEN> removeStartAndStop(Nfa<STATE> nfa, Function<STATE, TOKEN> state2token, AbstractElementAlias<TOKEN> root) {
        GroupAlias group;
        Collection children;
        if (this.excludeStartAndStop && root instanceof GroupAlias && (children = (group = (GroupAlias)root).getChildren()).size() > 1) {
            AbstractElementAlias first = (AbstractElementAlias)children.get(0);
            AbstractElementAlias last = (AbstractElementAlias)children.get(children.size() - 1);
            if (first instanceof ElementAlias && last instanceof ElementAlias) {
                Object startToken = state2token.apply(nfa.getStart());
                Object stopToken = state2token.apply(nfa.getStop());
                Object firstToken = ((ElementAlias)first).getElement();
                Object lastToken = ((ElementAlias)last).getElement();
                if (firstToken == startToken && lastToken == stopToken) {
                    if (children.size() == 3) {
                        return (AbstractElementAlias)children.get(1);
                    }
                    children.remove(children.size() - 1);
                    children.remove(0);
                    return root;
                }
            }
        }
        return root;
    }

    protected <T> boolean collectMergeableOptions(boolean root, AbstractElementAlias<T> alt, List<AbstractElementAlias<T>> result) {
        boolean optional = alt.optional;
        if ((root || !alt.isMany()) && alt instanceof AlternativeAlias) {
            for (AbstractElementAlias child : ((AlternativeAlias)alt).getChildren()) {
                optional |= this.collectMergeableOptions(false, child, result);
            }
        } else {
            result.add(alt);
            alt.optional = false;
        }
        return optional;
    }

    protected <T> void normalize(AbstractElementAlias<T> element) {
        if (element instanceof AlternativeAlias) {
            AlternativeAlias alt = (AlternativeAlias)element;
            ArrayList mergeable = Lists.newArrayList();
            alt.optional = this.collectMergeableOptions(true, element, mergeable);
            alt.children = Sets.newLinkedHashSet((Iterable)mergeable);
        }
        for (AbstractElementAlias<T> child : element.getChildren()) {
            this.normalize(child);
        }
    }

    public <ELEMENT, STATE> ELEMENT nfaToGrammar(Nfa<STATE> nfa, ProductionFactory<ELEMENT, STATE> grammarFactory) {
        return this.nfaToGrammar(nfa, Functions.identity(), grammarFactory);
    }

    public NfaToProduction excludeStartAndStop() {
        this.excludeStartAndStop = true;
        return this;
    }

    protected <T> void splitState(StateAlias<T> state) {
        if (state.getIncoming().size() >= state.getOutgoing().size()) {
            for (StateAlias stateAlias : Lists.newArrayList(state.getIncoming())) {
                StateAlias<T> rep = new StateAlias<T>(state.getElement());
                rep.getIncoming().add(stateAlias);
                rep.getOutgoing().addAll(state.getOutgoing());
                stateAlias.getOutgoing().add(rep);
                stateAlias.getOutgoing().remove(state);
                for (StateAlias<T> out : state.getOutgoing()) {
                    out.getIncoming().add(rep);
                }
            }
            for (StateAlias stateAlias : state.getOutgoing()) {
                stateAlias.getIncoming().remove(state);
            }
        } else {
            for (StateAlias stateAlias : Lists.newArrayList(state.getOutgoing())) {
                StateAlias<T> rep = new StateAlias<T>(state.getElement());
                rep.getOutgoing().add(stateAlias);
                rep.getIncoming().addAll(state.getIncoming());
                stateAlias.getIncoming().add(rep);
                stateAlias.getIncoming().remove(state);
                for (StateAlias<T> in : state.getIncoming()) {
                    in.getOutgoing().add(rep);
                }
            }
            for (StateAlias stateAlias : state.getIncoming()) {
                stateAlias.getOutgoing().remove(state);
            }
        }
        state.getOutgoing().clear();
        state.getIncoming().clear();
    }

    protected <STATE, TOKEN> StateAlias<TOKEN> toAlias(Nfa<STATE> nfa, Function<STATE, TOKEN> state2token, STATE state, Map<STATE, StateAlias<TOKEN>> cache) {
        StateAlias<Object> result = cache.get(state);
        if (result != null) {
            return result;
        }
        result = new StateAlias<Object>(new ElementAlias<Object>(state2token.apply(state)));
        cache.put(state, result);
        for (STATE follower : nfa.getFollowers(state)) {
            StateAlias<TOKEN> followerState = this.toAlias(nfa, state2token, follower, cache);
            result.getOutgoing().add(followerState);
            followerState.getIncoming().add(result);
        }
        return result;
    }

    protected static class StatesToDot<T>
    extends GraphvizDotBuilder {
        protected StatesToDot() {
        }

        @Override
        protected GraphvizDotBuilder.Props drawObject(Object obj) {
            if (obj instanceof StateAlias) {
                GraphvizDotBuilder.Digraph dg = new GraphvizDotBuilder.Digraph();
                this.drawState(dg, (StateAlias)obj, Maps.newHashMap());
                return dg;
            }
            return null;
        }

        protected GraphvizDotBuilder.Node drawState(GraphvizDotBuilder.Digraph dg, StateAlias<T> state, Map<StateAlias<T>, GraphvizDotBuilder.Node> nodes) {
            GraphvizDotBuilder.Node n = nodes.get(state);
            if (n != null) {
                return n;
            }
            n = new GraphvizDotBuilder.Node(state, state.getElement().toString());
            nodes.put(state, n);
            dg.add(n);
            for (StateAlias<T> follower : state.getOutgoing()) {
                this.drawState(dg, follower, nodes);
                GraphvizDotBuilder.Edge e = new GraphvizDotBuilder.Edge(state, follower);
                e.put("arrowhead", "onormal");
                dg.add(e);
            }
            return n;
        }
    }

    protected static class StateAliasNfa<TOKEN>
    implements Nfa<StateAlias<TOKEN>> {
        protected StateAlias<TOKEN> start;
        protected StateAlias<TOKEN> stop;

        public StateAliasNfa(StateAlias<TOKEN> start, StateAlias<TOKEN> stop) {
            this.start = start;
            this.stop = stop;
        }

        @Override
        public Iterable<StateAlias<TOKEN>> getFollowers(StateAlias<TOKEN> state) {
            return state.getOutgoing();
        }

        @Override
        public StateAlias<TOKEN> getStart() {
            return this.start;
        }

        @Override
        public StateAlias<TOKEN> getStop() {
            return this.stop;
        }
    }

    protected static class StateAlias<TOKEN> {
        protected AbstractElementAlias<TOKEN> element;
        protected Set<StateAlias<TOKEN>> incoming = Sets.newLinkedHashSet();
        protected Set<StateAlias<TOKEN>> outgoing = Sets.newLinkedHashSet();

        protected StateAlias(AbstractElementAlias<TOKEN> element) {
            this.element = element;
        }

        public void absorbIncoming(StateAlias<TOKEN> state) {
            for (StateAlias<TOKEN> in : state.incoming) {
                in.outgoing.remove(state);
                in.outgoing.add(this);
                this.incoming.add(in);
            }
        }

        public void absorbOutgoing(StateAlias<TOKEN> state) {
            for (StateAlias<TOKEN> out : state.outgoing) {
                out.incoming.remove(state);
                out.incoming.add(this);
                this.outgoing.add(out);
            }
        }

        public void addOutgoing(StateAlias<TOKEN> state) {
            this.outgoing.add(state);
            state.incoming.add(this);
        }

        protected AbstractElementAlias<TOKEN> getElement() {
            return this.element;
        }

        protected Set<StateAlias<TOKEN>> getIncoming() {
            return this.incoming;
        }

        protected Set<StateAlias<TOKEN>> getOutgoing() {
            return this.outgoing;
        }

        public String toString() {
            return "S(" + this.element + ")";
        }
    }

    protected static class GroupAlias<T>
    extends AbstractElementAlias<T> {
        protected List<AbstractElementAlias<T>> children = Lists.newArrayList();

        public GroupAlias() {
        }

        public GroupAlias(boolean optional, boolean many, AbstractElementAlias<T> ... children) {
            super(optional, many);
            Collections.addAll(this.children, children);
        }

        public void addChild(AbstractElementAlias<T> child) {
            if (child == this) {
                throw new RuntimeException();
            }
            this.children.add(child);
        }

        @Override
        public List<AbstractElementAlias<T>> getChildren() {
            return this.children;
        }

        @Override
        protected int getElementCount() {
            int result = 1;
            for (AbstractElementAlias<T> child : this.children) {
                result += child.getElementCount();
            }
            return result;
        }

        @Override
        protected void sort(Comparator<? super AbstractElementAlias<T>> comparator) {
            for (AbstractElementAlias<T> child : this.children) {
                child.sort(comparator);
            }
        }

        @Override
        protected T getFirstElement() {
            return this.children.get(0).getFirstElement();
        }
    }

    protected static class ElementAlias<T>
    extends AbstractElementAlias<T> {
        protected T element;

        public ElementAlias(boolean optional, boolean many, T element) {
            super(optional, many);
            this.element = element;
        }

        public ElementAlias(T element) {
            this.element = element;
        }

        public T getElement() {
            return this.element;
        }

        @Override
        protected int getElementCount() {
            return 1;
        }

        @Override
        protected void sort(Comparator<? super AbstractElementAlias<T>> comparator) {
        }

        @Override
        protected T getFirstElement() {
            return this.element;
        }

        @Override
        public Collection<AbstractElementAlias<T>> getChildren() {
            return Collections.emptyList();
        }
    }

    protected static class AlternativeAlias<T>
    extends AbstractElementAlias<T> {
        protected Set<AbstractElementAlias<T>> children = Sets.newLinkedHashSet();

        public AlternativeAlias() {
        }

        public AlternativeAlias(boolean optional, boolean many, AbstractElementAlias<T> ... children) {
            super(optional, many);
            Collections.addAll(this.children, children);
        }

        public void addChild(AbstractElementAlias<T> child) {
            if (child == this) {
                throw new RuntimeException();
            }
            this.children.add(child);
        }

        @Override
        public Set<AbstractElementAlias<T>> getChildren() {
            return this.children;
        }

        @Override
        protected int getElementCount() {
            int result = 1;
            for (AbstractElementAlias<T> child : this.children) {
                result += child.getElementCount();
            }
            return result;
        }

        @Override
        protected void sort(Comparator<? super AbstractElementAlias<T>> comparator) {
            for (AbstractElementAlias<T> child : this.children) {
                child.sort(comparator);
            }
            ArrayList sorting = Lists.newArrayList(this.children);
            Collections.sort(sorting, comparator);
            this.children = Sets.newLinkedHashSet((Iterable)sorting);
        }

        @Override
        protected T getFirstElement() {
            return this.children.iterator().next().getFirstElement();
        }
    }

    protected static class AliasGrammarProvider<TOKEN>
    implements Production<AbstractElementAlias<TOKEN>, TOKEN> {
        protected AbstractElementAlias<TOKEN> root;

        public AliasGrammarProvider(AbstractElementAlias<TOKEN> root) {
            this.root = root;
        }

        @Override
        public Iterable<AbstractElementAlias<TOKEN>> getAlternativeChildren(AbstractElementAlias<TOKEN> ele) {
            return ele instanceof AlternativeAlias ? ((AlternativeAlias)ele).getChildren() : null;
        }

        @Override
        public AbstractElementAlias<TOKEN> getParent(AbstractElementAlias<TOKEN> ele) {
            return null;
        }

        @Override
        public AbstractElementAlias<TOKEN> getRoot() {
            return this.root;
        }

        @Override
        public Iterable<AbstractElementAlias<TOKEN>> getSequentialChildren(AbstractElementAlias<TOKEN> ele) {
            return ele instanceof GroupAlias ? ((GroupAlias)ele).getChildren() : null;
        }

        @Override
        public TOKEN getToken(AbstractElementAlias<TOKEN> owner) {
            return owner instanceof ElementAlias ? (TOKEN)((ElementAlias)owner).getElement() : null;
        }

        @Override
        public Iterable<AbstractElementAlias<TOKEN>> getUnorderedChildren(AbstractElementAlias<TOKEN> ele) {
            return null;
        }

        @Override
        public boolean isMany(AbstractElementAlias<TOKEN> ele) {
            return ele.isMany();
        }

        @Override
        public boolean isOptional(AbstractElementAlias<TOKEN> ele) {
            return ele.isOptional();
        }
    }

    protected class ElementAliasComparator<T>
    implements Comparator<AbstractElementAlias<T>> {
        protected final Comparator<? super T> delegate;

        public ElementAliasComparator(Comparator<? super T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public int compare(AbstractElementAlias<T> o1, AbstractElementAlias<T> o2) {
            T e1 = o1.getFirstElement();
            T e2 = o2.getFirstElement();
            return this.delegate.compare(e1, e2);
        }
    }

    protected static abstract class AbstractElementAlias<T> {
        protected boolean many = false;
        protected boolean optional = false;

        protected AbstractElementAlias() {
        }

        protected AbstractElementAlias(boolean optional, boolean many) {
            this.optional = optional;
            this.many = many;
        }

        protected abstract int getElementCount();

        protected abstract void sort(Comparator<? super AbstractElementAlias<T>> var1);

        protected abstract T getFirstElement();

        public abstract Collection<AbstractElementAlias<T>> getChildren();

        public boolean isMany() {
            return this.many;
        }

        public boolean isOne() {
            return !this.optional && !this.many;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public void setMany(boolean many) {
            this.many = many;
        }

        public void setOptional(boolean optional) {
            this.optional = optional;
        }

        public String toString() {
            ProductionFormatter formatter = new ProductionFormatter();
            return (String)formatter.apply(new AliasGrammarProvider(this));
        }
    }
}

