/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import com.google.inject.ImplementedBy;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.util.IAcceptor;

@ImplementedBy(value=JavaIoFileSystemScanner.class)
public interface IFileSystemScanner {
    public void scan(URI var1, IAcceptor<URI> var2);

    public static class JavaIoFileSystemScanner
    implements IFileSystemScanner {
        @Override
        public void scan(URI root, IAcceptor<URI> acceptor) {
            String _fileString = root.toFileString();
            File file = new File(_fileString);
            this.scanRec(file, acceptor);
        }

        public void scanRec(File file, IAcceptor<URI> acceptor) {
            File _absoluteFile = file.getAbsoluteFile();
            java.net.URI _uRI = _absoluteFile.toURI();
            Path path = Paths.get(_uRI);
            java.net.URI _uri = path.toUri();
            String _string = _uri.toString();
            URI uri = URI.createURI((String)_string);
            acceptor.accept(uri);
            boolean _isDirectory = file.isDirectory();
            if (_isDirectory) {
                File[] _listFiles;
                for (File f : _listFiles = file.listFiles()) {
                    this.scanRec(f, acceptor);
                }
            }
        }
    }
}

