/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor;

import com.google.inject.Inject;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.XtextEditorInfo;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class LanguageSpecificURIEditorOpener
implements IURIEditorOpener {
    private static final Logger logger = Logger.getLogger(LanguageSpecificURIEditorOpener.class);
    @Inject
    private ILocationInFileProvider locationProvider;
    @Inject
    private IStorage2UriMapper mapper;
    @Inject
    private XtextEditorInfo editorInfo;
    @Inject(optional=true)
    private IWorkbench workbench;

    public void setLocationProvider(ILocationInFileProvider locationProvider) {
        this.locationProvider = locationProvider;
    }

    public ILocationInFileProvider getLocationProvider() {
        return this.locationProvider;
    }

    @Override
    public IEditorPart open(URI uri, boolean select) {
        return this.open(uri, null, -1, select);
    }

    @Override
    public IEditorPart open(final URI uri, final EReference crossReference, final int indexInList, final boolean select) {
        Iterator<Pair<IStorage, IProject>> storages = this.mapper.getStorages(uri.trimFragment()).iterator();
        if (storages != null && storages.hasNext()) {
            try {
                IStorage storage = (IStorage)storages.next().getFirst();
                IEditorInput editorInput = EditorUtils.createEditorInput(storage);
                IWorkbenchPage activePage = this.workbench.getActiveWorkbenchWindow().getActivePage();
                final IEditorPart editor = IDE.openEditor((IWorkbenchPage)activePage, (IEditorInput)editorInput, (String)this.getEditorId());
                Job selectAndRevealJob = new Job("Select and reveal referenced object"){

                    protected IStatus run(IProgressMonitor monitor) {
                        LanguageSpecificURIEditorOpener.this.selectAndReveal(editor, uri, crossReference, indexInList, select);
                        return Status.OK_STATUS;
                    }
                };
                selectAndRevealJob.setSystem(true);
                selectAndRevealJob.setPriority(20);
                selectAndRevealJob.schedule();
                return EditorUtils.getXtextEditor(editor);
            }
            catch (WrappedException e) {
                logger.error((Object)("Error while opening editor part for EMF URI '" + uri + "'"), e.getCause());
            }
            catch (PartInitException partInitException) {
                logger.error((Object)("Error while opening editor part for EMF URI '" + uri + "'"), (Throwable)partInitException);
            }
        }
        return null;
    }

    protected String getEditorId() {
        return this.editorInfo.getEditorId();
    }

    protected void selectAndReveal(IEditorPart openEditor, final URI uri, final EReference crossReference, final int indexInList, boolean select) {
        final XtextEditor xtextEditor = EditorUtils.getXtextEditor(openEditor);
        if (xtextEditor != null && select) {
            boolean success = false;
            int tries = 0;
            while (!success || tries >= 5) {
                try {
                    xtextEditor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                        public void process(XtextResource resource) throws Exception {
                            EObject object;
                            if (resource != null && (object = LanguageSpecificURIEditorOpener.this.findEObjectByURI(uri, resource)) != null) {
                                final ITextRegion location = crossReference != null ? LanguageSpecificURIEditorOpener.this.locationProvider.getSignificantTextRegion(object, (EStructuralFeature)crossReference, indexInList) : LanguageSpecificURIEditorOpener.this.locationProvider.getSignificantTextRegion(object);
                                LanguageSpecificURIEditorOpener.this.workbench.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        xtextEditor.selectAndReveal(location.getOffset(), location.getLength());
                                    }
                                });
                            }
                        }
                    });
                    success = true;
                }
                catch (OperationCanceledException operationCanceledException) {
                    ++tries;
                    continue;
                }
                catch (OperationCanceledError operationCanceledError) {
                    try {
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        ++tries;
                    }
                }
                ++tries;
            }
        }
    }

    protected EObject findEObjectByURI(URI uri, XtextResource resource) {
        if (uri.fragment() != null) {
            try {
                EObject result = resource.getEObject(uri.fragment());
                return result;
            }
            catch (IllegalArgumentException e) {
                logger.warn((Object)("Couldn't resolve EObject with URI '" + uri + "'. - " + e.getMessage()));
            }
            catch (WrappedException e) {
                logger.error((Object)("Error while resolving EObject with URI '" + uri + "'"), e.getCause());
            }
        }
        return null;
    }
}

