/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.contentassist.antlr.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.DFA;
import org.antlr.runtime.FailedPredicateException;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.Parser;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.LinkedHashSetWithoutNull;
import org.eclipse.xtext.parser.antlr.ITokenDefProvider;
import org.eclipse.xtext.parser.antlr.IUnorderedGroupHelper;
import org.eclipse.xtext.parser.antlr.TokenTool;
import org.eclipse.xtext.ui.editor.contentassist.antlr.FollowElement;
import org.eclipse.xtext.ui.editor.contentassist.antlr.LookAheadTerminal;
import org.eclipse.xtext.ui.editor.contentassist.antlr.LookAheadTerminalRuleCall;
import org.eclipse.xtext.ui.editor.contentassist.antlr.LookaheadKeyword;
import org.eclipse.xtext.ui.editor.contentassist.antlr.ObservableXtextTokenStream;
import org.eclipse.xtext.ui.editor.contentassist.antlr.internal.InfiniteRecursion;

public abstract class AbstractInternalContentAssistParser
extends Parser
implements ObservableXtextTokenStream.StreamListener,
ITokenDefProvider {
    private static final Logger logger = Logger.getLogger(AbstractInternalContentAssistParser.class);
    protected final List<EObject> grammarElements;
    protected final List<EObject> localTrace;
    protected final List<Integer> paramStack;
    protected int stackSize;
    protected final Set<FollowElement> followElements;
    protected ObservableXtextTokenStream.StreamListener delegate;
    protected List<TerminalRule> terminalRules;
    protected boolean mismatch;
    protected RecoveryListener recoveryListener;
    protected int lookAheadAddOn;
    protected int marked = 0;
    protected boolean resyncing = false;
    protected boolean strict = false;
    protected int wasErrorCount = -1;
    protected int predictionLevel = 0;
    protected int currentMarker;
    protected int firstMarker;
    protected boolean inMismatchIsUnwantedToken = false;
    protected boolean failedPredicateAtEOF = false;
    protected Multimap<Integer, AbstractElement> indexToHandledElements;
    protected IUnorderedGroupHelper unorderedGroupHelper;
    protected IFollowElementFactory followElementFactory = new DefaultFollowElementFactory();

    public AbstractInternalContentAssistParser(TokenStream input, RecognizerSharedState state) {
        super(input, state);
        this.grammarElements = new ArrayList<EObject>();
        this.localTrace = new ArrayList<EObject>();
        this.paramStack = new ArrayList<Integer>();
        this.followElements = new LinkedHashSetWithoutNull();
    }

    public AbstractInternalContentAssistParser(TokenStream input) {
        super(input);
        this.grammarElements = new ArrayList<EObject>();
        this.localTrace = new ArrayList<EObject>();
        this.followElements = new LinkedHashSetWithoutNull();
        this.paramStack = new ArrayList<Integer>();
    }

    protected int getLookaheadThreshold() {
        return Integer.MAX_VALUE;
    }

    public void before(EObject grammarElement) {
        List<EObject> secondRun;
        List<EObject> firstRun;
        List<EObject> traceAfterFirstOccurrence;
        int secondIdx;
        int idx;
        if (this.input.size() == this.input.index() && (idx = this.localTrace.indexOf(grammarElement)) >= 0 && idx != this.localTrace.size() - 1 && (secondIdx = (traceAfterFirstOccurrence = this.localTrace.subList(idx + 1, this.localTrace.size())).indexOf(grammarElement)) >= 0 && secondIdx != traceAfterFirstOccurrence.size() - 1 && (firstRun = this.localTrace.subList(idx, idx + 1 + secondIdx)).equals(secondRun = traceAfterFirstOccurrence.subList(secondIdx, traceAfterFirstOccurrence.size()))) {
            throw new InfiniteRecursion();
        }
        this.grammarElements.add(grammarElement);
        this.localTrace.add(grammarElement);
    }

    public void before(EObject grammarElement, int paramConfig) {
        this.before(grammarElement);
        this.paramStack.add(paramConfig);
    }

    public void after(EObject grammarElement, int paramConfig) {
        int old = this.paramStack.remove(this.paramStack.size() - 1);
        if (old != paramConfig) {
            throw new IllegalStateException(String.valueOf(paramConfig) + "!=" + old);
        }
        this.after(grammarElement);
    }

    public void after(EObject grammarElement) {
        int index;
        EObject foundGrammarElement = this.grammarElements.remove(this.grammarElements.size() - 1);
        if (grammarElement != foundGrammarElement) {
            throw new IllegalStateException("expected element: '" + grammarElement + "', but was: '" + foundGrammarElement + "'");
        }
        if (grammarElement instanceof UnorderedGroup && this.indexToHandledElements != null) {
            this.indexToHandledElements.removeAll((Object)this.grammarElements.size());
        } else if (!this.grammarElements.isEmpty() && this.grammarElements.get(index = this.grammarElements.size() - 1) instanceof UnorderedGroup) {
            if (this.indexToHandledElements == null) {
                this.indexToHandledElements = LinkedHashMultimap.create();
            }
            this.indexToHandledElements.put((Object)index, (Object)((AbstractElement)grammarElement));
        }
    }

    public void recover(IntStream stream, RecognitionException ex) {
        if (this.recoveryListener != null) {
            this.recoveryListener.beginErrorRecovery();
        }
        this.removeUnexpectedElements();
        if (ex instanceof FailedPredicateException && ex.token.getType() == -1) {
            this.failedPredicateAtEOF = true;
        }
        super.recover(stream, ex);
        if (this.recoveryListener != null) {
            this.recoveryListener.endErrorRecovery();
        }
    }

    private void removeUnexpectedElements() {
        while (this.stackSize < this.grammarElements.size()) {
            this.grammarElements.remove(this.grammarElements.size() - 1);
        }
    }

    public void emitErrorMessage(String msg) {
    }

    public RecognizerSharedState getInternalRecognizerSharedState() {
        return this.state;
    }

    protected abstract Grammar getGrammar();

    protected int keepStackSize() {
        int result = this.stackSize;
        this.stackSize = this.grammarElements.size();
        return result;
    }

    protected void restoreStackSize(int stackSize) {
        if (!this.isBacktracking()) {
            this.removeUnexpectedElements();
            this.stackSize = stackSize;
        }
    }

    protected boolean isBacktracking() {
        return this.state.backtracking != 0;
    }

    protected void selectEofStrategy(int lookAhead) {
        if (this.mismatch || !this.state.errorRecovery) {
            this.selectEofStrategy();
        } else if (this.strict && lookAhead == 1) {
            this.delegate = this.createNoOpStrategy();
            if (this.predictionLevel > 0) {
                this.delegate = this.createPredictionStrategy();
            }
        } else {
            this.selectEofStrategy();
        }
    }

    protected void selectEofStrategy() throws UnsupportedOperationException {
        if (this.mismatch) {
            this.delegate = this.createMismatchStrategy();
        } else if (!this.state.errorRecovery) {
            if (this.marked > 0 && this.state.syntaxErrors > 0 && this.state.lastErrorIndex >= this.firstMarker) {
                this.delegate = this.createNoOpStrategy();
                return;
            }
            this.delegate = this.createNotErrorRecoveryStrategy();
        } else {
            this.delegate = this.createErrorRecoveryStrategy();
        }
        if (this.predictionLevel > 0) {
            this.delegate = this.createPredictionStrategy();
        }
    }

    protected StreamAdapter createNoOpStrategy() {
        return new StreamAdapter(this){

            @Override
            public void announceEof(int lookAhead) {
            }
        };
    }

    protected StreamAdapter createPredictionStrategy() {
        return new StreamAdapter(this){
            private AbstractElement lastAddedElement;
            private AbstractElement globalLastAddedElement;
            private int lastKnownSyntaxErrors;
            private boolean wasMismatch;
            private ObservableXtextTokenStream.StreamListener privateDelegate;
            private IFollowElementFactory followElementFactory;
            private AbstractElement recovered;
            {
                this.lastKnownSyntaxErrors = Integer.MAX_VALUE;
                this.wasMismatch = false;
                this.privateDelegate = abstractInternalContentAssistParser2.delegate;
                this.followElementFactory = abstractInternalContentAssistParser2.followElementFactory;
                abstractInternalContentAssistParser2.followElementFactory = new IFollowElementFactory(){

                    @Override
                    public FollowElement createFollowElement(AbstractElement current, int lookAhead) {
                        if (lastKnownSyntaxErrors == Integer.MAX_VALUE || ((AbstractInternalContentAssistParser)(this).this).state.lastErrorIndex < 0) {
                            FollowElement result = followElementFactory.createFollowElement(current, lookAhead);
                            if (result != null) {
                                globalLastAddedElement = result.getGrammarElement();
                                if (lookAhead > 1 && this.isBacktracking() && lastKnownSyntaxErrors == Integer.MAX_VALUE) {
                                    lastKnownSyntaxErrors = ((AbstractInternalContentAssistParser)(this).this).state.syntaxErrors;
                                }
                            }
                            return result;
                        }
                        return null;
                    }
                };
            }

            @Override
            public void announceEof(int lookAhead) {
                try {
                    if (predictionLevel == 0) {
                        AbstractElement current;
                        if (!(this.wasMismatch || ((AbstractInternalContentAssistParser)this).state.errorRecovery && resyncing || (current = this.getCurrentGrammarElement()) == null || this.lastAddedElement != null && EcoreUtil.isAncestor((EObject)current, (EObject)this.lastAddedElement))) {
                            if (((AbstractInternalContentAssistParser)this).state.errorRecovery) {
                                if (!failedPredicateAtEOF && this.globalLastAddedElement != current && (this.globalLastAddedElement == null || GrammarUtil.isOptionalCardinality((AbstractElement)this.globalLastAddedElement) || GrammarUtil.isOneOrMoreCardinality((AbstractElement)this.globalLastAddedElement))) {
                                    this.createAndAddFollowElement(current, lookAhead);
                                }
                            } else if (this.globalLastAddedElement != current && ((AbstractInternalContentAssistParser)this).state.syntaxErrors <= this.lastKnownSyntaxErrors) {
                                this.createAndAddFollowElement(current, lookAhead);
                            }
                        }
                        if (mismatch && !this.wasMismatch && !failedPredicateAtEOF) {
                            current = this.getCurrentGrammarElement();
                            if (!(this.recovered != null && this.recovered != current || current == null || this.lastAddedElement != null && EcoreUtil.isAncestor((EObject)current, (EObject)this.lastAddedElement))) {
                                this.createAndAddFollowElement(current, lookAhead);
                            }
                        }
                    } else if (this.globalLastAddedElement != this.getCurrentGrammarElement()) {
                        this.privateDelegate.announceEof(lookAhead);
                    }
                }
                finally {
                    this.wasMismatch |= mismatch;
                    if (this.getCurrentGrammarElement() != null && this.getCurrentGrammarElement() != this.globalLastAddedElement && ((AbstractInternalContentAssistParser)this).state.errorRecovery && this.recovered == null) {
                        this.recovered = this.getCurrentGrammarElement();
                    }
                }
            }

            protected void createAndAddFollowElement(AbstractElement current, int lookAhead) {
                FollowElement followElement;
                if (marked > 0) {
                    lookAhead += lookAheadAddOn;
                }
                if ((followElement = this.followElementFactory.createFollowElement(current, lookAhead)) != null) {
                    followElements.add(followElement);
                    this.lastAddedElement = current;
                    this.globalLastAddedElement = current;
                }
            }
        };
    }

    protected StreamAdapter createErrorRecoveryStrategy() {
        return new StreamAdapter(this){
            private AbstractElement lastAddedElement;

            @Override
            public void announceEof(int lookAhead) {
                AbstractElement current = this.getCurrentGrammarElement();
                if (!(current == null || this.lastAddedElement != null && EcoreUtil.isAncestor((EObject)current, (EObject)this.lastAddedElement))) {
                    if (marked > 0) {
                        lookAhead += lookAheadAddOn;
                    }
                    followElements.add(this.createFollowElement(current, lookAhead));
                    this.lastAddedElement = current;
                }
            }
        };
    }

    protected StreamAdapter createNotErrorRecoveryStrategy() {
        return new StreamAdapter(this){

            @Override
            public void announceEof(int lookAhead) {
                AbstractElement current;
                if (!(((AbstractInternalContentAssistParser)this).state.errorRecovery || mismatch || this.isBacktracking() && marked <= 0 && wasErrorCount > 0 || (current = this.getCurrentGrammarElement()) == null)) {
                    if (marked > 0) {
                        lookAhead += lookAheadAddOn;
                    }
                    if (lookAhead <= this.getLookaheadThreshold()) {
                        followElements.add(this.createFollowElement(current, lookAhead));
                    }
                }
            }
        };
    }

    protected StreamAdapter createMismatchStrategy() {
        return new StreamAdapter(this){
            private boolean wasErrorRecovery;
            {
                this.wasErrorRecovery = false;
            }

            @Override
            public void announceEof(int lookAhead) {
                AbstractElement current;
                boolean bl = this.wasErrorRecovery = this.wasErrorRecovery || ((AbstractInternalContentAssistParser)this).state.errorRecovery;
                if (!this.wasErrorRecovery && !mismatch && (current = this.getCurrentGrammarElement()) != null) {
                    if (marked > 0) {
                        lookAhead += lookAheadAddOn;
                    }
                    followElements.add(this.createFollowElement(current, lookAhead));
                }
            }
        };
    }

    public void beginResync() {
        this.resyncing = true;
    }

    public void endResync() {
        this.resyncing = false;
    }

    protected Object recoverFromMismatchedToken(IntStream input, int ttype, BitSet follow) throws RecognitionException {
        try {
            this.mismatch = true;
            Object object = super.recoverFromMismatchedToken(input, ttype, follow);
            return object;
        }
        finally {
            this.mismatch = false;
        }
    }

    public boolean mismatchIsMissingToken(IntStream input, BitSet follow) {
        return false;
    }

    protected AbstractElement getCurrentGrammarElement() {
        int i = this.grammarElements.size() - 1;
        while (i >= 0) {
            EObject result = this.grammarElements.get(this.grammarElements.size() - 1);
            if (result instanceof AbstractElement) {
                return (AbstractElement)result;
            }
            --i;
        }
        return null;
    }

    protected FollowElement createFollowElement(AbstractElement current, int lookAhead) {
        return this.followElementFactory.createFollowElement(current, lookAhead);
    }

    public LookAheadTerminal createLookAheadTerminal(Token token) {
        Grammar grammar = this.getGrammar();
        String tokenName = this.getTokenNames()[token.getType()];
        if ((tokenName = this.getValueForTokenName(tokenName)).charAt(0) == '\'') {
            LookaheadKeyword result = new LookaheadKeyword();
            result.setKeyword(tokenName.substring(1, tokenName.length() - 1));
            result.setToken(token);
            return result;
        }
        LookAheadTerminalRuleCall result = new LookAheadTerminalRuleCall();
        result.setToken(token);
        String ruleName = TokenTool.getLexerRuleName((String)tokenName);
        if (this.terminalRules == null) {
            this.terminalRules = GrammarUtil.allTerminalRules((Grammar)grammar);
        }
        for (TerminalRule rule : this.terminalRules) {
            if (!rule.getName().equalsIgnoreCase(ruleName)) continue;
            result.setRule(rule);
            return result;
        }
        throw new IllegalArgumentException("tokenType " + token.getType() + " seems to be invalid.");
    }

    @Override
    public void announceEof(int lookAhead) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Reached Eof with LA " + lookAhead));
            logger.debug((Object)"Internal parser state is: ");
            logger.debug((Object)("  current: " + this.getCurrentGrammarElement()));
            logger.debug((Object)("  failed: " + this.state.failed));
            logger.debug((Object)("  errorRecovery: " + this.state.errorRecovery));
            logger.debug((Object)("  resyncing: " + this.resyncing));
            logger.debug((Object)("  marked: " + this.marked));
            logger.debug((Object)("  firstMarker: " + this.firstMarker));
            logger.debug((Object)("  currentMarker: " + this.currentMarker));
            logger.debug((Object)("  lookAheadAddOn: " + this.lookAheadAddOn));
            logger.debug((Object)("  params: " + this.paramStack));
            logger.debug((Object)("  predictionLevel: " + this.predictionLevel));
            logger.debug((Object)("  stackSize: " + this.stackSize));
            logger.debug((Object)("  backtracking: " + this.state.backtracking));
            logger.debug((Object)("  syntaxErrors: " + this.state.syntaxErrors));
            logger.debug((Object)("  token: " + this.state.token));
            logger.debug((Object)"==================================");
        }
        if (this.delegate == null) {
            this.selectEofStrategy(lookAhead);
            if (this.strict) {
                this.wasErrorCount = this.state.syntaxErrors;
            }
        }
        if (this.inMismatchIsUnwantedToken) {
            return;
        }
        if (this.grammarElements.isEmpty() || this.delegate == null) {
            return;
        }
        if (this.strict && this.wasErrorCount != this.state.syntaxErrors) {
            return;
        }
        this.delegate.announceEof(lookAhead);
    }

    @Override
    public void announceConsume() {
        if (this.marked <= 0) {
            this.localTrace.clear();
        } else {
            ++this.lookAheadAddOn;
        }
    }

    public boolean mismatchIsUnwantedToken(IntStream input, int ttype) {
        try {
            boolean result;
            this.inMismatchIsUnwantedToken = true;
            boolean bl = result = super.mismatchIsUnwantedToken(input, ttype);
            return bl;
        }
        finally {
            this.inMismatchIsUnwantedToken = false;
        }
    }

    @Override
    public void announceRewind(int marker) {
        int useLookAhead = -1;
        if (marker != 0 && this.delegate == null && this.strict && this.predictionLevel != 0 && this.lookAheadAddOn > 0 && this.state.syntaxErrors == 0 && this.input.index() == this.input.size() && marker + this.lookAheadAddOn <= this.input.size() && this.isBacktracking()) {
            useLookAhead = this.lookAheadAddOn;
            this.delegate = this.createNotErrorRecoveryStrategy();
            this.wasErrorCount = this.state.syntaxErrors;
        }
        this.currentMarker = marker;
        this.lookAheadAddOn = this.currentMarker - this.firstMarker;
        if (useLookAhead != -1) {
            this.announceEof(useLookAhead);
        }
        --this.marked;
    }

    @Override
    public void announceMark(int marker) {
        if (this.marked <= 0) {
            ++this.marked;
            this.lookAheadAddOn = 0;
            this.currentMarker = marker;
            this.firstMarker = marker;
        } else {
            ++this.marked;
            this.currentMarker = marker;
        }
    }

    public void beginDFAPrediction() {
        ++this.predictionLevel;
    }

    public boolean isDFAPrediction() {
        return this.predictionLevel != 0;
    }

    public void endDFAPrediction() {
        --this.predictionLevel;
    }

    public Set<FollowElement> getFollowElements() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getFollowElements()");
        }
        return this.followElements;
    }

    public Map<Integer, String> getTokenDefMap() {
        String[] names = this.getTokenNames();
        HashMap result = Maps.newHashMapWithExpectedSize((int)(names.length - 4));
        int i = 4;
        while (i < names.length) {
            result.put(i, this.getValueForTokenName(names[i]));
            ++i;
        }
        return result;
    }

    protected String getValueForTokenName(String tokenName) {
        return tokenName;
    }

    public List<EObject> getGrammarElements() {
        return this.grammarElements;
    }

    public List<EObject> getLocalTrace() {
        return this.localTrace;
    }

    public List<Integer> getParamStack() {
        return this.paramStack;
    }

    public RecoveryListener getRecoveryListener() {
        return this.recoveryListener;
    }

    public void setRecoveryListener(RecoveryListener recoveryListener) {
        this.recoveryListener = recoveryListener;
    }

    public void setUnorderedGroupHelper(IUnorderedGroupHelper unorderedGroupHelper) {
        this.unorderedGroupHelper = unorderedGroupHelper;
    }

    public IUnorderedGroupHelper getUnorderedGroupHelper() {
        return this.unorderedGroupHelper;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    protected static short[][] unpackEncodedStringArray(String[] arr) {
        int numStates = arr.length;
        short[][] result = new short[numStates][];
        int i = 0;
        while (i < numStates) {
            result[i] = DFA.unpackEncodedString((String)arr[i]);
            ++i;
        }
        return result;
    }

    protected class DefaultFollowElementFactory
    implements IFollowElementFactory {
        protected DefaultFollowElementFactory() {
        }

        @Override
        public FollowElement createFollowElement(AbstractElement current, int lookAhead) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating FollowElement for: " + current));
            }
            FollowElement result = new FollowElement();
            result.setLookAhead(lookAhead);
            if (lookAhead != 1) {
                int from = AbstractInternalContentAssistParser.this.input.index();
                int to = AbstractInternalContentAssistParser.this.input.size();
                if (AbstractInternalContentAssistParser.this.marked > 0) {
                    from = AbstractInternalContentAssistParser.this.firstMarker;
                }
                ArrayList lookAheadTerminals = Lists.newArrayListWithExpectedSize((int)(to - from));
                int tokenIndex = from;
                while (tokenIndex < to) {
                    Token token = AbstractInternalContentAssistParser.this.input.get(tokenIndex);
                    if (token != null) {
                        LookAheadTerminal lookAheadTerminal = AbstractInternalContentAssistParser.this.createLookAheadTerminal(token);
                        lookAheadTerminals.add(lookAheadTerminal);
                    }
                    ++tokenIndex;
                }
                result.setLookAheadTerminals(lookAheadTerminals);
                result.setLookAhead(lookAheadTerminals.size() + 1);
            }
            result.setGrammarElement(current);
            result.setTrace(Lists.newArrayList((Iterator)Iterators.filter(AbstractInternalContentAssistParser.this.grammarElements.iterator(), AbstractElement.class)));
            result.setLocalTrace(Lists.newArrayList((Iterator)Iterators.filter(AbstractInternalContentAssistParser.this.localTrace.iterator(), AbstractElement.class)));
            result.setParamStack((List<Integer>)ImmutableList.copyOf(AbstractInternalContentAssistParser.this.paramStack));
            if (current instanceof UnorderedGroup) {
                if (AbstractInternalContentAssistParser.this.indexToHandledElements != null) {
                    int index = AbstractInternalContentAssistParser.this.grammarElements.lastIndexOf(current);
                    ArrayList alreadyHandled = Lists.newArrayList((Iterator)Iterators.filter(AbstractInternalContentAssistParser.this.indexToHandledElements.get((Object)index).iterator(), AbstractElement.class));
                    result.setHandledUnorderedGroupElements(alreadyHandled);
                } else {
                    result.setHandledUnorderedGroupElements(Collections.<AbstractElement>emptyList());
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("FollowElement is: " + current));
                logger.debug((Object)"==================================");
            }
            return result;
        }
    }

    static interface IFollowElementFactory {
        public FollowElement createFollowElement(AbstractElement var1, int var2);
    }

    public static interface RecoveryListener {
        public void beginErrorRecovery();

        public void endErrorRecovery();
    }

    protected abstract class StreamAdapter
    implements ObservableXtextTokenStream.StreamListener {
        protected StreamAdapter() {
        }

        @Override
        public void announceConsume() {
            AbstractInternalContentAssistParser.this.announceConsume();
        }

        @Override
        public void announceMark(int marker) {
            AbstractInternalContentAssistParser.this.announceMark(marker);
        }

        @Override
        public void announceRewind(int marker) {
            AbstractInternalContentAssistParser.this.announceRewind(marker);
        }
    }
}

