/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.workspace;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.ui.util.IJdtHelper;
import org.eclipse.xtext.ui.workspace.EclipseProjectConfig;
import org.eclipse.xtext.ui.workspace.EclipseWorkspaceConfig;
import org.eclipse.xtext.ui.workspace.JdtProjectConfig;
import org.eclipse.xtext.workspace.IWorkspaceConfigProvider;
import org.eclipse.xtext.xbase.lib.Pure;

public class EclipseWorkspaceConfigProvider
implements IWorkspaceConfigProvider {
    @Inject
    @Accessors
    private IWorkspace workspace;
    @Inject
    @Accessors
    private IJdtHelper jdtHelper;

    public EclipseWorkspaceConfig getWorkspaceConfig(ResourceSet context) {
        IWorkspaceRoot _root = this.workspace.getRoot();
        return new EclipseWorkspaceConfig(this, _root);
    }

    public EclipseProjectConfig getProjectConfig(final IProject project) {
        boolean _isJavaCoreAvailable;
        boolean _and = false;
        boolean _notEquals = !Objects.equal((Object)this.jdtHelper, null);
        _and = !_notEquals ? false : (_isJavaCoreAvailable = this.jdtHelper.isJavaCoreAvailable());
        if (_and) {
            return new Provider<EclipseProjectConfig>(){

                public EclipseProjectConfig get() {
                    return new JdtProjectConfig(project);
                }
            }.get();
        }
        return new EclipseProjectConfig(project);
    }

    @Pure
    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(IWorkspace workspace) {
        this.workspace = workspace;
    }

    @Pure
    public IJdtHelper getJdtHelper() {
        return this.jdtHelper;
    }

    public void setJdtHelper(IJdtHelper jdtHelper) {
        this.jdtHelper = jdtHelper;
    }
}

