/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.generator.trace;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.trace.AbsoluteURI;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.generator.trace.internal.AbstractTrace;
import org.eclipse.xtext.ui.generator.trace.IEclipseTrace;
import org.eclipse.xtext.ui.generator.trace.ILocationInEclipseResource;
import org.eclipse.xtext.ui.generator.trace.LocationInEclipseResource;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.workspace.EclipseProjectConfig;
import org.eclipse.xtext.ui.workspace.EclipseWorkspaceConfigProvider;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.workspace.IProjectConfig;

public abstract class AbstractEclipseTrace
extends AbstractTrace
implements IEclipseTrace {
    @Inject
    private IStorage2UriMapper storage2uriMapper;
    @Inject
    private IWorkspace workspace;
    @Inject
    private EclipseWorkspaceConfigProvider workspaceConfigProvider;

    protected IProject findProject(String projectName) {
        IProject result = this.workspace.getRoot().getProject(projectName);
        return result;
    }

    protected IWorkspace getWorkspace() {
        return this.workspace;
    }

    protected IStorage2UriMapper getStorage2uriMapper() {
        return this.storage2uriMapper;
    }

    protected AbsoluteURI getURIForStorage(IStorage storage) {
        URI uri = this.storage2uriMapper.getUri(storage);
        if (uri != null) {
            return new AbsoluteURI(uri);
        }
        return new AbsoluteURI(URI.createPlatformResourceURI((String)storage.getFullPath().toString(), (boolean)true));
    }

    protected abstract IStorage findStorage(SourceRelativeURI var1, IProject var2);

    protected InputStream getContents(SourceRelativeURI uri, IProjectConfig projectConfig) throws IOException {
        return this.getContents(uri, ((EclipseProjectConfig)projectConfig).getProject());
    }

    protected abstract InputStream getContents(SourceRelativeURI var1, IProject var2) throws IOException;

    protected Reader getContentsAsText(SourceRelativeURI uri, IProjectConfig projectConfig) throws IOException {
        return this.getContentsAsText(uri, ((EclipseProjectConfig)projectConfig).getProject());
    }

    protected abstract Reader getContentsAsText(SourceRelativeURI var1, IProject var2) throws IOException;

    protected Reader getLocalContentsAsText(IProjectConfig projectConfig) throws IOException {
        return this.getLocalContentsAsText(((EclipseProjectConfig)projectConfig).getProject());
    }

    protected abstract Reader getLocalContentsAsText(IProject var1) throws IOException;

    public ILocationInEclipseResource getBestAssociatedLocation(ITextRegion region, IStorage associatedStorage) {
        AbsoluteURI uri = this.getURIForStorage(associatedStorage);
        return this.getBestAssociatedLocation(region, uri);
    }

    public Iterable<? extends ILocationInEclipseResource> getAllAssociatedLocations(ITextRegion localRegion, IStorage associatedStorage) {
        AbsoluteURI uri = this.getURIForStorage(associatedStorage);
        return this.getAllAssociatedLocations(localRegion, uri);
    }

    public Iterable<? extends ILocationInEclipseResource> getAllAssociatedLocations(IStorage associatedStorage) {
        AbsoluteURI uri = this.getURIForStorage(associatedStorage);
        return this.getAllAssociatedLocations(uri);
    }

    public ILocationInEclipseResource getBestAssociatedLocation(ITextRegion region) {
        return (ILocationInEclipseResource)super.getBestAssociatedLocation(region);
    }

    protected ILocationInEclipseResource createLocationInResource(ITextRegionWithLineInformation region, SourceRelativeURI srcRelativePath) {
        return new LocationInEclipseResource(region.getOffset(), region.getLength(), region.getLineNumber(), region.getEndLineNumber(), srcRelativePath, this);
    }

    public Iterable<? extends ILocationInEclipseResource> getAllAssociatedLocations(ITextRegion localRegion) {
        return super.getAllAssociatedLocations(localRegion);
    }

    public ILocationInEclipseResource getBestAssociatedLocation(ITextRegion localRegion, AbsoluteURI uri) {
        return (ILocationInEclipseResource)super.getBestAssociatedLocation(localRegion, uri);
    }

    public Iterable<? extends ILocationInEclipseResource> getAllAssociatedLocations(ITextRegion localRegion, AbsoluteURI uri) {
        return super.getAllAssociatedLocations(localRegion, uri);
    }

    public Iterable<? extends ILocationInEclipseResource> getAllAssociatedLocations(AbsoluteURI uri) {
        return super.getAllAssociatedLocations(uri);
    }

    public IProjectConfig getLocalProjectConfig() {
        return this.workspaceConfigProvider.getProjectConfig(this.getLocalProject());
    }

    public abstract IProject getLocalProject();

    public Iterable<? extends ILocationInEclipseResource> getAllAssociatedLocations() {
        return super.getAllAssociatedLocations();
    }
}

