/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.workspace;

import com.google.common.base.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.ui.workspace.EclipseWorkspaceConfigProvider;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IWorkspaceConfig;
import org.eclipse.xtext.xbase.lib.Exceptions;

@FinalFieldsConstructor
public class EclipseWorkspaceConfig
implements IWorkspaceConfig {
    private final EclipseWorkspaceConfigProvider provider;
    private final IWorkspaceRoot workspaceRoot;

    public IProjectConfig findProjectByName(String name) {
        try {
            IProject project = this.workspaceRoot.getProject(name);
            boolean _exists = project.exists();
            if (_exists) {
                return this.provider.getProjectConfig(project);
            }
            return null;
        }
        catch (Throwable _t) {
            if (_t instanceof IllegalArgumentException) {
                IllegalArgumentException cfr_ignored_0 = (IllegalArgumentException)_t;
                return null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public IProjectConfig findProjectContaining(URI member) {
        boolean _isPlatformResource = member.isPlatformResource();
        if (_isPlatformResource) {
            String _segment = member.segment(1);
            return this.findProjectByName(_segment);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EclipseWorkspaceConfig) {
            return Objects.equal((Object)((EclipseWorkspaceConfig)obj).workspaceRoot, (Object)this.workspaceRoot);
        }
        return false;
    }

    public int hashCode() {
        return this.workspaceRoot.hashCode();
    }

    public String toString() {
        return this.workspaceRoot.toString();
    }

    public EclipseWorkspaceConfig(EclipseWorkspaceConfigProvider provider, IWorkspaceRoot workspaceRoot) {
        this.provider = provider;
        this.workspaceRoot = workspaceRoot;
    }
}

