/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.resource;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.resource.IStorage2UriMapperContribution;
import org.eclipse.xtext.ui.resource.IStorage2UriMapperJdtExtensions;
import org.eclipse.xtext.ui.resource.JarEntryLocator;
import org.eclipse.xtext.ui.resource.PackageFragmentRootWalker;
import org.eclipse.xtext.ui.resource.SourceAttachmentPackageFragmentRootWalker;
import org.eclipse.xtext.ui.resource.UriValidator;
import org.eclipse.xtext.ui.util.IJdtHelper;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class Storage2UriMapperJavaImpl
implements IStorage2UriMapperJdtExtensions,
IStorage2UriMapperContribution,
IElementChangedListener {
    private static final Logger log = Logger.getLogger(Storage2UriMapperJavaImpl.class);
    @Inject
    private JarEntryLocator locator;
    @Inject
    private IJdtHelper jdtHelper;
    @Inject
    private UriValidator uriValidator;
    @Inject
    private IStorage2UriMapper host;
    private Map<String, PackageFragmentRootData> cachedPackageFragmentRootData = Maps.newLinkedHashMap();
    @Inject
    private IWorkspace workspace;
    private volatile boolean isInitialized = false;

    public void setJdtHelper(IJdtHelper jdtHelper) {
        this.jdtHelper = jdtHelper;
    }

    public void setLocator(JarEntryLocator locator) {
        this.locator = locator;
    }

    public void setUriValidator(UriValidator uriValidator) {
        this.uriValidator = uriValidator;
    }

    public void setHost(IStorage2UriMapper host) {
        this.host = host;
    }

    @Override
    public boolean isRejected(IFolder folder) {
        return this.jdtHelper.isFromOutputPath((IResource)folder);
    }

    @Override
    public Pair<URI, URI> getURIMapping(IPackageFragmentRoot root) throws JavaModelException {
        PackageFragmentRootData data = this.getData(root);
        if (data.uriPrefix == null) {
            return null;
        }
        IPath path = root.isExternal() ? root.getPath() : root.getUnderlyingResource().getLocation();
        URI physical = null;
        if (root.isArchive()) {
            String archiveScheme = "zip".equalsIgnoreCase(root.getPath().getFileExtension()) ? "zip" : "jar";
            physical = URI.createURI((String)(String.valueOf(archiveScheme) + ":file:" + path.toFile().getPath() + "!/"));
        } else {
            physical = URI.createFileURI((String)(String.valueOf(path.toFile().getPath()) + "/"));
        }
        return Tuples.create((Object)data.uriPrefix, (Object)physical);
    }

    @Override
    public Map<URI, IStorage> getAllEntries(IPackageFragmentRoot root) {
        try {
            IResource underlyingResource = root.getUnderlyingResource();
            if (underlyingResource instanceof IFolder) {
                return this.host.getAllEntries((IContainer)((IFolder)underlyingResource));
            }
        }
        catch (JavaModelException e) {
            if (!e.isDoesNotExist()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            return Collections.emptyMap();
        }
        PackageFragmentRootData data = this.getData(root);
        return data.uri2Storage;
    }

    private PackageFragmentRootData getData(IPackageFragmentRoot root) {
        boolean isCachable;
        boolean bl = isCachable = root.isArchive() || root.isExternal();
        if (isCachable) {
            return this.getCachedData(root);
        }
        PackageFragmentRootData data = this.initializeData(root);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageFragmentRootData getCachedData(IPackageFragmentRoot root) {
        String path = root.getPath().toString();
        Map<String, PackageFragmentRootData> map = this.cachedPackageFragmentRootData;
        synchronized (map) {
            if (this.cachedPackageFragmentRootData.containsKey(path)) {
                PackageFragmentRootData data = this.cachedPackageFragmentRootData.get(path);
                if (this.isUpToDate(data, root)) {
                    data.addRoot(root);
                    return data;
                }
                this.cachedPackageFragmentRootData.remove(path);
            }
        }
        PackageFragmentRootData data = this.initializeData(root);
        Map<String, PackageFragmentRootData> map2 = this.cachedPackageFragmentRootData;
        synchronized (map2) {
            this.cachedPackageFragmentRootData.put(path, data);
        }
        return data;
    }

    private boolean isUpToDate(PackageFragmentRootData data, IPackageFragmentRoot root) {
        return Objects.equal((Object)data.modificationStamp, (Object)this.computeModificationStamp(root));
    }

    private Object computeModificationStamp(IPackageFragmentRoot root) {
        try {
            if (root.exists()) {
                IResource resource = root.getUnderlyingResource();
                if (resource != null) {
                    return resource.getLocation().toFile().lastModified();
                }
                return root.getPath().toFile().lastModified();
            }
        }
        catch (JavaModelException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return new Object();
    }

    protected PackageFragmentRootData initializeData(final IPackageFragmentRoot root) {
        final PackageFragmentRootData data = new PackageFragmentRootData(this.computeModificationStamp(root));
        data.addRoot(root);
        try {
            SourceAttachmentPackageFragmentRootWalker<Void> walker = new SourceAttachmentPackageFragmentRootWalker<Void>(){

                @Override
                protected URI getURI(IFile file, PackageFragmentRootWalker.TraversalState state) {
                    if (!Storage2UriMapperJavaImpl.this.uriValidator.isPossiblyManaged((IStorage)file)) {
                        return null;
                    }
                    return super.getURI(file, state);
                }

                @Override
                protected URI getURI(IJarEntryResource jarEntry, PackageFragmentRootWalker.TraversalState state) {
                    if (!Storage2UriMapperJavaImpl.this.uriValidator.isPossiblyManaged((IStorage)jarEntry)) {
                        return null;
                    }
                    URI uri = Storage2UriMapperJavaImpl.this.locator.getURI(root, jarEntry, state);
                    if (!Storage2UriMapperJavaImpl.this.uriValidator.isValid(uri, (IStorage)jarEntry)) {
                        return null;
                    }
                    return uri;
                }

                @Override
                protected Void handle(URI uri, IStorage storage, PackageFragmentRootWalker.TraversalState state) {
                    data.uri2Storage.put(uri, storage);
                    return null;
                }
            };
            walker.traverse(root, false);
            if (walker.getBundleSymbolicName() != null) {
                data.uriPrefix = URI.createPlatformResourceURI((String)(String.valueOf(walker.getBundleSymbolicName()) + "/"), (boolean)true);
            }
        }
        catch (RuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (JavaModelException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Pair<IStorage, IProject>> getStorages(URI uri) {
        ArrayList packageFragmentRootDatas;
        ArrayList result = Lists.newArrayListWithCapacity((int)1);
        Map<String, PackageFragmentRootData> map = this.cachedPackageFragmentRootData;
        synchronized (map) {
            packageFragmentRootDatas = Lists.newArrayList(this.cachedPackageFragmentRootData.values());
        }
        Iterator iterator = packageFragmentRootDatas.iterator();
        while (iterator.hasNext()) {
            PackageFragmentRootData data = (PackageFragmentRootData)iterator.next();
            if (data.exists()) {
                IStorage storage;
                if (data.uriPrefix != null && !uri.toString().startsWith(data.uriPrefix.toString()) || (storage = data.uri2Storage.get(uri)) == null) continue;
                for (IPackageFragmentRoot root : data.associatedRoots.values()) {
                    result.add(Tuples.create((Object)storage, (Object)root.getJavaProject().getProject()));
                }
                continue;
            }
            iterator.remove();
        }
        if (result.isEmpty() && uri.isArchive()) {
            String authority = uri.authority();
            URI archiveURI = URI.createURI((String)(authority = authority.substring(0, authority.length() - 1)));
            if (archiveURI.isFile() || archiveURI.isPlatformResource()) {
                Path archivePath = new Path(archiveURI.isPlatformResource() ? archiveURI.toPlatformString(true) : archiveURI.toFileString());
                for (PackageFragmentRootData data : packageFragmentRootDatas) {
                    URI prefix;
                    URI expectedURI;
                    IStorage storage;
                    if (data.uriPrefix == null || !archivePath.equals((Object)data.getPath()) || (storage = data.uri2Storage.get(expectedURI = (prefix = data.uriPrefix.lastSegment().length() == 0 ? data.uriPrefix.trimSegments(1) : data.uriPrefix).appendSegments(uri.segments()))) == null) continue;
                    for (IPackageFragmentRoot root : data.associatedRoots.values()) {
                        result.add(Tuples.create((Object)storage, (Object)root.getJavaProject().getProject()));
                    }
                }
            }
        }
        return result;
    }

    @Override
    public URI getUri(IStorage storage) {
        if (storage instanceof IJarEntryResource) {
            IJarEntryResource casted = (IJarEntryResource)storage;
            IPackageFragmentRoot packageFragmentRoot = casted.getPackageFragmentRoot();
            Map<URI, IStorage> data = this.getAllEntries(packageFragmentRoot);
            for (Map.Entry<URI, IStorage> entry : data.entrySet()) {
                if (!entry.getValue().equals(casted)) continue;
                return entry.getKey();
            }
            if (packageFragmentRoot.exists() && packageFragmentRoot.isArchive()) {
                IPath jarPath = packageFragmentRoot.getPath();
                URI jarURI = packageFragmentRoot.isExternal() ? URI.createFileURI((String)jarPath.toOSString()) : URI.createPlatformResourceURI((String)jarPath.toString(), (boolean)true);
                URI result = URI.createURI((String)("archive:" + jarURI + "!" + storage.getFullPath()));
                return result;
            }
        }
        return null;
    }

    public void elementChanged(ElementChangedEvent event) {
        this.initializeCache();
        Set<IJavaProject> javaProjectsWithClasspathChange = this.getJavaProjectsWithClasspathChange(event.getDelta());
        if (!javaProjectsWithClasspathChange.isEmpty()) {
            for (IJavaProject project : javaProjectsWithClasspathChange) {
                this.updateCache(project);
            }
        }
        for (IJavaElementDelta projectDelta : this.getProjectDeltas(event.getDelta())) {
            IJavaProject project = (IJavaProject)projectDelta.getElement();
            if ((projectDelta.getKind() & 2) != 0) {
                this.clearCache(project, Collections.<PackageFragmentRootData>emptySet());
                return;
            }
            switch (projectDelta.getFlags()) {
                case 512: {
                    this.updateCache(project);
                    break;
                }
                case 1024: {
                    this.clearCache(project, Collections.<PackageFragmentRootData>emptySet());
                }
            }
        }
    }

    public void setWorkspace(IWorkspace workspace) {
        this.workspace = workspace;
    }

    private void updateCache(IJavaProject project) {
        try {
            HashSet datas = Sets.newHashSet();
            IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean isCachable;
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                boolean bl = isCachable = root.isArchive() || root.isExternal();
                if (isCachable) {
                    datas.add(this.getCachedData(root));
                }
                ++n2;
            }
            this.clearCache(project, datas);
        }
        catch (JavaModelException e) {
            log.error((Object)("Error getting package fragments roots of " + project.getElementName()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache(IJavaProject project, Set<PackageFragmentRootData> toBeKept) {
        ArrayList values;
        Map<String, PackageFragmentRootData> map = this.cachedPackageFragmentRootData;
        synchronized (map) {
            values = Lists.newArrayList(this.cachedPackageFragmentRootData.values());
        }
        ArrayList toBeRemoved = Lists.newArrayList();
        for (PackageFragmentRootData data : values) {
            if (toBeKept.contains(data)) continue;
            Iterator<Map.Entry<String, IPackageFragmentRoot>> i = data.associatedRoots.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, IPackageFragmentRoot> root = i.next();
                if (!project.equals(root.getValue().getJavaProject())) continue;
                i.remove();
            }
            if (data.associatedRoots.size() == 0) {
                toBeRemoved.add(data);
                continue;
            }
            IPackageFragmentRoot someRoot = (IPackageFragmentRoot)IterableExtensions.head(data.associatedRoots.values());
            PackageFragmentRootData newlyCollected = this.initializeData(someRoot);
            data.uri2Storage = newlyCollected.uri2Storage;
        }
        if (!toBeRemoved.isEmpty()) {
            Map<String, PackageFragmentRootData> map2 = this.cachedPackageFragmentRootData;
            synchronized (map2) {
                this.cachedPackageFragmentRootData.values().removeAll(toBeRemoved);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeCache() {
        if (!this.isInitialized) {
            Storage2UriMapperJavaImpl storage2UriMapperJavaImpl = this;
            synchronized (storage2UriMapperJavaImpl) {
                if (!this.isInitialized) {
                    IProject[] iProjectArray = this.workspace.getRoot().getProjects();
                    int n = iProjectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject project = iProjectArray[n2];
                        if (project.isAccessible() && JavaProject.hasJavaNature((IProject)project)) {
                            IJavaProject javaProject = JavaCore.create((IProject)project);
                            this.updateCache(javaProject);
                        }
                        ++n2;
                    }
                    this.isInitialized = true;
                }
            }
        }
    }

    private Set<IJavaElementDelta> getProjectDeltas(IJavaElementDelta delta) {
        IJavaElement element = delta.getElement();
        if (delta.getElement().getElementType() == 2) {
            return Collections.singleton(delta);
        }
        LinkedHashSet result = null;
        if (element instanceof IJavaModel) {
            IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta child = iJavaElementDeltaArray[n2];
                Set<IJavaElementDelta> projectDeltas = this.getProjectDeltas(child);
                if (!projectDeltas.isEmpty()) {
                    if (result == null) {
                        result = Sets.newLinkedHashSet();
                    }
                    result.addAll(projectDeltas);
                }
                ++n2;
            }
        }
        return result == null ? Collections.emptySet() : result;
    }

    private Set<IJavaProject> getJavaProjectsWithClasspathChange(IJavaElementDelta delta) {
        IJavaElement element = delta.getElement();
        if (element instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)element;
            if (delta.getKind() == 2 || delta.getKind() == 1 || (delta.getFlags() & 0x100) != 0 || (delta.getFlags() & 0x80) != 0 || (delta.getFlags() & 0x40) != 0 || root.isExternal() && (delta.getFlags() & 0x3001) == delta.getFlags()) {
                return Collections.singleton(root.getJavaProject());
            }
        } else {
            if (element instanceof IJavaModel) {
                return this.getPackageFragmentRootDeltas(delta.getAffectedChildren());
            }
            if (element instanceof IJavaProject) {
                if ((delta.getFlags() & 0x20000) != 0 || (delta.getFlags() & 0x200000) != 0) {
                    return Collections.singleton((IJavaProject)element);
                }
                return this.getPackageFragmentRootDeltas(delta.getAffectedChildren());
            }
        }
        return Collections.emptySet();
    }

    private Set<IJavaProject> getPackageFragmentRootDeltas(IJavaElementDelta[] affectedChildren) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        IJavaElementDelta[] iJavaElementDeltaArray = affectedChildren;
        int n = affectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta delta = iJavaElementDeltaArray[n2];
            set.addAll(this.getJavaProjectsWithClasspathChange(delta));
            ++n2;
        }
        return set;
    }

    public static class PackageFragmentRootData {
        public URI uriPrefix;
        public final Object modificationStamp;
        public final Map<String, IPackageFragmentRoot> associatedRoots;
        public Map<URI, IStorage> uri2Storage = Maps.newLinkedHashMap();

        public PackageFragmentRootData(Object modificationStamp) {
            this.modificationStamp = modificationStamp;
            this.associatedRoots = Maps.newHashMap();
        }

        public String toString() {
            return this.getPath() + " / " + this.uriPrefix;
        }

        public boolean exists() {
            if (this.associatedRoots.size() == 0) {
                return false;
            }
            return this.associatedRoots.values().iterator().next().exists();
        }

        public IPath getPath() {
            if (this.associatedRoots.size() == 0) {
                return null;
            }
            return this.associatedRoots.values().iterator().next().getPath();
        }

        public void addRoot(IPackageFragmentRoot root) {
            if (root != null) {
                this.associatedRoots.put(root.getHandleIdentifier(), root);
            }
        }
    }
}

