/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.util;

import com.google.inject.Inject;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.ui.MarkerTypes;
import org.eclipse.xtext.ui.editor.validation.XtextAnnotation;
import org.eclipse.xtext.ui.validation.MarkerTypeProvider;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.Issue;

public class IssueUtil {
    @Inject(optional=true)
    private MarkerTypeProvider markerTypeProvider;

    public Issue createIssue(IMarker marker) {
        Issue.IssueImpl issue = new Issue.IssueImpl();
        try {
            Map attributes = marker.getAttributes();
            String markerType = marker.getType();
            Object message = attributes.get("message");
            issue.setMessage(message instanceof String ? (String)message : null);
            Object lineNumber = attributes.get("lineNumber");
            issue.setLineNumber(lineNumber instanceof Integer ? Integer.valueOf((Integer)lineNumber - 1) : null);
            Object offset = attributes.get("charStart");
            Object endOffset = attributes.get("charEnd");
            if (offset instanceof Integer && endOffset instanceof Integer) {
                issue.setOffset((Integer)offset);
                issue.setLength(Integer.valueOf((Integer)endOffset - (Integer)offset));
            } else {
                issue.setOffset(Integer.valueOf(-1));
                issue.setLength(Integer.valueOf(0));
            }
            Object code = attributes.get("CODE_KEY");
            issue.setCode(code instanceof String ? (String)code : null);
            Object data = attributes.get("DATA_KEY");
            issue.setData(data instanceof String ? Strings.unpack((String)((String)data)) : null);
            Object uri = attributes.get("URI_KEY");
            issue.setUriToProblem(uri instanceof String ? URI.createURI((String)((String)uri)) : null);
            Object severity = attributes.get("severity");
            Severity translatedSeverity = this.translateSeverity(severity instanceof Integer ? (Integer)severity : 0);
            if (translatedSeverity == null) {
                throw new IllegalArgumentException(marker.toString());
            }
            issue.setSeverity(translatedSeverity);
            if (this.markerTypeProvider != null) {
                issue.setType(this.markerTypeProvider.getCheckType(markerType));
            } else {
                issue.setType(MarkerTypes.toCheckType(markerType));
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        return issue;
    }

    @Deprecated
    protected CheckType getCheckType(IMarker marker) {
        String markerType = MarkerUtilities.getMarkerType((IMarker)marker);
        if (this.markerTypeProvider != null) {
            return this.markerTypeProvider.getCheckType(markerType);
        }
        return MarkerTypes.toCheckType(markerType);
    }

    public Issue getIssueFromAnnotation(Annotation annotation) {
        if (annotation instanceof XtextAnnotation) {
            XtextAnnotation xtextAnnotation = (XtextAnnotation)annotation;
            return xtextAnnotation.getIssue();
        }
        if (annotation instanceof MarkerAnnotation) {
            MarkerAnnotation markerAnnotation = (MarkerAnnotation)annotation;
            return this.createIssue(markerAnnotation.getMarker());
        }
        return null;
    }

    public String getCode(Annotation annotation) {
        if (annotation instanceof MarkerAnnotation) {
            MarkerAnnotation ma = (MarkerAnnotation)annotation;
            return this.getCode(ma.getMarker());
        }
        if (annotation instanceof XtextAnnotation) {
            XtextAnnotation xa = (XtextAnnotation)annotation;
            return xa.getIssueCode();
        }
        return null;
    }

    public String getCode(IMarker marker) {
        return marker.getAttribute("CODE_KEY", null);
    }

    public String[] getIssueData(Annotation annotation) {
        if (annotation instanceof MarkerAnnotation) {
            MarkerAnnotation ma = (MarkerAnnotation)annotation;
            return this.getIssueData(ma.getMarker());
        }
        if (annotation instanceof XtextAnnotation) {
            XtextAnnotation xa = (XtextAnnotation)annotation;
            return xa.getIssueData();
        }
        return null;
    }

    public String[] getIssueData(IMarker marker) {
        return Strings.unpack((String)marker.getAttribute("DATA_KEY", null));
    }

    public URI getUriToProblem(IMarker marker) {
        String uri = marker.getAttribute("URI_KEY", null);
        return uri != null ? URI.createURI((String)uri) : null;
    }

    public URI getUriToProblem(Annotation annotation) {
        if (annotation instanceof MarkerAnnotation) {
            MarkerAnnotation ma = (MarkerAnnotation)annotation;
            return this.getUriToProblem(ma.getMarker());
        }
        if (annotation instanceof XtextAnnotation) {
            XtextAnnotation xa = (XtextAnnotation)annotation;
            return xa.getUriToProblem();
        }
        return null;
    }

    @Deprecated
    public Severity getSeverity(IMarker marker) {
        Severity translatedSeverity = this.translateSeverity(marker.getAttribute("severity", 0));
        if (translatedSeverity == null) {
            throw new IllegalArgumentException(marker.toString());
        }
        return translatedSeverity;
    }

    protected Severity translateSeverity(int severity) {
        switch (severity) {
            case 2: {
                return Severity.ERROR;
            }
            case 1: {
                return Severity.WARNING;
            }
            case 0: {
                return Severity.INFO;
            }
        }
        return null;
    }

    public boolean refersToSameIssue(IMarker marker, Annotation annotation) {
        URI markerURI = this.getUriToProblem(marker);
        String markerIssue = this.getCode(marker);
        if (markerURI == null || markerIssue == null) {
            return false;
        }
        return markerURI.equals(this.getUriToProblem(annotation)) && markerIssue.equals(this.getCode(annotation));
    }
}

