/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.testing;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.binder.AnnotatedBindingBuilder;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.ColoringInformation;
import org.eclipse.lsp4j.ColoringParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.FileChangeType;
import org.eclipse.lsp4j.FileEvent;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.ParameterInformation;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceContext;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.services.ServiceEndpoints;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientExtensions;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.LanguageInfo;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.LanguageServerImpl;
import org.eclipse.xtext.ide.server.ServerModule;
import org.eclipse.xtext.ide.server.UriExtensions;
import org.eclipse.xtext.ide.server.concurrent.RequestManager;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.testing.DefinitionTestConfiguration;
import org.eclipse.xtext.testing.DocumentHighlightConfiguration;
import org.eclipse.xtext.testing.DocumentSymbolConfiguraiton;
import org.eclipse.xtext.testing.FileInfo;
import org.eclipse.xtext.testing.FormattingConfiguration;
import org.eclipse.xtext.testing.HoverTestConfiguration;
import org.eclipse.xtext.testing.RangeFormattingConfiguration;
import org.eclipse.xtext.testing.ReferenceTestConfiguration;
import org.eclipse.xtext.testing.SignatureHelpConfiguration;
import org.eclipse.xtext.testing.TestCompletionConfiguration;
import org.eclipse.xtext.testing.TextDocumentConfiguration;
import org.eclipse.xtext.testing.TextDocumentPositionConfiguration;
import org.eclipse.xtext.testing.WorkspaceSymbolConfiguration;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Files;
import org.eclipse.xtext.util.Modules2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.junit.Assert;
import org.junit.Before;

@FinalFieldsConstructor
public abstract class AbstractLanguageServerTest
implements Endpoint {
    @Accessors
    protected final String fileExtension;
    @Inject
    protected IResourceServiceProvider.Registry resourceServerProviderRegistry;
    @Inject
    @Extension
    private UriExtensions _uriExtensions;
    @Inject
    protected LanguageServerImpl languageServer;
    protected List<Pair<String, Object>> notifications = CollectionLiterals.newArrayList();
    protected File root;
    protected LanguageInfo languageInfo;

    @Before
    public void setup() {
        try {
            boolean _not;
            File _file;
            Injector injector = Guice.createInjector((Module[])new Module[]{this.getServerModule()});
            injector.injectMembers((Object)this);
            Object resourceServiceProvider = this.resourceServerProviderRegistry.getExtensionToFactoryMap().get(this.fileExtension);
            if (resourceServiceProvider instanceof IResourceServiceProvider) {
                this.languageInfo = (LanguageInfo)((IResourceServiceProvider)resourceServiceProvider).get(LanguageInfo.class);
            }
            this.languageServer.connect((LanguageClient)ServiceEndpoints.toServiceObject((Endpoint)this, LanguageClientExtensions.class));
            this.languageServer.supportedMethods();
            File _absoluteFile = new File("").getAbsoluteFile();
            this.root = _file = new File(_absoluteFile, "/test-data/test-project");
            boolean _mkdirs = this.root.mkdirs();
            boolean bl = _not = !_mkdirs;
            if (_not) {
                Files.cleanFolder((File)this.root, null, (boolean)true, (boolean)false);
            }
            this.root.deleteOnExit();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected Module getServerModule() {
        ServerModule _serverModule = new ServerModule();
        Module _function = it -> {
            AnnotatedBindingBuilder _bind = it.bind(RequestManager.class);
            _bind.toInstance((Object)new RequestManager(){

                public <V> CompletableFuture<V> runRead(Functions.Function1<? super CancelIndicator, ? extends V> request) {
                    CompletableFuture<Object> result = new CompletableFuture<Object>();
                    try {
                        CancelIndicator _function = () -> false;
                        result.complete(request.apply((Object)_function));
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Throwable) {
                            Throwable e = _t;
                            result.completeExceptionally(e);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    return result;
                }

                public <U, V> CompletableFuture<V> runWrite(Functions.Function0<? extends U> nonCancellable, Functions.Function2<? super CancelIndicator, ? super U, ? extends V> request) {
                    CompletableFuture<Object> result = new CompletableFuture<Object>();
                    try {
                        CancelIndicator _function = () -> false;
                        result.complete(request.apply((Object)_function, nonCancellable.apply()));
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Throwable) {
                            Throwable e = _t;
                            result.completeExceptionally(e);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    return result;
                }
            });
        };
        return Modules2.mixin((Module[])new Module[]{_serverModule, _function});
    }

    protected Path getTestRootPath() {
        return this.root.toPath().toAbsolutePath().normalize();
    }

    protected Path relativize(String uri) {
        try {
            Path _xblockexpression = null;
            java.net.URI _uRI = new java.net.URI(uri);
            Path path = Paths.get(_uRI);
            _xblockexpression = this.getTestRootPath().relativize(path);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected InitializeResult initialize() {
        return this.initialize(null);
    }

    protected InitializeResult initialize(Procedures.Procedure1<? super InitializeParams> initializer) {
        try {
            InitializeParams _initializeParams = new InitializeParams();
            Procedures.Procedure1 _function = it -> {
                it.setProcessId(Integer.valueOf(1));
                it.setRootUri(this._uriExtensions.toUriString(this.root.toURI().normalize()));
            };
            InitializeParams params = (InitializeParams)ObjectExtensions.operator_doubleArrow((Object)_initializeParams, (Procedures.Procedure1)_function);
            if (initializer != null) {
                initializer.apply((Object)params);
            }
            return (InitializeResult)this.languageServer.initialize(params).get();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void open(String fileUri, String model) {
        this.open(fileUri, this.languageInfo.getLanguageName(), model);
    }

    protected void open(String fileUri, String langaugeId, String model) {
        DidOpenTextDocumentParams _didOpenTextDocumentParams = new DidOpenTextDocumentParams();
        Procedures.Procedure1 _function = it -> {
            TextDocumentItem _textDocumentItem = new TextDocumentItem();
            Procedures.Procedure1 _function_1 = it_1 -> {
                it_1.setUri(fileUri);
                it_1.setLanguageId(langaugeId);
                it_1.setVersion(1);
                it_1.setText(model);
            };
            TextDocumentItem _doubleArrow = (TextDocumentItem)ObjectExtensions.operator_doubleArrow((Object)_textDocumentItem, (Procedures.Procedure1)_function_1);
            it.setTextDocument(_doubleArrow);
        };
        DidOpenTextDocumentParams _doubleArrow = (DidOpenTextDocumentParams)ObjectExtensions.operator_doubleArrow((Object)_didOpenTextDocumentParams, (Procedures.Procedure1)_function);
        this.languageServer.didOpen(_doubleArrow);
    }

    protected void didCreateWatchedFiles(String ... fileUris) {
        DidChangeWatchedFilesParams _didChangeWatchedFilesParams = new DidChangeWatchedFilesParams();
        Procedures.Procedure1 _function = it -> {
            for (String fileUri : fileUris) {
                List _changes = it.getChanges();
                FileEvent _fileEvent = new FileEvent();
                Procedures.Procedure1 _function_1 = it_1 -> {
                    it_1.setUri(fileUri);
                    it_1.setType(FileChangeType.Created);
                };
                FileEvent _doubleArrow = (FileEvent)ObjectExtensions.operator_doubleArrow((Object)_fileEvent, (Procedures.Procedure1)_function_1);
                _changes.add(_doubleArrow);
            }
        };
        DidChangeWatchedFilesParams _doubleArrow = (DidChangeWatchedFilesParams)ObjectExtensions.operator_doubleArrow((Object)_didChangeWatchedFilesParams, (Procedures.Procedure1)_function);
        this.languageServer.didChangeWatchedFiles(_doubleArrow);
    }

    protected void close(String fileUri) {
        DidCloseTextDocumentParams _didCloseTextDocumentParams = new DidCloseTextDocumentParams();
        Procedures.Procedure1 _function = it -> {
            TextDocumentIdentifier _textDocumentIdentifier = new TextDocumentIdentifier(fileUri);
            it.setTextDocument(_textDocumentIdentifier);
        };
        DidCloseTextDocumentParams _doubleArrow = (DidCloseTextDocumentParams)ObjectExtensions.operator_doubleArrow((Object)_didCloseTextDocumentParams, (Procedures.Procedure1)_function);
        this.languageServer.didClose(_doubleArrow);
    }

    public String writeFile(String path, CharSequence contents) {
        try {
            File file = new File(this.root, path);
            file.getParentFile().mkdirs();
            file.createNewFile();
            FileWriter writer = new FileWriter(file);
            writer.write(contents.toString());
            writer.close();
            return this._uriExtensions.toUriString(file.toURI().normalize());
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String getVirtualFile(String path) {
        File file = new File(this.root, path);
        return this._uriExtensions.toUriString(file.toURI().normalize());
    }

    protected String _toExpectation(List<?> elements) {
        StringConcatenation _builder = new StringConcatenation();
        for (Object element : elements) {
            String _expectation = this.toExpectation(element);
            _builder.append(_expectation);
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }

    protected String _toExpectation(String it) {
        return it;
    }

    protected String _toExpectation(Integer it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)it);
        return _builder.toString();
    }

    protected String _toExpectation(Void it) {
        return "";
    }

    protected String _toExpectation(Either<?, ?> either) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isLeft = either.isLeft();
        if (_isLeft) {
            String _expectation = this.toExpectation(either.getLeft());
            _builder.append(_expectation);
            _builder.newLineIfNotEmpty();
        } else {
            String _expectation_1 = this.toExpectation(either.getRight());
            _builder.append(_expectation_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }

    protected String _toExpectation(Location it) {
        StringConcatenation _builder = new StringConcatenation();
        Path _relativize = this.relativize(it.getUri());
        _builder.append((Object)_relativize);
        _builder.append(" ");
        String _expectation = this.toExpectation(it.getRange());
        _builder.append(_expectation);
        return _builder.toString();
    }

    protected String _toExpectation(Range it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("[");
        String _expectation = this.toExpectation(it.getStart());
        _builder.append(_expectation);
        _builder.append(" .. ");
        String _expectation_1 = this.toExpectation(it.getEnd());
        _builder.append(_expectation_1);
        _builder.append("]");
        return _builder.toString();
    }

    protected String _toExpectation(Position it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("[");
        int _line = it.getLine();
        _builder.append((Object)_line);
        _builder.append(", ");
        int _character = it.getCharacter();
        _builder.append((Object)_character);
        _builder.append("]");
        return _builder.toString();
    }

    protected String _toExpectation(SymbolInformation it) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("symbol \"");
        String _name = it.getName();
        _builder.append(_name);
        _builder.append("\" {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("kind: ");
        int _value = it.getKind().getValue();
        _builder.append((Object)_value, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("location: ");
        String _expectation = this.toExpectation(it.getLocation());
        _builder.append(_expectation, "    ");
        _builder.newLineIfNotEmpty();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it.getContainerName());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append("    ");
            _builder.append("container: \"");
            String _containerName = it.getContainerName();
            _builder.append(_containerName, "    ");
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    protected String _toExpectation(CompletionItem it) {
        TextEdit _textEdit;
        boolean _tripleNotEquals;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        String _label = it.getLabel();
        _builder.append(_label);
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it.getDetail());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append(" (");
            String _detail = it.getDetail();
            _builder.append(_detail);
            _builder.append(")");
        }
        boolean bl2 = _tripleNotEquals = (_textEdit = it.getTextEdit()) != null;
        if (_tripleNotEquals) {
            _builder.append(" -> ");
            String _expectation = this.toExpectation(it.getTextEdit());
            _builder.append(_expectation);
        } else if (it.getInsertText() != null && !Objects.equal((Object)it.getInsertText(), (Object)it.getLabel())) {
            _builder.append(" -> ");
            String _insertText = it.getInsertText();
            _builder.append(_insertText);
        }
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    protected String _toExpectation(TextEdit it) {
        StringConcatenation _builder = new StringConcatenation();
        String _newText = it.getNewText();
        _builder.append(_newText);
        _builder.append(" ");
        String _expectation = this.toExpectation(it.getRange());
        _builder.append(_expectation);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    protected String _toExpectation(Hover it) {
        StringConcatenation _builder = new StringConcatenation();
        String _expectation = this.toExpectation(it.getRange());
        _builder.append(_expectation);
        _builder.newLineIfNotEmpty();
        String _expectation_1 = this.toExpectation(it.getContents());
        _builder.append(_expectation_1);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    protected String _toExpectation(SignatureHelp it) {
        boolean _tripleEquals;
        String _xblockexpression = null;
        int _size = it.getSignatures().size();
        boolean bl = _tripleEquals = _size == 0;
        if (_tripleEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Signature index is expected to be null when no signatures are available. Was: ");
            Integer _activeSignature = it.getActiveSignature();
            _builder.append((Object)_activeSignature);
            _builder.append(".");
            Assert.assertNull((String)_builder.toString(), (Object)it.getActiveSignature());
            return "<empty>";
        }
        Assert.assertNotNull((String)"Active signature index must not be null when signatures are available.", (Object)it.getActiveSignature());
        String _xifexpression = null;
        Integer _activeParameter = it.getActiveParameter();
        boolean _tripleEquals_1 = _activeParameter == null;
        _xifexpression = _tripleEquals_1 ? "<empty>" : ((ParameterInformation)((SignatureInformation)it.getSignatures().get(it.getActiveSignature())).getParameters().get(it.getActiveParameter())).getLabel();
        String param = _xifexpression;
        StringConcatenation _builder_1 = new StringConcatenation();
        Functions.Function1 _function = it_1 -> it_1.getLabel();
        String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)it.getSignatures(), (Functions.Function1)_function), (CharSequence)" | ");
        _builder_1.append(_join);
        _builder_1.append(" | ");
        _builder_1.append(param);
        _xblockexpression = _builder_1.toString();
        return _xblockexpression;
    }

    protected String _toExpectation(DocumentHighlight it) {
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        String _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        Range _range = it.getRange();
        boolean bl = _tripleEquals = _range == null;
        if (_tripleEquals) {
            _builder.append("[NaN, NaN]:[NaN, NaN]");
        } else {
            String _expectation = this.toExpectation(it.getRange());
            _builder.append(_expectation);
        }
        String rangeString = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        DocumentHighlightKind _kind = it.getKind();
        boolean bl2 = _tripleEquals_1 = _kind == null;
        if (_tripleEquals_1) {
            _builder_1.append("NaN");
        } else {
            String _expectation_1 = this.toExpectation(it.getKind());
            _builder_1.append(_expectation_1);
        }
        _builder_1.append(" ");
        _builder_1.append(rangeString);
        _xblockexpression = _builder_1.toString();
        return _xblockexpression;
    }

    protected String _toExpectation(DocumentHighlightKind kind) {
        return kind.toString().substring(0, 1).toUpperCase();
    }

    protected String _toExpectation(Map<Object, Object> it) {
        StringBuilder sb = new StringBuilder();
        Consumer<Map.Entry> _function = it_1 -> {
            boolean _greaterThan;
            int _length = sb.length();
            boolean bl = _greaterThan = _length > 0;
            if (_greaterThan) {
                sb.append("\n");
            }
            sb.append(this.toExpectation(it_1.getKey()));
            sb.append(" ->");
            Object _value = it_1.getValue();
            if (_value instanceof Iterable) {
                Object _value_1 = it_1.getValue();
                Consumer<Object> _function_1 = it_2 -> {
                    sb.append("\n * ");
                    sb.append(this.toExpectation(it_2));
                };
                ((Iterable)_value_1).forEach(_function_1);
            } else {
                sb.append(" ");
                sb.append(this.toExpectation(it_1.getValue()));
            }
        };
        it.entrySet().forEach(_function);
        return sb.toString();
    }

    protected String _toExpectation(ColoringInformation it) {
        StringConcatenation _builder = new StringConcatenation();
        String _expectation = this.toExpectation(it.getRange());
        _builder.append(_expectation);
        _builder.append(" -> [");
        String _join = IterableExtensions.join((Iterable)it.getStyles(), (CharSequence)", ");
        _builder.append(_join);
        _builder.append("]");
        return _builder.toString();
    }

    protected String _toExpectation(CodeLens it) {
        String _title = it.getCommand().getTitle();
        String _plus = _title + " ";
        String _expectation = this.toExpectation(it.getRange());
        return _plus + _expectation;
    }

    protected void testCodeLens(Procedures.Procedure1<? super TestCodeLensConfiguration> configurator) {
        try {
            TestCodeLensConfiguration configuration = new TestCodeLensConfiguration();
            configuration.setFilePath("MyModel." + this.fileExtension);
            configurator.apply((Object)configuration);
            String filePath = this.initializeContext(configuration).getUri();
            CodeLensParams _codeLensParams = new CodeLensParams();
            Procedures.Procedure1 _function = it -> {
                TextDocumentIdentifier _textDocumentIdentifier = new TextDocumentIdentifier(filePath);
                it.setTextDocument(_textDocumentIdentifier);
            };
            CodeLensParams _doubleArrow = (CodeLensParams)ObjectExtensions.operator_doubleArrow((Object)_codeLensParams, (Procedures.Procedure1)_function);
            CompletableFuture codeLenses = this.languageServer.codeLens(_doubleArrow);
            Functions.Function1 _function_1 = it -> {
                try {
                    return (CodeLens)this.languageServer.resolveCodeLens(it).get();
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            List result = IterableExtensions.toList((Iterable)ListExtensions.map((List)((List)codeLenses.get()), (Functions.Function1)_function_1));
            if (configuration.assertCodeLenses != null) {
                configuration.assertCodeLenses.apply((Object)result);
            } else {
                this.assertEquals(configuration.expectedCodeLensItems, this.toExpectation(result));
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String _toExpectation(Command it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("command : ");
        String _command = it.getCommand();
        _builder.append(_command);
        _builder.newLineIfNotEmpty();
        _builder.append("title : ");
        String _title = it.getTitle();
        _builder.append(_title);
        _builder.newLineIfNotEmpty();
        _builder.append("args : ");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function = it_1 -> this.toExpectation(it_1);
        String _join = IterableExtensions.join((Iterable)it.getArguments(), (CharSequence)",", (Functions.Function1)_function);
        _builder.append(_join, "\t");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    protected String _toExpectation(WorkspaceEdit it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("changes :");
        _builder.newLine();
        Set _entrySet = it.getChanges().entrySet();
        for (Map.Entry entry : _entrySet) {
            _builder.append("\t");
            String _lastSegment = URI.createURI((String)((String)entry.getKey())).lastSegment();
            _builder.append(_lastSegment, "\t");
            _builder.append(" : ");
            String _expectation = this.toExpectation(entry.getValue());
            _builder.append(_expectation, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("documentChanges : ");
        _builder.newLine();
        _builder.append("\t");
        String _expectation_1 = this.toExpectation(it.getDocumentChanges());
        _builder.append(_expectation_1, "\t");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    protected void testCodeAction(Procedures.Procedure1<? super TestCodeActionConfiguration> configurator) {
        try {
            TestCodeActionConfiguration configuration = new TestCodeActionConfiguration();
            configuration.setFilePath("MyModel." + this.fileExtension);
            configurator.apply((Object)configuration);
            String filePath = this.initializeContext(configuration).getUri();
            CodeActionParams _codeActionParams = new CodeActionParams();
            Procedures.Procedure1 _function = it -> {
                TextDocumentIdentifier _textDocumentIdentifier = new TextDocumentIdentifier(filePath);
                it.setTextDocument(_textDocumentIdentifier);
                CodeActionContext _codeActionContext = new CodeActionContext();
                Procedures.Procedure1 _function_1 = it_1 -> it_1.setDiagnostics(this.getDiagnostics().get(filePath));
                CodeActionContext _doubleArrow = (CodeActionContext)ObjectExtensions.operator_doubleArrow((Object)_codeActionContext, (Procedures.Procedure1)_function_1);
                it.setContext(_doubleArrow);
            };
            CodeActionParams _doubleArrow = (CodeActionParams)ObjectExtensions.operator_doubleArrow((Object)_codeActionParams, (Procedures.Procedure1)_function);
            CompletableFuture codeLenses = this.languageServer.codeAction(_doubleArrow);
            if (configuration.assertCodeActions != null) {
                configuration.assertCodeActions.apply(codeLenses.get());
            } else {
                this.assertEquals(configuration.expectedCodeActions, this.toExpectation(codeLenses.get()));
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void testCompletion(Procedures.Procedure1<? super TestCompletionConfiguration> configurator) {
        try {
            boolean _tripleNotEquals;
            TestCompletionConfiguration configuration = new TestCompletionConfiguration();
            configuration.setFilePath("MyModel." + this.fileExtension);
            configurator.apply((Object)configuration);
            String filePath = this.initializeContext(configuration).getUri();
            CompletionParams _completionParams = new CompletionParams();
            Procedures.Procedure1 _function = it -> {
                TextDocumentIdentifier _textDocumentIdentifier = new TextDocumentIdentifier(filePath);
                it.setTextDocument(_textDocumentIdentifier);
                int _line = configuration.getLine();
                int _column = configuration.getColumn();
                Position _position = new Position(_line, _column);
                it.setPosition(_position);
            };
            CompletionParams _doubleArrow = (CompletionParams)ObjectExtensions.operator_doubleArrow((Object)_completionParams, (Procedures.Procedure1)_function);
            CompletableFuture completionItems = this.languageServer.completion(_doubleArrow);
            Either result = (Either)completionItems.get();
            List _xifexpression = null;
            boolean _isLeft = result.isLeft();
            _xifexpression = _isLeft ? (List)result.getLeft() : ((CompletionList)result.getRight()).getItems();
            List items = _xifexpression;
            Functions.Function1 _function_1 = it -> it.getSortText();
            Assert.assertEquals((Object)items, (Object)IterableExtensions.toList((Iterable)IterableExtensions.sortBy((Iterable)items, (Functions.Function1)_function_1)));
            Procedures.Procedure1<? super CompletionList> _assertCompletionList = configuration.getAssertCompletionList();
            boolean bl = _tripleNotEquals = _assertCompletionList != null;
            if (_tripleNotEquals) {
                configuration.getAssertCompletionList().apply(result.getRight());
            } else {
                String actualCompletionItems = this.toExpectation(items);
                this.assertEquals(configuration.getExpectedCompletionItems(), actualCompletionItems);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected FileInfo initializeContext(TextDocumentConfiguration configuration) {
        boolean _not;
        this.initialize();
        boolean _isEmpty = configuration.getFilesInScope().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _tripleEquals;
            Functions.Function1 _function = it -> this.writeFile((String)it.getKey(), ((CharSequence)it.getValue()).toString());
            Iterable createdFiles = IterableExtensions.map(configuration.getFilesInScope().entrySet(), (Functions.Function1)_function);
            this.didCreateWatchedFiles((String[])Conversions.unwrapArray((Object)createdFiles, String.class));
            String _model = configuration.getModel();
            boolean bl2 = _tripleEquals = _model == null;
            if (_tripleEquals) {
                String _head = (String)IterableExtensions.head((Iterable)createdFiles);
                String _string = ((CharSequence)((Map.Entry)IterableExtensions.head(configuration.getFilesInScope().entrySet())).getValue()).toString();
                return new FileInfo(_head, _string);
            }
        }
        Assert.assertNotNull((Object)configuration.getModel());
        String filePath = this.writeFile(configuration.getFilePath(), configuration.getModel());
        this.open(filePath, configuration.getModel());
        String _model_1 = configuration.getModel();
        return new FileInfo(filePath, _model_1);
    }

    protected void testDefinition(Procedures.Procedure1<? super DefinitionTestConfiguration> configurator) {
        try {
            boolean _tripleNotEquals;
            DefinitionTestConfiguration configuration = new DefinitionTestConfiguration();
            configuration.setFilePath("MyModel." + this.fileExtension);
            configurator.apply((Object)configuration);
            String fileUri = this.initializeContext(configuration).getUri();
            TextDocumentPositionParams _textDocumentPositionParams = new TextDocumentPositionParams();
            Procedures.Procedure1 _function = it -> {
                TextDocumentIdentifier _textDocumentIdentifier = new TextDocumentIdentifier(fileUri);
                it.setTextDocument(_textDocumentIdentifier);
                int _line = configuration.getLine();
                int _column = configuration.getColumn();
                Position _position = new Position(_line, _column);
                it.setPosition(_position);
            };
            TextDocumentPositionParams _doubleArrow = (TextDocumentPositionParams)ObjectExtensions.operator_doubleArrow((Object)_textDocumentPositionParams, (Procedures.Procedure1)_function);
            CompletableFuture definitionsFuture = this.languageServer.definition(_doubleArrow);
            List definitions = (List)definitionsFuture.get();
            Procedures.Procedure1<? super List<? extends Location>> _assertDefinitions = configuration.getAssertDefinitions();
            boolean bl = _tripleNotEquals = _assertDefinitions != null;
            if (_tripleNotEquals) {
                configuration.getAssertDefinitions().apply((Object)definitions);
            } else {
                String actualDefinitions = this.toExpectation(definitions);
                this.assertEquals(configuration.getExpectedDefinitions(), actualDefinitions);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void testHover(Procedures.Procedure1<? super HoverTestConfiguration> configurator) {
        try {
            boolean _tripleNotEquals;
            HoverTestConfiguration configuration = new HoverTestConfiguration();
            configuration.setFilePath("MyModel." + this.fileExtension);
            configurator.apply((Object)configuration);
            String fileUri = this.initializeContext(configuration).getUri();
            TextDocumentPositionParams _textDocumentPositionParams = new TextDocumentPositionParams();
            Procedures.Procedure1 _function = it -> {
                TextDocumentIdentifier _textDocumentIdentifier = new TextDocumentIdentifier(fileUri);
                it.setTextDocument(_textDocumentIdentifier);
                int _line = configuration.getLine();
                int _column = configuration.getColumn();
                Position _position = new Position(_line, _column);
                it.setPosition(_position);
            };
            TextDocumentPositionParams _doubleArrow = (TextDocumentPositionParams)ObjectExtensions.operator_doubleArrow((Object)_textDocumentPositionParams, (Procedures.Procedure1)_function);
            CompletableFuture hoverFuture = this.languageServer.hover(_doubleArrow);
            Hover hover = (Hover)hoverFuture.get();
            Procedures.Procedure1<? super Hover> _assertHover = configuration.getAssertHover();
            boolean bl = _tripleNotEquals = _assertHover != null;
            if (_tripleNotEquals) {
                configuration.getAssertHover().apply((Object)hover);
            } else {
                String actualHover = this.toExpectation(hover);
                this.assertEquals(configuration.getExpectedHover(), actualHover);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void testSignatureHelp(Procedures.Procedure1<? super SignatureHelpConfiguration> configurator) {
        try {
            boolean _tripleNotEquals;
            SignatureHelpConfiguration configuration = new SignatureHelpConfiguration();
            configuration.setFilePath("MyModel." + this.fileExtension);
            configurator.apply((Object)configuration);
            String fileUri = this.initializeContext(configuration).getUri();
            TextDocumentPositionParams _textDocumentPositionParams = new TextDocumentPositionParams();
            Procedures.Procedure1 _function = it -> {
                TextDocumentIdentifier _textDocumentIdentifier = new TextDocumentIdentifier(fileUri);
                it.setTextDocument(_textDocumentIdentifier);
                int _line = configuration.getLine();
                int _column = configuration.getColumn();
                Position _position = new Position(_line, _column);
                it.setPosition(_position);
            };
            TextDocumentPositionParams _doubleArrow = (TextDocumentPositionParams)ObjectExtensions.operator_doubleArrow((Object)_textDocumentPositionParams, (Procedures.Procedure1)_function);
            CompletableFuture signatureHelpFuture = this.languageServer.signatureHelp(_doubleArrow);
            SignatureHelp signatureHelp = (SignatureHelp)signatureHelpFuture.get();
            Procedures.Procedure1<? super SignatureHelp> _assertSignatureHelp = configuration.getAssertSignatureHelp();
            boolean bl = _tripleNotEquals = _assertSignatureHelp != null;
            if (_tripleNotEquals) {
                configuration.getAssertSignatureHelp().apply((Object)signatureHelp);
            } else {
                String actualSignatureHelp = this.toExpectation(signatureHelp);
                this.assertEquals(configuration.getExpectedSignatureHelp().trim(), actualSignatureHelp.trim());
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void testDocumentHighlight(Procedures.Procedure1<? super DocumentHighlightConfiguration> configurator) {
        try {
            DocumentHighlightConfiguration _documentHighlightConfiguration = new DocumentHighlightConfiguration();
            Procedures.Procedure1 _function = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("MyModel.");
                _builder.append(this.fileExtension);
                it.setFilePath(_builder.toString());
            };
            DocumentHighlightConfiguration configuration = (DocumentHighlightConfiguration)ObjectExtensions.operator_doubleArrow((Object)_documentHighlightConfiguration, (Procedures.Procedure1)_function);
            configurator.apply((Object)configuration);
            String fileUri = this.initializeContext(configuration).getUri();
            TextDocumentPositionParams _textDocumentPositionParams = new TextDocumentPositionParams();
            Procedures.Procedure1 _function_1 = it -> {
                TextDocumentIdentifier _textDocumentIdentifier = new TextDocumentIdentifier(fileUri);
                it.setTextDocument(_textDocumentIdentifier);
                int _line = configuration.getLine();
                int _column = configuration.getColumn();
                Position _position = new Position(_line, _column);
                it.setPosition(_position);
            };
            TextDocumentPositionParams _doubleArrow = (TextDocumentPositionParams)ObjectExtensions.operator_doubleArrow((Object)_textDocumentPositionParams, (Procedures.Procedure1)_function_1);
            CompletableFuture highlights = this.languageServer.documentHighlight(_doubleArrow);
            Functions.Function1 _function_2 = it -> this.toExpectation(it);
            String actualDocumentHighlight = IterableExtensions.join((Iterable)ListExtensions.map((List)((List)highlights.get()), (Functions.Function1)_function_2), (CharSequence)" | ");
            this.assertEquals(configuration.getExpectedDocumentHighlight(), actualDocumentHighlight);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void testDocumentSymbol(Procedures.Procedure1<? super DocumentSymbolConfiguraiton> configurator) {
        try {
            boolean _tripleNotEquals;
            DocumentSymbolConfiguraiton configuration = new DocumentSymbolConfiguraiton();
            configuration.setFilePath("MyModel." + this.fileExtension);
            configurator.apply((Object)configuration);
            String fileUri = this.initializeContext(configuration).getUri();
            TextDocumentIdentifier _textDocumentIdentifier = new TextDocumentIdentifier(fileUri);
            DocumentSymbolParams _documentSymbolParams = new DocumentSymbolParams(_textDocumentIdentifier);
            CompletableFuture symbolsFuture = this.languageServer.documentSymbol(_documentSymbolParams);
            List symbols = (List)symbolsFuture.get();
            Procedures.Procedure1<? super List<? extends SymbolInformation>> _assertSymbols = configuration.getAssertSymbols();
            boolean bl = _tripleNotEquals = _assertSymbols != null;
            if (_tripleNotEquals) {
                configuration.getAssertSymbols().apply((Object)symbols);
            } else {
                String actualSymbols = this.toExpectation(symbols);
                this.assertEquals(configuration.getExpectedSymbols(), actualSymbols);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void testSymbol(Procedures.Procedure1<? super WorkspaceSymbolConfiguration> configurator) {
        try {
            boolean _tripleNotEquals;
            WorkspaceSymbolConfiguration configuration = new WorkspaceSymbolConfiguration();
            configuration.setFilePath("MyModel." + this.fileExtension);
            configurator.apply((Object)configuration);
            this.initializeContext(configuration);
            String _query = configuration.getQuery();
            WorkspaceSymbolParams _workspaceSymbolParams = new WorkspaceSymbolParams(_query);
            List symbols = (List)this.languageServer.symbol(_workspaceSymbolParams).get();
            Procedures.Procedure1<? super List<? extends SymbolInformation>> _assertSymbols = configuration.getAssertSymbols();
            boolean bl = _tripleNotEquals = _assertSymbols != null;
            if (_tripleNotEquals) {
                configuration.getAssertSymbols().apply((Object)symbols);
            } else {
                String actualSymbols = this.toExpectation(symbols);
                this.assertEquals(configuration.getExpectedSymbols(), actualSymbols);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void testReferences(Procedures.Procedure1<? super ReferenceTestConfiguration> configurator) {
        try {
            boolean _tripleNotEquals;
            ReferenceTestConfiguration configuration = new ReferenceTestConfiguration();
            configuration.setFilePath("MyModel." + this.fileExtension);
            configurator.apply((Object)configuration);
            String fileUri = this.initializeContext(configuration).getUri();
            ReferenceParams _referenceParams = new ReferenceParams();
            Procedures.Procedure1 _function = it -> {
                TextDocumentIdentifier _textDocumentIdentifier = new TextDocumentIdentifier(fileUri);
                it.setTextDocument(_textDocumentIdentifier);
                int _line = configuration.getLine();
                int _column = configuration.getColumn();
                Position _position = new Position(_line, _column);
                it.setPosition(_position);
                boolean _isIncludeDeclaration = configuration.isIncludeDeclaration();
                ReferenceContext _referenceContext = new ReferenceContext(_isIncludeDeclaration);
                it.setContext(_referenceContext);
            };
            ReferenceParams _doubleArrow = (ReferenceParams)ObjectExtensions.operator_doubleArrow((Object)_referenceParams, (Procedures.Procedure1)_function);
            CompletableFuture referencesFuture = this.languageServer.references(_doubleArrow);
            List references = (List)referencesFuture.get();
            Procedures.Procedure1<? super List<? extends Location>> _assertReferences = configuration.getAssertReferences();
            boolean bl = _tripleNotEquals = _assertReferences != null;
            if (_tripleNotEquals) {
                configuration.getAssertReferences().apply((Object)references);
            } else {
                String actualReferences = this.toExpectation(references);
                this.assertEquals(configuration.getExpectedReferences(), actualReferences);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void assertEquals(String expected, String actual) {
        String expectedM = expected.replace(System.lineSeparator(), "\n");
        String actualM = actual.replace(System.lineSeparator(), "\n");
        Assert.assertEquals((Object)expectedM.replace("\t", "    "), (Object)actualM.replace("\t", "    "));
    }

    public void assertEqualsStricter(String expected, String actual) {
        String expectedM = expected.replace(System.lineSeparator(), "\n");
        String actualM = actual.replace(System.lineSeparator(), "\n");
        Assert.assertEquals((Object)expectedM, (Object)actualM);
    }

    protected void testFormatting(Procedures.Procedure1<? super FormattingConfiguration> configurator) {
        this.testFormatting(null, configurator);
    }

    protected void testFormatting(Procedures.Procedure1<? super DocumentFormattingParams> paramsConfigurator, Procedures.Procedure1<? super FormattingConfiguration> configurator) {
        try {
            FormattingConfiguration configuration = new FormattingConfiguration();
            configuration.setFilePath("MyModel." + this.fileExtension);
            configurator.apply((Object)configuration);
            FileInfo fileInfo = this.initializeContext(configuration);
            DocumentFormattingParams _documentFormattingParams = new DocumentFormattingParams();
            Procedures.Procedure1 _function = it -> {
                String _uri = fileInfo.getUri();
                TextDocumentIdentifier _textDocumentIdentifier = new TextDocumentIdentifier(_uri);
                it.setTextDocument(_textDocumentIdentifier);
                if (paramsConfigurator != null) {
                    paramsConfigurator.apply(it);
                }
            };
            DocumentFormattingParams _doubleArrow = (DocumentFormattingParams)ObjectExtensions.operator_doubleArrow((Object)_documentFormattingParams, (Procedures.Procedure1)_function);
            CompletableFuture changes = this.languageServer.formatting(_doubleArrow);
            String _contents = fileInfo.getContents();
            Document result = new Document(Integer.valueOf(1), _contents).applyChanges((Iterable)ListExtensions.reverse((List)CollectionLiterals.newArrayList((Object[])((TextEdit[])Conversions.unwrapArray(changes.get(), TextEdit.class)))));
            this.assertEqualsStricter(configuration.getExpectedText(), result.getContents());
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void testRangeFormatting(Procedures.Procedure1<? super RangeFormattingConfiguration> configurator) {
        this.testRangeFormatting(null, configurator);
    }

    protected void testRangeFormatting(Procedures.Procedure1<? super DocumentRangeFormattingParams> paramsConfigurator, Procedures.Procedure1<? super RangeFormattingConfiguration> configurator) {
        try {
            RangeFormattingConfiguration configuration = new RangeFormattingConfiguration();
            configuration.setFilePath("MyModel." + this.fileExtension);
            configurator.apply((Object)configuration);
            FileInfo fileInfo = this.initializeContext(configuration);
            DocumentRangeFormattingParams _documentRangeFormattingParams = new DocumentRangeFormattingParams();
            Procedures.Procedure1 _function = it -> {
                String _uri = fileInfo.getUri();
                TextDocumentIdentifier _textDocumentIdentifier = new TextDocumentIdentifier(_uri);
                it.setTextDocument(_textDocumentIdentifier);
                it.setRange(configuration.getRange());
                if (paramsConfigurator != null) {
                    paramsConfigurator.apply(it);
                }
            };
            DocumentRangeFormattingParams _doubleArrow = (DocumentRangeFormattingParams)ObjectExtensions.operator_doubleArrow((Object)_documentRangeFormattingParams, (Procedures.Procedure1)_function);
            CompletableFuture changes = this.languageServer.rangeFormatting(_doubleArrow);
            String _contents = fileInfo.getContents();
            Document result = new Document(Integer.valueOf(1), _contents).applyChanges((Iterable)ListExtensions.reverse((List)CollectionLiterals.newArrayList((Object[])((TextEdit[])Conversions.unwrapArray(changes.get(), TextEdit.class)))));
            this.assertEqualsStricter(configuration.getExpectedText(), result.getContents());
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void notify(String method, Object parameter) {
        Pair _mappedTo = Pair.of((Object)method, (Object)parameter);
        this.notifications.add((Pair<String, Object>)_mappedTo);
    }

    public CompletableFuture<?> request(String method, Object parameter) {
        return CompletableFuture.completedFuture(null);
    }

    protected Map<String, List<Diagnostic>> getDiagnostics() {
        try {
            Functions.Function1 _function = it -> {
                HashMap result = CollectionLiterals.newHashMap();
                Functions.Function1 _function_1 = it_1 -> it_1.getValue();
                Iterable _filter = Iterables.filter((Iterable)ListExtensions.map(this.notifications, (Functions.Function1)_function_1), PublishDiagnosticsParams.class);
                for (PublishDiagnosticsParams diagnostic : _filter) {
                    result.put(diagnostic.getUri(), diagnostic.getDiagnostics());
                }
                return result;
            };
            return (Map)this.languageServer.getRequestManager().runRead(_function).get();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected Map<String, List<? extends ColoringInformation>> getColoringParams() {
        try {
            Functions.Function1 _function = it -> {
                Functions.Function1 _function_1 = it_1 -> it_1.getValue();
                Functions.Function1 _function_2 = it_1 -> it_1.getUri();
                Functions.Function1 _function_3 = it_1 -> it_1.getInfos();
                return IterableExtensions.toMap((Iterable)Iterables.filter((Iterable)ListExtensions.map(this.notifications, (Functions.Function1)_function_1), ColoringParams.class), (Functions.Function1)_function_2, (Functions.Function1)_function_3);
            };
            return (Map)this.languageServer.getRequestManager().runRead(_function).get();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String toExpectation(Object it) {
        if (it instanceof Integer) {
            return this._toExpectation((Integer)it);
        }
        if (it instanceof List) {
            return this._toExpectation((List)it);
        }
        if (it instanceof DocumentHighlightKind) {
            return this._toExpectation((DocumentHighlightKind)it);
        }
        if (it instanceof String) {
            return this._toExpectation((String)it);
        }
        if (it == null) {
            return this._toExpectation((Void)null);
        }
        if (it instanceof Map) {
            return this._toExpectation((Map)it);
        }
        if (it instanceof CodeLens) {
            return this._toExpectation((CodeLens)it);
        }
        if (it instanceof ColoringInformation) {
            return this._toExpectation((ColoringInformation)it);
        }
        if (it instanceof Command) {
            return this._toExpectation((Command)it);
        }
        if (it instanceof CompletionItem) {
            return this._toExpectation((CompletionItem)it);
        }
        if (it instanceof DocumentHighlight) {
            return this._toExpectation((DocumentHighlight)it);
        }
        if (it instanceof Hover) {
            return this._toExpectation((Hover)it);
        }
        if (it instanceof Location) {
            return this._toExpectation((Location)it);
        }
        if (it instanceof Position) {
            return this._toExpectation((Position)it);
        }
        if (it instanceof Range) {
            return this._toExpectation((Range)it);
        }
        if (it instanceof SignatureHelp) {
            return this._toExpectation((SignatureHelp)it);
        }
        if (it instanceof SymbolInformation) {
            return this._toExpectation((SymbolInformation)it);
        }
        if (it instanceof TextEdit) {
            return this._toExpectation((TextEdit)it);
        }
        if (it instanceof WorkspaceEdit) {
            return this._toExpectation((WorkspaceEdit)it);
        }
        if (it instanceof Either) {
            return this._toExpectation((Either)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    public AbstractLanguageServerTest(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    @Pure
    public String getFileExtension() {
        return this.fileExtension;
    }

    @Accessors
    public static class TestCodeActionConfiguration
    extends TextDocumentPositionConfiguration {
        private String expectedCodeActions = "";
        private Procedures.Procedure1<? super List<? extends Command>> assertCodeActions = null;

        @Pure
        public String getExpectedCodeActions() {
            return this.expectedCodeActions;
        }

        public void setExpectedCodeActions(String expectedCodeActions) {
            this.expectedCodeActions = expectedCodeActions;
        }

        @Pure
        public Procedures.Procedure1<? super List<? extends Command>> getAssertCodeActions() {
            return this.assertCodeActions;
        }

        public void setAssertCodeActions(Procedures.Procedure1<? super List<? extends Command>> assertCodeActions) {
            this.assertCodeActions = assertCodeActions;
        }
    }

    @Accessors
    public static class TestCodeLensConfiguration
    extends TextDocumentPositionConfiguration {
        private String expectedCodeLensItems = "";
        private Procedures.Procedure1<? super List<? extends CodeLens>> assertCodeLenses = null;

        @Pure
        public String getExpectedCodeLensItems() {
            return this.expectedCodeLensItems;
        }

        public void setExpectedCodeLensItems(String expectedCodeLensItems) {
            this.expectedCodeLensItems = expectedCodeLensItems;
        }

        @Pure
        public Procedures.Procedure1<? super List<? extends CodeLens>> getAssertCodeLenses() {
            return this.assertCodeLenses;
        }

        public void setAssertCodeLenses(Procedures.Procedure1<? super List<? extends CodeLens>> assertCodeLenses) {
            this.assertCodeLenses = assertCodeLenses;
        }
    }
}

