/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.build;

import com.google.common.annotations.Beta;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.xtext.build.BuildRequest;
import org.eclipse.xtext.build.IncrementalBuilder;
import org.eclipse.xtext.build.IndexState;
import org.eclipse.xtext.build.Source2GeneratedMapping;
import org.eclipse.xtext.junit4.util.InMemoryURIHandler;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ChunkedResourceDescriptions;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.junit.Before;

@Beta
public abstract class AbstractIncrementalBuilderTest {
    @Inject
    protected IncrementalBuilder incrementalBuilder;
    @Inject
    protected IndexState indexState;
    @Inject
    protected Provider<XtextResourceSet> resourceSetProvider;
    protected Multimap<URI, URI> generated;
    protected List<URI> deleted;
    protected List<Issue> issues;
    protected InMemoryURIHandler inMemoryURIHandler;

    @Before
    public void setUp() {
        InMemoryURIHandler _inMemoryURIHandler;
        this.clean();
        this.inMemoryURIHandler = _inMemoryURIHandler = new InMemoryURIHandler();
    }

    protected List<Issue> clean() {
        ArrayList _newArrayList_1;
        ArrayList _newArrayList;
        ArrayListMultimap _create;
        ArrayList _xblockexpression = null;
        this.generated = _create = ArrayListMultimap.create();
        this.deleted = _newArrayList = CollectionLiterals.newArrayList((Object[])new URI[0]);
        _xblockexpression = this.issues = (_newArrayList_1 = CollectionLiterals.newArrayList((Object[])new Issue[0]));
        return _xblockexpression;
    }

    protected IndexState build(BuildRequest buildRequest) {
        IndexState _indexState;
        this.clean();
        Functions.Function1<URI, IResourceServiceProvider> _function = new Functions.Function1<URI, IResourceServiceProvider>(){

            public IResourceServiceProvider apply(URI it) {
                IResourceServiceProvider.Registry _languages = AbstractIncrementalBuilderTest.this.getLanguages();
                return _languages.getResourceServiceProvider(it);
            }
        };
        IncrementalBuilder.Result _build = this.incrementalBuilder.build(buildRequest, (Functions.Function1)_function);
        this.indexState = _indexState = _build.getIndexState();
        return this.indexState;
    }

    protected abstract IResourceServiceProvider.Registry getLanguages();

    protected BuildRequest newBuildRequest(Procedures.Procedure1<? super BuildRequest> init) {
        BuildRequest _buildRequest = new BuildRequest();
        Procedures.Procedure1<BuildRequest> _function = new Procedures.Procedure1<BuildRequest>(){

            public void apply(BuildRequest it) {
                ResourceDescriptionsData _resourceDescriptions = AbstractIncrementalBuilderTest.this.indexState.getResourceDescriptions();
                final ResourceDescriptionsData newIndex = _resourceDescriptions.copy();
                URI _uri = AbstractIncrementalBuilderTest.this.uri("");
                it.setBaseDir(_uri);
                XtextResourceSet _get = (XtextResourceSet)AbstractIncrementalBuilderTest.this.resourceSetProvider.get();
                Procedures.Procedure1<XtextResourceSet> _function = new Procedures.Procedure1<XtextResourceSet>(){

                    public void apply(XtextResourceSet it) {
                        URIConverter _uRIConverter = it.getURIConverter();
                        EList _uRIHandlers = _uRIConverter.getURIHandlers();
                        _uRIHandlers.clear();
                        URIConverter _uRIConverter_1 = it.getURIConverter();
                        EList _uRIHandlers_1 = _uRIConverter_1.getURIHandlers();
                        _uRIHandlers_1.add((Object)(this).AbstractIncrementalBuilderTest.this.inMemoryURIHandler);
                        ClassLoader _classLoader = AbstractIncrementalBuilderTest.class.getClassLoader();
                        it.setClasspathURIContext((Object)_classLoader);
                        ProjectDescription _projectDescription = new ProjectDescription();
                        Procedures.Procedure1<ProjectDescription> _function = new Procedures.Procedure1<ProjectDescription>(){

                            public void apply(ProjectDescription it) {
                                it.setName("test-project");
                            }
                        };
                        ProjectDescription projectDescription = (ProjectDescription)ObjectExtensions.operator_doubleArrow((Object)_projectDescription, (Procedures.Procedure1)_function);
                        projectDescription.attachToEmfObject((Notifier)it);
                        Map _emptyMap = CollectionLiterals.emptyMap();
                        ChunkedResourceDescriptions index = new ChunkedResourceDescriptions(_emptyMap, (ResourceSet)it);
                        String _name = projectDescription.getName();
                        index.setContainer(_name, newIndex);
                    }
                };
                XtextResourceSet _doubleArrow = (XtextResourceSet)ObjectExtensions.operator_doubleArrow((Object)_get, (Procedures.Procedure1)_function);
                it.setResourceSet(_doubleArrow);
                it.setDirtyFiles(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new URI[0])));
                it.setDeletedFiles(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new URI[0])));
                BuildRequest.IPostValidationCallback _function_1 = new BuildRequest.IPostValidationCallback(){

                    public boolean afterValidate(URI uri, Iterable<Issue> issues) {
                        Iterables.addAll((this).AbstractIncrementalBuilderTest.this.issues, issues);
                        return IterableExtensions.isEmpty(issues);
                    }
                };
                it.setAfterValidate(_function_1);
                Procedures.Procedure1<URI> _function_2 = new Procedures.Procedure1<URI>(){

                    public void apply(URI it) {
                        (this).AbstractIncrementalBuilderTest.this.deleted.add(it);
                    }
                };
                it.setAfterDeleteFile((Procedures.Procedure1)_function_2);
                Procedures.Procedure2<URI, URI> _function_3 = new Procedures.Procedure2<URI, URI>(){

                    public void apply(URI source, URI target) {
                        (this).AbstractIncrementalBuilderTest.this.generated.put((Object)source, (Object)target);
                    }
                };
                it.setAfterGenerateFile((Procedures.Procedure2)_function_3);
                Source2GeneratedMapping _fileMappings = AbstractIncrementalBuilderTest.this.indexState.getFileMappings();
                Source2GeneratedMapping _copy = _fileMappings.copy();
                IndexState _indexState = new IndexState(newIndex, _copy);
                it.setState(_indexState);
            }
        };
        BuildRequest result = (BuildRequest)ObjectExtensions.operator_doubleArrow((Object)_buildRequest, (Procedures.Procedure1)_function);
        init.apply((Object)result);
        return result;
    }

    protected URI delete(URI uri) {
        try {
            Map _emptyMap = CollectionLiterals.emptyMap();
            this.inMemoryURIHandler.delete(uri, _emptyMap);
            return uri;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected URI uri(String path) {
        return URI.createURI((String)("inmemory:/" + path));
    }

    protected URI operator_minus(String path, final String content) {
        try {
            URI uri = this.uri(path);
            Map _emptyMap = CollectionLiterals.emptyMap();
            OutputStream _createOutputStream = this.inMemoryURIHandler.createOutputStream(uri, _emptyMap);
            Procedures.Procedure1<OutputStream> _function = new Procedures.Procedure1<OutputStream>(){

                public void apply(OutputStream it) {
                    try {
                        byte[] _bytes = content.getBytes();
                        it.write(_bytes);
                        it.close();
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            };
            ObjectExtensions.operator_doubleArrow((Object)_createOutputStream, (Procedures.Procedure1)_function);
            return uri;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected boolean containsSuffix(final Iterable<? extends URI> uris, String ... suffixes) {
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(final String suffix) {
                Functions.Function1<URI, Boolean> _function = new Functions.Function1<URI, Boolean>(){

                    public Boolean apply(URI uri) {
                        String _string = uri.toString();
                        return _string.endsWith(suffix);
                    }
                };
                return IterableExtensions.exists((Iterable)uris, (Functions.Function1)_function);
            }
        };
        return IterableExtensions.forall((Iterable)((Iterable)Conversions.doWrapArray((Object)suffixes)), (Functions.Function1)_function);
    }
}

