/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.java.resource;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.descriptions.JvmTypesResourceDescriptionStrategy;
import org.eclipse.xtext.java.resource.JavaResource;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.DefaultResourceDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class JavaResourceDescriptionManager
implements IResourceDescription.Manager {
    @Inject
    private JvmTypesResourceDescriptionStrategy descriptionStrategy;
    @Inject
    private IResourceScopeCache cache;

    public IResourceDescription.Delta createDelta(IResourceDescription oldDescription, IResourceDescription newDescription) {
        return new DefaultResourceDescriptionDelta(oldDescription, newDescription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResourceDescription getResourceDescription(Resource resource) {
        if (resource instanceof JavaResource) {
            boolean initialized = ((JavaResource)resource).isInitialized() || ((JavaResource)resource).isInitializing();
            try {
                if (!initialized) {
                    ((JavaResource)resource).eSetDeliver(false);
                    ((JavaResource)resource).installStubs();
                }
                DefaultResourceDescription result = new DefaultResourceDescription(resource, (IDefaultResourceDescriptionStrategy)this.descriptionStrategy, this.cache);
                if (!initialized) {
                    Iterable _exportedObjects = result.getExportedObjects();
                    Consumer<IEObjectDescription> _function = it -> it.getEObjectURI();
                    _exportedObjects.forEach(_function);
                }
                DefaultResourceDescription defaultResourceDescription = result;
                return defaultResourceDescription;
            }
            finally {
                if (!initialized) {
                    ((JavaResource)resource).discardDerivedState();
                    ((JavaResource)resource).eSetDeliver(true);
                }
            }
        }
        throw new IllegalArgumentException("Can only handle JavaResources");
    }

    public boolean isAffected(IResourceDescription.Delta delta, IResourceDescription candidate) throws IllegalArgumentException {
        throw new UnsupportedOperationException("TODO: auto-generated method stub");
    }

    public boolean isAffected(Collection<IResourceDescription.Delta> deltas, IResourceDescription candidate, IResourceDescriptions context) throws IllegalArgumentException {
        Iterable _importedNames = candidate.getImportedNames();
        Set importedNames = IterableExtensions.toSet((Iterable)_importedNames);
        for (IResourceDescription.Delta delta : deltas) {
            boolean _hasChanges = this.hasChanges(delta, candidate);
            if (!_hasChanges || !this.isAffected(importedNames, delta.getNew()) && !this.isAffected(importedNames, delta.getOld())) continue;
            return true;
        }
        return false;
    }

    protected boolean hasChanges(IResourceDescription.Delta delta, IResourceDescription candidate) {
        return delta.haveEObjectDescriptionsChanged();
    }

    protected boolean isAffected(Collection<QualifiedName> importedNames, IResourceDescription description) {
        if (description != null) {
            Iterable _exportedObjects = description.getExportedObjects();
            for (IEObjectDescription desc : _exportedObjects) {
                QualifiedName _name = desc.getName();
                QualifiedName _lowerCase = _name.toLowerCase();
                boolean _contains = importedNames.contains(_lowerCase);
                if (!_contains) continue;
                return true;
            }
        }
        return false;
    }
}

