/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.syntaxcoloring;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;

public class LightweightPosition
implements Comparable<LightweightPosition> {
    private final int offset;
    private int length;
    private IntToStringArray[] ids;
    private final int timestamp;

    public LightweightPosition(int offset, int length, int timestamp, String ... ids) {
        this(offset, length, timestamp, new IntToStringArray[]{new IntToStringArray(timestamp, ids)});
    }

    public LightweightPosition(int offset, int length, int timestamp, IntToStringArray[] ids) {
        this.offset = offset;
        this.length = length;
        this.timestamp = timestamp;
        this.ids = ids;
    }

    @Override
    public int compareTo(LightweightPosition pos) {
        if (this.offset < pos.offset) {
            return -1;
        }
        if (this.offset > pos.offset) {
            return 1;
        }
        if (this.length < pos.length) {
            return -1;
        }
        if (this.length > pos.length) {
            return 1;
        }
        if (this.timestamp < pos.timestamp) {
            return -1;
        }
        if (this.timestamp > pos.timestamp) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.length;
        result = 31 * result + this.offset;
        result = 31 * result + this.timestamp;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LightweightPosition other = (LightweightPosition)obj;
        if (this.length != other.length) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        return this.timestamp == other.timestamp;
    }

    public String toString() {
        return String.valueOf(this.offset) + "(" + this.length + ")@" + this.timestamp + ": " + Arrays.toString(this.ids);
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    IntToStringArray[] internalGetIds() {
        return this.ids;
    }

    public String[] getIds() {
        if (this.ids.length == 1) {
            return this.ids[0].ids;
        }
        Arrays.sort(this.ids);
        LinkedHashSet<String> allIds = new LinkedHashSet<String>(this.ids.length * this.ids[0].ids.length);
        IntToStringArray[] intToStringArrayArray = this.ids;
        int n = this.ids.length;
        int n2 = 0;
        while (n2 < n) {
            IntToStringArray intToStringArray = intToStringArrayArray[n2];
            List<String> addUs = Arrays.asList(intToStringArray.ids);
            if (allIds.isEmpty()) {
                allIds.addAll(addUs);
            } else {
                allIds.removeAll(addUs);
                allIds.addAll(addUs);
            }
            ++n2;
        }
        return allIds.toArray(new String[allIds.size()]);
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public void merge(int timestamp, String ... other) {
        this.merge(new IntToStringArray[]{new IntToStringArray(timestamp, other)});
    }

    public void merge(IntToStringArray[] other) {
        IntToStringArray[] oldIds = this.ids;
        this.ids = this.createArray(oldIds.length + other.length);
        System.arraycopy(oldIds, 0, this.ids, 0, oldIds.length);
        System.arraycopy(other, 0, this.ids, oldIds.length, other.length);
    }

    protected IntToStringArray[] createArray(int len) {
        return new IntToStringArray[len];
    }

    public static class IntToStringArray
    implements Comparable<IntToStringArray> {
        private int timestamp;
        private String[] ids;

        public IntToStringArray(int timestamp, String ... ids) {
            this.timestamp = timestamp;
            this.ids = ids;
        }

        @Override
        public int compareTo(IntToStringArray o) {
            if (this.timestamp < o.timestamp) {
                return -1;
            }
            if (this.timestamp > o.timestamp) {
                return 1;
            }
            return 0;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.timestamp;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IntToStringArray other = (IntToStringArray)obj;
            return this.timestamp == other.timestamp;
        }

        public String toString() {
            return String.valueOf(Arrays.toString(this.ids)) + "@" + this.timestamp;
        }
    }
}

